/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.spigotcb1_8_R3;

import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import java.util.List;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityBoat;
import net.minecraft.server.v1_8_R3.IBlockAccess;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class BlockCacheSpigotCB1_8_R3
extends BlockCache {
    protected WorldServer world;
    protected World bukkitWorld;

    public BlockCacheSpigotCB1_8_R3(World world) {
        this.setAccess(world);
    }

    @Override
    public BlockCache setAccess(World world) {
        if (world != null) {
            this.maxBlockY = world.getMaxHeight() - 1;
            this.world = ((CraftWorld)world).getHandle();
            this.bukkitWorld = world;
        } else {
            this.world = null;
            this.bukkitWorld = null;
        }
        return this;
    }

    @Override
    public Material fetchTypeId(int x, int y, int z) {
        return this.bukkitWorld.getBlockAt(x, y, z).getType();
    }

    @Override
    public int fetchData(int x, int y, int z) {
        return this.bukkitWorld.getBlockAt(x, y, z).getData();
    }

    @Override
    public double[] fetchBounds(int x, int y, int z) {
        int id = this.getType(x, y, z).getId();
        Block block = Block.getById((int)id);
        if (block == null) {
            return null;
        }
        block.updateShape((IBlockAccess)this.world, new BlockPosition(x, y, z));
        return new double[]{block.B(), block.D(), block.F(), block.C(), block.E(), block.G()};
    }

    @Override
    public boolean standsOnEntity(Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            net.minecraft.server.v1_8_R3.Entity mcEntity = ((CraftEntity)entity).getHandle();
            AxisAlignedBB box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            List list = this.world.getEntities(mcEntity, box);
            for (net.minecraft.server.v1_8_R3.Entity other : list) {
                if (!(other instanceof EntityBoat)) continue;
                if (minY >= other.locY && minY - other.locY <= 0.7) {
                    return true;
                }
                AxisAlignedBB otherBox = other.getBoundingBox();
                if (box.a > otherBox.d || box.d < otherBox.a || box.b > otherBox.e || box.e < otherBox.b || box.c > otherBox.f || box.f < otherBox.c) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.world = null;
        this.bukkitWorld = null;
    }
}

