/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.net.FlyingFrequency;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.checks.net.model.TeleportQueue;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.time.monotonic.Monotonic;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MovingFlying
extends BaseAdapter {
    public static final int indexOnGround = 0;
    public static final int indexhasPos = 1;
    public static final int indexhasLook = 2;
    public static final int indexX = 0;
    public static final int indexY = 1;
    public static final int indexZ = 2;
    public static final int indexStance = 3;
    public static final int indexYaw = 0;
    public static final int indexPitch = 1;
    private final FlyingFrequency flyingFrequency = new FlyingFrequency();
    private final int idFlying = this.counters.registerKey("packet.flying");
    private final int idAsyncFlying = this.counters.registerKey("packet.flying.asynchronous");
    private long packetMismatch = Long.MIN_VALUE;
    private long packetMismatchLogFrequency = 60000L;
    private final HashSet<DataPacketFlying.PACKET_CONTENT> validContent = new LinkedHashSet<DataPacketFlying.PACKET_CONTENT>();
    private final PacketType confirmTeleportType = ProtocolLibComponent.findPacketTypeByName(PacketType.Protocol.PLAY, PacketType.Sender.CLIENT, "PacketPlayInTeleportAccept");
    private boolean acceptConfirmTeleportPackets;

    private static PacketType[] initPacketTypes() {
        LinkedList<PacketType> types = new LinkedList<PacketType>(Arrays.asList(PacketType.Play.Client.FLYING, PacketType.Play.Client.LOOK, PacketType.Play.Client.POSITION, PacketType.Play.Client.POSITION_LOOK));
        PacketType confirmType = ProtocolLibComponent.findPacketTypeByName(PacketType.Protocol.PLAY, PacketType.Sender.CLIENT, "PacketPlayInTeleportAccept");
        if (confirmType != null) {
            StaticLog.logInfo("Confirm teleport packet available (via name): " + confirmType);
            types.add(confirmType);
        }
        return types.toArray(new PacketType[types.size()]);
    }

    public MovingFlying(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, MovingFlying.initPacketTypes());
        boolean bl = this.acceptConfirmTeleportPackets = this.confirmTeleportType != null;
        if (ConfigManager.isTrueForAnyConfig("checks.net.flyingfrequency.active")) {
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(FlyingFrequency.class.getSimpleName()));
        }
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.flyingFrequency);
    }

    public void onPacketReceiving(PacketEvent event) {
        if (event.getPacketType().equals((Object)this.confirmTeleportType)) {
            if (this.acceptConfirmTeleportPackets) {
                this.onConfirmTeleportPacket(event);
            }
        } else {
            this.onFlyingPacket(event);
        }
    }

    private void onConfirmTeleportPacket(PacketEvent event) {
        try {
            this.processConfirmTeleport(event);
        }
        catch (Throwable t) {
            this.noConfirmTeleportPacket();
        }
    }

    private void processConfirmTeleport(PacketEvent event) {
        PacketContainer packet = event.getPacket();
        StructureModifier integers = packet.getIntegers();
        if (integers.size() != 1) {
            this.noConfirmTeleportPacket();
            return;
        }
        Integer teleportId = (Integer)integers.read(0);
        if (teleportId == null) {
            return;
        }
        Player player = event.getPlayer();
        NetData data = this.dataFactory.getData(player);
        AlmostBoolean matched = data.teleportQueue.processAck(teleportId);
        if (matched.decideOptimistically()) {
            CheckUtils.subtract(System.currentTimeMillis(), 1.0f, data.flyingFrequencyAll);
        }
        if (data.debug) {
            this.debug(player, "Confirm teleport packet" + (matched.decideOptimistically() ? " (matched=" + (Object)((Object)matched) + ")" : "") + ": " + teleportId);
        }
    }

    private void noConfirmTeleportPacket() {
        this.acceptConfirmTeleportPackets = false;
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Confirm teleport packet not available.");
    }

    private void onFlyingPacket(PacketEvent event) {
        boolean primaryThread = Bukkit.isPrimaryThread();
        this.counters.add(this.idFlying, 1, primaryThread);
        if (event.isAsync() == primaryThread) {
            this.counters.add(ProtocolLibComponent.idInconsistentIsAsync, 1, primaryThread);
        }
        if (!primaryThread) {
            this.counters.addSynchronized(this.idAsyncFlying, 1);
        }
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (player == null) {
            this.counters.add(ProtocolLibComponent.idNullPlayer, 1, primaryThread);
            event.setCancelled(true);
            return;
        }
        NetConfig cc = (NetConfig)this.configFactory.getConfig(player.getWorld());
        NetData data = this.dataFactory.getData(player);
        data.lastKeepAliveTime = time;
        if (!cc.flyingFrequencyActive) {
            return;
        }
        boolean cancel = false;
        DataPacketFlying packetData = this.interpretPacket(event, time);
        boolean skipFlyingFrequency = false;
        if (packetData != null) {
            if (this.isInvalidContent(packetData)) {
                event.setCancelled(true);
                if (data.debug) {
                    this.debug(player, "Incoming packet, cancel due to malicious content: " + packetData.toString());
                }
                return;
            }
            switch (data.teleportQueue.processAck(packetData)) {
                case WAITING: {
                    if (data.debug) {
                        this.debug(player, "Incoming packet, still waiting for ACK on outgoing position.");
                    }
                    if (this.confirmTeleportType == null || !cc.supersededFlyingCancelWaiting) break;
                    TeleportQueue.AckReference ackReference = data.teleportQueue.getLastAckReference();
                    if (ackReference.lastOutgoingId == Integer.MIN_VALUE || ackReference.lastOutgoingId == ackReference.maxConfirmedId) break;
                    cancel = true;
                    break;
                }
                case ACK: {
                    skipFlyingFrequency = true;
                    if (data.debug) {
                        this.debug(player, "Incoming packet, interpret as ACK for outgoing position.");
                    }
                }
                default: {
                    data.addFlyingQueue(packetData);
                }
            }
            this.validContent.add(packetData.getSimplifiedContentType());
        }
        PlayerData pData = DataManager.getPlayerData(player);
        if (!cancel && !skipFlyingFrequency && this.flyingFrequency.check(player, packetData, time, data, cc, pData)) {
            cancel = true;
        }
        if (cancel) {
            event.setCancelled(true);
        }
        if (data.debug) {
            this.debug(player, (packetData == null ? "(Incompatible data)" : packetData.toString()) + (event.isCancelled() ? " CANCEL" : ""));
        }
    }

    private boolean isInvalidContent(DataPacketFlying packetData) {
        if (packetData.hasPos && LocUtil.isBadCoordinate(packetData.getX(), packetData.getY(), packetData.getZ())) {
            return true;
        }
        return packetData.hasLook && LocUtil.isBadCoordinate(packetData.getYaw(), packetData.getPitch());
    }

    private DataPacketFlying interpretPacket(PacketEvent event, long time) {
        List floats;
        List doubles;
        PacketContainer packet = event.getPacket();
        List booleans = packet.getBooleans().getValues();
        if (booleans.size() != 3) {
            this.packetMismatch(event);
            return null;
        }
        boolean onGround = (Boolean)booleans.get(0);
        boolean hasPos = (Boolean)booleans.get(1);
        boolean hasLook = (Boolean)booleans.get(2);
        if (!hasPos && !hasLook) {
            return new DataPacketFlying(onGround, time);
        }
        if (hasPos) {
            doubles = packet.getDoubles().getValues();
            if (doubles.size() != 3 && doubles.size() != 4) {
                this.packetMismatch(event);
                return null;
            }
        } else {
            doubles = null;
        }
        if (hasLook) {
            floats = packet.getFloat().getValues();
            if (floats.size() != 2) {
                this.packetMismatch(event);
                return null;
            }
        } else {
            floats = null;
        }
        if (hasPos && hasLook) {
            return new DataPacketFlying(onGround, (Double)doubles.get(0), (Double)doubles.get(1), (Double)doubles.get(2), ((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), time);
        }
        if (hasLook) {
            return new DataPacketFlying(onGround, ((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), time);
        }
        if (hasPos) {
            return new DataPacketFlying(onGround, (double)((Double)doubles.get(0)), (double)((Double)doubles.get(1)), (Double)doubles.get(2), time);
        }
        throw new IllegalStateException("Can't be, it can't be!");
    }

    private void packetMismatch(PacketEvent packetEvent) {
        long time = Monotonic.synchMillis();
        if (time - this.packetMismatchLogFrequency > this.packetMismatch) {
            this.packetMismatch = time;
            StringBuilder builder = new StringBuilder(512);
            builder.append(CheckUtils.getLogMessagePrefix(packetEvent.getPlayer(), this.checkType));
            builder.append("Incoming packet could not be interpreted. Are server and plugins up to date (NCP/ProtocolLib...)? This message is logged every ");
            builder.append(Long.toString(this.packetMismatchLogFrequency / 1000L));
            builder.append(" seconds, disregarding for which player this happens.");
            if (!this.validContent.isEmpty()) {
                builder.append(" On other occasion, valid content was received for: ");
                StringUtil.join(this.validContent, ", ", builder);
            }
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, builder.toString());
        }
    }
}

