/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.velocity;

public class UnusedTracker {
    private int lastBlocked = 0;
    private int lastNotBlockedStart = 0;
    private int resultUpdateCount = 0;
    private int resultViolationCount = 0;
    private double resultViolationAmount = 0.0;

    public void updateState(int tick, boolean blocked) {
        if (blocked) {
            this.lastBlocked = tick;
            if (tick == this.lastNotBlockedStart) {
                --this.lastNotBlockedStart;
            }
        } else if (this.lastNotBlockedStart <= this.lastBlocked) {
            this.lastNotBlockedStart = tick;
        }
        ++this.resultUpdateCount;
    }

    public void addValue(int tick, double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("The added amount must be greater than zero.");
        }
        if (this.lastBlocked >= this.lastNotBlockedStart || tick <= this.lastNotBlockedStart) {
            return;
        }
        this.addViolation(amount);
    }

    private void addViolation(double amount) {
        ++this.resultViolationCount;
        this.resultViolationAmount += amount;
    }

    public void resetResults() {
        this.resultUpdateCount = 0;
        this.resultViolationCount = 0;
        this.resultViolationAmount = 0.0;
    }

    public int getResultUpdateCount() {
        return this.resultUpdateCount;
    }

    public int getResultViolationCount() {
        return this.resultViolationCount;
    }

    public double getResultViolationAmount() {
        return this.resultViolationAmount;
    }
}

