/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleAxisVelocity;
import fr.neatmonster.nocheatplus.checks.moving.velocity.UnusedTracker;
import fr.neatmonster.nocheatplus.logging.debug.DebugUtil;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import org.bukkit.entity.Player;

public class UnusedVelocity {
    public static boolean checkUnusedVelocity(Player player, CheckType checkType) {
        return UnusedVelocity.checkUnusedVelocity(player, checkType, MovingData.getData(player), MovingConfig.getConfig(player));
    }

    public static boolean checkUnusedVelocity(Player player, CheckType checkType, MovingData data, MovingConfig cc) {
        boolean violation = false;
        SimpleAxisVelocity verVel = data.getVerticalVelocityTracker();
        violation |= UnusedVelocity.quickCheckDirection(player, verVel.unusedTrackerPos, checkType, "vert/pos", data, cc);
        return violation |= UnusedVelocity.quickCheckDirection(player, verVel.unusedTrackerNeg, checkType, "vert/neg", data, cc);
    }

    private static boolean quickCheckDirection(Player player, UnusedTracker tracker, CheckType checkType, String trackerId, MovingData data, MovingConfig cc) {
        int countV = tracker.getResultViolationCount();
        if (countV > 0) {
            String msg = "Unused velocity " + trackerId + ": c_v: " + countV + " , a_v: " + tracker.getResultViolationAmount() + " , c_u: " + tracker.getResultUpdateCount();
            DebugUtil.debug(CheckUtils.getLogMessagePrefix(player, checkType) + msg);
        }
        tracker.resetResults();
        return false;
    }
}

