/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

import org.bukkit.configuration.ConfigurationSection;

public class ModelFlying {
    public static final double HORIZONTAL_SPEED = 0.6;
    public static final double VERTICAL_ASCEND_SPEED = 1.0;
    private final String id;
    private double horizontalModSpeed = 100.0;
    private double horizontalModSprint = 1.92;
    private double verticalAscendModSpeed = 100.0;
    private boolean verticalAscendGliding = false;
    private double maxHeight = 128.0;
    private boolean applyModifiers = true;
    private boolean gravity = true;
    private boolean ground = true;
    private boolean scaleLevitationEffect = false;
    private boolean locked = false;

    public ModelFlying() {
        this(null);
    }

    public ModelFlying(String id) {
        this.id = id;
    }

    public ModelFlying(String id, ConfigurationSection config, String prefix, ModelFlying defaults) {
        this(id);
        this.horizontalModSpeed(config.getDouble(prefix + "horizontal.speed", defaults.getHorizontalModSpeed()));
        this.horizontalModSprint(config.getDouble(prefix + "horizontal.modsprint", defaults.getHorizontalModSprint()));
        this.verticalAscendModSpeed(config.getDouble(prefix + "vertical.ascend.speed", defaults.getVerticalAscendModSpeed()));
        this.verticalAscendGliding(defaults.getVerticalAscendGliding());
        this.maxHeight(config.getDouble(prefix + "vertical.maxheight", defaults.getMaxHeight()));
        this.applyModifiers(config.getBoolean(prefix + "modifiers", defaults.getApplyModifiers()));
        this.gravity(config.getBoolean(prefix + "vertical.gravity", defaults.getGravity()));
        this.ground(config.getBoolean(prefix + "ground", defaults.getGround()));
        this.scaleLevitationEffect(defaults.getScaleLevitationEffect());
    }

    public ModelFlying(String id, ModelFlying defaults) {
        this(id);
        this.horizontalModSpeed(defaults.getHorizontalModSpeed());
        this.horizontalModSprint(defaults.getHorizontalModSprint());
        this.verticalAscendModSpeed(defaults.getVerticalAscendModSpeed());
        this.verticalAscendGliding(defaults.getVerticalAscendGliding());
        this.maxHeight(defaults.getMaxHeight());
        this.applyModifiers(defaults.getApplyModifiers());
        this.gravity(defaults.getGravity());
        this.ground(defaults.getGround());
        this.scaleLevitationEffect(defaults.getScaleLevitationEffect());
    }

    public ModelFlying lock() {
        this.checkLocked();
        this.locked = true;
        return this;
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void checkLocked() {
        if (this.locked) {
            throw new RuntimeException("The model has been locked against changes.");
        }
    }

    public String getId() {
        return this.id;
    }

    public double getHorizontalModSpeed() {
        return this.horizontalModSpeed;
    }

    public double getHorizontalModSprint() {
        return this.horizontalModSprint;
    }

    public double getVerticalAscendModSpeed() {
        return this.verticalAscendModSpeed;
    }

    public boolean getVerticalAscendGliding() {
        return this.verticalAscendGliding;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public boolean getApplyModifiers() {
        return this.applyModifiers;
    }

    public boolean getGravity() {
        return this.gravity;
    }

    public boolean getGround() {
        return this.ground;
    }

    public boolean getScaleLevitationEffect() {
        return this.scaleLevitationEffect;
    }

    public ModelFlying horizontalModSpeed(double horizontalModSpeed) {
        this.checkLocked();
        this.horizontalModSpeed = horizontalModSpeed;
        return this;
    }

    public ModelFlying horizontalModSprint(double horizontalModSprint) {
        this.checkLocked();
        this.horizontalModSprint = horizontalModSprint;
        return this;
    }

    public ModelFlying verticalAscendModSpeed(double verticalAscendModSpeed) {
        this.checkLocked();
        this.verticalAscendModSpeed = verticalAscendModSpeed;
        return this;
    }

    public ModelFlying verticalAscendGliding(boolean verticalAscendGliding) {
        this.checkLocked();
        this.verticalAscendGliding = verticalAscendGliding;
        return this;
    }

    public ModelFlying maxHeight(double maxHeight) {
        this.checkLocked();
        this.maxHeight = maxHeight;
        return this;
    }

    public ModelFlying applyModifiers(boolean applyModifiers) {
        this.checkLocked();
        this.applyModifiers = applyModifiers;
        return this;
    }

    public ModelFlying gravity(boolean gravity) {
        this.checkLocked();
        this.gravity = gravity;
        return this;
    }

    public ModelFlying ground(boolean ground) {
        this.checkLocked();
        this.ground = ground;
        return this;
    }

    public ModelFlying scaleLevitationEffect(boolean scaleLevitationEffect) {
        this.checkLocked();
        this.scaleLevitationEffect = scaleLevitationEffect;
        return this;
    }
}

