/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.magic;

import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.player.Passable;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class LostGround {
    public static boolean lostGround(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, PlayerMoveData lastMove, MovingData data, MovingConfig cc, BlockChangeTracker blockChangeTracker, Collection<String> tags) {
        if (yDistance >= -0.7 && yDistance <= Math.max(cc.sfStepHeight, LiftOffEnvelope.NORMAL.getMaxJumpGain(data.jumpAmplifier) + 0.174)) {
            if (yDistance >= 0.0 && lastMove.toIsValid && LostGround.lostGroundAscend(player, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, tags)) {
                return true;
            }
            if (yDistance <= 0.0 && LostGround.lostGroundDescend(player, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, tags)) {
                return true;
            }
        } else if (yDistance < -0.7 && lastMove.toIsValid && hDistance <= 0.5 && LostGround.lostGroundFastDescend(player, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, tags)) {
            return true;
        }
        return blockChangeTracker != null && LostGround.lostGroundPastState(player, from, to, data, cc, blockChangeTracker, tags);
    }

    private static boolean lostGroundPastState(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, BlockChangeTracker blockChangeTracker, Collection<String> tags) {
        int tick = TickTask.getTick();
        if (from.isOnGroundOpportune(cc.yOnGround, 0L, blockChangeTracker, data.blockChangeRef, tick)) {
            return LostGround.applyLostGround(player, from, false, data.playerMoves.getCurrentMove(), data, "past", tags);
        }
        return false;
    }

    private static boolean lostGroundAscend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, PlayerMoveData lastMove, MovingData data, MovingConfig cc, Collection<String> tags) {
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        double setBackYDistance = from.getY() - data.getSetBackY();
        if (yDistance <= cc.sfStepHeight && hDistance <= 1.5) {
            double setBackYMargin = data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier) - setBackYDistance;
            if (setBackYMargin >= 0.0) {
                if (to.isOnGround() && setBackYMargin >= yDistance && (lastMove.yDistance < 0.0 || yDistance <= cc.sfStepHeight && from.isOnGround(cc.sfStepHeight - yDistance))) {
                    return LostGround.applyLostGround(player, from, true, thisMove, data, "step", tags);
                }
                double maxJumpGain = data.liftOffEnvelope.getMaxJumpGain(data.jumpAmplifier);
                if (maxJumpGain > yDistance && (yDistance > 0.0 && lastMove.yDistance < 0.0 && Math.abs(lastMove.yDistance) + 0.0834 + yDistance > cc.yOnGround + maxJumpGain && from.isOnGround(0.025) || lastMove.yDistance == 0.0 && LostGround.noobTowerStillCommon(to, yDistance))) {
                    return LostGround.applyLostGround(player, from, true, thisMove, data, "nbtwr", tags);
                }
            }
            if (lastMove.yDistance < 0.0) {
                if (BlockProperties.isOnGroundShuffled(to.getBlockCache(), from.getX(), from.getY() + cc.sfStepHeight, from.getZ(), to.getX(), to.getY(), to.getZ(), 0.1 + from.getBoxMarginHorizontal(), to.getyOnGround(), 0.0)) {
                    return LostGround.applyLostGround(player, from, false, thisMove, data, "couldstep", tags);
                }
                if (!to.isOnGround()) {
                    if (LostGround.lostGroundEdgeAsc(player, from.getBlockCache(), from.getWorld(), from.getX(), from.getY(), from.getZ(), from.getBoxMarginHorizontal(), from.getyOnGround(), lastMove, data, "asc1", tags, from.getMCAccess())) {
                        return true;
                    }
                    if (yDistance == 0.0 && lastMove.yDistance <= -0.1515 && hDistance <= lastMove.hDistance * 1.1) {
                        double xzMargin;
                        double d = xzMargin = lastMove.yDistance <= -0.23 ? 0.3 : 0.15;
                        if (LostGround.lostGroundEdgeAsc(player, from.getBlockCache(), to.getWorld(), to.getX(), to.getY(), to.getZ(), from.getX(), from.getY(), from.getZ(), hDistance, to.getBoxMarginHorizontal(), xzMargin, data, "asc5", tags, from.getMCAccess())) {
                            return true;
                        }
                    } else if (from.isOnGround(from.getyOnGround(), 0.0625, 0.0)) {
                        return LostGround.applyLostGround(player, from, false, thisMove, data, "edgeasc2", tags);
                    }
                }
            }
        }
        return false;
    }

    private static boolean noobTowerStillCommon(PlayerLocation to, double yDistance) {
        return yDistance < 0.025 && to.getY() - (double)to.getBlockY() < 0.025 && to.isOnGround(0.025);
    }

    public static boolean lostGroundStill(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, PlayerMoveData lastMove, MovingData data, MovingConfig cc, Collection<String> tags) {
        if (lastMove.yDistance <= -0.23 && lastMove.hDistance > 0.0 && lastMove.yDistance < -0.3) {
            if (LostGround.lostGroundEdgeAsc(player, from.getBlockCache(), to.getWorld(), to.getX(), to.getY(), to.getZ(), from.getX(), from.getY(), from.getZ(), hDistance, to.getBoxMarginHorizontal(), 0.3, data, "asc7", tags, from.getMCAccess())) {
                return true;
            }
        } else if ((lastMove.yDistance == 0.0 && lastMove.touchedGround || lastMove.yDistance < 0.0) && data.liftOffEnvelope.getMaxJumpGain(data.jumpAmplifier) > yDistance && LostGround.noobTowerStillCommon(to, yDistance)) {
            PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
            return LostGround.applyLostGround(player, from, true, thisMove, data, "nbtwr", tags);
        }
        return false;
    }

    private static boolean lostGroundEdgeAsc(Player player, BlockCache blockCache, World world, double x1, double y1, double z1, double boxMarginHorizontal, double yOnGround, PlayerMoveData lastMove, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        return LostGround.lostGroundEdgeAsc(player, blockCache, world, x1, y1, z1, lastMove.from.getX(), lastMove.from.getY(), lastMove.from.getZ(), lastMove.hDistance, boxMarginHorizontal, yOnGround, data, tag, tags, mcAccess);
    }

    private static boolean lostGroundEdgeAsc(Player player, BlockCache blockCache, World world, double x1, double y1, double z1, double x2, double y2, double z2, double hDistance2, double boxMarginHorizontal, double yOnGround, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        x2 -= x1;
        z2 -= z1;
        double fMin = 1.0;
        if (Math.abs(x2) > hDistance2) {
            fMin = Math.min(fMin, hDistance2 / Math.abs(x2));
        }
        if (Math.abs(z2) > hDistance2) {
            fMin = Math.min(fMin, hDistance2 / Math.abs(z2));
        }
        if (BlockProperties.isOnGroundShuffled(blockCache, x1, y1, z1, x2 = fMin * x2 + x1, y1, z2 = fMin * z2 + z1, boxMarginHorizontal, yOnGround, 0.0)) {
            return LostGround.applyLostGround(player, new Location(world, x2, y2, z2), true, data.playerMoves.getCurrentMove(), data, "edge" + tag, tags, mcAccess);
        }
        return false;
    }

    private static boolean lostGroundDescend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, PlayerMoveData lastMove, MovingData data, MovingConfig cc, Collection<String> tags) {
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        double setBackYDistance = to.getY() - data.getSetBackY();
        if (yDistance < 0.0 && !to.isOnGround() && from.isOnGround(from.getY() - to.getY() + 0.001)) {
            Location ref = from.getLocation();
            ref.setY(to.getY());
            if (Passable.isPassable(from.getLocation(), ref)) {
                return LostGround.applyLostGround(player, from, false, thisMove, data, "vcollide", tags);
            }
        }
        if (!lastMove.toIsValid) {
            return false;
        }
        if (data.sfJumpPhase <= 7) {
            if (lastMove.yDistance <= yDistance && setBackYDistance < 0.0 && !to.isOnGround() && from.isOnGround(0.6, 0.4, 0.0, 0L)) {
                return LostGround.applyLostGround(player, from, true, thisMove, data, "pyramid", tags);
            }
            if (yDistance == 0.0 && lastMove.yDistance > 0.0 && lastMove.yDistance < 0.25 && (double)data.sfJumpPhase <= Math.max(0.0, 6.0 + data.jumpAmplifier * 3.0) && setBackYDistance > 1.0 && setBackYDistance < Math.max(0.0, 1.5 + 0.2 * data.jumpAmplifier) && !to.isOnGround() && from.isOnGround(0.25, 0.4, 0.0, 0L)) {
                return LostGround.applyLostGround(player, from, true, thisMove, data, "ministep", tags);
            }
        }
        if (yDistance < 0.0 && hDistance <= 1.5 && lastMove.yDistance < 0.0 && yDistance > lastMove.yDistance && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.2, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return LostGround.applyLostGround(player, from, true, thisMove, data, "edgedesc", tags);
        }
        return false;
    }

    private static boolean lostGroundFastDescend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, PlayerMoveData lastMove, MovingData data, MovingConfig cc, Collection<String> tags) {
        if (yDistance > lastMove.yDistance && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.3, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return LostGround.applyLostGround(player, from, true, data.playerMoves.getCurrentMove(), data, "fastedge", tags);
        }
        return false;
    }

    private static boolean applyLostGround(Player player, Location refLoc, boolean setBackSafe, PlayerMoveData thisMove, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        if (setBackSafe) {
            data.setSetBack(refLoc);
        }
        return LostGround.applyLostGround(player, thisMove, data, tag, tags, mcAccess);
    }

    private static boolean applyLostGround(Player player, PlayerLocation refLoc, boolean setBackSafe, PlayerMoveData thisMove, MovingData data, String tag, Collection<String> tags) {
        if (setBackSafe) {
            data.setSetBack(refLoc);
        }
        return LostGround.applyLostGround(player, thisMove, data, tag, tags, refLoc.getMCAccess());
    }

    private static boolean applyLostGround(Player player, PlayerMoveData thisMove, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        data.sfJumpPhase = 0;
        data.jumpAmplifier = MovingUtil.getJumpAmplifier(player, mcAccess);
        data.clearAccounting();
        thisMove.touchedGround = true;
        thisMove.touchedGroundWorkaround = true;
        tags.add("lostground_" + tag);
        return true;
    }
}

