/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.location.setback;

import fr.neatmonster.nocheatplus.components.location.IGetLocationWithLook;
import fr.neatmonster.nocheatplus.components.location.ISetLocationWithLook;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import org.bukkit.Location;
import org.bukkit.World;

public class SetBackEntry
implements IGetLocationWithLook,
ISetLocationWithLook {
    private String worldName;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;
    private int time;
    private long msTime;
    private boolean isValid = false;

    public SetBackEntry set(Location loc, int time, long msTime) {
        return this.set(loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), time, msTime);
    }

    public SetBackEntry set(IGetLocationWithLook loc, int time, long msTime) {
        return this.set(loc.getWorldName(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), time, msTime);
    }

    public SetBackEntry set(String worldName, double x, double y, double z, float yaw, float pitch, int time, long msTime) {
        if (worldName == null) {
            throw new NullPointerException("World name must not be null.");
        }
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.time = time;
        this.msTime = msTime;
        this.isValid = true;
        return this;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    public int getTime() {
        return this.time;
    }

    public long getMsTime() {
        return this.msTime;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    @Override
    public void setX(double x) {
        this.x = x;
    }

    @Override
    public void setY(double y) {
        this.y = y;
    }

    @Override
    public void setZ(double z) {
        this.z = z;
    }

    @Override
    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Override
    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setMsTime(long msTime) {
        this.msTime = msTime;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean isValidAndOlderThan(SetBackEntry other) {
        return this.isValid && this.time < other.time;
    }

    public Location getLocation(World world) {
        if (!this.isValid) {
            throw new IllegalStateException("Can't return a Location instance from an invalid state.");
        }
        if (!world.getName().equals(this.worldName)) {
            throw new IllegalArgumentException("The name of the given world must equal the stored world name.");
        }
        return new Location(world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public int hashCode() {
        return LocUtil.hashCode(this);
    }

    public String toString() {
        return "SetBackEntry(" + this.worldName + "/" + LocUtil.simpleFormat(this) + ")";
    }
}

