/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.access.IRemoveSubCheckData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.location.setback.DefaultSetBackStorage;
import fr.neatmonster.nocheatplus.checks.moving.location.tracking.LocationTrace;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveConsistency;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveTrace;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.checks.moving.velocity.AccountEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.FrictionAxisVelocity;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleAxisVelocity;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.checks.workaround.WRPT;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.components.data.ICanHandleTimeRunningBackwards;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessDimensions;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.location.IPositionWithLook;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionAccumulator;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.RichEntityLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.workaround.IWorkaroundRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MovingData
extends ACheckData
implements IRemoveSubCheckData {
    public static final CheckDataFactory factory = new MovingDataFactory();
    private static Map<String, MovingData> playersMap = new HashMap<String, MovingData>();
    private static final LiftOffEnvelope defaultLiftOffEnvelope = LiftOffEnvelope.UNKNOWN;
    public static final int vehicleMorePacketsBufferDefault = 50;
    private static final double TOL_VVEL = 0.0625;
    public double creativeFlyVL = 0.0;
    public double morePacketsVL = 0.0;
    public double noFallVL = 0.0;
    public double survivalFlyVL = 0.0;
    public double vehicleMorePacketsVL = 0.0;
    public double vehicleEnvelopeVL = 0.0;
    public int bunnyhopDelay;
    public double jumpAmplifier = 0.0;
    public long timeSprinting = 0L;
    public double multSprinting = 1.30000002;
    public SimpleEntry verticalBounce = null;
    public final BlockChangeReference blockChangeRef = new BlockChangeReference();
    public int speedTick = 0;
    public float walkSpeed = 0.0f;
    public float flySpeed = 0.0f;
    private int playerMoveCount = 0;
    private int setBackResetTime = 0;
    private int morePacketsSetBackResetTime = 0;
    public IPositionWithLook crossWorldFrom = null;
    public final MoveTrace<PlayerMoveData> playerMoves = new MoveTrace<PlayerMoveData>(new Callable<PlayerMoveData>(){

        @Override
        public PlayerMoveData call() throws Exception {
            return new PlayerMoveData();
        }
    }, 2);
    public final MoveTrace<VehicleMoveData> vehicleMoves = new MoveTrace<VehicleMoveData>(new Callable<VehicleMoveData>(){

        @Override
        public VehicleMoveData call() throws Exception {
            return new VehicleMoveData();
        }
    }, 2);
    private final SimpleAxisVelocity verVel = new SimpleAxisVelocity();
    private final FrictionAxisVelocity horVel = new FrictionAxisVelocity();
    public int fireworksBoostDuration = 0;
    public int fireworksBoostTickExpire = 0;
    private final LocationTrace trace;
    public LiftOffEnvelope liftOffEnvelope = defaultLiftOffEnvelope;
    public int insideMediumCount = 0;
    public int combinedMediumHCount = 0;
    public double combinedMediumHValue = 0.0;
    private Location setBack = null;
    private Location teleported = null;
    public final ActionFrequency morePacketsFreq;
    public final ActionFrequency morePacketsBurstFreq;
    private Location morePacketsSetback = null;
    public float noFallFallDistance = 0.0f;
    public double noFallMaxY = 0.0;
    public boolean noFallSkipAirCheck = false;
    public double passableVL;
    public double sfHorizontalBuffer = 0.0;
    public int lostSprintCount = 0;
    public int sfJumpPhase = 0;
    public int sfZeroVdistRepeat = 0;
    private boolean sfDirty = false;
    public boolean sfLowJump = false;
    public boolean sfNoLowJump = false;
    public int sfHoverTicks = -1;
    public int sfHoverLoginTicks = 0;
    public int sfOnIce = 0;
    public long sfCobwebTime = 0L;
    public double sfCobwebVL = 0.0;
    public long sfVLTime = 0L;
    public final ActionAccumulator vDistAcc = new ActionAccumulator(3, 3);
    public double lastFrictionHorizontal = 0.0;
    public double lastFrictionVertical = 0.0;
    public double nextFrictionHorizontal = 0.0;
    public double nextFrictionVertical = 0.0;
    public final IWorkaroundRegistry.WorkaroundSet ws;
    public boolean joinOrRespawn = false;
    public int timeSinceSetBack = 0;
    public int lastSetBackHash = 0;
    public boolean wasInVehicle = false;
    public boolean isVehicleSetBack = false;
    public MoveConsistency vehicleConsistency = MoveConsistency.INCONSISTENT;
    public final DefaultSetBackStorage vehicleSetBacks = new DefaultSetBackStorage();
    public int vehicleMorePacketsBuffer = 50;
    public long vehicleMorePacketsLastTime;
    public int vehicleSetBackTaskId = -1;

    public static MovingData getData(Player player) {
        MovingData data = playersMap.get(player.getName());
        if (data == null) {
            data = new MovingData(MovingConfig.getConfig(player));
            playersMap.put(player.getName(), data);
        }
        return data;
    }

    public static ICheckData removeData(String playerName) {
        return playersMap.remove(playerName);
    }

    public static void clear() {
        playersMap.clear();
    }

    public static void onWorldUnload(World world) {
        String worldName = world.getName();
        for (MovingData data : playersMap.values()) {
            data.onWorldUnload(worldName);
        }
    }

    public static void onReload() {
        MovingConfig globalCc = MovingConfig.getConfig((String)null);
        int tick = TickTask.getTick();
        for (MovingData data : playersMap.values()) {
            data.adjustOnReload(globalCc, tick);
        }
    }

    public MovingData(MovingConfig config) {
        super(config);
        this.morePacketsFreq = new ActionFrequency(config.morePacketsEPSBuckets, 500L);
        this.morePacketsBurstFreq = new ActionFrequency(12, 5000L);
        this.trace = new LocationTrace(config.traceMaxAge, config.traceMaxSize, NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(LocationTrace.TraceEntryPool.class));
        this.ws = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(WRPT.class).getWorkaroundSet("moving");
    }

    @Override
    public boolean removeSubCheckData(CheckType checkType) {
        switch (checkType) {
            case MOVING_SURVIVALFLY: {
                this.survivalFlyVL = 0.0;
                this.clearFlyData();
                this.resetSetBack();
                return true;
            }
            case MOVING_CREATIVEFLY: {
                this.creativeFlyVL = 0.0;
                this.clearFlyData();
                this.resetSetBack();
                return true;
            }
            case MOVING_NOFALL: {
                this.noFallVL = 0.0;
                this.clearNoFallData();
                return true;
            }
            case MOVING_MOREPACKETS: {
                this.morePacketsVL = 0.0;
                this.clearPlayerMorePacketsData();
                this.morePacketsSetback = null;
                this.morePacketsSetBackResetTime = 0;
                return true;
            }
            case MOVING_PASSABLE: {
                this.passableVL = 0.0;
                return true;
            }
            case MOVING_VEHICLE: {
                this.vehicleEnvelopeVL = 0.0;
                this.vehicleMorePacketsVL = 0.0;
                this.clearVehicleData();
                return true;
            }
            case MOVING_VEHICLE_ENVELOPE: {
                this.vehicleEnvelopeVL = 0.0;
                this.vehicleMoves.invalidate();
                this.vehicleSetBacks.invalidateAll();
                return true;
            }
            case MOVING_VEHICLE_MOREPACKETS: {
                this.vehicleMorePacketsVL = 0.0;
                this.clearVehicleMorePacketsData();
                return true;
            }
        }
        return false;
    }

    public void clearMostMovingCheckData() {
        this.clearFlyData();
        this.clearVehicleData();
        this.clearAllMorePacketsData();
    }

    public void clearVehicleData() {
        this.vehicleMoves.invalidate();
        this.vehicleSetBacks.invalidateAll();
    }

    public void clearFlyData() {
        this.playerMoves.invalidate();
        this.bunnyhopDelay = 0;
        this.sfJumpPhase = 0;
        this.jumpAmplifier = 0.0;
        this.setBack = null;
        this.sfZeroVdistRepeat = 0;
        this.clearAccounting();
        this.clearNoFallData();
        this.removeAllPlayerSpeedModifiers();
        this.lostSprintCount = 0;
        this.sfHoverLoginTicks = -1;
        this.sfHoverTicks = -1;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.insideMediumCount = 0;
        this.vehicleConsistency = MoveConsistency.INCONSISTENT;
        this.lastFrictionVertical = 0.0;
        this.lastFrictionHorizontal = 0.0;
        this.verticalBounce = null;
        this.blockChangeRef.valid = false;
    }

    public void onSetBack(PlayerLocation setBack) {
        this.morePacketsSetback = null;
        this.clearAccounting();
        this.lostSprintCount = 0;
        this.sfHoverTicks = -1;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.insideMediumCount = 0;
        this.removeAllPlayerSpeedModifiers();
        this.vehicleConsistency = MoveConsistency.INCONSISTENT;
        this.lastFrictionVertical = 0.0;
        this.lastFrictionHorizontal = 0.0;
        this.verticalBounce = null;
        this.timeSinceSetBack = 0;
        this.lastSetBackHash = setBack == null ? 0 : setBack.hashCode();
        this.resetPlayerPositions(setBack);
        this.adjustMediumProperties(setBack);
        if (setBack == null) {
            this.setSetBack(setBack);
        }
    }

    public void prepareSetBack(Location loc) {
        this.playerMoves.invalidate();
        this.vehicleMoves.invalidate();
        this.clearAccounting();
        this.sfJumpPhase = 0;
        this.sfZeroVdistRepeat = 0;
        this.verticalBounce = null;
        this.setTeleported(loc);
    }

    public void adjustMediumProperties(PlayerLocation loc) {
        loc.collectBlockFlags();
        if (loc.isInWeb()) {
            this.liftOffEnvelope = LiftOffEnvelope.NO_JUMP;
            this.nextFrictionVertical = 0.0;
            this.nextFrictionHorizontal = 0.0;
        } else if (loc.isInLiquid()) {
            this.liftOffEnvelope = LiftOffEnvelope.LIMIT_LIQUID;
            if (loc.isInLava()) {
                this.nextFrictionVertical = 0.535;
                this.nextFrictionHorizontal = 0.535;
            } else {
                this.nextFrictionVertical = 0.89;
                this.nextFrictionHorizontal = 0.89;
            }
        } else if (loc.isOnGround()) {
            this.liftOffEnvelope = LiftOffEnvelope.NORMAL;
            this.nextFrictionVertical = 0.98;
            this.nextFrictionHorizontal = 0.98;
        } else {
            this.liftOffEnvelope = LiftOffEnvelope.UNKNOWN;
            this.nextFrictionVertical = 0.98;
            this.nextFrictionHorizontal = 0.98;
        }
        this.insideMediumCount = 0;
    }

    public void onPlayerLeave() {
        this.removeAllPlayerSpeedModifiers();
        this.trace.reset();
        this.playerMoves.invalidate();
        this.vehicleMoves.invalidate();
    }

    public void onWorldUnload(String worldName) {
        if (this.teleported != null && worldName.equalsIgnoreCase(this.teleported.getWorld().getName())) {
            this.resetTeleported();
        }
        if (this.setBack != null && worldName.equalsIgnoreCase(this.setBack.getWorld().getName())) {
            this.clearFlyData();
        }
        if (this.morePacketsSetback != null && worldName.equalsIgnoreCase(this.morePacketsSetback.getWorld().getName())) {
            this.clearPlayerMorePacketsData();
            this.clearNoFallData();
        }
        this.vehicleSetBacks.resetByWorldName(worldName);
    }

    public void resetPlayerPositions(PlayerLocation loc) {
        this.resetPlayerPositions();
        if (loc != null) {
            PlayerMoveData lastMove = this.playerMoves.getFirstPastMove();
            lastMove.setWithExtraProperties(loc);
        }
    }

    private void resetPlayerPositions() {
        this.playerMoves.invalidate();
        this.sfZeroVdistRepeat = 0;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.insideMediumCount = 0;
        this.lastFrictionVertical = 0.0;
        this.lastFrictionHorizontal = 0.0;
        this.verticalBounce = null;
        this.blockChangeRef.valid = false;
    }

    public void resetVehiclePositions(RichEntityLocation loc) {
        this.vehicleMoves.invalidate();
        if (loc != null) {
            VehicleMoveData lastMove = this.vehicleMoves.getFirstPastMove();
            lastMove.setWithExtraProperties(loc);
            Entity entity = loc.getEntity();
            lastMove.vehicleId = entity.getUniqueId();
            lastMove.vehicleType = entity.getType();
        }
    }

    public void clearAccounting() {
        this.vDistAcc.clear();
    }

    public void clearAllMorePacketsData() {
        this.clearPlayerMorePacketsData();
        this.clearVehicleMorePacketsData();
    }

    public void clearPlayerMorePacketsData() {
        this.morePacketsSetback = null;
        long now = System.currentTimeMillis();
        this.morePacketsFreq.clear(now);
        this.morePacketsBurstFreq.clear(now);
    }

    public void reducePlayerMorePacketsData(float amount) {
        CheckUtils.reduce(System.currentTimeMillis(), amount, this.morePacketsFreq, this.morePacketsBurstFreq);
    }

    public void clearVehicleMorePacketsData() {
        this.vehicleMorePacketsLastTime = 0L;
        this.vehicleMorePacketsBuffer = 50;
        this.vehicleSetBacks.getMidTermEntry().setValid(false);
    }

    public void clearNoFallData() {
        this.noFallFallDistance = 0.0f;
        this.noFallMaxY = 0.0;
        this.noFallSkipAirCheck = false;
    }

    public void setSetBack(PlayerLocation loc) {
        if (this.setBack == null) {
            this.setBack = loc.getLocation();
        } else {
            LocUtil.set(this.setBack, loc);
        }
        this.setBackResetTime = this.playerMoveCount;
    }

    public void setSetBack(Location loc) {
        if (this.setBack == null) {
            this.setBack = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.setBack, loc);
        }
        this.setBackResetTime = this.playerMoveCount;
    }

    public Location getSetBack(Location ref) {
        return LocUtil.clone(this.setBack, ref);
    }

    public Location getSetBack(PlayerLocation ref) {
        return LocUtil.clone(this.setBack, ref);
    }

    public boolean hasSetBack() {
        return this.setBack != null;
    }

    public boolean hasSetBackWorldChanged(Location loc) {
        if (this.setBack == null) {
            return true;
        }
        return this.setBack.getWorld().equals(loc.getWorld());
    }

    public double getSetBackX() {
        return this.setBack.getX();
    }

    public double getSetBackY() {
        return this.setBack.getY();
    }

    public double getSetBackZ() {
        return this.setBack.getZ();
    }

    public void setSetBackY(double y) {
        this.setBack.setY(y);
    }

    public boolean hasTeleported() {
        return this.teleported != null;
    }

    public final Location getTeleported() {
        return this.teleported == null ? this.teleported : LocUtil.clone(this.teleported);
    }

    public boolean isTeleported(Location loc) {
        return loc != null && this.teleported != null && this.teleported.equals((Object)loc);
    }

    public boolean isTeleportedPosition(Location loc) {
        return loc != null && this.teleported != null && TrigUtil.isSamePos(this.teleported, loc);
    }

    public boolean isTeleportedPosition(IGetPosition pos) {
        return pos != null && this.teleported != null && TrigUtil.isSamePos(pos, this.teleported);
    }

    public final void setTeleported(Location loc) {
        this.teleported = LocUtil.clone(loc);
    }

    public boolean hasMorePacketsSetBack() {
        return this.morePacketsSetback != null;
    }

    public boolean isMorePacketsSetBackOldest() {
        return this.morePacketsSetBackResetTime < this.setBackResetTime;
    }

    public final void setMorePacketsSetBack(PlayerLocation loc) {
        if (this.morePacketsSetback == null) {
            this.morePacketsSetback = loc.getLocation();
        } else {
            LocUtil.set(this.morePacketsSetback, loc);
        }
        this.morePacketsSetBackResetTime = this.playerMoveCount;
    }

    public final void setMorePacketsSetBack(Location loc) {
        if (this.morePacketsSetback == null) {
            this.morePacketsSetback = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.morePacketsSetback, loc);
        }
        this.morePacketsSetBackResetTime = this.playerMoveCount;
    }

    public Location getMorePacketsSetBack() {
        return LocUtil.clone(this.morePacketsSetback);
    }

    public final void resetTeleported() {
        this.teleported = null;
    }

    public final void resetSetBack() {
        this.setBack = null;
    }

    public void addVelocity(Player player, MovingConfig cc, double vx, double vy, double vz) {
        this.addVelocity(player, cc, vx, vy, vz, 0L);
    }

    public void addVelocity(Player player, MovingConfig cc, double vx, double vy, double vz, long flags) {
        int tick = TickTask.getTick();
        this.removeInvalidVelocity(tick - cc.velocityActivationTicks);
        if (this.debug) {
            CheckUtils.debug(player, CheckType.MOVING, "New velocity: " + vx + ", " + vy + ", " + vz);
        }
        this.verVel.add(new SimpleEntry(tick, vy, flags, cc.velocityActivationCounter));
        if (vx != 0.0 || vz != 0.0) {
            double newVal = Math.sqrt(vx * vx + vz * vz);
            this.horVel.add(new AccountEntry(tick, newVal, cc.velocityActivationCounter, MovingData.getHorVelValCount(newVal)));
        }
        this.sfDirty = true;
        this.sfNoLowJump = true;
    }

    public static int getHorVelValCount(double velocity) {
        return Math.max(20, 1 + (int)Math.round(velocity * 10.0));
    }

    public void prependVerticalVelocity(SimpleEntry entry) {
        this.verVel.addToFront(entry);
    }

    public SimpleEntry peekVerticalVelocity(double amount, int minActCount, int maxActCount) {
        return this.verVel.peek(amount, minActCount, maxActCount, 0.0625);
    }

    public void addVerticalVelocity(SimpleEntry entry) {
        this.verVel.add(entry);
    }

    public void addHorizontalVelocity(AccountEntry vel) {
        this.horVel.add(vel);
    }

    private void removeAllPlayerSpeedModifiers() {
        this.removeAllVelocity();
        this.fireworksBoostDuration = 0;
        this.fireworksBoostTickExpire = 0;
        this.sfHorizontalBuffer = 0.0;
    }

    public void removeAllVelocity() {
        this.horVel.clear();
        this.verVel.clear();
        this.sfDirty = false;
    }

    public void removeInvalidVelocity(int tick) {
        this.horVel.removeInvalid(tick);
        this.verVel.removeInvalid(tick);
    }

    public void clearActiveHorVel() {
        this.horVel.clearActive();
    }

    public boolean hasActiveHorVel() {
        return this.horVel.hasActive();
    }

    public boolean hasQueuedHorVel() {
        return this.horVel.hasQueued();
    }

    public boolean hasAnyHorVel() {
        return this.horVel.hasAny();
    }

    public boolean hasAnyVerVel() {
        return this.verVel.hasQueued();
    }

    public void velocityTick(int invalidateBeforeTick) {
        this.removeInvalidVelocity(invalidateBeforeTick);
        this.horVel.tick();
        if (!this.sfDirty && (this.horVel.hasActive() || this.horVel.hasQueued())) {
            this.sfDirty = true;
        }
    }

    public double getHorizontalFreedom() {
        return this.horVel.getFreedom();
    }

    public double useHorizontalVelocity(double amount) {
        double available = this.horVel.use(amount);
        if (available >= amount) {
            this.sfDirty = true;
        }
        return available;
    }

    public void addHorizontalVelocity(StringBuilder builder) {
        if (this.horVel.hasActive()) {
            builder.append("\n horizontal velocity (active):");
            this.horVel.addActive(builder);
        }
        if (this.horVel.hasQueued()) {
            builder.append("\n horizontal velocity (queued):");
            this.horVel.addQueued(builder);
        }
    }

    public SimpleEntry useVerticalVelocity(double amount) {
        SimpleEntry available = this.verVel.use(amount, 0.0625);
        if (available != null) {
            this.playerMoves.getCurrentMove().verVelUsed = available;
            this.sfDirty = true;
        }
        return available;
    }

    public SimpleEntry getOrUseVerticalVelocity(double amount) {
        SimpleEntry verVelUsed = this.playerMoves.getCurrentMove().verVelUsed;
        if (verVelUsed != null && this.verVel.matchesEntry(verVelUsed, amount, 0.0625)) {
            return verVelUsed;
        }
        return this.useVerticalVelocity(amount);
    }

    public void addVerticalVelocity(StringBuilder builder) {
        if (this.verVel.hasQueued()) {
            builder.append("\n vertical velocity (queued):");
            this.verVel.addQueued(builder);
        }
    }

    public boolean isSetBack(Location loc) {
        if (loc == null || this.setBack == null) {
            return false;
        }
        if (!loc.getWorld().getName().equals(this.setBack.getWorld().getName())) {
            return false;
        }
        return loc.getX() == this.setBack.getX() && loc.getY() == this.setBack.getY() && loc.getZ() == this.setBack.getZ();
    }

    public void adjustWalkSpeed(float walkSpeed, int tick, int speedGrace) {
        if (walkSpeed > this.walkSpeed) {
            this.walkSpeed = walkSpeed;
            this.speedTick = tick;
        } else if (walkSpeed < this.walkSpeed) {
            if (tick - this.speedTick > speedGrace) {
                this.walkSpeed = walkSpeed;
                this.speedTick = tick;
            }
        } else {
            this.speedTick = tick;
        }
    }

    public void adjustFlySpeed(float flySpeed, int tick, int speedGrace) {
        if (flySpeed > this.flySpeed) {
            this.flySpeed = flySpeed;
            this.speedTick = tick;
        } else if (flySpeed < this.flySpeed) {
            if (tick - this.speedTick > speedGrace) {
                this.flySpeed = flySpeed;
                this.speedTick = tick;
            }
        } else {
            this.speedTick = tick;
        }
    }

    public boolean hasTrace() {
        return this.trace != null;
    }

    public LocationTrace getTrace(Player player) {
        return this.trace;
    }

    private LocationTrace getTrace(int maxAge, int maxSize) {
        if (this.trace.getMaxSize() != maxSize || this.trace.getMaxAge() != (long)maxAge) {
            this.trace.adjustSettings(maxAge, maxSize, TickTask.getTick());
        }
        return this.trace;
    }

    public LocationTrace updateTrace(Player player, Location loc, long time, IEntityAccessDimensions iead) {
        LocationTrace trace = this.getTrace(player);
        if (iead == null) {
            trace.addEntry(time, loc.getX(), loc.getY(), loc.getZ(), 0.3, player.getEyeHeight());
        } else {
            trace.addEntry(time, loc.getX(), loc.getY(), loc.getZ(), iead.getWidth((Entity)player) / 2.0, Math.max(player.getEyeHeight(), iead.getHeight((Entity)player)));
        }
        return trace;
    }

    public void resetTrace(Player player, Location loc, long time, IEntityAccessDimensions iead, MovingConfig cc) {
        this.resetTrace(player, loc, time, cc.traceMaxAge, cc.traceMaxSize, iead);
    }

    public void resetTrace(Player player, Location loc, long time, int maxAge, int maxSize, IEntityAccessDimensions iead) {
        if (this.trace != null) {
            this.trace.reset();
        }
        this.getTrace(maxAge, maxSize).addEntry(time, loc.getX(), loc.getY(), loc.getZ(), iead.getWidth((Entity)player) / 2.0, Math.max(player.getEyeHeight(), iead.getHeight((Entity)player)));
    }

    protected void adjustOnReload(MovingConfig cc, int tick) {
        this.trace.adjustSettings(cc.traceMaxAge, cc.traceMaxSize, tick);
    }

    public boolean isVelocityJumpPhase() {
        return this.sfDirty;
    }

    public boolean resetVelocityJumpPhase() {
        return this.resetVelocityJumpPhase(null);
    }

    public boolean resetVelocityJumpPhase(Collection<String> tags) {
        if (this.horVel.hasActive() || this.horVel.hasQueued() || this.sfDirty && this.shouldRetainSFDirty(tags)) {
            this.sfDirty = true;
            return true;
        }
        this.sfDirty = false;
        return false;
    }

    private final boolean shouldRetainSFDirty(Collection<String> tags) {
        SimpleEntry entry;
        PlayerMoveData thisMove = this.playerMoves.getLatestValidMove();
        if ((thisMove == null || !thisMove.toIsValid || thisMove.yDistance >= 0.0) && ((entry = this.verVel.peek(thisMove == null ? 0.05 : thisMove.yDistance, 0, 4, 0.0)) != null && entry.hasFlag(512L) || thisMove != null && thisMove.verVelUsed != null && thisMove.verVelUsed.hasFlag(512L))) {
            if (tags != null) {
                tags.add("retain_dirty_bounce");
            }
            return true;
        }
        return false;
    }

    public void setFrictionJumpPhase() {
        this.sfDirty = true;
    }

    public void useVerticalBounce(Player player) {
        player.setFallDistance(0.0f);
        this.noFallMaxY = 0.0;
        this.noFallFallDistance = 0.0f;
        this.noFallSkipAirCheck = true;
        this.prependVerticalVelocity(this.verticalBounce);
        this.verticalBounce = null;
    }

    public void handleTimeRanBackwards() {
        long time = System.currentTimeMillis();
        this.timeSprinting = Math.min(this.timeSprinting, time);
        this.vehicleMorePacketsLastTime = Math.min(this.vehicleMorePacketsLastTime, time);
        this.sfCobwebTime = Math.min(this.sfCobwebTime, time);
        this.sfVLTime = Math.min(this.sfVLTime, time);
        this.clearAccounting();
        this.removeAllPlayerSpeedModifiers();
    }

    public SimpleAxisVelocity getVerticalVelocityTracker() {
        return this.verVel;
    }

    public int getPlayerMoveCount() {
        return this.playerMoveCount;
    }

    public void increasePlayerMoveCount() {
        ++this.playerMoveCount;
        if (this.playerMoveCount == Integer.MAX_VALUE) {
            this.playerMoveCount = 0;
            this.morePacketsSetBackResetTime = 0;
            this.setBackResetTime = 0;
        }
    }

    public int getMorePacketsSetBackAge() {
        return this.playerMoveCount - this.morePacketsSetBackResetTime;
    }

    public void removeLeadingQueuedVerticalVelocityByFlag(long flag) {
        this.verVel.removeLeadingQueuedVerticalVelocityByFlag(flag);
    }

    public static final class MovingDataFactory
    implements CheckDataFactory,
    ICanHandleTimeRunningBackwards {
        @Override
        public final ICheckData getData(Player player) {
            return MovingData.getData(player);
        }

        @Override
        public ICheckData getDataIfPresent(UUID playerId, String playerName) {
            return (ICheckData)playersMap.get(playerName);
        }

        @Override
        public ICheckData removeData(String playerName) {
            return MovingData.removeData(playerName);
        }

        @Override
        public void removeAllData() {
            MovingData.clear();
        }

        @Override
        public void handleTimeRanBackwards() {
            for (MovingData data : playersMap.values()) {
                data.handleTimeRanBackwards();
            }
        }
    }
}

