/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.WrapBlockCache;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;

public class HotFixFallingBlockPortalEnter
implements Listener {
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final WrapBlockCache wrapBlockCache;

    public static void testAvailability() {
        if (ReflectionUtil.getClass("org.bukkit.event.entity.EntityPortalEnterEvent") == null || ReflectionUtil.getClass("org.bukkit.entity.FallingBlock") == null) {
            throw new RuntimeException("Not available.");
        }
        if (!ServerVersion.isMinecraftVersionUnknown() && ServerVersion.compareMinecraftVersion("1.9") < 0) {
            throw new RuntimeException("Not needed.");
        }
    }

    public HotFixFallingBlockPortalEnter() {
        HotFixFallingBlockPortalEnter.testAvailability();
        this.wrapBlockCache = new WrapBlockCache();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        Entity entity = event.getEntity();
        Object mat = entity instanceof FallingBlock ? ((FallingBlock)entity).getMaterial() : (entity instanceof Item ? (((Item)entity).getItemStack().getType().hasGravity() ? ((Item)entity).getItemStack().getType() : null) : null);
        if (mat != null) {
            Location loc = entity.getLocation(this.useLoc);
            World world = loc.getWorld();
            if (InventoryConfig.getConfig((World)world).hotFixFallingBlockEndPortalActive) {
                BlockCache blockCache = this.wrapBlockCache.getBlockCache();
                blockCache.setAccess(world);
                boolean nearbyPortal = BlockProperties.collidesId(blockCache, loc.getX() - 2.0, loc.getY() - 2.0, loc.getZ() - 2.0, loc.getX() + 3.0, loc.getY() + 3.0, loc.getZ() + 3.0, Material.ENDER_PORTAL);
                blockCache.cleanup();
                if (nearbyPortal) {
                    entity.remove();
                    String message = "[INVENTORY_HOTFIX] Remove falling block entering a portal near an end portal: " + mat + " at " + world.getName() + "/" + LocUtil.simpleFormatPosition(loc);
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, message);
                }
            }
            this.useLoc.setWorld(null);
        }
    }
}

