/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.utilities.InventoryUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class FastClick
extends Check {
    public FastClick() {
        super(CheckType.INVENTORY_FASTCLICK);
    }

    public boolean check(Player player, long now, InventoryView view, int slot, ItemStack cursor, ItemStack clicked, boolean isShiftClick, InventoryData data, InventoryConfig cc, PlayerData pData) {
        float amount;
        if (cursor != null && cc.fastClickTweaks1_5) {
            Material clickedMat;
            Material cursorMat = cursor.getType();
            int cursorAmount = Math.max(1, cursor.getAmount());
            Material material = clickedMat = clicked == null ? Material.AIR : clicked.getType();
            amount = cursorMat != data.fastClickLastCursor && (!isShiftClick || clicked == null || clicked.getType() != data.fastClickLastClicked) || cursorMat == Material.AIR || cursorAmount != data.fastClickLastCursorAmount ? 1.0f : (clickedMat == Material.AIR || clickedMat == cursorMat || isShiftClick && clickedMat == data.fastClickLastClicked ? Math.min(cc.fastClickNormalLimit, cc.fastClickShortTermLimit) / (float)(isShiftClick && clickedMat != Material.AIR ? 1.0 + (double)Math.max(cursorAmount, InventoryUtil.getStackCount(view, clicked)) : (double)cursorAmount) * 0.75f : 1.0f);
            data.fastClickLastCursor = cursorMat;
            data.fastClickLastClicked = clickedMat;
            data.fastClickLastCursorAmount = cursorAmount;
        } else {
            data.fastClickLastCursor = null;
            data.fastClickLastClicked = null;
            data.fastClickLastCursorAmount = 0;
            amount = 1.0f;
        }
        data.fastClickFreq.add(now, amount);
        float shortTerm = data.fastClickFreq.bucketScore(0);
        if (shortTerm > cc.fastClickShortTermLimit) {
            shortTerm /= TickTask.getLag(data.fastClickFreq.bucketDuration(), true);
        }
        shortTerm -= cc.fastClickShortTermLimit;
        float normal = data.fastClickFreq.score(1.0f);
        if (normal > cc.fastClickNormalLimit) {
            normal /= TickTask.getLag(data.fastClickFreq.bucketDuration() * (long)data.fastClickFreq.numberOfBuckets(), true);
        }
        double violation = Math.max(shortTerm, normal -= cc.fastClickNormalLimit);
        boolean cancel = false;
        if (violation > 0.0) {
            data.fastClickVL += violation;
            ViolationData vd = new ViolationData(this, player, data.fastClickVL, violation, cc.fastClickActions);
            cancel = this.executeActions(vd).willCancel();
        }
        if (data.debug && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
            player.sendMessage("FastClick: " + data.fastClickFreq.bucketScore(0) + " | " + data.fastClickFreq.score(1.0f) + " | cursor=" + cursor + " | clicked=" + clicked);
        }
        return cancel;
    }
}

