/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors;

import fr.neatmonster.nocheatplus.checks.chat.analysis.WordLetterCount;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.AbstractWordProcessor;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class DigestedWords
extends AbstractWordProcessor {
    protected boolean sort = false;
    protected boolean compress = false;
    protected boolean split = false;
    protected int minWordSize = 0;
    protected int maxWordSize = 0;
    protected final List<Character> letters = new ArrayList<Character>(10);
    protected final List<Character> digits = new ArrayList<Character>(10);
    protected final List<Character> other = new ArrayList<Character>(10);

    public DigestedWords(String name, DigestedWordsSettings settings) {
        this(name);
        this.weight = settings.weight;
        this.minWordSize = settings.minWordSize;
        this.maxWordSize = settings.maxWordSize;
        this.sort = settings.sort;
        this.compress = settings.compress;
        this.split = settings.split;
    }

    public DigestedWords(String name) {
        super(name);
    }

    @Override
    public float loop(long ts, int index, String key, WordLetterCount word) {
        Collection<Character> chars;
        this.letters.clear();
        this.digits.clear();
        this.other.clear();
        if (this.compress) {
            chars = word.counts.keySet();
        } else {
            chars = new ArrayList(word.word.length());
            for (int i = 0; i < word.word.length(); ++i) {
                char c = word.word.charAt(i);
                if (Character.isUpperCase(c)) {
                    c = Character.toLowerCase(c);
                }
                chars.add(Character.valueOf(c));
            }
        }
        int len = chars.size();
        for (Character c : chars) {
            if (!this.split || Character.isLetter(c.charValue())) {
                this.letters.add(c);
                continue;
            }
            if (Character.isDigit(c.charValue())) {
                this.digits.add(c);
                continue;
            }
            this.other.add(c);
        }
        float score = 0.0f;
        if (this.prepare(this.letters)) {
            score += this.getScore(this.letters, ts) * (float)this.letters.size();
        }
        if (this.prepare(this.digits)) {
            score += this.getScore(this.digits, ts) * (float)this.digits.size();
        }
        if (this.prepare(this.other)) {
            score += this.getScore(this.other, ts) * (float)this.other.size();
        }
        return len == 0 ? 0.0f : score / (float)len;
    }

    protected boolean prepare(List<Character> chars) {
        if (chars.isEmpty()) {
            return false;
        }
        int size = chars.size();
        if (size < this.minWordSize) {
            return false;
        }
        if (this.maxWordSize > 0 && size > this.maxWordSize) {
            return false;
        }
        if (this.sort) {
            Collections.sort(chars);
        }
        return true;
    }

    @Override
    public void clear() {
        this.letters.clear();
        this.digits.clear();
        this.other.clear();
        super.clear();
    }

    public static final char[] toArray(Collection<Character> chars) {
        char[] a = new char[chars.size()];
        int i = 0;
        for (Character c : chars) {
            a[i] = c.charValue();
            ++i;
        }
        return a;
    }

    protected abstract float getScore(List<Character> var1, long var2);

    public static class DigestedWordsSettings {
        public boolean sort = false;
        public boolean compress = false;
        public boolean split = false;
        public float weight = 1.0f;
        public int minWordSize = 0;
        public int maxWordSize = 0;

        public DigestedWordsSettings applyConfig(ConfigFile config, String prefix) {
            this.sort = config.getBoolean(prefix + "sort", this.sort);
            this.compress = config.getBoolean(prefix + "compress", this.compress);
            this.split = config.getBoolean(prefix + "split", this.split);
            this.weight = (float)config.getDouble(prefix + "weight", this.weight);
            this.minWordSize = config.getInt(prefix + "minwordsize", this.minWordSize);
            this.maxWordSize = config.getInt(prefix + "maxwordsize", this.maxWordSize);
            return this;
        }
    }
}

