/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.checks.access.CheckConfigFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class BlockInteractConfig
extends ACheckConfig {
    public static final CheckConfigFactory factory = new CheckConfigFactory(){

        @Override
        public final ICheckConfig getConfig(Player player) {
            return BlockInteractConfig.getConfig(player);
        }

        @Override
        public void removeAllConfigs() {
            BlockInteractConfig.clear();
        }
    };
    private static final Map<String, BlockInteractConfig> worldsMap = new HashMap<String, BlockInteractConfig>();
    public final boolean directionCheck;
    public final ActionList directionActions;
    public final boolean reachCheck;
    public final ActionList reachActions;
    public final boolean speedCheck;
    public final long speedInterval;
    public final int speedLimit;
    public final ActionList speedActions;
    public final boolean visibleCheck;
    public final ActionList visibleActions;

    public static void clear() {
        worldsMap.clear();
    }

    public static BlockInteractConfig getConfig(Player player) {
        if (!worldsMap.containsKey(player.getWorld().getName())) {
            worldsMap.put(player.getWorld().getName(), new BlockInteractConfig(ConfigManager.getConfigFile(player.getWorld().getName())));
        }
        return worldsMap.get(player.getWorld().getName());
    }

    public BlockInteractConfig(ConfigFile data) {
        super(data, "checks.blockinteract.");
        this.directionCheck = data.getBoolean("checks.blockinteract.direction.active");
        this.directionActions = (ActionList)data.getOptimizedActionList("checks.blockinteract.direction.actions", Permissions.BLOCKINTERACT_DIRECTION);
        this.reachCheck = data.getBoolean("checks.blockinteract.reach.active");
        this.reachActions = (ActionList)data.getOptimizedActionList("checks.blockinteract.reach.actions", Permissions.BLOCKINTERACT_REACH);
        this.speedCheck = data.getBoolean("checks.blockinteract.speed.active");
        this.speedInterval = data.getLong("checks.blockinteract.speed.interval");
        this.speedLimit = data.getInt("checks.blockinteract.speed.limit");
        this.speedActions = (ActionList)data.getOptimizedActionList("checks.blockinteract.speed.actions", Permissions.BLOCKINTERACT_SPEED);
        this.visibleCheck = data.getBoolean("checks.blockinteract.visible.active");
        this.visibleActions = (ActionList)data.getOptimizedActionList("checks.blockinteract.visible.actions", Permissions.BLOCKINTERACT_VISIBLE);
    }

    @Override
    public final boolean isEnabled(CheckType checkType) {
        switch (checkType) {
            case BLOCKINTERACT_SPEED: {
                return this.speedCheck;
            }
            case BLOCKINTERACT_DIRECTION: {
                return this.directionCheck;
            }
            case BLOCKINTERACT_REACH: {
                return this.reachCheck;
            }
            case BLOCKINTERACT_VISIBLE: {
                return this.visibleCheck;
            }
        }
        return true;
    }
}

