/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockbreak;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakConfig;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.utilities.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class FastBreak
extends Check {
    public FastBreak() {
        super(CheckType.BLOCKBREAK_FASTBREAK);
    }

    public boolean check(Player player, Block block, AlmostBoolean isInstaBreak, BlockBreakConfig cc, BlockBreakData data, PlayerData pData) {
        long elapsedTime;
        long now = System.currentTimeMillis();
        boolean cancel = false;
        Material blockType = block.getType();
        long expectedBreakingTime = Math.max(0L, Math.round((double)BlockProperties.getBreakingDuration(blockType, player) * (double)cc.fastBreakModSurvival / 100.0));
        if (cc.fastBreakStrict) {
            elapsedTime = data.fastBreakBreakTime > data.fastBreakfirstDamage ? 0L : now - data.fastBreakfirstDamage;
        } else {
            long l = elapsedTime = data.fastBreakBreakTime > now ? 0L : now - data.fastBreakBreakTime;
        }
        if (!isInstaBreak.decideOptimistically() && elapsedTime >= 0L) {
            if (elapsedTime + cc.fastBreakDelay < expectedBreakingTime) {
                float lag = cc.lag ? TickTask.getLag(expectedBreakingTime, true) : 1.0f;
                long missingTime = expectedBreakingTime - (long)(lag * (float)elapsedTime);
                if (missingTime > 0L) {
                    data.fastBreakPenalties.add(now, missingTime);
                    if (data.fastBreakPenalties.score(cc.fastBreakBucketFactor) > (float)cc.fastBreakGrace) {
                        double vlAdded = (double)missingTime / 1000.0;
                        data.fastBreakVL += vlAdded;
                        ViolationData vd = new ViolationData(this, player, data.fastBreakVL, vlAdded, cc.fastBreakActions);
                        if (vd.needsParameters()) {
                            vd.setParameter(ParameterName.BLOCK_TYPE, blockType.toString());
                        }
                        cancel = this.executeActions(vd).willCancel();
                    }
                }
            } else if (expectedBreakingTime > cc.fastBreakDelay) {
                data.fastBreakVL *= 0.9;
            }
        }
        if (data.debug && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
            if (data.stats != null) {
                data.stats.addStats(data.stats.getId(blockType + "/u", true), elapsedTime);
                data.stats.addStats(data.stats.getId(blockType + "/r", true), expectedBreakingTime);
                player.sendMessage(data.stats.getStatsStr(true));
            }
            ItemStack stack = Bridge1_9.getItemInMainHand(player);
            boolean isValidTool = BlockProperties.isValidTool(blockType, stack);
            double haste = PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.FAST_DIGGING);
            String msg = (isInstaBreak.decideOptimistically() ? "[Insta=" + (Object)((Object)isInstaBreak) + "]" : "[Normal]") + "[" + blockType + "] " + elapsedTime + "u / " + expectedBreakingTime + "r (" + (isValidTool ? "tool" : "no-tool") + ")" + (Double.isInfinite(haste) ? "" : " haste=" + ((int)haste + 1));
            player.sendMessage(msg);
        }
        return cancel;
    }
}

