/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockbreak;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakConfig;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.checks.blockbreak.Direction;
import fr.neatmonster.nocheatplus.checks.blockbreak.FastBreak;
import fr.neatmonster.nocheatplus.checks.blockbreak.Frequency;
import fr.neatmonster.nocheatplus.checks.blockbreak.NoSwing;
import fr.neatmonster.nocheatplus.checks.blockbreak.Reach;
import fr.neatmonster.nocheatplus.checks.blockbreak.WrongBlock;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractListener;
import fr.neatmonster.nocheatplus.checks.inventory.Items;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;

public class BlockBreakListener
extends CheckListener {
    private final Direction direction = this.addCheck(new Direction());
    private final FastBreak fastBreak = this.addCheck(new FastBreak());
    private final Frequency frequency = this.addCheck(new Frequency());
    private final NoSwing noSwing = this.addCheck(new NoSwing());
    private final Reach reach = this.addCheck(new Reach());
    private final WrongBlock wrongBlock = this.addCheck(new WrongBlock());
    private AlmostBoolean isInstaBreak = AlmostBoolean.NO;
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDIllegalItem = this.counters.registerKey("illegalitem");
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public BlockBreakListener() {
        super(CheckType.BLOCKBREAK);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockBreakEvent event) {
        FlyingQueueHandle flyingHandle;
        long now = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (Items.checkIllegalEnchantmentsAllHands(player)) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDIllegalItem, 1);
        } else if (MovingUtil.hasScheduledPlayerSetBack(player)) {
            event.setCancelled(true);
        }
        if (event.isCancelled()) {
            this.isInstaBreak = AlmostBoolean.NO;
            return;
        }
        Block block = event.getBlock();
        boolean cancelled = false;
        PlayerData pData = DataManager.getPlayerData(player);
        BlockBreakConfig cc = BlockBreakConfig.getConfig(player);
        BlockBreakData data = BlockBreakData.getData(player);
        BlockInteractData bdata = BlockInteractData.getData(player);
        int tick = TickTask.getTick();
        boolean isInteractBlock = !bdata.getLastIsCancelled() && bdata.matchesLastBlock(tick, block);
        int skippedRedundantChecks = 0;
        GameMode gameMode = player.getGameMode();
        boolean wrongBlockEnabled = this.wrongBlock.isEnabled(player);
        if (wrongBlockEnabled && this.wrongBlock.check(player, block, cc, data, pData, this.isInstaBreak)) {
            cancelled = true;
        }
        if (!cancelled && this.frequency.isEnabled(player) && this.frequency.check(player, tick, cc, data)) {
            cancelled = true;
        }
        if (!cancelled && gameMode != GameMode.CREATIVE && this.fastBreak.isEnabled(player) && this.fastBreak.check(player, block, this.isInstaBreak, cc, data, pData)) {
            cancelled = true;
        }
        if (!cancelled && this.noSwing.isEnabled(player) && this.noSwing.check(player, data)) {
            cancelled = true;
        }
        if (cc.reachCheck || cc.directionCheck) {
            flyingHandle = new FlyingQueueHandle(player);
            Location loc = player.getLocation(this.useLoc);
            double eyeHeight = MovingUtil.getEyeHeight(player);
            if (!cancelled) {
                if (isInteractBlock && bdata.isPassedCheck(CheckType.BLOCKINTERACT_REACH)) {
                    ++skippedRedundantChecks;
                } else if (this.reach.isEnabled(player) && this.reach.check(player, eyeHeight, block, data)) {
                    cancelled = true;
                }
            }
            if (!cancelled) {
                if (isInteractBlock && (bdata.isPassedCheck(CheckType.BLOCKINTERACT_DIRECTION) || bdata.isPassedCheck(CheckType.BLOCKINTERACT_VISIBLE))) {
                    ++skippedRedundantChecks;
                } else if (this.direction.isEnabled(player) && this.direction.check(player, loc, eyeHeight, block, flyingHandle, data, cc)) {
                    cancelled = true;
                }
            }
            this.useLoc.setWorld(null);
        } else {
            flyingHandle = null;
        }
        if (!cancelled && BlockProperties.isLiquid(block.getType()) && !pData.hasPermission(Permissions.BLOCKBREAK_BREAK_LIQUID, player) && !NCPExemptionManager.isExempted(player, CheckType.BLOCKBREAK_BREAK, true)) {
            cancelled = true;
        }
        if (cancelled) {
            event.setCancelled(cancelled);
            data.clickedX = block.getX();
            data.clickedY = block.getY();
            data.clickedZ = block.getZ();
        } else if (data.debug) {
            this.debugBlockBreakResult(player, block, skippedRedundantChecks, flyingHandle);
        }
        data.wasInstaBreak = this.isInstaBreak.decideOptimistically() ? now : 0L;
        data.fastBreakBreakTime = now;
        this.isInstaBreak = AlmostBoolean.NO;
    }

    private void debugBlockBreakResult(Player player, Block block, int skippedRedundantChecks, FlyingQueueHandle flyingHandle) {
        int flyingIndex;
        DataPacketFlying packet;
        this.debug(player, "Block break(" + block.getType() + "): " + block.getX() + ", " + block.getY() + ", " + block.getZ());
        BlockInteractListener.debugBlockVSBlockInteract(player, this.checkType, block, "onBlockBreak", Action.LEFT_CLICK_BLOCK);
        if (skippedRedundantChecks > 0) {
            this.debug(player, "Skipped redundant checks: " + skippedRedundantChecks);
        }
        if (flyingHandle != null && flyingHandle.isFlyingQueueFetched() && (packet = flyingHandle.getIfFetched(flyingIndex = flyingHandle.getFirstIndexWithContentIfFetched())) != null) {
            this.debug(player, "Flying packet queue used at index " + flyingIndex + ": pitch=" + packet.getPitch() + ",yaw=" + packet.getYaw());
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAnimation(PlayerAnimationEvent event) {
        BlockBreakData.getData((Player)event.getPlayer()).noSwingArmSwung = true;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.isInstaBreak = AlmostBoolean.NO;
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        this.checkBlockDamage(event.getPlayer(), event.getClickedBlock(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onBlockDamageLowest(BlockDamageEvent event) {
        if (MovingUtil.hasScheduledPlayerSetBack(event.getPlayer())) {
            event.setCancelled(true);
        } else if (event.getInstaBreak()) {
            this.isInstaBreak = AlmostBoolean.MAYBE;
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onBlockDamage(BlockDamageEvent event) {
        if (!event.isCancelled() && event.getInstaBreak()) {
            if (this.isInstaBreak != AlmostBoolean.MAYBE) {
                this.isInstaBreak = AlmostBoolean.YES;
            }
        } else {
            this.isInstaBreak = AlmostBoolean.NO;
        }
        this.checkBlockDamage(event.getPlayer(), event.getBlock(), (Cancellable)event);
    }

    private void checkBlockDamage(Player player, Block block, Cancellable event) {
        Material tool;
        long now = System.currentTimeMillis();
        BlockBreakData data = BlockBreakData.getData(player);
        if (block == null) {
            return;
        }
        int tick = TickTask.getTick();
        ItemStack stack = Bridge1_9.getItemInMainHand(player);
        Material material = tool = stack == null ? null : stack.getType();
        if (!data.toolChanged(tool) && tick >= data.clickedTick && now >= data.fastBreakfirstDamage && now >= data.fastBreakBreakTime && data.fastBreakBreakTime < data.fastBreakfirstDamage && data.clickedX == block.getX() && data.clickedZ == block.getZ() && data.clickedY == block.getY() && tick - data.clickedTick <= 1) {
            return;
        }
        data.setClickedBlock(block, tick, now, tool);
        if (data.debug) {
            BlockInteractListener.debugBlockVSBlockInteract(player, this.checkType, block, "checkBlockDamage", Action.LEFT_CLICK_BLOCK);
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        BlockBreakData data = BlockBreakData.getData(player);
        if (data.toolChanged(player.getInventory().getItem(event.getNewSlot()))) {
            data.resetClickedBlock();
        }
    }
}

