/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.access;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import java.util.Collection;
import org.bukkit.entity.Player;

public abstract class SubCheckDataFactory<D extends ICheckData>
implements CheckDataFactory {
    protected final CheckDataFactory parentFactory;
    protected final CheckType checkType;

    public SubCheckDataFactory(CheckType checkType, CheckDataFactory parentFactory) {
        this.checkType = checkType;
        this.parentFactory = parentFactory;
    }

    @Override
    public void removeAllData() {
        for (String playerName : this.getPresentData()) {
            D data = this.getData(playerName);
            if (data == null) continue;
            this.removeFromData(playerName, data);
        }
    }

    @Override
    public ICheckData getData(Player player) {
        return this.parentFactory.getData(player);
    }

    @Override
    public ICheckData removeData(String playerName) {
        if (!this.hasData(playerName)) {
            return null;
        }
        D data = this.getData(playerName);
        if (data != null && this.removeFromData(playerName, data)) {
            return data;
        }
        return null;
    }

    protected abstract D getData(String var1);

    protected abstract Collection<String> getPresentData();

    protected abstract boolean hasData(String var1);

    protected abstract boolean removeFromData(String var1, D var2);
}

