/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks;

import fr.neatmonster.nocheatplus.checks.access.CheckConfigFactory;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakConfig;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.net.NetConfigCache;
import fr.neatmonster.nocheatplus.checks.net.NetDataFactory;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import org.bukkit.entity.Player;

public enum CheckType {
    ALL(Permissions.CHECKS),
    BLOCKBREAK(ALL, BlockBreakConfig.factory, BlockBreakData.factory, Permissions.BLOCKBREAK),
    BLOCKBREAK_BREAK(BLOCKBREAK, Permissions.BLOCKBREAK_BREAK),
    BLOCKBREAK_DIRECTION(BLOCKBREAK, Permissions.BLOCKBREAK_DIRECTION),
    BLOCKBREAK_FASTBREAK(BLOCKBREAK, Permissions.BLOCKBREAK_FASTBREAK),
    BLOCKBREAK_FREQUENCY(BLOCKBREAK, Permissions.BLOCKBREAK_FREQUENCY),
    BLOCKBREAK_NOSWING(BLOCKBREAK, Permissions.BLOCKBREAK_NOSWING),
    BLOCKBREAK_REACH(BLOCKBREAK, Permissions.BLOCKBREAK_REACH),
    BLOCKBREAK_WRONGBLOCK(BLOCKBREAK, Permissions.BLOCKBREAK_WRONGBLOCK),
    BLOCKINTERACT(ALL, BlockInteractConfig.factory, BlockInteractData.factory, Permissions.BLOCKINTERACT),
    BLOCKINTERACT_DIRECTION(BLOCKINTERACT, Permissions.BLOCKINTERACT_DIRECTION),
    BLOCKINTERACT_REACH(BLOCKINTERACT, Permissions.BLOCKINTERACT_REACH),
    BLOCKINTERACT_SPEED(BLOCKINTERACT, Permissions.BLOCKINTERACT_SPEED),
    BLOCKINTERACT_VISIBLE(BLOCKINTERACT, Permissions.BLOCKINTERACT_VISIBLE),
    BLOCKPLACE(ALL, BlockPlaceConfig.factory, BlockPlaceData.factory, Permissions.BLOCKPLACE),
    BLOCKPLACE_AGAINST(BLOCKPLACE, Permissions.BLOCKPLACE_AGAINST),
    BLOCKPLACE_AUTOSIGN(BLOCKPLACE, Permissions.BLOCKPLACE_AUTOSIGN),
    BLOCKPLACE_DIRECTION(BLOCKPLACE, Permissions.BLOCKPLACE_DIRECTION),
    BLOCKPLACE_FASTPLACE(BLOCKPLACE, Permissions.BLOCKPLACE_FASTPLACE),
    BLOCKPLACE_NOSWING(BLOCKPLACE, Permissions.BLOCKPLACE_NOSWING),
    BLOCKPLACE_REACH(BLOCKPLACE, Permissions.BLOCKBREAK_REACH),
    BLOCKPLACE_SPEED(BLOCKPLACE, Permissions.BLOCKPLACE_SPEED),
    CHAT(ALL, ChatConfig.factory, ChatData.factory, Permissions.CHAT),
    CHAT_CAPTCHA(CHAT, Permissions.CHAT_CAPTCHA),
    CHAT_COLOR(CHAT, Permissions.CHAT_COLOR),
    CHAT_COMMANDS(CHAT, Permissions.CHAT_COMMANDS),
    CHAT_TEXT(CHAT, Permissions.CHAT_TEXT),
    CHAT_LOGINS(CHAT, Permissions.CHAT_LOGINS),
    CHAT_RELOG(CHAT, Permissions.CHAT_RELOG),
    COMBINED(ALL, CombinedConfig.factory, CombinedData.factory, Permissions.COMBINED),
    COMBINED_BEDLEAVE(COMBINED, Permissions.COMBINED_BEDLEAVE),
    COMBINED_IMPROBABLE(COMBINED, Permissions.COMBINED_IMPROBABLE),
    COMBINED_MUNCHHAUSEN(COMBINED, Permissions.COMBINED_MUNCHHAUSEN),
    COMBINED_YAWRATE(COMBINED),
    FIGHT(ALL, FightConfig.factory, FightData.factory, Permissions.FIGHT),
    FIGHT_ANGLE(FIGHT, Permissions.FIGHT_ANGLE),
    FIGHT_CRITICAL(FIGHT, Permissions.FIGHT_CRITICAL),
    FIGHT_DIRECTION(FIGHT, Permissions.FIGHT_DIRECTION),
    FIGHT_FASTHEAL(FIGHT, Permissions.FIGHT_FASTHEAL),
    FIGHT_GODMODE(FIGHT, Permissions.FIGHT_GODMODE),
    FIGHT_NOSWING(FIGHT, Permissions.FIGHT_NOSWING),
    FIGHT_REACH(FIGHT, Permissions.FIGHT_REACH),
    FIGHT_SELFHIT(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_SELFHIT, FightConfig.factory, FightData.selfHitDataFactory),
    FIGHT_SPEED(FIGHT, Permissions.FIGHT_SPEED),
    INVENTORY(ALL, InventoryConfig.factory, InventoryData.factory, Permissions.INVENTORY),
    INVENTORY_DROP(INVENTORY, Permissions.INVENTORY_DROP),
    INVENTORY_FASTCLICK(INVENTORY, Permissions.INVENTORY_FASTCLICK),
    INVENTORY_FASTCONSUME(INVENTORY, Permissions.INVENTORY_FASTCONSUME),
    INVENTORY_GUTENBERG(INVENTORY, Permissions.INVENTORY_GUTENBERG),
    INVENTORY_INSTANTBOW(INVENTORY, Permissions.INVENTORY_INSTANTBOW),
    INVENTORY_INSTANTEAT(INVENTORY, Permissions.INVENTORY_INSTANTEAT),
    INVENTORY_ITEMS(INVENTORY, Permissions.INVENTORY_ITEMS),
    INVENTORY_OPEN(INVENTORY, Permissions.INVENTORY_OPEN),
    MOVING(ALL, MovingConfig.factory, MovingData.factory, Permissions.MOVING),
    MOVING_CREATIVEFLY(MOVING, Permissions.MOVING_CREATIVEFLY),
    MOVING_MOREPACKETS(MOVING, Permissions.MOVING_MOREPACKETS),
    MOVING_NOFALL(MOVING, Permissions.MOVING_NOFALL),
    MOVING_PASSABLE(MOVING, Permissions.MOVING_PASSABLE),
    MOVING_SURVIVALFLY(MOVING, Permissions.MOVING_SURVIVALFLY),
    MOVING_VEHICLE(MOVING, Permissions.MOVING_VEHICLE),
    MOVING_VEHICLE_MOREPACKETS(MOVING_VEHICLE, Permissions.MOVING_VEHICLE_MOREPACKETS),
    MOVING_VEHICLE_ENVELOPE(MOVING_VEHICLE, Permissions.MOVING_VEHICLE_ENVELOPE),
    NET(ALL, new NetConfigCache(), new NetDataFactory(), Permissions.NET),
    NET_ATTACKFREQUENCY(NET, Permissions.NET_ATTACKFREQUENCY),
    NET_FLYINGFREQUENCY(NET, Permissions.NET_FLYINGFREQUENCY),
    NET_KEEPALIVEFREQUENCY(NET, Permissions.NET_KEEPALIVEFREQUENCY),
    NET_PACKETFREQUENCY(NET, Permissions.NET_PACKETFREQUENCY),
    NET_SOUNDDISTANCE(NET);

    private final CheckTypeType type;
    private final CheckType parent;
    private final CheckConfigFactory configFactory;
    private final CheckDataFactory dataFactory;
    private final RegisteredPermission permission;

    private CheckType(RegisteredPermission permission) {
        this(CheckTypeType.SPECIAL, null, permission, null, null);
    }

    private CheckType(CheckType parent, CheckConfigFactory configFactory, CheckDataFactory dataFactory, RegisteredPermission permission) {
        this(CheckTypeType.GROUP, parent, permission, configFactory, dataFactory);
    }

    private CheckType(CheckType parent) {
        this(parent, null);
    }

    private CheckType(CheckType parent, RegisteredPermission permission) {
        this(CheckTypeType.CHECK, parent, permission, parent.getConfigFactory(), parent.getDataFactory());
    }

    private CheckType(CheckTypeType type, CheckType parent, RegisteredPermission permission, CheckConfigFactory configFactory, CheckDataFactory dataFactory) {
        this.type = type;
        this.parent = parent;
        this.permission = permission;
        this.configFactory = configFactory;
        this.dataFactory = dataFactory;
    }

    public CheckTypeType getType() {
        return this.type;
    }

    public CheckConfigFactory getConfigFactory() {
        return this.configFactory;
    }

    public CheckDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public String getName() {
        return this.toString().toLowerCase().replace("_", ".");
    }

    public CheckType getParent() {
        return this.parent;
    }

    public RegisteredPermission getPermission() {
        return this.permission;
    }

    public final boolean isEnabled(Player player) {
        return this.configFactory.getConfig(player).isEnabled(this);
    }

    public static enum CheckTypeType {
        SPECIAL,
        GROUP,
        CHECK;

    }
}

