/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.actions.types;

import fr.neatmonster.nocheatplus.actions.AbstractActionList;
import fr.neatmonster.nocheatplus.actions.ParameterHolder;
import fr.neatmonster.nocheatplus.actions.types.ActionWithParameters;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class CommandAction<D extends ParameterHolder, L extends AbstractActionList<D, L>>
extends ActionWithParameters<D, L> {
    private final boolean logDebug = ConfigManager.getConfigFile().getBoolean("logging.extended.commands.actions");

    public CommandAction(String name, int delay, int repeat, String command) {
        super(name, delay, repeat, command);
    }

    @Override
    public void execute(D violationData) {
        String command = this.getMessage(violationData);
        try {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            if (this.logDebug) {
                this.debug(violationData, command);
            }
        }
        catch (Exception e) {
            StaticLog.logOnce(Level.WARNING, "Failed to execute the command '" + command + "': " + e.getMessage() + ", please check if everything is setup correct.", StringUtil.throwableToString(e));
        }
    }

    private void debug(D violationData, String command) {
        String prefix;
        if (violationData instanceof ViolationData) {
            ViolationData vd = (ViolationData)violationData;
            prefix = CheckUtils.getLogMessagePrefix(vd.player, vd.check.getType());
        } else {
            prefix = "";
        }
        StaticLog.logDebug(prefix + "Execute command action: " + command);
    }

    public String toString() {
        return "cmd:" + this.name + ":" + this.delay + ":" + this.repeat;
    }
}

