/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;

public class MapUtil {
    public static BlockFace matchBlockFace(int x, int y, int z) {
        for (BlockFace blockFace : BlockFace.values()) {
            if (blockFace.getModX() != x || blockFace.getModY() != y || blockFace.getModZ() != z) continue;
            return blockFace;
        }
        return null;
    }

    public static final boolean isFullBounds(double[] bounds) {
        if (bounds == null) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (bounds[i] > 0.0) {
                return false;
            }
            if (!(bounds[i + 3] < 1.0)) continue;
            return false;
        }
        return true;
    }

    public static int ensureChunksLoaded(World world, double x, double z, double xzMargin) {
        int loaded = 0;
        int minX = Location.locToBlock((double)(x - xzMargin)) / 16;
        int maxX = Location.locToBlock((double)(x + xzMargin)) / 16;
        int minZ = Location.locToBlock((double)(z - xzMargin)) / 16;
        int maxZ = Location.locToBlock((double)(z + xzMargin)) / 16;
        for (int cx = minX; cx <= maxX; ++cx) {
            for (int cz = minZ; cz <= maxZ; ++cz) {
                if (world.isChunkLoaded(cx, cz)) continue;
                try {
                    world.loadChunk(cx, cz);
                    ++loaded;
                    continue;
                }
                catch (Exception ex) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().severe(Streams.STATUS, "Failed to load chunk at " + cx * 16 + "," + cz * 16 + " (real coordinates):\n" + StringUtil.throwableToString(ex));
                }
            }
        }
        return loaded;
    }
}

