/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.location;

import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class RichEntityLocation
extends RichBoundsLocation {
    private final IHandle<MCAccess> mcAccess;
    private double width;
    private double height;
    private boolean isLiving;
    private double eyeHeight;
    private boolean standsOnEntity = false;
    private Entity entity = null;

    public RichEntityLocation(IHandle<MCAccess> mcAccess, BlockCache blockCache) {
        super(blockCache);
        this.mcAccess = mcAccess;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getEyeHeight() {
        return this.eyeHeight;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean isLiving() {
        return this.isLiving;
    }

    public MCAccess getMCAccess() {
        return this.mcAccess.getHandle();
    }

    public IHandle<MCAccess> getMCAccessHandle() {
        return this.mcAccess;
    }

    public boolean standsOnEntity(double yOnGround, double xzMargin, double yMargin) {
        return this.blockCache.standsOnEntity(this.entity, this.minX - xzMargin, this.minY - yOnGround - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.minY + yMargin, this.maxZ + xzMargin);
    }

    @Override
    public boolean isOnGround() {
        if (this.onGround != null) {
            return this.onGround;
        }
        boolean res = super.isOnGround();
        if (!res) {
            double d1 = 0.25;
            if (this.blockCache.standsOnEntity(this.entity, this.minX - 0.25, this.minY - this.yOnGround - 0.25, this.minZ - 0.25, this.maxX + 0.25, this.minY + 0.25 + 0.25, this.maxZ + 0.25)) {
                this.standsOnEntity = true;
                this.onGround = true;
                res = this.onGround;
            }
        }
        return res;
    }

    public boolean isOnGroundDueToStandingOnAnEntity() {
        return this.isOnGround() && this.standsOnEntity;
    }

    public boolean canClimbUp(double jumpHeigth) {
        if (BlockProperties.isAttachedClimbable(this.getTypeId())) {
            if (BlockProperties.canClimbUp(this.blockCache, this.blockX, this.blockY, this.blockZ)) {
                return true;
            }
            int headY = Location.locToBlock((double)this.maxY);
            if (headY > this.blockY) {
                for (int cy = this.blockY + 1; cy <= headY; ++cy) {
                    if (!BlockProperties.canClimbUp(this.blockCache, this.blockX, cy, this.blockZ)) continue;
                    return true;
                }
            }
            return this.isOnGround(jumpHeigth);
        }
        return true;
    }

    public boolean isHeadObstructed(double marginAboveEyeHeight) {
        return this.isHeadObstructed(marginAboveEyeHeight, true);
    }

    public boolean isHeadObstructed(double marginAboveEyeHeight, boolean stepCorrection) {
        if (marginAboveEyeHeight < 0.0) {
            throw new IllegalArgumentException("marginAboveEyeHeight must be greater than 0.");
        }
        if (stepCorrection) {
            double ref = this.maxY + marginAboveEyeHeight;
            ref = ref - (double)Location.locToBlock((double)ref) + 0.35;
            for (double bound = 1.0; bound > 0.0; bound -= 0.25) {
                if (!(ref >= bound)) continue;
                marginAboveEyeHeight += bound + 0.35 - ref;
                break;
            }
        }
        return BlockProperties.collides(this.blockCache, this.minX, this.maxY, this.minZ, this.maxX, this.maxY + marginAboveEyeHeight, this.maxZ, 132L);
    }

    public boolean isHeadObstructed() {
        return this.isHeadObstructed(0.0, true);
    }

    public void set(Location location, Entity entity, double yOnGround) {
        MCAccess mcAccess = this.mcAccess.getHandle();
        this.doSet(location, entity, mcAccess.getWidth(entity), mcAccess.getHeight(entity), yOnGround);
    }

    public void set(Location location, Entity entity, double fullHeight, double yOnGround) {
        MCAccess mcAccess = this.mcAccess.getHandle();
        this.doSet(location, entity, mcAccess.getWidth(entity), fullHeight, yOnGround);
    }

    public void set(Location location, Entity entity, double fullWidth, double fullHeight, double yOnGround) {
        this.doSet(location, entity, fullWidth, fullHeight, yOnGround);
    }

    protected void doSet(Location location, Entity entity, double fullWidth, double fullHeight, double yOnGround) {
        double eyeHeight;
        boolean isLiving;
        if (entity instanceof LivingEntity) {
            isLiving = true;
            LivingEntity living = (LivingEntity)entity;
            eyeHeight = living.getEyeHeight();
            fullHeight = Math.max(Math.max(fullHeight, eyeHeight), living.getEyeHeight(true));
        } else {
            isLiving = false;
            eyeHeight = fullHeight;
        }
        this.doSetExactHeight(location, entity, isLiving, fullWidth, eyeHeight, fullHeight, fullHeight, yOnGround);
    }

    protected void doSetExactHeight(Location location, Entity entity, boolean isLiving, double fullWidth, double eyeHeight, double height, double fullHeight, double yOnGround) {
        this.entity = entity;
        this.isLiving = isLiving;
        MCAccess mcAccess = this.mcAccess.getHandle();
        this.width = mcAccess.getWidth(entity);
        this.eyeHeight = eyeHeight;
        this.height = mcAccess.getHeight(entity);
        this.standsOnEntity = false;
        super.set(location, fullWidth, fullHeight, yOnGround);
    }

    @Override
    public void set(Location location, double fullWidth, double fullHeight, double yOnGround) {
        throw new UnsupportedOperationException("Set must specify an instance of Entity.");
    }

    public void prepare(RichEntityLocation other) {
        super.prepare(other);
        this.standsOnEntity = other.standsOnEntity;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.entity = null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("RichEntityLocation(");
        builder.append(this.world == null ? "null" : this.world.getName());
        builder.append('/');
        builder.append(Double.toString(this.x));
        builder.append(", ");
        builder.append(Double.toString(this.y));
        builder.append(", ");
        builder.append(Double.toString(this.z));
        builder.append(')');
        return builder.toString();
    }
}

