/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.corw;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class DualCollection<T, C extends Collection<T>> {
    private final Lock lock;
    private Collection<T> primaryThreadCollection = null;
    private Collection<T> asynchronousCollection = null;
    private short nullCount = (short)6;
    private short emptyCount = 0;

    public DualCollection() {
        this(new ReentrantLock());
    }

    public DualCollection(Lock lock) {
        this.lock = lock;
    }

    public void setNullCount(short nullCount) {
        this.nullCount = nullCount;
    }

    protected abstract C newCollection();

    public boolean addAsynchronous(T element) {
        this.lock.lock();
        if (this.asynchronousCollection == null) {
            this.asynchronousCollection = this.newCollection();
        }
        boolean res = this.asynchronousCollection.add(element);
        this.lock.unlock();
        return res;
    }

    public boolean addAllAsynchronous(Collection<T> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        this.lock.lock();
        if (this.asynchronousCollection == null) {
            this.asynchronousCollection = this.newCollection();
        }
        boolean res = this.asynchronousCollection.addAll(elements);
        this.lock.unlock();
        return res;
    }

    public boolean containsAsynchronous(T element) {
        if (this.asynchronousCollection == null) {
            return false;
        }
        this.lock.lock();
        boolean res = this.asynchronousCollection == null ? false : this.asynchronousCollection.contains(element);
        this.lock.unlock();
        return res;
    }

    public void mergePrimaryThread() {
        if (this.asynchronousCollection != null) {
            this.lock.lock();
            this.internalMergePrimaryThreadNoLock();
            this.lock.unlock();
        }
    }

    private void internalMergePrimaryThreadNoLock() {
        if (this.asynchronousCollection.isEmpty()) {
            this.emptyCount = (short)(this.emptyCount + 1);
            if (this.emptyCount >= this.nullCount) {
                this.asynchronousCollection = null;
            }
        } else {
            this.primaryThreadCollection.addAll(this.asynchronousCollection);
            this.asynchronousCollection.clear();
        }
    }

    public void mergePrimaryThreadNoLock() {
        if (this.asynchronousCollection != null) {
            this.internalMergePrimaryThreadNoLock();
        }
    }

    public boolean addPrimaryThread(T element) {
        if (this.primaryThreadCollection == null) {
            this.primaryThreadCollection = this.newCollection();
        }
        return this.primaryThreadCollection.add(element);
    }

    public boolean addAllPrimaryThread(Collection<T> elements) {
        if (this.primaryThreadCollection == null) {
            this.primaryThreadCollection = this.newCollection();
        }
        return this.primaryThreadCollection.addAll(elements);
    }

    public boolean isEmptyPrimaryThread() {
        if (this.primaryThreadCollection == null) {
            return true;
        }
        if (this.primaryThreadCollection.isEmpty()) {
            this.emptyCount = (short)(this.emptyCount + 1);
            if (this.emptyCount >= this.nullCount) {
                this.primaryThreadCollection = null;
                this.emptyCount = 0;
            }
            return true;
        }
        return false;
    }

    public boolean isEmtpyAfterMergePrimaryThread() {
        this.mergePrimaryThread();
        return this.isEmptyPrimaryThread();
    }

    public boolean isEmtpyAfterMergePrimaryThreadNoLock() {
        this.mergePrimaryThreadNoLock();
        return this.isEmptyPrimaryThread();
    }

    public boolean containsPrimaryThread(T element) {
        return this.primaryThreadCollection == null ? false : this.primaryThreadCollection.contains(element);
    }

    public Iterator<T> iteratorPrimaryThread() {
        if (this.primaryThreadCollection == null) {
            this.primaryThreadCollection = this.newCollection();
        }
        return this.primaryThreadCollection.iterator();
    }

    public void clearPrimaryThread() {
        if (this.primaryThreadCollection != null) {
            this.primaryThreadCollection.clear();
        }
    }
}

