/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.components.registry.feature.TickListener;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.utilities.OnDemandTickListener;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TickTask
implements Runnable {
    public static final int lagMaxTicks = 80;
    private static final Object permissionLock = new Object();
    private static Set<PermissionUpdateEntry> permissionUpdates = new LinkedHashSet<PermissionUpdateEntry>(50);
    private static Map<UUID, ImprobableUpdateEntry> improbableUpdates = new LinkedHashMap<UUID, ImprobableUpdateEntry>(50);
    private static final Set<PlayerData.PlayerTickListener> playerTickListeners = new LinkedHashSet<PlayerData.PlayerTickListener>();
    private static final ReentrantLock improbableLock = new ReentrantLock();
    private static final Object actionLock = new Object();
    private static List<ViolationData> delayedActions = new LinkedList<ViolationData>();
    private static final Set<TickListener> tickListeners = new LinkedHashSet<TickListener>();
    private static final long[] tickDurations = new long[80];
    private static final long[] tickDurationsSq = new long[80];
    private static final long lagMaxCoveredMs = 324050L;
    private static long[] spikeDurations = new long[]{150L, 450L, 1000L, 5000L};
    private static ActionFrequency[] spikes = new ActionFrequency[spikeDurations.length];
    protected static int taskId = -1;
    protected static int tick = 0;
    protected static long timeStart = 0L;
    protected static long timeLast = 0L;
    protected static boolean locked = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeActions() {
        List<ViolationData> copyActions;
        Iterator<ViolationData> iterator = actionLock;
        synchronized (iterator) {
            if (delayedActions.isEmpty()) {
                return;
            }
            copyActions = delayedActions;
            delayedActions = new LinkedList<ViolationData>();
        }
        for (ViolationData vd : copyActions) {
            vd.executeActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePermissions() {
        Set<PermissionUpdateEntry> copyPermissions;
        Iterator<PermissionUpdateEntry> iterator = permissionLock;
        synchronized (iterator) {
            if (permissionUpdates.isEmpty()) {
                return;
            }
            copyPermissions = permissionUpdates;
            permissionUpdates = new LinkedHashSet<PermissionUpdateEntry>(50);
        }
        for (PermissionUpdateEntry entry : copyPermissions) {
            String[] perms;
            Player player = DataManager.getPlayer(entry.playerName);
            if (player == null || !player.isOnline() || (perms = entry.checkType.getConfigFactory().getConfig(player).getCachePermissions()) == null) continue;
            ICheckData data = entry.checkType.getDataFactory().getData(player);
            for (int j = 0; j < perms.length; ++j) {
                String permission = perms[j];
                data.setCachedPermission(permission, player.hasPermission(permission));
            }
        }
    }

    public static void updateImprobable() {
        improbableLock.lock();
        if (improbableUpdates.isEmpty()) {
            improbableLock.unlock();
            return;
        }
        Map<UUID, ImprobableUpdateEntry> updateMap = improbableUpdates;
        improbableUpdates = new LinkedHashMap<UUID, ImprobableUpdateEntry>(50);
        improbableLock.unlock();
        for (Map.Entry<UUID, ImprobableUpdateEntry> entry : updateMap.entrySet()) {
            Player player = DataManager.getPlayer(entry.getKey());
            if (player == null) continue;
            Improbable.feed(player, entry.getValue().addLevel, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestPermissionUpdate(String playerName, CheckType checkType) {
        Object object = permissionLock;
        synchronized (object) {
            if (locked) {
                return;
            }
            permissionUpdates.add(new PermissionUpdateEntry(playerName, checkType));
        }
    }

    public static void addPlayerTickListener(PlayerData.PlayerTickListener playerTickListener) {
        if (!locked) {
            playerTickListeners.add(playerTickListener);
        }
    }

    public static boolean isPlayerTiskListenerThere(PlayerData.PlayerTickListener playerTickListener) {
        return playerTickListeners.contains(playerTickListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestActionsExecution(ViolationData actions) {
        Object object = actionLock;
        synchronized (object) {
            if (locked) {
                return;
            }
            delayedActions.add(actions);
        }
    }

    public static void requestImprobableUpdate(UUID playerId, float addLevel) {
        if (playerId == null) {
            throw new NullPointerException("The playerId may not be null.");
        }
        improbableLock.lock();
        ImprobableUpdateEntry entry = improbableUpdates.get(playerId);
        if (entry == null) {
            entry = new ImprobableUpdateEntry(addLevel);
            improbableUpdates.put(playerId, entry);
        } else {
            entry.addLevel += addLevel;
        }
        improbableLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTickListener(TickListener listener) {
        Set<TickListener> set = tickListeners;
        synchronized (set) {
            if (locked) {
                return;
            }
            if (!tickListeners.contains(listener)) {
                tickListeners.add(listener);
            }
            if (listener instanceof OnDemandTickListener) {
                ((OnDemandTickListener)listener).setRegistered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeTickListener(TickListener listener) {
        Set<TickListener> set = tickListeners;
        synchronized (set) {
            if (listener instanceof OnDemandTickListener) {
                ((OnDemandTickListener)listener).setRegistered(false);
            }
            return tickListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllTickListeners() {
        Set<TickListener> set = tickListeners;
        synchronized (set) {
            for (TickListener listener : tickListeners) {
                if (!(listener instanceof OnDemandTickListener)) continue;
                try {
                    OnDemandTickListener odtl = (OnDemandTickListener)listener;
                    if (!odtl.isRegistered()) continue;
                    odtl.setRegistered(false);
                }
                catch (Throwable t) {
                    StaticLog.logWarning("Failed to set OnDemandTickListener to unregistered state: " + t.getClass().getSimpleName());
                    StaticLog.logWarning(t);
                }
            }
            tickListeners.clear();
        }
    }

    public static final int getTick() {
        return tick;
    }

    public static final long getTimeStart() {
        return timeStart;
    }

    public static final long getTimeLast() {
        return timeLast;
    }

    public static final float getLag(long ms) {
        return TickTask.getLag(ms, false);
    }

    public static final float getLag(long ms, boolean exact) {
        long passed;
        if (ms < 0L) {
            return TickTask.getLag(0L, exact);
        }
        if (ms > 324050L) {
            return TickTask.getLag(324050L, exact);
        }
        int tick = TickTask.tick;
        if (tick == 0) {
            return 1.0f;
        }
        int add = ms > 0L && ms % 50L == 0L ? 0 : 1;
        int totalTicks = Math.min(tick, add + (int)(ms / 50L));
        int maxTick = Math.min(80, totalTicks);
        long sum = tickDurations[maxTick - 1];
        long covered = maxTick * 50;
        if (totalTicks > 80) {
            int maxTickSq = Math.min(80, totalTicks / 80);
            if (80 * maxTickSq == totalTicks) {
                --maxTickSq;
            }
            sum += tickDurationsSq[maxTickSq - 1];
            covered += (long)(4000 * maxTickSq);
        }
        if (exact && (passed = System.currentTimeMillis() - timeLast) > 50L) {
            covered += 50L;
            sum += passed;
        }
        return Math.max(1.0f, (float)sum / (float)covered);
    }

    public static final int getModerateLagSpikes() {
        spikes[0].update(System.currentTimeMillis());
        return (int)spikes[0].score(1.0f);
    }

    public static final int getHeavyLagSpikes() {
        spikes[1].update(System.currentTimeMillis());
        return (int)spikes[1].score(1.0f);
    }

    public static final int getNumberOfLagSpikes() {
        spikes[0].update(System.currentTimeMillis());
        return (int)spikes[0].score(1.0f);
    }

    public static final long[] getLagSpikeDurations() {
        return Arrays.copyOf(spikeDurations, spikeDurations.length);
    }

    public static final int[] getLagSpikes() {
        int[] out = new int[spikeDurations.length];
        long now = System.currentTimeMillis();
        for (int i = 0; i < spikeDurations.length; ++i) {
            spikes[i].update(now);
            out[i] = (int)spikes[i].score(1.0f);
        }
        return out;
    }

    public static boolean isLocked() {
        return locked;
    }

    public static int start(Plugin plugin) {
        TickTask.cancel();
        taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, (Runnable)new TickTask(), 1L, 1L);
        timeStart = taskId != -1 ? System.currentTimeMillis() : 0L;
        return taskId;
    }

    public static void cancel() {
        if (taskId == -1) {
            return;
        }
        Bukkit.getScheduler().cancelTask(taskId);
        taskId = -1;
    }

    public static void setLocked(boolean locked) {
        TickTask.locked = locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purge() {
        Set<TickListener> set = permissionLock;
        synchronized (set) {
            permissionUpdates.clear();
        }
        set = actionLock;
        synchronized (set) {
            delayedActions.clear();
        }
        improbableLock.lock();
        improbableUpdates.clear();
        improbableLock.unlock();
        set = tickListeners;
        synchronized (set) {
            tickListeners.clear();
        }
        if (Bukkit.isPrimaryThread()) {
            playerTickListeners.clear();
        }
    }

    public static void reset() {
        int i;
        tick = 0;
        timeLast = 0L;
        for (i = 0; i < 80; ++i) {
            TickTask.tickDurations[i] = 0L;
            TickTask.tickDurationsSq[i] = 0L;
        }
        for (i = 0; i < spikeDurations.length; ++i) {
            spikes[i].clear(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        TickListener[] copyListeners;
        Set<TickListener> set = tickListeners;
        synchronized (set) {
            if (tickListeners.isEmpty()) {
                return;
            }
            copyListeners = tickListeners.toArray(new TickListener[tickListeners.size()]);
        }
        for (int i = 0; i < copyListeners.length; ++i) {
            TickListener listener = copyListeners[i];
            try {
                listener.onTick(tick, timeLast);
                continue;
            }
            catch (Throwable t) {
                StaticLog.logSevere("(TickTask) TickListener generated an exception:");
                StaticLog.logSevere(t);
            }
        }
    }

    private void processPlayerTickListeners(int tick, long timeLast) {
        Iterator<PlayerData.PlayerTickListener> it = playerTickListeners.iterator();
        while (it.hasNext()) {
            PlayerData.PlayerTickListener listener = it.next();
            try {
                if (!listener.processOnTick(tick, timeLast)) continue;
                it.remove();
            }
            catch (Throwable t) {
                StaticLog.logSevere("(TickTask) PlayerTickListener generated an exception:");
                StaticLog.logSevere(t);
            }
        }
    }

    @Override
    public void run() {
        int i;
        long lastDur;
        TickTask.updateImprobable();
        TickTask.executeActions();
        if (!playerTickListeners.isEmpty()) {
            this.processPlayerTickListeners(tick, timeLast);
        }
        TickTask.updatePermissions();
        this.notifyListeners();
        long time = System.currentTimeMillis();
        if (timeLast > time) {
            StaticLog.logWarning("System time ran backwards (" + timeLast + "->" + time + "), clear all data and history...");
            DataManager.handleSystemTimeRanBackwards();
            lastDur = 50L;
            for (i = 0; i < spikeDurations.length; ++i) {
                spikes[i].update(time);
            }
        } else {
            lastDur = tick > 0 ? time - timeLast : 50L;
        }
        if (tick > 0 && tick % 80 == 0) {
            long sum = tickDurations[79];
            for (int i2 = 1; i2 < 80; ++i2) {
                TickTask.tickDurationsSq[i2] = tickDurationsSq[i2 - 1] + sum;
            }
            TickTask.tickDurationsSq[0] = sum;
        }
        for (i = 1; i < 80; ++i) {
            TickTask.tickDurations[i] = tickDurations[i - 1] + lastDur;
        }
        TickTask.tickDurations[0] = lastDur;
        if (lastDur > spikeDurations[0] && tick > 0) {
            spikes[0].add(time, 1.0f);
            for (i = 1; i < spikeDurations.length && lastDur > spikeDurations[i]; ++i) {
                spikes[i].add(time, 1.0f);
            }
        }
        ++tick;
        timeLast = time;
    }

    static {
        for (int i = 0; i < spikeDurations.length; ++i) {
            TickTask.spikes[i] = new ActionFrequency(3, 1200000L);
        }
    }

    protected static final class ImprobableUpdateEntry {
        public float addLevel;

        public ImprobableUpdateEntry(float addLevel) {
            this.addLevel = addLevel;
        }
    }

    protected static final class PermissionUpdateEntry {
        public final CheckType checkType;
        public final String playerName;
        private final int hashCode;

        public PermissionUpdateEntry(String playerName, CheckType checkType) {
            this.playerName = playerName;
            this.checkType = checkType;
            this.hashCode = playerName.hashCode() ^ checkType.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PermissionUpdateEntry)) {
                return false;
            }
            PermissionUpdateEntry other = (PermissionUpdateEntry)obj;
            return this.playerName.equals(other.playerName) && this.checkType.equals((Object)other.checkType);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

