/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.CheckTypeUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CheckUtils {
    private static void improperAPIAccess(CheckType checkType) {
        String trace = Arrays.toString(Thread.currentThread().getStackTrace());
        StaticLog.logOnce(Streams.STATUS, Level.SEVERE, "Off primary thread call to hasByPass for " + (Object)((Object)checkType), trace);
    }

    public static void kickIllegalMove(Player player, MovingConfig cc) {
        player.kickPlayer(cc.msgKickIllegalMove);
        StaticLog.logWarning("[NCP] Disconnect " + player.getName() + " due to illegal move!");
    }

    public static final long guessKeepAliveTime(Player player, long now, long maxAge) {
        int tick = TickTask.getTick();
        long ref = Long.MIN_VALUE;
        FightData fData = FightData.getData(player);
        ref = Math.max(ref, fData.speedBuckets.lastUpdate());
        ref = Math.max(ref, now - 50L * (long)(tick - fData.lastAttackTick));
        ref = Math.max(ref, fData.regainHealthTime);
        ref = Math.max(ref, CombinedData.getData((Player)player).lastMoveTime);
        InventoryData iData = InventoryData.getData(player);
        ref = Math.max(ref, iData.lastClickTime);
        ref = Math.max(ref, iData.instantEatInteract);
        BlockBreakData bbData = BlockBreakData.getData(player);
        ref = Math.max(ref, bbData.frequencyBuckets.lastUpdate());
        if ((ref = Math.max(ref, bbData.fastBreakfirstDamage)) > now || ref < now - maxAge) {
            return Long.MIN_VALUE;
        }
        return ref;
    }

    public static boolean isEnabled(CheckType checkType, Player player, ICheckData data, ICheckConfig cc) {
        if (cc == null ? !checkType.isEnabled(player) : !cc.isEnabled(checkType)) {
            return false;
        }
        return !CheckUtils.hasBypass(checkType, player, data);
    }

    public static boolean hasBypass(CheckType checkType, Player player, ICheckData data) {
        return CheckUtils.hasBypass(checkType, player, data, Bukkit.isPrimaryThread());
    }

    public static boolean hasBypass(CheckType checkType, Player player, ICheckData data, boolean isPrimaryThread) {
        String permission = checkType.getPermission();
        if (isPrimaryThread) {
            if (permission != null && player.hasPermission(permission)) {
                return true;
            }
        } else if (permission != null) {
            if (data == null ? checkType.hasCachedPermission(player, permission) : data.hasCachedPermission(permission)) {
                return true;
            }
            if (!CheckTypeUtil.needsSynchronization(checkType)) {
                CheckUtils.improperAPIAccess(checkType);
            }
        }
        return NCPExemptionManager.isExempted(player, checkType, isPrimaryThread);
    }

    public static void debug(Player player, CheckType checkType, String message) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, CheckUtils.getLogMessagePrefix(player, checkType) + message);
    }

    public static String getLogMessagePrefix(Player player, CheckType checkType) {
        String base = "[" + (Object)((Object)checkType) + "] ";
        if (player != null) {
            base = base + "[" + player.getName() + "] ";
        }
        return base;
    }

    public static Random getRandom() {
        return NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Random.class);
    }

    public static void reduce(long time, float amount, ActionFrequency ... freqs) {
        for (int i = 0; i < freqs.length; ++i) {
            ActionFrequency freq = freqs[i];
            freq.update(time);
            freq.setBucket(0, Math.max(0.0f, freq.bucketScore(0) - amount));
        }
    }

    public static void subtract(long time, float amount, ActionFrequency ... freqs) {
        for (int i = 0; i < freqs.length; ++i) {
            ActionFrequency freq = freqs[i];
            freq.update(time);
            freq.setBucket(0, freq.bucketScore(0) - amount);
        }
    }
}

