/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.players;

import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class PlayerData
implements IData {
    public static final String TAG_NOTIFY_OFF = "notify_off";
    private Set<String> tags = null;
    final UUID playerId;
    final String playerName;
    final String lcName;
    private final PlayerTickListener playerTickListener;
    private boolean requestUpdateInventory = false;
    private boolean requestPlayerSetBack = false;

    public PlayerData(UUID playerId, String playerName) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.lcName = playerName.toLowerCase();
        this.playerTickListener = new PlayerTickListener(this);
    }

    private boolean processOnTick(int tick, long timeLast) {
        Player player = DataManager.getPlayer(this.playerId);
        if (player != null) {
            if (this.requestPlayerSetBack) {
                MovingUtil.processStoredSetBack(player, "Player set back on tick: ");
            }
            if (player.isOnline() && this.requestUpdateInventory) {
                player.updateInventory();
            }
        }
        this.requestUpdateInventory = false;
        this.requestPlayerSetBack = false;
        return true;
    }

    private void registerPlayerTickListener() {
        TickTask.addPlayerTickListener(this.playerTickListener);
    }

    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
            if (this.tags.isEmpty()) {
                this.tags = null;
            }
        }
    }

    public void setTag(String tag, boolean add) {
        if (add) {
            this.addTag(tag);
        } else {
            this.removeTag(tag);
        }
    }

    public boolean getNotifyOff() {
        return this.hasTag(TAG_NOTIFY_OFF);
    }

    public void setNotifyOff(boolean notifyOff) {
        this.setTag(TAG_NOTIFY_OFF, notifyOff);
    }

    public void requestUpdateInventory() {
        this.requestUpdateInventory = true;
        this.registerPlayerTickListener();
    }

    public void requestPlayerSetBack() {
        this.requestPlayerSetBack = true;
        this.registerPlayerTickListener();
    }

    public boolean isPlayerSetBackScheduled() {
        return this.requestPlayerSetBack && TickTask.isPlayerTiskListenerThere(this.playerTickListener);
    }

    public static final class PlayerTickListener {
        private final PlayerData data;
        private final int hashCode;

        private PlayerTickListener(PlayerData data) {
            this.data = data;
            this.hashCode = data.playerId.hashCode();
        }

        public boolean processOnTick(int tick, long timeLast) {
            return this.data.processOnTick(tick, timeLast);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlayerTickListener) {
                return this.data.playerId.equals(((PlayerTickListener)obj).data.playerId);
            }
            if (obj instanceof UUID) {
                return this.data.playerId.equals((UUID)obj);
            }
            return false;
        }
    }
}

