/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.players;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.checks.access.CheckConfigFactory;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.access.IRemoveSubCheckData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.versions.BukkitVersion;
import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.data.ICanHandleTimeRunningBackwards;
import fr.neatmonster.nocheatplus.components.registry.ComponentRegistry;
import fr.neatmonster.nocheatplus.components.registry.feature.ComponentWithName;
import fr.neatmonster.nocheatplus.components.registry.feature.ConsistencyChecker;
import fr.neatmonster.nocheatplus.components.registry.feature.IDisableListener;
import fr.neatmonster.nocheatplus.components.registry.feature.IHaveCheckType;
import fr.neatmonster.nocheatplus.components.registry.feature.INeedConfig;
import fr.neatmonster.nocheatplus.components.registry.feature.IRemoveData;
import fr.neatmonster.nocheatplus.components.registry.order.SetupOrder;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.ExecutionHistory;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.players.PlayerMap;
import fr.neatmonster.nocheatplus.utilities.CheckTypeUtil;
import fr.neatmonster.nocheatplus.utilities.IdUtil;
import fr.neatmonster.nocheatplus.utilities.OnDemandTickListener;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

@SetupOrder(priority=-80)
public class DataManager
implements Listener,
INeedConfig,
ComponentRegistry<IRemoveData>,
ComponentWithName,
ConsistencyChecker,
IDisableListener {
    private static DataManager instance = null;
    private int foundInconsistencies = 0;
    private final HashMapLOW<UUID, PlayerData> playerData = new HashMapLOW(100);
    private final Set<UUID> bulkPlayerDataRemoval = new LinkedHashSet<UUID>();
    private final Map<UUID, Long> lastLogout = new LinkedHashMap<UUID, Long>(50, 0.75f, true);
    private final PlayerMap playerMap;
    private final ArrayList<IRemoveData> iRemoveData = new ArrayList();
    private final Map<CheckType, Map<String, ExecutionHistory>> executionHistories = new HashMap<CheckType, Map<String, ExecutionHistory>>();
    private boolean doExpireData = false;
    private long durExpireData = 0L;
    private boolean deleteData = true;
    private boolean deleteHistory = false;
    private final OnDemandTickListener rareTasksListener = new OnDemandTickListener(){
        private int delayUnregister = 0;

        @Override
        public boolean delegateTick(int tick, long timeLast) {
            if (DataManager.this.rareTasks()) {
                this.delayUnregister = 10;
                return true;
            }
            if (this.delayUnregister == 0) {
                return false;
            }
            --this.delayUnregister;
            return true;
        }
    };

    public DataManager() {
        String version;
        instance = this;
        if (ServerVersion.isMinecraftVersionUnknown()) {
            BukkitVersion.init();
        }
        this.playerMap = GenericVersion.compareVersions(version = ServerVersion.getMinecraftVersion(), "1.8") >= 0 || version.equals("1.7.10") && Bukkit.getServer().getVersion().toLowerCase().indexOf("spigot") != -1 ? new PlayerMap(false) : new PlayerMap(true);
    }

    public void checkExpiration() {
        Map.Entry<UUID, Long> entry;
        long ts;
        if (!this.doExpireData || this.durExpireData <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        LinkedHashSet<CheckDataFactory> factories = new LinkedHashSet<CheckDataFactory>();
        Set<Map.Entry<UUID, Long>> entries = this.lastLogout.entrySet();
        Iterator<Map.Entry<UUID, Long>> iterator = entries.iterator();
        while (iterator.hasNext() && now - (ts = (entry = iterator.next()).getValue().longValue()) > this.durExpireData) {
            UUID playerId = entry.getKey();
            this.legacyPlayerDataExpirationRemovalByName(playerId, factories, this.deleteData);
            this.bulkPlayerDataRemoval.add(playerId);
            iterator.remove();
        }
        if (!this.bulkPlayerDataRemoval.isEmpty()) {
            this.doBulkPlayerDataRemoval();
        }
    }

    private final void legacyPlayerDataExpirationRemovalByName(UUID playerId, Set<CheckDataFactory> factories, boolean deleteData) {
        String playerName = DataManager.getPlayerName(playerId);
        if (playerName == null) {
            return;
        }
        if (deleteData) {
            factories.clear();
            for (CheckType type : CheckType.values()) {
                CheckDataFactory factory = type.getDataFactory();
                if (factory == null) continue;
                factories.add(factory);
            }
            for (CheckDataFactory factory : factories) {
                factory.removeData(playerName);
            }
            DataManager.clearComponentData(CheckType.ALL, playerName);
        }
        if (deleteData || this.deleteHistory) {
            DataManager.removeExecutionHistory(CheckType.ALL, playerName);
        }
        if (this.deleteHistory) {
            ViolationHistory.removeHistory(playerName);
        }
    }

    private final boolean rareTasks() {
        boolean something = false;
        if (!this.bulkPlayerDataRemoval.isEmpty()) {
            this.doBulkPlayerDataRemoval();
            something = true;
        }
        return something;
    }

    private final void doBulkPlayerDataRemoval() {
        int size = this.bulkPlayerDataRemoval.size();
        if (size > 0) {
            Iterator<UUID> it = this.bulkPlayerDataRemoval.iterator();
            while (it.hasNext()) {
                boolean skip = !this.lastLogout.containsKey(it.next());
                if (!skip) continue;
                it.remove();
                --size;
            }
            if (size > 0) {
                this.playerData.remove(this.bulkPlayerDataRemoval);
                this.bulkPlayerDataRemoval.clear();
                if (ConfigManager.getConfigFile().getBoolean("logging.extended.status")) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.STATUS, "Bulk PlayerData removal: " + size);
                }
            }
        }
    }

    public static String getPlayerName(UUID playerId) {
        PlayerMap.PlayerInfo info = DataManager.instance.playerMap.getPlayerInfo(playerId);
        if (info != null && info.exactName != null) {
            return info.exactName;
        }
        PlayerData data = DataManager.instance.playerData.get(playerId);
        if (data != null && data.playerName != null) {
            return data.playerName;
        }
        return null;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.lastLogout.remove(player.getUniqueId());
        CombinedData.getData((Player)player).lastJoinTime = System.currentTimeMillis();
        this.addOnlinePlayer(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onPlayerLeave(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerKick(PlayerKickEvent event) {
        this.onPlayerLeave(event.getPlayer());
    }

    private final void onPlayerLeave(Player player) {
        long now = System.currentTimeMillis();
        this.lastLogout.put(player.getUniqueId(), now);
        CombinedData.getData((Player)player).lastLogoutTime = now;
        this.removeOnlinePlayer(player);
    }

    @Override
    public void onReload() {
        this.adjustSettings();
    }

    private void adjustSettings() {
        ConfigFile config = ConfigManager.getConfigFile();
        this.doExpireData = config.getBoolean("data.expiration.active");
        this.durExpireData = config.getLong("data.expiration.duration", 1L, 1000000L, 60L) * 60000L;
        this.deleteData = config.getBoolean("data.expiration.data", true);
        this.deleteHistory = config.getBoolean("data.expiration.history");
    }

    public static void registerExecutionHistory(CheckType type, Map<String, ExecutionHistory> histories) {
        DataManager.instance.executionHistories.put(type, histories);
    }

    public static ExecutionHistory getExecutionHistory(CheckType type, String playerName) {
        Map<String, ExecutionHistory> map = DataManager.instance.executionHistories.get((Object)type);
        if (map != null) {
            return map.get(playerName);
        }
        return null;
    }

    public static boolean removeExecutionHistory(CheckType type, String playerName) {
        boolean removed = false;
        for (CheckType refType : CheckTypeUtil.getWithDescendants(type)) {
            Map<String, ExecutionHistory> map = DataManager.instance.executionHistories.get((Object)refType);
            if (map == null || map.remove(playerName) == null) continue;
            removed = true;
        }
        return removed;
    }

    public static void clearData(CheckType checkType) {
        HashSet<CheckDataFactory> factories = new HashSet<CheckDataFactory>();
        for (CheckType type : CheckTypeUtil.getWithDescendants(checkType)) {
            CheckDataFactory factory;
            Map<String, ExecutionHistory> map = DataManager.instance.executionHistories.get((Object)type);
            if (map != null) {
                map.clear();
            }
            if ((factory = type.getDataFactory()) == null) continue;
            factories.add(factory);
        }
        for (CheckDataFactory factory : factories) {
            factory.removeAllData();
        }
        for (IRemoveData rmd : DataManager.instance.iRemoveData) {
            CheckType refType;
            if (checkType == CheckType.ALL) {
                rmd.removeAllData();
                continue;
            }
            if (!(rmd instanceof IHaveCheckType) || (refType = ((IHaveCheckType)((Object)rmd)).getCheckType()) != checkType && !CheckTypeUtil.isAncestor(checkType, refType)) continue;
            rmd.removeAllData();
        }
        ViolationHistory.clear(checkType);
        if (checkType == CheckType.ALL) {
            DataManager.instance.bulkPlayerDataRemoval.addAll(DataManager.instance.playerData.getKeys());
            instance.doBulkPlayerDataRemoval();
        }
    }

    public static void handleSystemTimeRanBackwards() {
        HashSet<CheckDataFactory> factories = new HashSet<CheckDataFactory>();
        for (CheckType type : CheckTypeUtil.getWithDescendants(CheckType.ALL)) {
            CheckDataFactory factory;
            Map<String, ExecutionHistory> map = DataManager.instance.executionHistories.get((Object)type);
            if (map != null) {
                map.clear();
            }
            if ((factory = type.getDataFactory()) == null) continue;
            factories.add(factory);
        }
        for (CheckDataFactory factory : factories) {
            if (factory instanceof ICanHandleTimeRunningBackwards) {
                ((ICanHandleTimeRunningBackwards)((Object)factory)).handleTimeRanBackwards();
                continue;
            }
            factory.removeAllData();
        }
        for (IRemoveData rmd : DataManager.instance.iRemoveData) {
            if (rmd instanceof ICanHandleTimeRunningBackwards) {
                ((ICanHandleTimeRunningBackwards)((Object)rmd)).handleTimeRanBackwards();
                continue;
            }
            rmd.removeAllData();
        }
        ViolationHistory.clear(CheckType.ALL);
    }

    public static void restoreDefaultDebugFlags() {
        Player[] players = BridgeMisc.getOnlinePlayers();
        for (CheckType checkType : CheckType.values()) {
            CheckDataFactory dataFactory;
            CheckConfigFactory configFactory = checkType.getConfigFactory();
            if (configFactory == null || (dataFactory = checkType.getDataFactory()) == null) continue;
            for (int i = 0; i < players.length; ++i) {
                ICheckData data;
                Player player = players[i];
                ICheckConfig config = configFactory.getConfig(player);
                if (config == null || (data = dataFactory.getData(player)) == null || config.getDebug() == data.getDebug()) continue;
                data.setDebug(config.getDebug());
            }
        }
    }

    public static boolean removeData(String playerName, CheckType checkType) {
        UUID playerId;
        PlayerData pd = DataManager.getPlayerData(playerName);
        UUID uUID = playerId = pd == null ? DataManager.getUUID(playerName) : pd.playerId;
        if (checkType == null) {
            checkType = CheckType.ALL;
        }
        boolean had = false;
        if (DataManager.clearComponentData(checkType, playerName)) {
            had = true;
        }
        HashSet<CheckDataFactory> factories = new HashSet<CheckDataFactory>();
        for (CheckType otherType : CheckTypeUtil.getWithDescendants(checkType)) {
            CheckDataFactory otherFactory = otherType.getDataFactory();
            if (otherFactory == null) continue;
            factories.add(otherFactory);
        }
        for (CheckDataFactory factory : factories) {
            if (!DataManager.removeDataPrecisely(playerId, playerName, checkType, factory)) continue;
            had = true;
        }
        if (checkType == CheckType.ALL && playerId != null) {
            DataManager.instance.bulkPlayerDataRemoval.add(playerId);
            DataManager.instance.rareTasksListener.register();
        }
        return had;
    }

    private static boolean removeDataPrecisely(UUID playerId, String playerName, CheckType checkType, CheckDataFactory factory) {
        ICheckData data = factory.getDataIfPresent(playerId, playerName);
        if (data == null) {
            return false;
        }
        boolean debug = data.getDebug();
        String debugText = debug ? "[" + (Object)((Object)checkType) + "] [" + playerName + "] Data removal: " : null;
        boolean res = false;
        if (data instanceof IRemoveSubCheckData && ((IRemoveSubCheckData)((Object)data)).removeSubCheckData(checkType)) {
            if (debug) {
                debugText = debugText + "Removed (sub) check data, keeping the data object.";
            }
            res = true;
        } else if (factory.removeData(playerName) == null) {
            if (debug) {
                debugText = debugText + "Could not remove data, despite present!";
            }
        } else {
            if (debug) {
                debugText = debugText + "Removed the entire data object.";
            }
            res = true;
        }
        if (debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, debugText);
        }
        return res;
    }

    public static boolean clearComponentData(CheckType checkType, String PlayerName) {
        boolean removed = false;
        for (IRemoveData rmd : DataManager.instance.iRemoveData) {
            CheckType refType;
            if (checkType == CheckType.ALL) {
                if (rmd.removeData(PlayerName) == null) continue;
                removed = true;
                continue;
            }
            if (!(rmd instanceof IHaveCheckType) || (refType = ((IHaveCheckType)((Object)rmd)).getCheckType()) != checkType && !CheckTypeUtil.isAncestor(checkType, refType) || rmd.removeData(PlayerName) == null) continue;
            removed = true;
        }
        return removed;
    }

    public static void clearConfigs() {
        LinkedHashSet<CheckConfigFactory> factories = new LinkedHashSet<CheckConfigFactory>();
        for (CheckType checkType : CheckType.values()) {
            CheckConfigFactory factory = checkType.getConfigFactory();
            if (factory == null) continue;
            factories.add(factory);
        }
        for (CheckConfigFactory factory : factories) {
            factory.removeAllConfigs();
        }
    }

    public static Player getPlayerExact(String playerName) {
        return DataManager.instance.playerMap.getPlayerExact(playerName);
    }

    public static UUID getUUID(String input) {
        Player player = DataManager.getPlayer(input);
        if (player != null) {
            return player.getUniqueId();
        }
        return IdUtil.UUIDFromStringSafe(input);
    }

    public static Player getPlayer(UUID id) {
        return DataManager.instance.playerMap.getPlayer(id);
    }

    public static Player getPlayer(String playerName) {
        return DataManager.instance.playerMap.getPlayer(playerName);
    }

    @Override
    public boolean addComponent(IRemoveData obj) {
        if (this.iRemoveData.contains(obj)) {
            return false;
        }
        this.iRemoveData.add(obj);
        return true;
    }

    @Override
    public void removeComponent(IRemoveData obj) {
        this.iRemoveData.remove(obj);
    }

    public void onEnable() {
        for (Player player : BridgeMisc.getOnlinePlayers()) {
            this.addOnlinePlayer(player);
        }
    }

    private void addOnlinePlayer(Player player) {
        this.playerMap.updatePlayer(player);
    }

    private void removeOnlinePlayer(Player player) {
        this.playerMap.remove(player);
    }

    @Override
    public void onDisable() {
        DataManager.clearData(CheckType.ALL);
        this.playerData.clear();
        this.iRemoveData.clear();
        DataManager.clearConfigs();
        this.lastLogout.clear();
        this.executionHistories.clear();
        this.playerMap.clear();
        if (this.foundInconsistencies > 0) {
            StaticLog.logWarning("DataMan found " + this.foundInconsistencies + " inconsistencies (warnings suppressed).");
            this.foundInconsistencies = 0;
        }
    }

    @Override
    public String getComponentName() {
        return "NoCheatPlus_DataManager";
    }

    @Override
    public void checkConsistency(Player[] onlinePlayers) {
        int missing = 0;
        int changed = 0;
        for (int i = 0; i < onlinePlayers.length; ++i) {
            Player player = onlinePlayers[i];
            UUID id = player.getUniqueId();
            if (!this.playerMap.hasPlayerInfo(id)) {
                ++missing;
            }
            if (!this.playerMap.storesPlayerInstances() || player == this.playerMap.getPlayer(id)) continue;
            ++changed;
            this.addOnlinePlayer(player);
        }
        int storedSize = this.playerMap.size();
        if (missing != 0 || changed != 0 || onlinePlayers.length != storedSize) {
            ++this.foundInconsistencies;
            if (!ConfigManager.getConfigFile().getBoolean("data.consistencychecks.suppresswarnings")) {
                LinkedList<String> details = new LinkedList<String>();
                if (missing != 0) {
                    details.add("missing online players (" + missing + ")");
                }
                if (onlinePlayers.length != storedSize) {
                    details.add("wrong number of online players (" + storedSize + " instead of " + onlinePlayers.length + ")");
                }
                if (changed != 0) {
                    details.add("changed player instances (" + changed + ")");
                }
                StaticLog.logWarning("DataMan inconsistencies: " + StringUtil.join(details, " | "));
            }
        }
    }

    public static PlayerData getPlayerData(Player player) {
        return DataManager.getPlayerData(player.getUniqueId(), player.getName(), true);
    }

    public static PlayerData getPlayerData(UUID playerId, String playerName, boolean create) {
        PlayerData data = DataManager.instance.playerData.get(playerId);
        if (data != null) {
            return data;
        }
        if (!create) {
            return null;
        }
        PlayerData newData = new PlayerData(playerId, playerName);
        PlayerData oldData = DataManager.instance.playerData.putIfAbsent(playerId, newData);
        return oldData == null ? newData : oldData;
    }

    public static PlayerData getPlayerData(String playerName) {
        UUID playerId = DataManager.getUUID(playerName);
        return playerId == null ? null : DataManager.instance.playerData.get(playerId);
    }

    public static PlayerData getPlayerData(UUID playerID) {
        return DataManager.instance.playerData.get(playerID);
    }

    public boolean storesPlayerInstances() {
        return this.playerMap.storesPlayerInstances();
    }
}

