/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.permissions;

import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

public class PermissionUtil {
    private static final String AUTO_GENERATED = "Auto-generated permission (NoCheatPlus).";

    public static List<CommandProtectionEntry> protectCommands(Collection<String> commands, String permissionBase, boolean ops) {
        return PermissionUtil.protectCommands(permissionBase, commands, true, ops);
    }

    public static List<CommandProtectionEntry> protectCommands(String permissionBase, Collection<String> ignoredCommands, boolean invertIgnored, boolean ops) {
        return PermissionUtil.protectCommands(permissionBase, ignoredCommands, invertIgnored, ops, ColorUtil.replaceColors(ConfigManager.getConfigFile().getString("protection.plugins.hide.unknowncommand.message")));
    }

    public static List<CommandProtectionEntry> protectCommands(String permissionBase, Collection<String> ignoredCommands, boolean invertIgnored, boolean ops, String permissionMessage) {
        HashSet<String> checked = new HashSet<String>();
        for (String label : ignoredCommands) {
            checked.add(CommandUtil.getCommandLabel(label, false));
        }
        PluginManager pm = Bukkit.getPluginManager();
        Permission rootPerm = pm.getPermission(permissionBase);
        if (rootPerm == null) {
            rootPerm = new Permission(permissionBase);
            pm.addPermission(rootPerm);
        }
        LinkedList<CommandProtectionEntry> changed = new LinkedList<CommandProtectionEntry>();
        for (Command command : CommandUtil.getCommands()) {
            boolean permRegistered;
            boolean cmdHadPerm;
            String lcLabel = command.getLabel().trim().toLowerCase();
            if (!checked.contains(lcLabel) && !PermissionUtil.containsAnyAliases(checked, command) ? invertIgnored : !invertIgnored) continue;
            String cmdPermName = command.getPermission();
            if (cmdPermName == null) {
                cmdPermName = permissionBase + "." + lcLabel;
                command.setPermission(cmdPermName);
                cmdHadPerm = false;
            } else {
                cmdHadPerm = true;
            }
            Permission cmdPerm = pm.getPermission(cmdPermName);
            boolean bl = permRegistered = cmdPerm != null;
            if (!permRegistered) {
                cmdPerm = new Permission(cmdPermName);
                if (!cmdHadPerm) {
                    cmdPerm.addParent(rootPerm, true);
                }
                pm.addPermission(cmdPerm);
            }
            if (cmdHadPerm && permRegistered) {
                changed.add(new CommandProtectionEntry(command, lcLabel, cmdPermName, cmdPerm.getDefault(), command.getPermissionMessage()));
            } else {
                changed.add(new CommandProtectionEntry(command, lcLabel, null, null, command.getPermissionMessage()));
            }
            cmdPerm.setDefault(ops ? PermissionDefault.OP : PermissionDefault.FALSE);
            command.setPermissionMessage(permissionMessage);
        }
        return changed;
    }

    private static final boolean containsAnyAliases(Set<String> checked, Command command) {
        List aliases = command.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                if (!checked.contains(alias.trim().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static void addChildPermission(Collection<String> permissions, String childPermissionName, PermissionDefault permissionDefault) {
        PluginManager pm = Bukkit.getPluginManager();
        Permission childPermission = pm.getPermission(childPermissionName);
        if (childPermission == null) {
            childPermission = new Permission(childPermissionName, AUTO_GENERATED, permissionDefault);
            pm.addPermission(childPermission);
        }
        for (String permissionName : permissions) {
            Permission permission = pm.getPermission(permissionName);
            if (permission == null) {
                permission = new Permission(permissionName, AUTO_GENERATED, permissionDefault);
                pm.addPermission(permission);
            }
            if (permission.getChildren().containsKey(childPermissionName)) continue;
            childPermission.addParent(permission, true);
        }
    }

    public static void addChildPermissionBySuffix(String permissionName, String childPermissionSuffix, PermissionDefault permissionDefault, boolean childValue) {
        PluginManager pm = Bukkit.getPluginManager();
        Permission permission = pm.getPermission(permissionName);
        if (permission == null) {
            throw new NullPointerException("Permission is not registered: " + permissionName);
        }
        String childPermissionName = permissionName + "." + childPermissionSuffix;
        Permission childPermission = pm.getPermission(childPermissionName);
        if (childPermission == null) {
            childPermission = new Permission(childPermissionName, AUTO_GENERATED, permissionDefault);
            pm.addPermission(childPermission);
        }
        if (!permission.getChildren().containsKey(childPermissionName)) {
            childPermission.addParent(permission, childValue);
        }
    }

    public static class CommandProtectionEntry {
        public final Command command;
        public final String label;
        public final String permission;
        public final PermissionDefault permissionDefault;
        public final String permissionMessage;

        public CommandProtectionEntry(Command command, String label, String permission, PermissionDefault permissionDefault, String permissionMessage) {
            this.command = command;
            this.label = label;
            this.permission = permission;
            this.permissionDefault = permissionDefault;
            this.permissionMessage = permissionMessage;
        }

        public void restore() {
            Permission perm;
            if (!this.label.equalsIgnoreCase(this.command.getLabel().trim().toLowerCase())) {
                this.command.setLabel(this.label);
            }
            this.command.setPermission(this.permission);
            if (this.permission != null && this.permissionDefault != null && (perm = Bukkit.getPluginManager().getPermission(this.permission)) != null && perm.getDefault() != this.permissionDefault) {
                perm.setDefault(this.permissionDefault);
            }
            this.command.setPermissionMessage(this.permissionMessage);
        }
    }
}

