/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging.details;

import fr.neatmonster.nocheatplus.logging.details.ContentLogger;
import fr.neatmonster.nocheatplus.logging.details.LogNode;
import fr.neatmonster.nocheatplus.logging.details.LogNodeDispatcher;
import fr.neatmonster.nocheatplus.logging.details.LogRecord;
import fr.neatmonster.nocheatplus.utilities.ds.corw.IQueueRORA;
import fr.neatmonster.nocheatplus.utilities.ds.corw.QueueRORA;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractLogNodeDispatcher
implements LogNodeDispatcher {
    protected final IQueueRORA<LogRecord<?>> queuePrimary = new QueueRORA();
    protected final IQueueRORA<LogRecord<?>> queueAsynchronous = new QueueRORA();
    protected int maxQueueSize = 5000;
    protected int taskAsynchronousID = -1;
    protected final Runnable taskAsynchronous = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i = 0;
            while (i < 3) {
                if (AbstractLogNodeDispatcher.this.runLogsAsynchronous()) {
                    i = 0;
                    if (AbstractLogNodeDispatcher.this.taskAsynchronousID == -1) {
                        return;
                    }
                    Thread.yield();
                } else {
                    ++i;
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException e) {
                        IQueueRORA<LogRecord<?>> iQueueRORA = AbstractLogNodeDispatcher.this.queueAsynchronous;
                        synchronized (iQueueRORA) {
                            AbstractLogNodeDispatcher.this.taskAsynchronousID = -1;
                        }
                        return;
                    }
                }
                IQueueRORA<LogRecord<?>> iQueueRORA = AbstractLogNodeDispatcher.this.queueAsynchronous;
                synchronized (iQueueRORA) {
                    if (AbstractLogNodeDispatcher.this.queueAsynchronous.isEmpty()) {
                        if (i >= 3) {
                            AbstractLogNodeDispatcher.this.taskAsynchronousID = -1;
                        }
                    } else {
                        i = 0;
                    }
                }
            }
        }
    };
    protected ContentLogger<String> initLogger = null;

    @Override
    public <C> void dispatch(LogNode<C> node, Level level, C content) {
        if (this.isWithinContext(node)) {
            node.logger.log(level, content);
        } else {
            this.scheduleLog(node, level, content);
        }
    }

    protected boolean runLogsPrimary() {
        return this.runLogs(this.queuePrimary);
    }

    protected boolean runLogsAsynchronous() {
        return this.runLogs(this.queueAsynchronous);
    }

    private boolean runLogs(IQueueRORA<LogRecord<?>> queue) {
        List<LogRecord<?>> records = queue.removeAll();
        if (records.isEmpty()) {
            return false;
        }
        for (LogRecord<?> record : records) {
            record.run();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(long ms) {
        if (!this.isPrimaryThread()) {
            throw new IllegalStateException("Must only be called from within the primary thread.");
        }
        IQueueRORA<LogRecord<?>> iQueueRORA = this.queueAsynchronous;
        synchronized (iQueueRORA) {
            if (this.taskAsynchronousID != -1) {
                this.cancelTask(this.taskAsynchronousID);
                this.taskAsynchronousID = -1;
            } else {
                ms = 0L;
            }
        }
        if (ms > 0L) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.runLogsPrimary();
        this.runLogsAsynchronous();
    }

    protected <C> boolean isWithinContext(LogNode<C> node) {
        switch (node.options.callContext) {
            case PRIMARY_THREAD_DIRECT: 
            case PRIMARY_THREAD_ONLY: {
                return this.isPrimaryThread();
            }
            case ANY_THREAD_DIRECT: {
                return true;
            }
            case ASYNCHRONOUS_ONLY: 
            case ASYNCHRONOUS_DIRECT: {
                return !this.isPrimaryThread();
            }
            case PRIMARY_THREAD_TASK: 
            case ASYNCHRONOUS_TASK: {
                return false;
            }
        }
        return false;
    }

    protected <C> void scheduleLog(LogNode<C> node, Level level, C content) {
        LogRecord<C> record = new LogRecord<C>(node, level, content);
        switch (node.options.callContext) {
            case ASYNCHRONOUS_DIRECT: 
            case ASYNCHRONOUS_TASK: {
                if (this.queueAsynchronous.add(record) > this.maxQueueSize) {
                    this.reduceQueue(this.queueAsynchronous);
                }
                if (this.taskAsynchronousID != -1) break;
                this.scheduleAsynchronous();
                break;
            }
            case PRIMARY_THREAD_DIRECT: 
            case PRIMARY_THREAD_TASK: {
                this.queuePrimary.add(record);
                break;
            }
            case PRIMARY_THREAD_ONLY: 
            case ASYNCHRONOUS_ONLY: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad CallContext: " + (Object)((Object)node.options.callContext));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reduceQueue(IQueueRORA<LogRecord<?>> queue) {
        int dropped;
        IQueueRORA<LogRecord<?>> iQueueRORA = queue;
        synchronized (iQueueRORA) {
            int size = queue.size();
            if (size < this.maxQueueSize) {
                return;
            }
            this.logINIT(Level.WARNING, "Dropping log entries from the " + (queue == this.queueAsynchronous ? "asynchronous" : "primary thread") + " queue to reduce memory consumption...");
            dropped = queue.reduce(this.maxQueueSize / 2);
        }
        this.logINIT(Level.WARNING, "Dropped " + dropped + " log entries from the " + (queue == this.queueAsynchronous ? "asynchronous" : "primary thread") + " queue.");
    }

    @Override
    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    @Override
    public void setInitLogger(ContentLogger<String> logger) {
        this.initLogger = logger;
    }

    protected void logINIT(Level level, String message) {
        if (this.initLogger != null) {
            this.initLogger.log(level, message);
        }
    }

    protected abstract boolean isPrimaryThread();

    protected abstract void scheduleAsynchronous();

    protected abstract void cancelTask(int var1);
}

