/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.logging.StreamID;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class StaticLog {
    private static boolean useLogManager = false;
    private static StreamID streamID = Streams.INIT;
    private static final Set<Integer> logOnce = Collections.synchronizedSet(new HashSet());

    public static void setUseLogManager(boolean useLogManager) {
        StaticLog.useLogManager = useLogManager;
    }

    public static void setStreamID(StreamID streamID) {
        if (streamID == null) {
            throw new NullPointerException("StreamID must not be null, use setUseLogManager(false) instead.");
        }
        StaticLog.streamID = streamID;
    }

    public static void logDebug(String msg) {
        StaticLog.log(Level.FINE, msg);
    }

    public static void logInfo(String msg) {
        StaticLog.log(Level.INFO, msg);
    }

    public static void logWarning(String msg) {
        StaticLog.log(Level.WARNING, msg);
    }

    public static void logSevere(String msg) {
        StaticLog.log(Level.SEVERE, msg);
    }

    public static void logDebug(Throwable t) {
        StaticLog.log(Level.FINE, StringUtil.throwableToString(t));
    }

    public static void logInfo(Throwable t) {
        StaticLog.log(Level.INFO, StringUtil.throwableToString(t));
    }

    public static void logWarning(Throwable t) {
        StaticLog.log(Level.WARNING, StringUtil.throwableToString(t));
    }

    public static void logSevere(Throwable t) {
        StaticLog.log(Level.SEVERE, StringUtil.throwableToString(t));
    }

    public static void log(Level level, String msg) {
        StaticLog.log(streamID, level, msg);
    }

    public static void log(StreamID streamID, Level level, String msg) {
        if (useLogManager) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().log(streamID, level, msg);
        } else {
            System.out.println("[" + level + "][NoCheatPlus] " + new Date());
            System.out.println(msg);
        }
    }

    public static void logOnce(Level level, String header, String longMessage) {
        StaticLog.logOnce(streamID, level, header, longMessage);
    }

    public static void logOnce(StreamID stream, Level level, String header, String longMessage) {
        int ref = header.hashCode() ^ longMessage.hashCode() ^ new Integer(header.length()).hashCode() ^ new Integer(longMessage.length()).hashCode();
        boolean details = logOnce.add(ref);
        String extra = details ? " -> log once id=" : " See earlier in this log, search for -> log once id=";
        StaticLog.log(stream, level, header + extra + ref);
        if (details) {
            StaticLog.log(stream, level, longMessage);
            if (logOnce.size() > 10000) {
                logOnce.clear();
                StaticLog.log(stream, level, "Cleared log once ids, due to exceeding the maximum number of stored ids.");
            }
        }
    }
}

