/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.hooks.allviolations;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.access.IViolationInfo;
import fr.neatmonster.nocheatplus.hooks.ILast;
import fr.neatmonster.nocheatplus.hooks.IStats;
import fr.neatmonster.nocheatplus.hooks.NCPHook;
import fr.neatmonster.nocheatplus.hooks.NCPHookManager;
import fr.neatmonster.nocheatplus.hooks.allviolations.AllViolationsConfig;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class AllViolationsHook
implements NCPHook,
ILast,
IStats {
    private AllViolationsConfig config;
    private Integer hookId = null;
    private final ParameterName[] parameters;
    private final String[] noParameterTexts;

    public AllViolationsHook() {
        LinkedHashSet<ParameterName> parameters = new LinkedHashSet<ParameterName>();
        for (ParameterName name : ParameterName.values()) {
            parameters.add(name);
        }
        for (ParameterName name : Arrays.asList(ParameterName.PLAYER, ParameterName.PLAYER_NAME, ParameterName.PLAYER_DISPLAY_NAME, ParameterName.IP, ParameterName.CHECK, ParameterName.UUID, ParameterName.VIOLATIONS, ParameterName.WORLD)) {
            parameters.remove((Object)name);
        }
        this.parameters = parameters.toArray(new ParameterName[parameters.size()]);
        this.noParameterTexts = new String[parameters.size()];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.noParameterTexts[i] = "[" + this.parameters[i].getText() + "]";
        }
    }

    public void setConfig(AllViolationsConfig config) {
        this.config = config;
        if (config == null || !config.doesLogAnything()) {
            this.unregister();
        } else {
            this.register();
        }
    }

    public void unregister() {
        if (this.hookId != null) {
            NCPHookManager.removeHook(this);
            this.hookId = null;
        }
    }

    public void register() {
        this.unregister();
        this.hookId = NCPHookManager.addHook(CheckType.ALL, (NCPHook)this);
    }

    @Override
    public String getHookName() {
        return "AllViolations(NCP)";
    }

    @Override
    public String getHookVersion() {
        return "1.0";
    }

    @Override
    public boolean onCheckFailure(CheckType checkType, Player player, IViolationInfo info) {
        AllViolationsConfig config = this.config;
        if (config == null) {
            return false;
        }
        boolean debugSet = false;
        if (config.debugOnly || config.debug) {
            CheckDataFactory factory = checkType.getDataFactory();
            if (config.debugOnly && factory == null) {
                return false;
            }
            ICheckData data = factory.getData(player);
            if (data == null) {
                if (config.debugOnly) {
                    return false;
                }
            } else {
                debugSet = data.getDebug();
                if (config.debugOnly && !debugSet) {
                    return false;
                }
            }
        }
        this.log(checkType, player, info, config.allToTrace || debugSet, config.allToNotify);
        return false;
    }

    private void log(CheckType checkType, Player player, IViolationInfo info, boolean toTrace, boolean toNotify) {
        StringBuilder builder = new StringBuilder(300);
        String playerName = player.getName();
        builder.append("[VL] [" + checkType.toString() + "] ");
        builder.append("[" + ChatColor.YELLOW + playerName);
        builder.append(ChatColor.WHITE + "] ");
        String displayName = ChatColor.stripColor((String)player.getDisplayName()).trim();
        if (!playerName.equals(displayName)) {
            builder.append("[->" + ChatColor.YELLOW + displayName + ChatColor.WHITE + "] ");
        }
        builder.append("VL=" + StringUtil.fdec1.format(info.getTotalVl()));
        builder.append("(+" + StringUtil.fdec1.format(info.getAddedVl()) + ")");
        builder.append(ChatColor.GRAY);
        for (int i = 0; i < this.parameters.length; ++i) {
            ParameterName name = this.parameters[i];
            String value = info.getParameter(name);
            if (value == null || value.isEmpty() || value.equals(this.noParameterTexts[i])) continue;
            builder.append(" " + name.getText() + "=" + value);
        }
        String message = builder.toString();
        LogManager logManager = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
        if (toNotify) {
            logManager.info(Streams.NOTIFY_INGAME, message);
        }
        if (toTrace) {
            logManager.info(Streams.TRACE_FILE, ChatColor.stripColor((String)message));
        }
    }
}

