/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.hooks;

import fr.neatmonster.nocheatplus.config.ConfigFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.NPC;

public class ExemptionSettings {
    public final MetaDataListCheck defaultMetaData;
    public final boolean npcWildCardExempt;
    public final boolean npcBukkitInterface;
    public final MetaDataListCheck npcMetaData;

    public ExemptionSettings() {
        this(new MetaDataListCheck(Arrays.asList("nocheat.exempt")), true, true, new MetaDataListCheck(Arrays.asList("NPC")));
    }

    public ExemptionSettings(ConfigFile config) {
        this(new MetaDataListCheck(config, "compatibility.exemptions.wildcard.default.metadata.active", "compatibility.exemptions.wildcard.default.metadata.keys"), config.getBoolean("compatibility.exemptions.wildcard.npc.active"), config.getBoolean("compatibility.exemptions.wildcard.npc.bukkitnpc"), new MetaDataListCheck(config, "compatibility.exemptions.wildcard.npc.metadata.active", "compatibility.exemptions.wildcard.npc.metadata.keys"));
    }

    public ExemptionSettings(MetaDataListCheck defaultMetaData, boolean npcWildCardExempt, boolean npcBukkitInterface, MetaDataListCheck npcMetaData) {
        this.defaultMetaData = defaultMetaData == null ? new MetaDataListCheck(null) : defaultMetaData;
        this.npcWildCardExempt = npcWildCardExempt;
        this.npcBukkitInterface = npcBukkitInterface;
        this.npcMetaData = npcMetaData == null ? new MetaDataListCheck(null) : npcMetaData;
    }

    public boolean isExemptedBySettings(Entity entity) {
        return this.isExemptedBySettings(entity, Bukkit.isPrimaryThread());
    }

    public boolean isExemptedBySettings(Entity entity, boolean isPrimaryThread) {
        return isPrimaryThread && this.defaultMetaData.hasAnyMetaDataKey(entity) || this.npcWildCardExempt && this.isRegardedAsNpc(entity, isPrimaryThread);
    }

    public boolean isRegardedAsNpc(Entity entity) {
        return this.isRegardedAsNpc(entity, Bukkit.isPrimaryThread());
    }

    public boolean isRegardedAsNpc(Entity entity, boolean isPrimaryThread) {
        return this.npcBukkitInterface && entity instanceof NPC || isPrimaryThread && this.npcMetaData.hasAnyMetaDataKey(entity);
    }

    public static final class MetaDataListCheck {
        private final String[] metaDataKeys;

        private static String[] getKeys(Collection<String> keys) {
            if (keys == null) {
                return null;
            }
            ArrayList<String> notNull = new ArrayList<String>(keys.size());
            for (String key : keys) {
                if (key == null) continue;
                notNull.add(key);
            }
            if (notNull.isEmpty()) {
                return null;
            }
            return notNull.toArray(new String[notNull.size()]);
        }

        public MetaDataListCheck(ConfigFile config, String pathActive, String pathKeys) {
            this(config.getBoolean(pathActive) ? config.getStringList(pathKeys) : null);
        }

        public MetaDataListCheck(Collection<String> keys) {
            this.metaDataKeys = MetaDataListCheck.getKeys(keys);
        }

        public boolean hasAnyMetaDataKey(Entity entity) {
            if (this.metaDataKeys == null) {
                return false;
            }
            for (int i = 0; i < this.metaDataKeys.length; ++i) {
                if (!entity.hasMetadata(this.metaDataKeys[i])) continue;
                return true;
            }
            return false;
        }
    }
}

