/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.event.mini;

import fr.neatmonster.nocheatplus.components.registry.order.IGetRegistrationOrder;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.event.mini.MiniListenerNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class MiniListenerRegistry<EB, P> {
    protected NodeFactory<EB, P> nodeFactory = new NodeFactory<EB, P>(){

        @Override
        public <E extends EB> MiniListenerNode<E, P> newNode(Class<E> eventClass, P basePriority) {
            return new MiniListenerNode(basePriority);
        }
    };
    protected final Map<Class<? extends EB>, Map<P, MiniListenerNode<? extends EB, P>>> classMap = new HashMap<Class<? extends EB>, Map<P, MiniListenerNode<? extends EB, P>>>();
    protected final Map<Object, Set<MiniListener<? extends EB>>> attachments = new HashMap<Object, Set<MiniListener<? extends EB>>>();

    public void attach(MiniListener<? extends EB>[] listeners, Object anchor) {
        this.attach(Arrays.asList(listeners), anchor);
    }

    public void attach(Collection<MiniListener<? extends EB>> listeners, Object anchor) {
        for (MiniListener<EB> miniListener : listeners) {
            this.attach(miniListener, anchor);
        }
    }

    public <E extends EB> void attach(MiniListener<E> listener, Object anchor) {
        if (listener == null) {
            throw new NullPointerException("Must not be null: listener");
        }
        if (anchor == null) {
            throw new NullPointerException("Must not be null: anchor");
        }
        if (anchor.equals(listener)) {
            throw new IllegalArgumentException("Must not be equal: listener and anchor");
        }
        Set<MiniListener<EB>> attached = this.attachments.get(anchor);
        if (attached == null) {
            attached = new HashSet<MiniListener<? extends EB>>();
            this.attachments.put(anchor, attached);
        }
        attached.add(listener);
    }

    public void inheritAttached(Object registeredAnchor, Object otherAnchor) {
        if (registeredAnchor == null) {
            throw new NullPointerException("Must not be null: registeredAnchor");
        }
        if (otherAnchor == null) {
            throw new NullPointerException("Must not be null: newAnchor");
        }
        if (registeredAnchor.equals(otherAnchor)) {
            throw new IllegalArgumentException("Must not be equal: registeredAnchor and newAnchor");
        }
        Set<MiniListener<? extends EB>> attached = this.attachments.get(registeredAnchor);
        if (attached != null) {
            Set<MiniListener<EB>> attached2 = this.attachments.get(otherAnchor);
            if (attached2 == null) {
                attached2 = new HashSet<MiniListener<? extends EB>>();
                this.attachments.put(otherAnchor, attached2);
            }
            attached2.addAll(attached);
        }
    }

    public void unregisterAttached(Object anchor) {
        Set<MiniListener<? extends EB>> attached = this.attachments.get(anchor);
        if (attached != null) {
            for (MiniListener<? extends EB> miniListener : new ArrayList<MiniListener<EB>>(attached)) {
                this.unregister(miniListener);
            }
        }
    }

    public <E extends EB> void unregister(MiniListener<E> listener) {
        for (Map<P, MiniListenerNode<EB, P>> prioMap : this.classMap.values()) {
            for (MiniListenerNode<EB, P> node : prioMap.values()) {
                try {
                    node.removeMiniListener(listener);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        Iterator<Map.Entry<Object, Set<MiniListener<EB>>>> it = this.attachments.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Set<MiniListener<EB>>> entry = it.next();
            Set<MiniListener<EB>> attached = entry.getValue();
            attached.remove(listener);
            if (!attached.isEmpty()) continue;
            it.remove();
        }
    }

    public void clear() {
        this.attachments.clear();
        for (Map<P, MiniListenerNode<EB, P>> prioMap : this.classMap.values()) {
            for (MiniListenerNode<EB, P> node : prioMap.values()) {
                node.clear();
            }
        }
    }

    public <E extends EB> void register(Class<E> eventClass, MiniListener<E> listener, P basePriority, RegistrationOrder defaultOrder, boolean ignoreCancelled) {
        MiniListenerNode<Object, P> node;
        Map<P, MiniListenerNode<EB, P>> prioMap;
        RegistrationOrder order = null;
        if (listener instanceof IGetRegistrationOrder) {
            order = ((IGetRegistrationOrder)((Object)listener)).getRegistrationOrder();
        }
        if (order == null) {
            Class<?> listenerClass = listener.getClass();
            order = listenerClass.isAnnotationPresent(RegistrationOrder.RegisterEventsWithOrder.class) ? new RegistrationOrder(listenerClass.getAnnotation(RegistrationOrder.RegisterEventsWithOrder.class)) : (listenerClass.isAnnotationPresent(RegistrationOrder.RegisterWithOrder.class) ? new RegistrationOrder(listenerClass.getAnnotation(RegistrationOrder.RegisterWithOrder.class)) : defaultOrder);
        }
        if ((prioMap = this.classMap.get(eventClass)) == null) {
            prioMap = new HashMap<P, MiniListenerNode<? extends EB, P>>();
            this.classMap.put(eventClass, prioMap);
        }
        if ((node = prioMap.get(basePriority)) == null) {
            node = this.nodeFactory.newNode(eventClass, basePriority);
            this.registerNode(eventClass, node, basePriority);
            prioMap.put(basePriority, node);
        }
        node.addMiniListener(listener, ignoreCancelled, order);
    }

    protected abstract <E extends EB> void registerNode(Class<E> var1, MiniListenerNode<E, P> var2, P var3);

    public static interface NodeFactory<EB, P> {
        public <E extends EB> MiniListenerNode<E, P> newNode(Class<E> var1, P var2);
    }
}

