/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.event.mini;

import fr.neatmonster.nocheatplus.components.registry.order.IGetRegistrationOrder;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class MiniListenerNode<E, P> {
    protected final SortListenerEntry<E> typedSort = new SortListenerEntry();
    protected final List<ListenerEntry<E>> registeredListeners = new ArrayList<ListenerEntry<E>>();
    protected ListenerEntry<E>[] sortedListeners = new ListenerEntry[0];
    protected final P basePriority;

    public MiniListenerNode(P basePriority) {
        this.basePriority = basePriority;
    }

    public void clear() {
        this.registeredListeners.clear();
        this.sortedListeners = new ListenerEntry[0];
    }

    public void removeMiniListener(MiniListener<E> listener) {
        boolean changed = false;
        Iterator<ListenerEntry<E>> it = this.registeredListeners.iterator();
        while (it.hasNext()) {
            if (it.next().listener != listener) continue;
            it.remove();
            changed = true;
            break;
        }
        if (changed) {
            this.generateSortedListeners();
        }
    }

    public void addMiniListener(MiniListener<E> listener, boolean ignoreCancelled, RegistrationOrder order) {
        this.registeredListeners.add(new ListenerEntry<E>(listener, ignoreCancelled, order));
        this.generateSortedListeners();
    }

    protected void generateSortedListeners() {
        if (this.registeredListeners.isEmpty()) {
            this.clear();
        } else {
            ListenerEntry<E>[] sortedOdd = this.typedSort.getSortedArray(this.registeredListeners);
            ListenerEntry[] sortedListeners = new ListenerEntry[sortedOdd.length];
            System.arraycopy(sortedOdd, 0, sortedListeners, 0, sortedOdd.length);
            this.sortedListeners = sortedListeners;
        }
    }

    protected boolean isCancelled(E event) {
        return false;
    }

    public void onEvent(E event) {
        ListenerEntry<E>[] listeners = this.sortedListeners;
        for (int i = 0; i < listeners.length; ++i) {
            ListenerEntry<E> entry = listeners[i];
            if (entry.ignoreCancelled && this.isCancelled(event)) continue;
            try {
                entry.listener.onEvent(event);
                continue;
            }
            catch (Throwable t) {
                this.logListenerException(entry, i, listeners.length, event, t);
            }
        }
    }

    private void logListenerException(ListenerEntry<E> entry, int index, int length, E event, Throwable t) {
        StaticLog.logOnce(Streams.STATUS, Level.SEVERE, "Listener exception: event=" + event.getClass().getName() + " priority=" + this.basePriority + " index=" + index + " n=" + length, StringUtil.throwableToString(t));
    }

    protected static final class SortListenerEntry<E>
    extends RegistrationOrder.AbstractRegistrationOrderSort<ListenerEntry<E>> {
        protected SortListenerEntry() {
        }

        @Override
        protected RegistrationOrder fetchRegistrationOrder(ListenerEntry<E> item) {
            return item.getRegistrationOrder();
        }
    }

    protected static class ListenerEntry<E>
    implements IGetRegistrationOrder {
        public final MiniListener<E> listener;
        public final boolean ignoreCancelled;
        private final RegistrationOrder order;

        public ListenerEntry(MiniListener<E> listener, boolean ignoreCancelled, RegistrationOrder order) {
            this.listener = listener;
            this.ignoreCancelled = ignoreCancelled;
            this.order = order == null ? new RegistrationOrder() : new RegistrationOrder(order);
        }

        @Override
        public RegistrationOrder getRegistrationOrder() {
            return this.order;
        }
    }
}

