/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.registry;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.NoCheatPlus;
import fr.neatmonster.nocheatplus.checks.inventory.FastConsume;
import fr.neatmonster.nocheatplus.checks.inventory.Gutenberg;
import fr.neatmonster.nocheatplus.checks.inventory.HotFixFallingBlockPortalEnter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.components.registry.activation.Activation;
import fr.neatmonster.nocheatplus.components.registry.activation.IActivation;
import fr.neatmonster.nocheatplus.components.registry.activation.IDescriptiveActivation;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.plugin.Plugin;

public class DefaultComponentFactory {
    private final IActivation protocolLibPresent = new Activation().pluginExist("ProtocolLib");
    private final List<IDescriptiveActivation> protocolLibActivation = new ArrayList<IDescriptiveActivation>();

    public DefaultComponentFactory() {
        for (Activation condition : Arrays.asList(new Activation().neutralDescription("ProtocolLib 4.3.0 or later for Minecraft 1.12.x").pluginVersionGT("ProtocolLib", "4.3.0", true).minecraftVersionBetween("1.12", true, "1.13", false).advertise(true), new Activation().neutralDescription("ProtocolLib 4.2.0 or later for Minecraft 1.11.x").pluginVersionGT("ProtocolLib", "4.2.0", true).minecraftVersionBetween("1.11", true, "1.12", false).advertise(true), new Activation().neutralDescription("ProtocolLib 4.1 or later for Minecraft 1.8.x to 1.10.x").pluginVersionGT("ProtocolLib", "4.1", true).minecraftVersionBetween("1.8", true, "1.11", false).advertise(true), new Activation().neutralDescription("ProtocolLib 4.0.2 for Minecraft 1.10.x").pluginVersionBetween("ProtocolLib", "4.0.2", true, "4.1", false).minecraftVersionBetween("1.10", true, "1.11", false), new Activation().neutralDescription("ProtocolLib 4.0.1 or 4.0.0 for Minecraft 1.9.x").pluginVersionBetween("ProtocolLib", "4.0.0", true, "4.0.1", true).minecraftVersionBetween("1.9", true, "1.10", false), new Activation().neutralDescription("ProtocolLib 3.7.0 for Minecraft 1.7.x and earlier").pluginVersionBetween("ProtocolLib", "3.7", true, "3.7.0", true).minecraftVersionLT("1.10", false).advertise(true), new Activation().neutralDescription("ProtocolLib 3.6.5 or 3.6.4 for Minecraft 1.8.x").pluginVersionBetween("ProtocolLib", "3.6.4", true, "3.6.5", true).minecraftVersionBetween("1.8", true, "1.9", false), new Activation().neutralDescription("ProtocolLib 3.6.6 for PaperSpigot 1.8.x").pluginVersionEQ("ProtocolLib", "3.6.6").serverVersionContainsIgnoreCase("paperspigot").minecraftVersionBetween("1.8", true, "1.9", false).advertise(true), new Activation().neutralDescription("ProtocolLib 3.6.4 before Minecraft 1.9").pluginVersionEQ("ProtocolLib", "3.6.4").minecraftVersionBetween("1.2.5", true, "1.9", false))) {
            this.protocolLibActivation.add(condition);
        }
    }

    public Collection<Object> getAvailableComponentsOnEnable(NoCheatPlus plugin) {
        LinkedList<Object> available = new LinkedList<Object>();
        try {
            FastConsume.testAvailability();
            available.add(new FastConsume());
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(FastConsume.class.getSimpleName()));
        }
        catch (Throwable t) {
            StaticLog.logInfo("Inventory checks: FastConsume is not available.");
        }
        try {
            Gutenberg.testAvailability();
            available.add(new Gutenberg());
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(Gutenberg.class.getSimpleName()));
        }
        catch (Throwable t) {
            StaticLog.logInfo("Inventory checks: Gutenberg is not available.");
        }
        try {
            HotFixFallingBlockPortalEnter.testAvailability();
            available.add(new HotFixFallingBlockPortalEnter());
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(HotFixFallingBlockPortalEnter.class.getSimpleName()));
        }
        catch (RuntimeException t) {
            // empty catch block
        }
        if (this.protocolLibPresent.isAvailable()) {
            boolean protocolLibAvailable = false;
            for (IActivation iActivation : this.protocolLibActivation) {
                if (!iActivation.isAvailable()) continue;
                protocolLibAvailable = true;
                break;
            }
            if (protocolLibAvailable) {
                try {
                    available.add(new ProtocolLibComponent((Plugin)plugin));
                }
                catch (Throwable t) {
                    StaticLog.logWarning("Failed to set up packet level access with ProtocolLib.");
                    if (ConfigManager.getConfigFile().getBoolean("logging.extended.status")) {
                        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.INIT, t);
                    }
                }
            } else {
                LinkedList<String> parts = new LinkedList<String>();
                parts.add("Packet level access via ProtocolLib not available, supported configurations: ");
                for (IDescriptiveActivation cond : this.protocolLibActivation) {
                    if (!cond.advertise()) continue;
                    parts.add(cond.getNeutralDescription());
                }
                StaticLog.logWarning(StringUtil.join(parts, " | "));
            }
        } else {
            StaticLog.logInfo("Packet level access: ProtocolLib is not available.");
        }
        return available;
    }
}

