/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin.log.stream;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.StreamID;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class StreamCommand
extends BaseCommand {
    public StreamCommand(JavaPlugin plugin) {
        super(plugin, "stream", (String)null);
        this.usage = "ncp log stream (stream_id)[@(level)][?color|?nocolor][+(stream_id2)[@(level2)][?color|?nocolor][+...]] (message...) ";
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (!StreamCommand.demandConsoleCommandSender(sender)) {
            return true;
        }
        if (args.length < 4) {
            return false;
        }
        LogManager man = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
        String message = null;
        String messageColor = null;
        String messageNoColor = null;
        for (String streamDef : args[2].split("\\+")) {
            String logMessage;
            StreamID streamId;
            String[] split;
            Level level = null;
            boolean color = false;
            boolean noColor = false;
            if (streamDef.indexOf(63) != -1) {
                split = streamDef.split("\\?");
                if (split.length != 2) {
                    sender.sendMessage("Bad flag (color|nocolor): " + streamDef);
                    continue;
                }
                streamDef = split[0];
                String temp = split[1].toLowerCase();
                if (temp.matches("^(nc|noc|nocol|nocolor)$")) {
                    noColor = true;
                } else if (temp.matches("^(c|col|color)$")) {
                    color = true;
                } else {
                    sender.sendMessage("Bad flag (color|nocolor): " + temp);
                    continue;
                }
            }
            if (streamDef.indexOf(64) != -1) {
                split = streamDef.split("@");
                if (split.length != 2) {
                    sender.sendMessage("Bad level definition: " + streamDef);
                    continue;
                }
                streamDef = split[0];
                try {
                    level = Level.parse(split[1].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage("Bad level: " + split[1]);
                    continue;
                }
            }
            if ((streamId = man.getStreamID(streamDef)) == null) {
                String altStreamDef = streamDef.toLowerCase();
                if (altStreamDef.equals("notify")) {
                    streamId = Streams.NOTIFY_INGAME;
                } else if (altStreamDef.equals("debug")) {
                    streamId = Streams.TRACE_FILE;
                    if (level == null) {
                        level = Level.FINE;
                    }
                } else if (altStreamDef.equals("status")) {
                    streamId = Streams.STATUS;
                } else if (altStreamDef.equals("init")) {
                    streamId = Streams.INIT;
                } else if (altStreamDef.equals("console")) {
                    streamId = Streams.PLUGIN_LOGGER;
                } else if (altStreamDef.equals("file")) {
                    streamId = Streams.DEFAULT_FILE;
                } else {
                    sender.sendMessage("Bad stream id: " + streamDef);
                    continue;
                }
            }
            if (level == null) {
                level = Level.INFO;
            }
            if (message == null) {
                message = StringUtil.join(args, 3, " ");
            }
            if (noColor) {
                if (messageNoColor == null) {
                    messageNoColor = ChatColor.stripColor((String)ColorUtil.removeColors(message));
                }
                logMessage = messageNoColor;
            } else if (color) {
                if (messageColor == null) {
                    messageColor = ColorUtil.replaceColors(message);
                }
                logMessage = messageColor;
            } else {
                logMessage = message;
            }
            man.log(streamId, level, logMessage);
        }
        return true;
    }
}

