/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin.exemption;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class UnexemptCommand
extends BaseCommand {
    public UnexemptCommand(JavaPlugin plugin) {
        super(plugin, "unexempt", "nocheatplus.command.unexempt");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        UUID id;
        CheckType checkType;
        if (args.length < 2 || args.length > 3) {
            return false;
        }
        String playerName = args[1];
        if (args.length == 3) {
            try {
                checkType = CheckType.valueOf(args[2].toUpperCase().replace('-', '_').replace('.', '_'));
            }
            catch (Exception e) {
                sender.sendMessage(TAG + "Could not interpret: " + args[2]);
                sender.sendMessage(TAG + "Check type should be one of: " + StringUtil.join(Arrays.asList(CheckType.values()), " | "));
                return true;
            }
        } else {
            checkType = CheckType.ALL;
        }
        if (playerName.equals("*")) {
            NCPExemptionManager.clear();
            sender.sendMessage(TAG + "Removed exemptions for all players for checks: " + (Object)((Object)checkType));
            return true;
        }
        Player player = DataManager.getPlayer(playerName);
        if (player != null) {
            playerName = player.getName();
            id = player.getUniqueId();
        } else {
            id = DataManager.getUUID(playerName);
        }
        if (id == null) {
            sender.sendMessage(TAG + "Not an online player nor a UUID: " + playerName);
        } else {
            NCPExemptionManager.unexempt(id, checkType);
            sender.sendMessage(TAG + "Remove exemptions for " + playerName + " for checks: " + (Object)((Object)checkType));
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 3) {
            return CommandUtil.getCheckTypeTabMatches(args[2]);
        }
        return null;
    }

    @Override
    public boolean testPermission(CommandSender sender, Command command, String alias, String[] args) {
        return super.testPermission(sender, command, alias, args) || args.length >= 2 && args[1].trim().equalsIgnoreCase(sender.getName()) && sender.hasPermission(this.permission + ".self");
    }
}

