/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.actions;

import fr.neatmonster.nocheatplus.command.AbstractCommand;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.IdUtil;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class BanCommand
extends BaseCommand {
    public BanCommand(JavaPlugin plugin) {
        super(plugin, "ban", "nocheatplus.command.ban");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!BanCommand.demandConsoleCommandSender(sender)) {
            return true;
        }
        if (args.length < 2) {
            return false;
        }
        String name = args[1].trim();
        String reason = args.length > 2 ? AbstractCommand.join(args, 2) : "";
        this.ban(sender, name, reason);
        return true;
    }

    void ban(CommandSender sender, String name, String reason) {
        Server server = Bukkit.getServer();
        Player player = DataManager.getPlayer(name);
        if (player == null && !IdUtil.isValidMinecraftUserName(name)) {
            UUID id = IdUtil.UUIDFromStringSafe(name);
            if (id != null) {
                StaticLog.logWarning("Banning by UUID might not work (" + id.toString() + "), relay to the vanilla command.");
            } else {
                StaticLog.logWarning("Might not be a valid user name: " + name);
            }
        }
        if (player != null) {
            player.kickPlayer(reason);
        }
        server.dispatchCommand((CommandSender)server.getConsoleSender(), "ban " + name);
        this.logBan(sender, player, name, reason);
    }

    private void logBan(CommandSender sender, Player player, String name, String reason) {
        StaticLog.logInfo("(" + sender.getName() + ") Banned " + name + (player != null ? "/" + player.getName() : "") + " : " + reason);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }
}

