/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.net.AttackFrequency;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UseEntityAdapter
extends BaseAdapter {
    private static final int INTERPRETED = 1;
    private static final int ATTACK = 2;
    private final AttackFrequency attackFrequency;
    private final LegacyReflectionSet legacySet;

    public UseEntityAdapter(Plugin plugin) {
        super(plugin, PacketType.Play.Client.USE_ENTITY);
        if (ConfigManager.isTrueForAnyConfig("checks.net.attackfrequency.active")) {
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(AttackFrequency.class.getSimpleName()));
        }
        this.attackFrequency = new AttackFrequency();
        LegacyReflectionSet set = null;
        for (String versionDetail : new String[]{"v1_7_R4", "v1_7_R1"}) {
            try {
                set = new LegacyReflectionSet(versionDetail);
                if (set == null) continue;
                break;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.legacySet = set;
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.attackFrequency);
    }

    public void onPacketReceiving(PacketEvent event) {
        StructureModifier actions;
        int flags;
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        NetConfig cc = this.configFactory.getConfig(player);
        NetData data = this.dataFactory.getData(player);
        data.lastKeepAliveTime = time;
        if (!cc.attackFrequencyActive) {
            return;
        }
        PacketContainer packet = event.getPacket();
        boolean isAttack = false;
        boolean packetInterpreted = false;
        if (this.legacySet != null && ((flags = this.getAction_legacy(packet)) & 1) != 0) {
            packetInterpreted = true;
            if ((flags & 2) != 0) {
                isAttack = true;
            }
        }
        if (!packetInterpreted && (actions = packet.getEntityUseActions()).size() == 1 && actions.read(0) == EnumWrappers.EntityUseAction.ATTACK) {
            isAttack = true;
            packetInterpreted = true;
        }
        if (!packetInterpreted) {
            return;
        }
        boolean cancel = false;
        if (isAttack && this.attackFrequency.isEnabled(player, data, cc) && this.attackFrequency.check(player, time, data, cc)) {
            cancel = true;
        }
        if (cancel) {
            event.setCancelled(true);
        }
    }

    private int getAction_legacy(PacketContainer packetContainer) {
        String actionName = this.legacySet.getActionFromNMSPacket(packetContainer.getHandle());
        return actionName == null ? 0 : 1 | ("ATTACK".equals(actionName) ? 2 : 0);
    }

    private static class LegacyReflectionSet {
        final Class<?> packetClass_legacy;
        final Class<?> enumClassAction_legacy;
        final Method methodGetAction_legacy;
        final Method methodName_legacy;

        private LegacyReflectionSet(String versionDetail) {
            Method methodGetAction;
            Class<?> packetClass = ReflectionUtil.getClass("net.minecraft.server." + versionDetail + ".PacketPlayInUseEntity");
            Class<?> actionClass = ReflectionUtil.getClass("net.minecraft.server." + versionDetail + ".EnumEntityUseAction");
            Method method = methodGetAction = packetClass == null || actionClass == null ? null : ReflectionUtil.getMethodNoArgs(packetClass, "c", actionClass);
            if (packetClass == null || actionClass == null || methodGetAction == null) {
                this.packetClass_legacy = null;
                this.enumClassAction_legacy = null;
                this.methodGetAction_legacy = null;
                this.methodName_legacy = null;
            } else {
                this.packetClass_legacy = packetClass;
                this.enumClassAction_legacy = actionClass;
                this.methodGetAction_legacy = methodGetAction;
                this.methodName_legacy = ReflectionUtil.getMethodNoArgs(this.enumClassAction_legacy, "name", String.class);
            }
            if (this.methodName_legacy == null) {
                throw new RuntimeException("Not supported.");
            }
        }

        String getActionFromNMSPacket(Object handle) {
            Class<?> clazz = handle.getClass();
            if (clazz != this.packetClass_legacy) {
                return null;
            }
            Object action = ReflectionUtil.invokeMethodNoArgs(this.methodGetAction_legacy, handle);
            if (action == null) {
                return null;
            }
            Object actionName = ReflectionUtil.invokeMethodNoArgs(this.methodName_legacy, action);
            if (actionName instanceof String) {
                return (String)actionName;
            }
            return null;
        }
    }
}

