/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.NetStatic;
import fr.neatmonster.nocheatplus.checks.net.PacketFrequency;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import java.util.LinkedHashSet;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CatchAllAdapter
extends BaseAdapter {
    private final PacketFrequency packetFrequency = new PacketFrequency();

    private static Iterable<? extends PacketType> getPacketTypes() {
        LinkedHashSet<PacketType> types = new LinkedHashSet<PacketType>();
        for (PacketType type : PacketType.Play.Client.getInstance().values()) {
            if (!type.isSupported()) continue;
            types.add(type);
        }
        return types;
    }

    public CatchAllAdapter(Plugin plugin) {
        super(plugin, ListenerPriority.LOWEST, CatchAllAdapter.getPacketTypes());
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.packetFrequency);
    }

    public void onPacketReceiving(PacketEvent event) {
        NetData data;
        NetConfig cc;
        Player player = event.getPlayer();
        if (player == null) {
            this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
            return;
        }
        try {
            cc = NetStatic.getWorldConfig(player, this.configFactory, this.dataFactory);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (cc.packetFrequencyActive && this.packetFrequency.isEnabled(player, data = this.dataFactory.getData(player), cc) && this.packetFrequency.check(player, data, cc)) {
            event.setCancelled(true);
        }
    }
}

