/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.checks.net.model.TeleportQueue;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.entity.Player;

public class NetData
extends ACheckData {
    private final Lock lock = new ReentrantLock();
    public ActionFrequency attackFrequencySeconds = new ActionFrequency(16, 500L);
    public final ActionFrequency flyingFrequencyAll;
    public boolean flyingFrequencyOnGround = false;
    public long flyingFrequencyTimeOnGround = 0L;
    public long flyingFrequencyTimeNotOnGround = 0L;
    public final ActionFrequency flyingFrequencyRedundantFreq;
    public ActionFrequency keepAliveFreq = new ActionFrequency(20, 1000L);
    public long lastKeepAliveTime = 0L;
    public final TeleportQueue teleportQueue = new TeleportQueue();
    private final LinkedList<DataPacketFlying> flyingQueue = new LinkedList();
    private final int flyingQueueMaxSize = 10;
    private long maxSequence = 0L;
    public final ActionFrequency packetFrequency;

    public NetData(NetConfig config) {
        super(config);
        this.flyingFrequencyAll = new ActionFrequency(config.flyingFrequencySeconds, 1000L);
        this.flyingFrequencyRedundantFreq = new ActionFrequency(config.flyingFrequencyRedundantSeconds, 1000L);
        this.packetFrequency = config.packetFrequencySeconds <= 2 ? new ActionFrequency(config.packetFrequencySeconds * 3, 333L) : new ActionFrequency(config.packetFrequencySeconds * 2, 500L);
    }

    public void onJoin(Player player) {
        this.teleportQueue.clear();
        this.clearFlyingQueue();
    }

    public void onLeave(Player player) {
        this.teleportQueue.clear();
        this.clearFlyingQueue();
    }

    public boolean addFlyingQueue(DataPacketFlying packetData) {
        boolean res = false;
        this.lock.lock();
        packetData.setSequence(++this.maxSequence);
        this.flyingQueue.addFirst(packetData);
        if (this.flyingQueue.size() > 10) {
            this.flyingQueue.removeLast();
            res = true;
        }
        this.lock.unlock();
        return res;
    }

    public void clearFlyingQueue() {
        this.lock.lock();
        this.flyingQueue.clear();
        this.lock.unlock();
    }

    public DataPacketFlying[] copyFlyingQueue() {
        this.lock.lock();
        DataPacketFlying[] out = this.flyingQueue.toArray(new DataPacketFlying[this.flyingQueue.size()]);
        this.lock.unlock();
        return out;
    }

    public DataPacketFlying peekFlyingQueue() {
        this.lock.lock();
        DataPacketFlying latest = this.flyingQueue.isEmpty() ? null : this.flyingQueue.getFirst();
        this.lock.unlock();
        return latest;
    }

    public void handleSystemTimeRanBackwards() {
        long now = System.currentTimeMillis();
        this.teleportQueue.clear();
        this.lastKeepAliveTime = Math.min(this.lastKeepAliveTime, now);
        this.flyingFrequencyTimeNotOnGround = Math.min(this.flyingFrequencyTimeNotOnGround, now);
        this.flyingFrequencyTimeOnGround = Math.min(this.flyingFrequencyTimeOnGround, now);
    }
}

