/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.velocity;

import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.UnusedTracker;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.Iterator;
import java.util.LinkedList;

public class SimpleAxisVelocity {
    private static final long FILTER_SPLIT = 6L;
    private static final long FILTER_POST_USE = 6L;
    private static final double marginAcceptZero = 0.005;
    private static final double thresholdCleanup = 10.0;
    private final LinkedList<SimpleEntry> queued = new LinkedList();
    private boolean unusedActive = true;
    private double unusedSensitivity = 0.1;
    public final UnusedTracker unusedTrackerPos = new UnusedTracker();
    public final UnusedTracker unusedTrackerNeg = new UnusedTracker();

    public void addToFront(SimpleEntry entry) {
        this.queued.addFirst(entry);
    }

    public void add(SimpleEntry entry) {
        this.queued.add(entry);
        if ((double)this.queued.size() > 10.0) {
            this.removeInvalid(TickTask.getTick());
        }
    }

    public boolean hasQueued() {
        return !this.queued.isEmpty();
    }

    public SimpleEntry use(double amount, double tolerance) {
        Iterator it = this.queued.iterator();
        SimpleEntry entry = null;
        while (it.hasNext()) {
            entry = (SimpleEntry)it.next();
            it.remove();
            if (this.matchesEntry(entry, amount, tolerance)) break;
            if (this.unusedActive) {
                this.addUnused(entry);
            }
            entry = null;
        }
        if (entry == null) {
            return null;
        }
        if ((entry.flags & 6L) != 0L) {
            return this.processFlagsPostUse(entry, amount);
        }
        return entry;
    }

    private SimpleEntry processFlagsPostUse(SimpleEntry entry, double amount) {
        if (this.allowsSplit(entry, amount)) {
            this.addToFront(new SimpleEntry(entry.tick, entry.value - amount, entry.flags, (entry.flags & 1L) == 0L ? entry.actCount : Math.max(entry.actCount, 2)));
        }
        return entry;
    }

    private final boolean allowsSplit(SimpleEntry entry, double amount) {
        if ((entry.flags & 6L) == 0L) {
            return false;
        }
        double remain = entry.value - amount;
        return (entry.flags & 2L) != 0L && remain > entry.value / 3.0 || (entry.flags & 4L) != 0L && remain > 0.42;
    }

    public SimpleEntry peek(double amount, int minActCount, int maxActCount, double tolerance) {
        for (SimpleEntry entry : this.queued) {
            if (entry.actCount < minActCount || entry.actCount > maxActCount || !this.matchesEntry(entry, amount, tolerance)) continue;
            return entry;
        }
        return null;
    }

    public boolean matchesEntry(SimpleEntry entry, double amount, double tolerance) {
        return Math.abs(amount) <= Math.abs(entry.value) + tolerance && (amount > 0.0 && entry.value > 0.0 && amount <= entry.value + tolerance || amount < 0.0 && entry.value < 0.0 && entry.value - tolerance <= amount || amount == 0.0 && Math.abs(entry.value) <= 0.005);
    }

    public void removeInvalid(int invalidateBeforeTick) {
        Iterator it = this.queued.iterator();
        while (it.hasNext()) {
            SimpleEntry entry = (SimpleEntry)it.next();
            --entry.actCount;
            if (entry.actCount > 0 && entry.tick >= invalidateBeforeTick) continue;
            it.remove();
            if (!this.unusedActive) continue;
            this.addUnused(entry);
        }
    }

    public void clear() {
        if (this.unusedActive && !this.queued.isEmpty()) {
            this.removeInvalid(TickTask.getTick());
        }
        this.queued.clear();
    }

    public void addQueued(StringBuilder builder) {
        for (SimpleEntry vel : this.queued) {
            builder.append(" ");
            builder.append(vel);
        }
    }

    public void updateBlockedState(int tick, boolean posBlocked, boolean negBlocked) {
        this.unusedTrackerPos.updateState(tick, posBlocked);
        this.unusedTrackerNeg.updateState(tick, negBlocked);
    }

    private void addUnused(SimpleEntry entry) {
        if (Math.abs(entry.value) < this.unusedSensitivity || entry.initialActCount < 5) {
            return;
        }
        if (entry.value < 0.0) {
            this.unusedTrackerNeg.addValue(entry.tick, -entry.value);
        } else {
            this.unusedTrackerPos.addValue(entry.tick, entry.value);
        }
    }

    public boolean isUnusedActive() {
        return this.unusedActive;
    }

    public void setUnusedActive(boolean unusedActive) {
        this.unusedActive = unusedActive;
    }
}

