/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.vehicle;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.location.setback.SetBackEntry;
import fr.neatmonster.nocheatplus.checks.moving.magic.MagicVehicle;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveInfo;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;

public class VehicleEnvelope
extends Check {
    private final List<String> tags = new LinkedList<String>();
    private final List<String> debugDetails = new LinkedList<String>();
    private final CheckDetails checkDetails = new CheckDetails();
    private final Class<?> bestHorse;

    public VehicleEnvelope() {
        super(CheckType.MOVING_VEHICLE_ENVELOPE);
        Class<?> clazz = ReflectionUtil.getClass("org.bukkit.entity.AbstractHorse");
        this.bestHorse = clazz == null ? ReflectionUtil.getClass("org.bukkit.entity.Horse") : clazz;
    }

    public SetBackEntry check(Player player, Entity vehicle, VehicleMoveData thisMove, boolean isFake, MovingData data, MovingConfig cc) {
        this.tags.clear();
        this.tags.add("entity." + vehicle.getType());
        if (data.debug) {
            this.debugDetails.clear();
            data.ws.setJustUsedIds(this.debugDetails);
        }
        boolean violation = this.checkEntity(player, vehicle, thisMove, isFake, data, cc);
        if (data.debug && !this.debugDetails.isEmpty()) {
            this.debugDetails(player);
            this.debugDetails.clear();
        }
        if (violation) {
            data.vehicleEnvelopeVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.vehicleEnvelopeVL, 1.0, cc.vehicleEnvelopeActions);
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            if (this.executeActions(vd).willCancel()) {
                return data.vehicleSetBacks.getValidSafeMediumEntry();
            }
        } else {
            data.vehicleEnvelopeVL *= 0.99;
        }
        return null;
    }

    private void debugDetails(Player player) {
        if (!this.tags.isEmpty()) {
            this.debugDetails.add("tags:");
            this.debugDetails.add(StringUtil.join(this.tags, "+"));
        }
        StringBuilder builder = new StringBuilder(500);
        builder.append("Details:\n");
        for (String detail : this.debugDetails) {
            builder.append(" , ");
            builder.append(detail);
        }
        this.debug(player, builder.toString());
        this.debugDetails.clear();
    }

    private double getHDistCap(EntityType type, MovingConfig cc) {
        Double v = cc.vehicleEnvelopeHorizontalSpeedCap.get(type);
        if (v == null) {
            return cc.vehicleEnvelopeHorizontalSpeedCap.get(null);
        }
        return v;
    }

    private boolean checkEntity(Player player, Entity vehicle, VehicleMoveData thisMove, boolean isFake, MovingData data, MovingConfig cc) {
        boolean violation = false;
        if (data.debug) {
            this.debugDetails.add("inair: " + data.sfJumpPhase);
        }
        if (this.maxDistHorizontal(thisMove, this.getHDistCap(this.checkDetails.simplifiedType, cc))) {
            return true;
        }
        if (thisMove.from.inWeb) {
            if (data.debug) {
                this.debugDetails.add("");
            }
        } else if (this.checkDetails.canClimb && thisMove.from.onClimbable) {
            this.checkDetails.checkDescendMuch = false;
            this.checkDetails.checkAscendMuch = false;
            if (Math.abs(thisMove.yDistance) > 0.1625) {
                violation = true;
                this.tags.add("climbspeed");
            }
        } else if (this.checkDetails.canRails && thisMove.fromOnRails) {
            if (Math.abs(thisMove.yDistance) < 0.5) {
                this.checkDetails.checkDescendMuch = false;
                this.checkDetails.checkAscendMuch = false;
            }
        } else if (thisMove.from.inWater && thisMove.to.inWater) {
            if (data.debug) {
                this.debugDetails.add("water-water");
            }
            if (MagicVehicle.oddInWater(thisMove, this.checkDetails, data)) {
                this.checkDetails.checkAscendMuch = false;
                this.checkDetails.checkDescendMuch = false;
                violation = false;
            }
        } else if (thisMove.from.onGround && thisMove.to.onGround) {
            if (this.checkDetails.canStepUpBlock && thisMove.yDistance > 0.0 && thisMove.yDistance <= 1.0) {
                this.checkDetails.checkAscendMuch = false;
                this.tags.add("step_up");
            }
            if (thisMove.from.onIce && thisMove.to.onIce) {
                if (data.debug) {
                    this.debugDetails.add("ice-ice");
                }
            } else if (data.debug) {
                this.debugDetails.add("ground-ground");
            }
        } else if (this.checkDetails.inAir) {
            if (this.checkInAir(thisMove, data)) {
                violation = true;
            }
        } else {
            if (data.debug) {
                this.debugDetails.add("?-?");
            }
            if (!this.checkDetails.toIsSafeMedium) {
                // empty if block
            }
        }
        if (this.checkDetails.checkAscendMuch && thisMove.yDistance > this.checkDetails.maxAscend) {
            this.tags.add("ascend_much");
            violation = true;
        }
        if (this.checkDetails.checkDescendMuch && thisMove.yDistance < -5.0) {
            this.tags.add("descend_much");
            violation = true;
        }
        if (!violation) {
            if (this.checkDetails.inAir) {
                ++data.sfJumpPhase;
            } else {
                if (this.checkDetails.toIsSafeMedium) {
                    data.vehicleSetBacks.setSafeMediumEntry(thisMove.to);
                    data.sfJumpPhase = 0;
                } else if (this.checkDetails.fromIsSafeMedium) {
                    data.vehicleSetBacks.setSafeMediumEntry(thisMove.from);
                    data.sfJumpPhase = 0;
                }
                data.ws.resetConditions("reset.notinair");
            }
            data.vehicleSetBacks.setLastMoveEntry(thisMove.to);
        }
        return violation;
    }

    protected void prepareCheckDetails(Entity vehicle, VehicleMoveInfo moveInfo, VehicleMoveData thisMove) {
        this.checkDetails.reset();
        this.checkDetails.fromIsSafeMedium = thisMove.from.inWater || thisMove.from.onGround || thisMove.from.inWeb;
        this.checkDetails.toIsSafeMedium = thisMove.to.inWater || thisMove.to.onGround || thisMove.to.inWeb;
        boolean bl = this.checkDetails.inAir = !this.checkDetails.fromIsSafeMedium && !this.checkDetails.toIsSafeMedium;
        if (vehicle instanceof Boat) {
            this.checkDetails.simplifiedType = EntityType.BOAT;
            this.checkDetails.maxAscend = 0.27;
        } else if (vehicle instanceof Minecart) {
            this.checkDetails.simplifiedType = EntityType.MINECART;
            this.checkDetails.canRails = true;
            thisMove.setExtraMinecartProperties(moveInfo);
            if (thisMove.fromOnRails) {
                this.checkDetails.fromIsSafeMedium = true;
                this.checkDetails.inAir = false;
            }
            if (thisMove.toOnRails) {
                this.checkDetails.toIsSafeMedium = true;
                this.checkDetails.inAir = false;
            }
            this.checkDetails.gravityTargetSpeed = 0.79;
        } else if (this.bestHorse != null && this.bestHorse.isAssignableFrom(vehicle.getClass())) {
            this.checkDetails.simplifiedType = EntityType.HORSE;
            this.checkDetails.canStepUpBlock = true;
            this.checkDetails.canJump = true;
        } else if (vehicle instanceof Pig) {
            this.checkDetails.simplifiedType = EntityType.PIG;
            this.checkDetails.canJump = false;
            this.checkDetails.canStepUpBlock = true;
            this.checkDetails.canClimb = true;
        } else {
            this.checkDetails.simplifiedType = thisMove.vehicleType;
        }
        if (this.checkDetails.canJump) {
            this.checkDetails.maxAscend = 1.0;
        }
        if (this.checkDetails.canClimb) {
            if (thisMove.from.onClimbable) {
                this.checkDetails.fromIsSafeMedium = true;
                this.checkDetails.inAir = false;
            }
            if (thisMove.to.onClimbable) {
                this.checkDetails.toIsSafeMedium = true;
                this.checkDetails.inAir = false;
            }
        }
    }

    private boolean checkInAir(VehicleMoveData thisMove, MovingData data) {
        if (data.debug) {
            this.debugDetails.add("air-air");
        }
        if (!this.checkDetails.canJump && thisMove.yDistance > 0.0) {
            this.tags.add("ascend_at_all");
            return true;
        }
        boolean violation = false;
        double minDescend = -(thisMove.yDistance < -0.5 ? 0.0052 : 0.0208) * (double)(this.checkDetails.canJump ? Math.max(data.sfJumpPhase - 8, 0) : data.sfJumpPhase);
        double maxDescend = this.getInAirMaxDescend(thisMove, data);
        if (data.sfJumpPhase > (this.checkDetails.canJump ? 8 : 1) && thisMove.yDistance > Math.max(minDescend, -this.checkDetails.gravityTargetSpeed)) {
            this.tags.add("slow_fall_vdist");
            violation = true;
        } else if (data.sfJumpPhase > 1 && thisMove.yDistance < maxDescend) {
            this.tags.add("fast_fall_vdist");
            violation = true;
        }
        if (violation) {
            if (MagicVehicle.oddInAir(thisMove, minDescend, maxDescend, this.checkDetails, data)) {
                violation = false;
                this.checkDetails.checkAscendMuch = false;
                this.checkDetails.checkDescendMuch = false;
            }
            if (data.debug) {
                this.debugDetails.add("maxDescend: " + maxDescend);
            }
        }
        return violation;
    }

    private double getInAirMaxDescend(PlayerMoveData thisMove, MovingData data) {
        double maxDescend = -0.07289999999999999 * (double)data.sfJumpPhase - 0.5;
        VehicleMoveData firstPastMove = data.vehicleMoves.getFirstPastMove();
        if (thisMove.yDistance < maxDescend && firstPastMove.toIsValid) {
            if (firstPastMove.yDistance < maxDescend && firstPastMove.yDistance > maxDescend * 2.5) {
                maxDescend = Math.min(maxDescend, firstPastMove.yDistance - 0.046849999999999996);
                this.debugDetails.add("desc_frict");
            } else if (firstPastMove.specialCondition && thisMove.yDistance > -1.5) {
                maxDescend = Math.min(maxDescend, -1.5);
                this.debugDetails.add("desc_special");
            }
        }
        return maxDescend;
    }

    private boolean maxDistHorizontal(VehicleMoveData thisMove, double maxDistanceHorizontal) {
        if (thisMove.hDistance > maxDistanceHorizontal) {
            this.tags.add("hdist");
            return true;
        }
        return false;
    }

    public class CheckDetails {
        public boolean canClimb;
        public boolean canRails;
        public boolean canJump;
        public boolean canStepUpBlock;
        public double maxAscend;
        public double gravityTargetSpeed;
        public EntityType simplifiedType;
        public boolean checkAscendMuch;
        public boolean checkDescendMuch;
        public boolean fromIsSafeMedium;
        public boolean toIsSafeMedium;
        public boolean inAir;

        public void reset() {
            this.canStepUpBlock = false;
            this.canJump = false;
            this.canRails = false;
            this.canClimb = false;
            this.maxAscend = 0.0;
            this.checkDescendMuch = true;
            this.checkAscendMuch = true;
            this.inAir = false;
            this.toIsSafeMedium = false;
            this.fromIsSafeMedium = false;
            this.simplifiedType = null;
            this.gravityTargetSpeed = 3.7;
        }
    }
}

