/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.vehicle;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.location.setback.SetBackEntry;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveConsistency;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.util.AuxMoving;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.checks.moving.vehicle.VehicleEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.vehicle.VehicleMorePackets;
import fr.neatmonster.nocheatplus.checks.moving.vehicle.VehicleSetBackTask;
import fr.neatmonster.nocheatplus.checks.moving.velocity.AccountEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessLastPositionAndLook;
import fr.neatmonster.nocheatplus.components.location.IGetLocationWithLook;
import fr.neatmonster.nocheatplus.components.location.SimplePositionWithLook;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.entity.PassengerUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.plugin.Plugin;

public class VehicleChecks
extends CheckListener {
    private final Plugin plugin = Bukkit.getPluginManager().getPlugin("NoCheatPlus");
    private final Set<EntityType> normalVehicles = new HashSet<EntityType>();
    private final Location useLoc1 = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLoc2 = new Location(null, 0.0, 0.0, 0.0);
    private final SimplePositionWithLook usePos1 = new SimplePositionWithLook();
    private final SimplePositionWithLook usePos2 = new SimplePositionWithLook();
    private final AuxMoving aux = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);
    private final PassengerUtil passengerUtil = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(PassengerUtil.class);
    private final IHandle<IEntityAccessLastPositionAndLook> lastPosLook = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IEntityAccessLastPositionAndLook.class);
    private final VehicleMorePackets vehicleMorePackets = this.addCheck(new VehicleMorePackets());
    private final VehicleEnvelope vehicleEnvelope = new VehicleEnvelope();

    public VehicleChecks() {
        super(CheckType.MOVING_VEHICLE);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (vehicle == null) {
            return;
        }
        if (vehicle.getVehicle() != null) {
            return;
        }
        Player player = this.passengerUtil.getFirstPlayerPassenger((Entity)vehicle);
        if (player == null) {
            return;
        }
        if (vehicle.isDead() || !vehicle.isValid()) {
            this.onPlayerVehicleLeave(player, (Entity)vehicle);
            return;
        }
        EntityType vehicleType = vehicle.getType();
        MovingData data = MovingData.getData(player);
        Location from = event.getFrom();
        Location to = event.getTo();
        if (data.debug) {
            this.outputDebugVehicleMoveEvent(player, from, to);
        }
        if (from == null) {
            return;
        }
        if (!from.equals((Object)to) && !from.getWorld().equals(to.getWorld())) {
            return;
        }
        if (this.normalVehicles.contains(vehicleType)) {
            return;
        }
        this.debug(player, "VehicleMoveEvent: legacy handling, potential issue.");
        this.checkVehicleMove((Entity)vehicle, vehicleType, from, to, player, false, data);
    }

    private void outputDebugVehicleMoveEvent(Player player, Location from, Location to) {
        if (from != null && from.equals((Object)to)) {
            this.debug(player, "VehicleMoveEvent: from=to: " + from);
        } else {
            this.debug(player, "VehicleMoveEvent: from: " + from + " , to: " + to);
        }
    }

    public Location onPlayerMoveVehicle(Player player, Location from, Location to, MovingData data) {
        Entity vehicle = this.passengerUtil.getLastNonPlayerVehicle((Entity)player);
        if (data.debug) {
            this.debug(player, "onPlayerMoveVehicle: vehicle: " + vehicle);
        }
        data.wasInVehicle = true;
        data.sfHoverTicks = -1;
        data.removeAllVelocity();
        data.sfLowJump = false;
        if (vehicle == null || vehicle.isDead() || !vehicle.isValid()) {
            this.onPlayerVehicleLeave(player, vehicle);
            return null;
        }
        EntityType vehicleType = vehicle.getType();
        if (!this.normalVehicles.contains(vehicleType)) {
            this.onVehicleUpdate(vehicle, vehicleType, player, true, data);
            return null;
        }
        Location vLoc = vehicle.getLocation();
        data.vehicleConsistency = MoveConsistency.getConsistency(from, to, vLoc);
        MovingConfig cc = MovingConfig.getConfig(player);
        if (data.vehicleConsistency == MoveConsistency.INCONSISTENT) {
            if (cc.vehicleEnforceLocation) {
                return vLoc;
            }
            return null;
        }
        this.aux.resetPositionsAndMediumProperties(player, vLoc, data, cc);
        return null;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void b(VehicleUpdateEvent event) {
        Vehicle vehicle = event.getVehicle();
        EntityType vehicleType = vehicle.getType();
        if (!this.normalVehicles.contains(vehicleType)) {
            this.normalVehicles.add(vehicleType);
            if (MovingConfig.getConfig((String)vehicle.getWorld().getName()).debug) {
                this.debug(null, "VehicleUpdateEvent fired for: " + vehicleType);
            }
        }
        if (vehicle.getVehicle() != null) {
            return;
        }
        Player player = this.passengerUtil.getFirstPlayerPassenger((Entity)vehicle);
        if (player == null || player.isDead()) {
            return;
        }
        if (vehicle.isDead() || !vehicle.isValid()) {
            this.onPlayerVehicleLeave(player, (Entity)vehicle);
            return;
        }
        MovingData data = MovingData.getData(player);
        if (data.debug) {
            Location loc = vehicle.getLocation(this.useLoc1);
            this.debug(player, "VehicleUpdateEvent: " + vehicleType + " " + loc);
            this.useLoc1.setWorld(null);
        }
        this.onVehicleUpdate((Entity)vehicle, vehicleType, player, false, data);
    }

    private void onVehicleUpdate(Entity vehicle, EntityType vehicleType, Player player, boolean fake, MovingData data) {
        if (data.debug && this.lastPosLook != null) {
            this.lastPosLook.getHandle().getPositionAndLook(vehicle, this.usePos1);
            this.debug(player, "Last position is reported as: " + LocUtil.simpleFormat(this.usePos1));
        }
        this.checkVehicleMove(vehicle, vehicleType, null, null, player, true, data);
    }

    private void checkVehicleMove(Entity vehicle, EntityType vehicleType, Location from, Location to, Player player, boolean fake, MovingData data) {
        MovingConfig cc = MovingConfig.getConfig(player);
        if (cc.ignoredVehicles.contains(vehicleType)) {
            data.clearVehicleData();
            return;
        }
        World world = vehicle.getWorld();
        VehicleMoveInfo moveInfo = this.aux.useVehicleMoveInfo();
        Location vehicleLocation = vehicle.getLocation(moveInfo.useLoc);
        VehicleMoveData firstPastMove = data.vehicleMoves.getFirstPastMove();
        if (!firstPastMove.valid) {
            Location refLoc = from == null ? vehicleLocation : from;
            MovingUtil.ensureChunksLoaded(player, refLoc, "vehicle move (no past move)", data, cc);
            this.aux.resetVehiclePositions(vehicle, refLoc, data, cc);
            if (data.debug) {
                this.debug(player, "Missing past move data, set to: " + firstPastMove.from);
            }
        }
        Location useFrom = LocUtil.set(this.useLoc1, world, firstPastMove.toIsValid ? firstPastMove.to : firstPastMove.from);
        Location useTo = vehicleLocation;
        if (vehicleType == EntityType.PIG) {
            moveInfo.setExtendFullWidth(0.52);
        }
        moveInfo.set(vehicle, useFrom, useTo, vehicleType == EntityType.PIG ? Math.max(0.13, cc.yOnGround) : cc.yOnGround);
        moveInfo.setExtendFullWidth(0.0);
        if (this.checkIllegal(moveInfo.from, moveInfo.to)) {
            SetBackEntry newTo = data.vehicleSetBacks.getValidSafeMediumEntry();
            if (newTo == null) {
                this.recoverVehicleSetBack(player, vehicle, vehicleLocation, moveInfo, data, cc);
            }
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING_VEHICLE) + "Illegal coordinates on checkVehicleMove: from: " + from + " , to: " + to);
            this.setBack(player, vehicle, newTo, data, cc);
            this.aux.returnVehicleMoveInfo(moveInfo);
            return;
        }
        MovingUtil.ensureChunksLoaded(player, useFrom, useTo, firstPastMove, "vehicle move", data, cc);
        VehicleMoveData thisMove = data.vehicleMoves.getCurrentMove();
        thisMove.set(moveInfo.from, moveInfo.to);
        MovingUtil.prepareFullCheck(moveInfo.from, moveInfo.to, thisMove, cc.yOnGround);
        thisMove.setExtraVehicleProperties(vehicle);
        this.checkVehicleMove(vehicle, vehicleType, vehicleLocation, world, moveInfo, thisMove, firstPastMove, player, fake, data, cc);
        this.aux.returnVehicleMoveInfo(moveInfo);
    }

    private void recoverVehicleSetBack(Player player, Entity vehicle, Location vehicleLocation, VehicleMoveInfo moveInfo, MovingData data, MovingConfig cc) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, this.checkType) + "Illegal coordinates on vehicle moving: world: " + moveInfo.from.getWorldName() + " , from: " + LocUtil.simpleFormat(moveInfo.from) + " , to: " + LocUtil.simpleFormat(moveInfo.to));
        if (moveInfo.from.hasIllegalCoords()) {
            if (LocUtil.isBadCoordinate(vehicleLocation.getX(), vehicleLocation.getY(), vehicleLocation.getZ())) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, this.checkType) + "Could not recover vehicle coordinates. Player will be kicked.");
                player.kickPlayer(cc.msgKickIllegalVehicleMove);
            } else {
                data.vehicleSetBacks.setDefaultEntry(vehicleLocation);
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, this.checkType) + "Using the current vehicle location for set back, due to not having a past location to rely on. This could be a bug.");
            }
        } else {
            data.vehicleSetBacks.setDefaultEntry(moveInfo.from);
        }
    }

    private boolean checkIllegal(RichBoundsLocation from, RichBoundsLocation to) {
        return from.hasIllegalCoords() || to.hasIllegalCoords();
    }

    private void checkVehicleMove(Entity vehicle, EntityType vehicleType, Location vehicleLocation, World world, VehicleMoveInfo moveInfo, VehicleMoveData thisMove, VehicleMoveData firstPastMove, Player player, boolean fake, MovingData data, MovingConfig cc) {
        SetBackEntry tempNewTo;
        data.joinOrRespawn = false;
        data.vehicleConsistency = MoveConsistency.getConsistency(thisMove, player.getLocation(this.useLoc1));
        switch (data.vehicleConsistency) {
            case FROM: 
            case TO: {
                this.aux.resetPositionsAndMediumProperties(player, player.getLocation(this.useLoc1), data, cc);
                break;
            }
        }
        SetBackEntry newTo = null;
        data.sfNoLowJump = true;
        if (cc.noFallVehicleReset) {
            data.noFallSkipAirCheck = true;
            data.sfLowJump = false;
            data.clearNoFallData();
        }
        if (data.debug) {
            this.outputDebugVehicleMove(player, vehicle, thisMove, fake);
        }
        if (!data.vehicleSetBacks.isDefaultEntryValid()) {
            this.ensureSetBack(player, thisMove, data);
        }
        if ((newTo == null || data.vehicleSetBacks.getSafeMediumEntry().isValidAndOlderThan(newTo)) && this.vehicleEnvelope.isEnabled(player, data, cc)) {
            if (data.timeSinceSetBack == 0 || thisMove.to.hashCode() == data.lastSetBackHash) {
                thisMove.specialCondition = true;
                if (data.debug) {
                    this.debug(player, "Skip envelope check on first move after set back acknowledging the set back with an odd starting point (from).");
                }
            } else {
                this.vehicleEnvelope.prepareCheckDetails(vehicle, moveInfo, thisMove);
                tempNewTo = this.vehicleEnvelope.check(player, vehicle, thisMove, fake, data, cc);
                if (tempNewTo != null) {
                    newTo = tempNewTo;
                }
            }
        }
        if (newTo == null || data.vehicleSetBacks.getMidTermEntry().isValidAndOlderThan(newTo)) {
            if (this.vehicleMorePackets.isEnabled(player, data, cc)) {
                tempNewTo = this.vehicleMorePackets.check(player, thisMove, newTo, data, cc);
                if (tempNewTo != null) {
                    newTo = tempNewTo;
                }
            } else {
                data.clearVehicleMorePacketsData();
            }
        }
        if (newTo == null) {
            List<Entity> passengers = this.passengerUtil.handleVehicle.getHandle().getEntityPassengers(vehicle);
            if (passengers.size() > 1) {
                this.updateVehicleData(player, data, vehicle, moveInfo, passengers);
            }
            ++data.timeSinceSetBack;
            data.vehicleMoves.finishCurrentMove();
        } else {
            this.setBack(player, vehicle, newTo, data, cc);
        }
        this.useLoc1.setWorld(null);
    }

    private void updateVehicleData(Player player, MovingData data, Entity vehicle, VehicleMoveInfo moveInfo, List<Entity> passengers) {
        for (Entity passenger : passengers) {
            if (!(passenger instanceof Player) || player.equals(passenger)) continue;
            Player otherPlayer = (Player)passenger;
            MovingData otherData = MovingData.getData(otherPlayer);
            otherData.resetVehiclePositions(moveInfo.to);
            otherData.vehicleSetBacks.resetAllLazily(data.vehicleSetBacks.getOldestValidEntry());
            otherData.wasInVehicle = true;
            otherData.vehicleMoves.invalidate();
        }
    }

    private void ensureSetBack(Player player, VehicleMoveData thisMove, MovingData data) {
        IGetLocationWithLook ensureLoc = !data.vehicleSetBacks.isAnyEntryValid() ? thisMove.from : data.vehicleSetBacks.getOldestValidEntry();
        data.vehicleSetBacks.setDefaultEntry(ensureLoc);
        if (data.debug) {
            this.debug(player, "Ensure vehicle set back: " + ensureLoc);
        }
    }

    private void setBack(Player player, Entity vehicle, SetBackEntry newTo, MovingData data, MovingConfig cc) {
        if (data.vehicleSetBackTaskId == -1) {
            boolean scheduleSetBack;
            if (data.debug) {
                this.debug(player, "Will set back to: " + newTo);
            }
            if (scheduleSetBack = cc.scheduleVehicleSetBacks) {
                this.aux.resetVehiclePositions(vehicle, LocUtil.set(this.useLoc2, vehicle.getWorld(), newTo), data, cc);
                data.vehicleSetBackTaskId = Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, (Runnable)new VehicleSetBackTask(vehicle, player, newTo.getLocation(vehicle.getWorld()), data.debug, new Entity[0]));
                if (data.vehicleSetBackTaskId == -1) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "Failed to schedule vehicle set back task. Player: " + player.getName() + " , set back: " + newTo);
                    scheduleSetBack = false;
                } else if (data.debug) {
                    this.debug(player, "Vehicle set back task id: " + data.vehicleSetBackTaskId);
                }
            }
            if (!scheduleSetBack) {
                if (data.debug) {
                    this.debug(player, "Attempt to set the player back directly.");
                }
                this.passengerUtil.teleportWithPassengers(vehicle, player, newTo.getLocation(vehicle.getWorld()), data.debug);
            }
        } else if (data.debug) {
            data.vehicleMoves.invalidate();
            this.debug(player, "Vehicle set back task already scheduled, skip this time.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerVehicleEnter(VehicleEnterEvent event) {
        Entity entity = event.getEntered();
        if (entity instanceof Player && this.onPlayerVehicleEnter((Player)entity, (Entity)event.getVehicle())) {
            event.setCancelled(true);
        }
    }

    public boolean onPlayerVehicleEnter(Player player, Entity vehicle) {
        Entity lastVehicle;
        MovingData data = MovingData.getData(player);
        if (!data.isVehicleSetBack && MovingUtil.hasScheduledPlayerSetBack(player.getUniqueId(), data)) {
            if (data.debug) {
                this.debug(player, "Vehicle enter: prevent, due to a scheduled set back.");
            }
            return true;
        }
        if (data.debug) {
            this.debug(player, "Vehicle enter: first vehicle: " + vehicle.getClass().getName());
        }
        if ((lastVehicle = this.passengerUtil.getLastNonPlayerVehicle(vehicle, true)) == null) {
            data.clearVehicleData();
            if (data.debug) {
                this.debugNestedVehicleEnter(player);
            }
            return false;
        }
        if (!lastVehicle.equals(vehicle)) {
            if (data.debug) {
                this.debug(player, "Vehicle enter: last of nested vehicles: " + lastVehicle.getClass().getName());
            }
            this.dataOnVehicleEnter(player, lastVehicle, data);
        } else {
            this.dataOnVehicleEnter(player, vehicle, data);
        }
        return false;
    }

    private void debugNestedVehicleEnter(Player player) {
        this.debug(player, "Vehicle enter: Skip on nested vehicles, possibly with multiple players involved, who would do that?");
        LinkedList<String> vehicles = new LinkedList<String>();
        for (Entity tempVehicle = player.getVehicle(); tempVehicle != null; tempVehicle = tempVehicle.getVehicle()) {
            vehicles.add(tempVehicle.getType().toString());
        }
        if (!vehicles.isEmpty()) {
            this.debug(player, "Vehicle enter: Nested vehicles: " + StringUtil.join(vehicles, ", "));
        }
    }

    private void dataOnVehicleEnter(Player player, Entity vehicle, MovingData data) {
        MovingConfig cc = MovingConfig.getConfig(player);
        data.joinOrRespawn = false;
        data.removeAllVelocity();
        Location vLoc = vehicle.getLocation(this.useLoc1);
        data.vehicleConsistency = MoveConsistency.getConsistency(vLoc, null, player.getLocation(this.useLoc2));
        if (!data.isVehicleSetBack) {
            data.vehicleSetBacks.resetAll(vLoc);
        }
        this.aux.resetVehiclePositions(vehicle, vLoc, data, cc);
        if (data.debug) {
            this.debug(player, "Vehicle enter: " + vehicle.getType() + " , player: " + this.useLoc2 + " c=" + (Object)((Object)data.vehicleConsistency));
        }
        this.useLoc1.setWorld(null);
        this.useLoc2.setWorld(null);
    }

    public void onVehicleLeaveMiss(Player player, MovingData data, MovingConfig cc) {
        if (data.debug) {
            StaticLog.logWarning("VehicleExitEvent missing for: " + player.getName());
        }
        this.onPlayerVehicleLeave(player, null);
        data.noFallSkipAirCheck = true;
        data.sfLowJump = false;
        data.clearNoFallData();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleExit(VehicleExitEvent event) {
        LivingEntity entity = event.getExited();
        if (!(entity instanceof Player)) {
            return;
        }
        this.onPlayerVehicleLeave((Player)entity, (Entity)event.getVehicle());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVehicleDestroyLowest(VehicleDestroyEvent event) {
        Entity attacker = event.getAttacker();
        if (attacker instanceof Player && this.passengerUtil.isPassenger(attacker, (Entity)event.getVehicle())) {
            Player player = (Player)attacker;
            MovingData data = MovingData.getData(player);
            MovingConfig cc = MovingConfig.getConfig(player);
            if (cc.vehiclePreventDestroyOwn) {
                if (CheckUtils.isEnabled(CheckType.MOVING_SURVIVALFLY, player, data, cc) || CheckUtils.isEnabled(CheckType.MOVING_CREATIVEFLY, player, data, cc)) {
                    // empty if block
                }
                event.setCancelled(true);
                player.sendMessage(ChatColor.DARK_RED + "Destroying your own vehicle is disabled.");
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        for (Entity entity : this.passengerUtil.handleVehicle.getHandle().getEntityPassengers((Entity)event.getVehicle())) {
            if (!(entity instanceof Player)) continue;
            this.onPlayerVehicleLeave((Player)entity, (Entity)event.getVehicle());
        }
    }

    private void onPlayerVehicleLeave(Player player, Entity vehicle) {
        Location pLoc;
        MovingData data = MovingData.getData(player);
        data.wasInVehicle = false;
        data.joinOrRespawn = false;
        MovingConfig cc = MovingConfig.getConfig(player);
        Location loc = pLoc = player.getLocation(this.useLoc1);
        if (vehicle != null) {
            Location vLoc = vehicle.getLocation(this.useLoc2);
            if (!this.normalVehicles.contains(vehicle.getType()) || cc.noFallVehicleReset) {
                data.noFallSkipAirCheck = true;
                data.clearNoFallData();
            }
            if (MoveConsistency.getConsistency(vLoc, null, pLoc) == MoveConsistency.INCONSISTENT) {
                loc = vLoc;
                if (data.vehicleConsistency != MoveConsistency.INCONSISTENT) {
                    Location oldLoc;
                    PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
                    if (lastMove.toIsValid && MoveConsistency.getConsistency(oldLoc = new Location(pLoc.getWorld(), lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ()), null, pLoc) != MoveConsistency.INCONSISTENT) {
                        loc = oldLoc;
                    }
                }
            }
            if (data.debug) {
                this.debug(player, "Vehicle leave: " + vehicle.getType() + "@" + pLoc.distance(vLoc));
            }
        }
        if (BlockProperties.isLiquid(loc.getBlock().getType())) {
            loc.setY((double)Location.locToBlock((double)loc.getY()) + 1.25);
        }
        if (data.debug) {
            this.debug(player, "Vehicle leave: " + pLoc.toString() + (pLoc.equals((Object)loc) ? "" : " / player at: " + pLoc.toString()));
        }
        this.aux.resetPositionsAndMediumProperties(player, loc, data, cc);
        data.setSetBack(loc);
        data.removeAllVelocity();
        data.addHorizontalVelocity(new AccountEntry(0.9, 1, 1));
        data.addVerticalVelocity(new SimpleEntry(0.6, 1));
        this.useLoc1.setWorld(null);
        this.useLoc2.setWorld(null);
    }

    private void outputDebugVehicleMove(Player player, Entity vehicle, VehicleMoveData thisMove, boolean fake) {
        StringBuilder builder = new StringBuilder(250);
        Location vLoc = vehicle.getLocation();
        Location loc = player.getLocation();
        Entity actualVehicle = player.getVehicle();
        boolean wrongVehicle = actualVehicle == null || actualVehicle.getEntityId() != vehicle.getEntityId();
        builder.append(CheckUtils.getLogMessagePrefix(player, this.checkType));
        builder.append("VEHICLE MOVE " + (fake ? "(fake)" : "") + " in world " + thisMove.from.getWorldName() + ":");
        builder.append("\nFrom: ");
        builder.append(LocUtil.simpleFormat(thisMove.from));
        builder.append("\nTo: ");
        builder.append(LocUtil.simpleFormat(thisMove.to));
        builder.append("\n" + (thisMove.from.resetCond ? "resetcond" : (thisMove.from.onGround ? "ground" : "---")) + " -> " + (thisMove.to.resetCond ? "resetcond" : (thisMove.to.onGround ? "ground" : "---")));
        builder.append("\n Vehicle: ");
        builder.append(LocUtil.simpleFormat(vLoc));
        builder.append("\n Player: ");
        builder.append(LocUtil.simpleFormat(loc));
        builder.append("\n Vehicle type: " + vehicle.getType() + (wrongVehicle ? (actualVehicle == null ? " (exited?)" : " actual: " + actualVehicle.getType()) : ""));
        builder.append("\n hdist: " + thisMove.hDistance);
        builder.append(" vdist: " + thisMove.yDistance);
        builder.append(" fake: " + fake);
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
    }
}

