/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.LocationData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class NoFall
extends Check {
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public NoFall() {
        super(CheckType.MOVING_NOFALL);
    }

    public static final double getDamage(float fallDistance) {
        return (double)fallDistance - 3.0;
    }

    private void handleOnGround(Player player, double y, boolean reallyOnGround, MovingData data, MovingConfig cc) {
        double maxD = this.estimateDamage(player, y, data);
        if (maxD >= 1.0) {
            if (cc.noFallSkipAllowFlight && player.getAllowFlight()) {
                data.clearNoFallData();
                data.noFallSkipAirCheck = true;
            } else {
                if (data.debug) {
                    this.debug(player, "NoFall deal damage" + (reallyOnGround ? "" : "violation") + ": " + maxD);
                }
                data.noFallSkipAirCheck = true;
                this.dealFallDamage(player, maxD);
            }
        } else {
            data.clearNoFallData();
            player.setFallDistance(0.0f);
        }
    }

    public double estimateDamage(Player player, double y, MovingData data) {
        return NoFall.getDamage(Math.max((float)(data.noFallMaxY - y), data.noFallFallDistance));
    }

    private void adjustFallDistance(Player player, double minY, boolean reallyOnGround, MovingData data, MovingConfig cc) {
        float fallDistance;
        float noFallFallDistance = Math.max(data.noFallFallDistance, (float)(data.noFallMaxY - minY));
        if ((double)noFallFallDistance >= 3.0 && (noFallFallDistance - (fallDistance = player.getFallDistance()) >= 0.5f || (double)noFallFallDistance >= 3.0 && (double)fallDistance < 3.0)) {
            player.setFallDistance(noFallFallDistance);
        }
        data.clearNoFallData();
    }

    private void dealFallDamage(Player player, double damage) {
        if (((MCAccess)this.mcAccess.getHandle()).dealFallDamageFiresAnEvent().decide()) {
            ((MCAccess)this.mcAccess.getHandle()).dealFallDamage(player, damage);
        } else {
            EntityDamageEvent event = BridgeHealth.getEntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.FALL, damage);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                player.setLastDamageCause(event);
                ((MCAccess)this.mcAccess.getHandle()).dealFallDamage(player, BridgeHealth.getDamage(event));
            }
        }
        player.setFallDistance(0.0f);
    }

    public void check(Player player, PlayerLocation pFrom, PlayerLocation pTo, MovingData data, MovingConfig cc) {
        double max;
        boolean toOnGround;
        boolean fromOnGround;
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        LocationData from = thisMove.from;
        LocationData to = thisMove.to;
        double fromY = from.getY();
        double toY = to.getY();
        double yDiff = toY - fromY;
        double oldNFDist = data.noFallFallDistance;
        boolean fromReset = from.resetCond;
        boolean toReset = to.resetCond;
        if (yDiff < 0.0 && cc.yOnGround < cc.noFallyOnGround) {
            this.adjustYonGround(pFrom, pTo, cc.noFallyOnGround);
            fromOnGround = pFrom.isOnGround();
            toOnGround = pTo.isOnGround();
        } else {
            fromOnGround = from.onGround;
            toOnGround = to.onGround;
        }
        double minY = Math.min(fromY, toY);
        if (fromReset) {
            data.clearNoFallData();
            if (toY - fromY <= -3.0) {
                data.noFallSkipAirCheck = true;
            }
        } else if (fromOnGround || !toOnGround && thisMove.touchedGround) {
            this.touchDown(player, minY, data, cc);
            if (toY - fromY <= -3.0) {
                data.noFallSkipAirCheck = true;
            }
        } else if (toReset) {
            data.clearNoFallData();
        } else if (toOnGround) {
            if (yDiff < 0.0) {
                data.noFallFallDistance = (float)((double)data.noFallFallDistance - yDiff);
            }
            this.touchDown(player, minY, data, cc);
        }
        data.noFallMaxY = Math.max(Math.max(fromY, toY), data.noFallMaxY);
        float mcFallDistance = player.getFallDistance();
        if (!toReset && !toOnGround && yDiff < 0.0) {
            data.noFallFallDistance = (float)((double)data.noFallFallDistance - yDiff);
        } else if (cc.noFallAntiCriticals && (toReset || toOnGround || (fromReset || fromOnGround || thisMove.touchedGround) && yDiff >= 0.0) && (max = (double)Math.max(data.noFallFallDistance, mcFallDistance)) > 0.0 && max < 0.75) {
            if (data.debug) {
                this.debug(player, "NoFall: Reset fall distance (anticriticals): mc=" + mcFallDistance + " / nf=" + data.noFallFallDistance);
            }
            if (data.noFallFallDistance > 0.0f) {
                data.noFallFallDistance = 0.0f;
            }
            if (mcFallDistance > 0.0f) {
                player.setFallDistance(0.0f);
            }
        }
        if (data.debug) {
            this.debug(player, "NoFall: mc=" + mcFallDistance + " / nf=" + data.noFallFallDistance + (oldNFDist < (double)data.noFallFallDistance ? " (+" + ((double)data.noFallFallDistance - oldNFDist) + ")" : "") + " | ymax=" + data.noFallMaxY);
        }
    }

    private void touchDown(Player player, double minY, MovingData data, MovingConfig cc) {
        if (cc.noFallDealDamage) {
            this.handleOnGround(player, minY, true, data, cc);
        } else {
            this.adjustFallDistance(player, minY, true, data, cc);
        }
    }

    private void adjustYonGround(PlayerLocation from, PlayerLocation to, double yOnGround) {
        if (!from.isOnGround()) {
            from.setyOnGround(yOnGround);
        }
        if (!to.isOnGround()) {
            to.setyOnGround(yOnGround);
        }
    }

    public void onLeave(Player player) {
        MovingData data = MovingData.getData(player);
        float fallDistance = player.getFallDistance();
        if (data.noFallFallDistance > fallDistance) {
            double playerY = player.getLocation(this.useLoc).getY();
            this.useLoc.setWorld(null);
            if (player.isFlying() || player.getGameMode() == GameMode.CREATIVE || player.getAllowFlight() && MovingConfig.getConfig((Player)player).noFallSkipAllowFlight) {
                player.setFallDistance(0.0f);
                data.noFallFallDistance = 0.0f;
                data.noFallMaxY = playerY;
            } else {
                float yDiff = (float)(data.noFallMaxY - playerY);
                float maxDist = Math.max(yDiff, data.noFallFallDistance);
                player.setFallDistance(maxDist);
            }
        }
    }

    public void checkDamage(Player player, MovingData data, double y) {
        MovingConfig cc = MovingConfig.getConfig(player);
        this.handleOnGround(player, y, false, data, cc);
    }

    public boolean isEnabled(Player player, MovingConfig cc) {
        return cc.noFallCheck && !NCPExemptionManager.isExempted(player, CheckType.MOVING_NOFALL, true) && !player.hasPermission("nocheatplus.checks.moving.nofall");
    }
}

