/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.combined.BedLeave;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.magic.Magic;
import fr.neatmonster.nocheatplus.checks.moving.model.ModelFlying;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.player.CreativeFly;
import fr.neatmonster.nocheatplus.checks.moving.player.MorePackets;
import fr.neatmonster.nocheatplus.checks.moving.player.NoFall;
import fr.neatmonster.nocheatplus.checks.moving.player.Passable;
import fr.neatmonster.nocheatplus.checks.moving.player.PlayerSetBackMethod;
import fr.neatmonster.nocheatplus.checks.moving.player.SurvivalFly;
import fr.neatmonster.nocheatplus.checks.moving.util.AuxMoving;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.checks.moving.vehicle.VehicleChecks;
import fr.neatmonster.nocheatplus.checks.moving.velocity.AccountEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessDimensions;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.location.IGetPositionWithLook;
import fr.neatmonster.nocheatplus.components.location.SimplePositionWithLook;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.feature.IHaveCheckType;
import fr.neatmonster.nocheatplus.components.registry.feature.INeedConfig;
import fr.neatmonster.nocheatplus.components.registry.feature.IRemoveData;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.registry.feature.TickListener;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.logging.debug.DebugUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class MovingListener
extends CheckListener
implements TickListener,
IRemoveData,
IHaveCheckType,
INeedConfig,
JoinLeaveListener {
    private static final long FLAGS_VELOCITY_BOUNCE_BLOCK = 512L;
    private static final long FLAGS_VELOCITY_BOUNCE_BLOCK_MOVE_ASCEND = 773L;
    public final NoFall noFall = this.addCheck(new NoFall());
    private final CreativeFly creativeFly = this.addCheck(new CreativeFly());
    private final MorePackets morePackets = this.addCheck(new MorePackets());
    private final VehicleChecks vehicleChecks = new VehicleChecks();
    private final SurvivalFly survivalFly = this.addCheck(new SurvivalFly());
    private final Passable passable = this.addCheck(new Passable());
    private final BedLeave bedLeave = this.addCheck(new BedLeave());
    private final Map<String, PlayerMoveEvent> processingEvents = new HashMap<String, PlayerMoveEvent>();
    private final Set<String> hoverTicks = new LinkedHashSet<String>(30);
    private final Set<String> playersEnforce = new LinkedHashSet<String>(30);
    private int hoverTicksStep = 5;
    final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final AuxMoving aux = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);
    private IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);
    private final BlockChangeTracker blockChangeTracker;
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idMoveEvent = this.counters.registerKey("event.player.move");

    public MovingListener() {
        super(CheckType.MOVING);
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.vehicleChecks);
        this.blockChangeTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();
        if (Bridge1_9.hasEntityToggleGlideEvent()) {
            this.queuedComponents.add(new Listener(){

                @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
                public void onEntityToggleGlide(EntityToggleGlideEvent event) {
                    if (MovingListener.this.handleEntityToggleGlideEvent(event.getEntity(), event.isGliding())) {
                        event.setCancelled(true);
                    }
                }
            });
        }
    }

    private boolean handleEntityToggleGlideEvent(Entity entity, boolean isGliding) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (isGliding && !Bridge1_9.isGlidingWithElytra(player)) {
            PlayerMoveInfo info = this.aux.usePlayerMoveInfo();
            info.set(player, player.getLocation(info.useLoc), null, 0.001);
            MovingData data = MovingData.getData(player);
            boolean res = !MovingUtil.canLiftOffWithElytra(player, (PlayerLocation)info.from, data);
            info.cleanup();
            this.aux.returnPlayerMoveInfo(info);
            if (res && data.debug) {
                this.debug(player, "Prevent toggle glide on.");
            }
            return res;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        CombinedData.getData((Player)event.getPlayer()).wasInBed = true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        if (this.bedLeave.isEnabled(player) && this.bedLeave.checkBed(player)) {
            MovingConfig cc = MovingConfig.getConfig(player);
            Location loc = player.getLocation(this.useLoc);
            MovingData data = MovingData.getData(player);
            Location target = null;
            PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
            moveInfo.set(player, loc, null, cc.yOnGround);
            boolean sfCheck = MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, data, cc);
            this.aux.returnPlayerMoveInfo(moveInfo);
            if (sfCheck) {
                target = data.getSetBack(loc);
            }
            if (target == null) {
                target = LocUtil.clone(loc);
            }
            if (sfCheck && cc.sfSetBackPolicyFallDamage && this.noFall.isEnabled(player, cc)) {
                double y = loc.getY();
                if (data.hasSetBack()) {
                    y = Math.min(y, data.getSetBackY());
                }
                this.noFall.checkDamage(player, data, y);
            }
            this.useLoc.setWorld(null);
            data.prepareSetBack(target);
            player.teleport(target, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
        } else {
            CombinedData.getData((Player)player).wasInBed = false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        MovingConfig cc = MovingConfig.getConfig(player);
        data.clearMostMovingCheckData();
        Location loc = player.getLocation(this.useLoc);
        data.setSetBack(loc);
        if (cc.loadChunksOnWorldChange) {
            MovingUtil.ensureChunksLoaded(player, loc, "world change", data, cc);
        }
        this.aux.resetPositionsAndMediumProperties(player, loc, data, cc);
        data.resetTrace(player, loc, TickTask.getTick(), (IEntityAccessDimensions)this.mcAccess.getHandle(), cc);
        if (cc.enforceLocation) {
            this.playersEnforce.add(player.getName());
        }
        this.useLoc.setWorld(null);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE || event.getNewGameMode() == GameMode.CREATIVE) {
            MovingData data = MovingData.getData(event.getPlayer());
            data.clearFlyData();
            data.clearPlayerMorePacketsData();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        String token;
        boolean earlyReturn;
        this.counters.add(this.idMoveEvent, 1);
        Player player = event.getPlayer();
        this.processingEvents.put(player.getName(), event);
        MovingConfig cc = MovingConfig.getConfig(player);
        MovingData data = MovingData.getData(player);
        data.increasePlayerMoveCount();
        Location from = event.getFrom();
        Location to = event.getTo();
        Location newTo = null;
        if (player.isInsideVehicle()) {
            newTo = this.vehicleChecks.onPlayerMoveVehicle(player, from, to, data);
            earlyReturn = true;
            token = "vehicle";
        } else if (player.isDead()) {
            data.sfHoverTicks = -1;
            earlyReturn = true;
            token = "dead";
        } else if (player.isSleeping()) {
            data.sfHoverTicks = -1;
            earlyReturn = true;
            token = "sleeping";
        } else if (!from.getWorld().equals(to.getWorld())) {
            earlyReturn = true;
            token = "worldchange";
        } else if (data.hasTeleported()) {
            earlyReturn = this.handleTeleportedOnMove(player, event, data, cc);
            token = "awaitsetback";
        } else {
            earlyReturn = false;
            token = null;
        }
        if (earlyReturn) {
            if (data.debug) {
                this.debug(player, "Early return" + (token == null ? "" : " (" + token + ")") + " on PlayerMoveEvent: from: " + from + " , to: " + to);
            }
            if (newTo != null) {
                if (LocUtil.needsYawCorrection(newTo.getYaw())) {
                    newTo.setYaw(LocUtil.correctYaw(newTo.getYaw()));
                }
                if (LocUtil.needsPitchCorrection(newTo.getPitch())) {
                    newTo.setPitch(LocUtil.correctPitch(newTo.getPitch()));
                }
                this.prepareSetBack(player, event, newTo, data, cc);
            }
            data.joinOrRespawn = false;
            return;
        }
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        Location loc = player.getLocation(moveInfo.useLoc);
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (cc.loadChunksOnMove) {
            MovingUtil.ensureChunksLoaded(player, from, to, lastMove, "move", data, cc);
        }
        if (!cc.splitMoves || TrigUtil.isSamePos(from, loc) || lastMove.valid && TrigUtil.isSamePos(loc, lastMove.from.getX(), lastMove.from.getY(), lastMove.from.getZ())) {
            moveInfo.set(player, from, to, cc.yOnGround);
            this.checkPlayerMove(player, from, to, 0, moveInfo, data, cc, event);
        } else {
            if (data.debug) {
                this.debug(player, "Split move 1 (from -> loc):");
            }
            moveInfo.set(player, from, loc, cc.yOnGround);
            if (!this.checkPlayerMove(player, from, loc, 1, moveInfo, data, cc, event) && this.processingEvents.containsKey(player.getName())) {
                this.onMoveMonitorNotCancelled(player, from, loc, System.currentTimeMillis(), TickTask.getTick(), CombinedData.getData(player), data, cc);
                data.joinOrRespawn = false;
                if (data.debug) {
                    this.debug(player, "Split move 2 (loc -> to):");
                }
                moveInfo.set(player, loc, to, cc.yOnGround);
                this.checkPlayerMove(player, loc, to, 2, moveInfo, data, cc, event);
            }
        }
        data.joinOrRespawn = false;
        this.aux.returnPlayerMoveInfo(moveInfo);
    }

    private boolean handleTeleportedOnMove(Player player, PlayerMoveEvent event, MovingData data, MovingConfig cc) {
        if (data.isTeleportedPosition(event.getFrom())) {
            this.confirmSetBack(player, false, data, cc);
            if (data.debug) {
                this.debug(player, "Implicitly confirm set back with the start point of a move.");
            }
            return false;
        }
        if (DataManager.getPlayerData(player).isPlayerSetBackScheduled()) {
            event.setCancelled(true);
            if (data.debug) {
                this.debug(player, "Cancel move, due to a scheduled teleport (set back).");
            }
            return true;
        }
        if (data.debug) {
            this.debug(player, "Invalidate left-over teleported (set back) location: " + data.getTeleported());
        }
        data.resetTeleported();
        return false;
    }

    private boolean checkPlayerMove(Player player, Location from, Location to, int multiMoveCount, PlayerMoveInfo moveInfo, MovingData data, MovingConfig cc, PlayerMoveEvent event) {
        boolean useBlockChangeTracker;
        boolean checkSf;
        boolean checkCf;
        Location newTo = null;
        data.resetTeleported();
        if (data.debug) {
            this.outputMoveDebug(player, (PlayerLocation)moveInfo.from, (PlayerLocation)moveInfo.to, Math.max(cc.noFallyOnGround, cc.yOnGround), (MCAccess)this.mcAccess.getHandle());
        }
        if (((PlayerLocation)moveInfo.from).hasIllegalCoords() || ((PlayerLocation)moveInfo.to).hasIllegalCoords() || !cc.ignoreStance && (((PlayerLocation)moveInfo.from).hasIllegalStance() || ((PlayerLocation)moveInfo.to).hasIllegalStance())) {
            MovingUtil.handleIllegalMove(event, player, data, cc);
            return true;
        }
        String playerName = player.getName();
        if (cc.enforceLocation && this.playersEnforce.contains(playerName)) {
            newTo = this.enforceLocation(player, from, data);
            this.playersEnforce.remove(playerName);
        }
        long time = System.currentTimeMillis();
        if (player.isSprinting() || cc.assumeSprint) {
            if (player.getFoodLevel() > 5 || player.getAllowFlight() || player.isFlying()) {
                data.timeSprinting = time;
                data.multSprinting = this.attributeAccess.getHandle().getSprintAttributeMultiplier(player);
                if (data.multSprinting == Double.MAX_VALUE) {
                    data.multSprinting = 1.30000002;
                } else if (cc.assumeSprint && data.multSprinting == 1.0) {
                    data.multSprinting = 1.30000002;
                }
            } else if (time < data.timeSprinting) {
                data.timeSprinting = 0L;
            }
        } else if (time < data.timeSprinting) {
            data.timeSprinting = 0L;
        }
        PlayerLocation pFrom = (PlayerLocation)moveInfo.from;
        PlayerLocation pTo = (PlayerLocation)moveInfo.to;
        if (data.wasInVehicle) {
            this.vehicleChecks.onVehicleLeaveMiss(player, data, cc);
        }
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        thisMove.set(pFrom, pTo);
        if (multiMoveCount > 0) {
            thisMove.multiMoveCount = multiMoveCount;
        }
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        double jumpAmplifier = this.aux.getJumpAmplifier(player);
        if (jumpAmplifier > data.jumpAmplifier) {
            data.jumpAmplifier = jumpAmplifier;
        }
        int tick = TickTask.getTick();
        data.velocityTick(tick - cc.velocityActivationTicks);
        if (MovingUtil.shouldCheckSurvivalFly(player, pFrom, data, cc)) {
            checkCf = false;
            checkSf = true;
            data.adjustWalkSpeed(player.getWalkSpeed(), tick, cc.speedGrace);
        } else if (cc.creativeFlyCheck && !NCPExemptionManager.isExempted(player, CheckType.MOVING_CREATIVEFLY, true) && !player.hasPermission("nocheatplus.checks.moving.creativefly")) {
            checkCf = true;
            checkSf = false;
            this.prepareCreativeFlyCheck(player, from, to, moveInfo, thisMove, multiMoveCount, tick, data, cc);
        } else {
            checkSf = false;
            checkCf = false;
        }
        boolean checkNf = true;
        BounceType verticalBounce = BounceType.NO_BOUNCE;
        if (checkSf || checkCf) {
            MovingUtil.checkSetBack(player, pFrom, data, this);
            if (data.crossWorldFrom != null) {
                if (!TrigUtil.isSamePosAndLook((IGetPositionWithLook)pFrom, pTo) && TrigUtil.isSamePosAndLook((IGetPositionWithLook)pTo, data.crossWorldFrom)) {
                    newTo = data.getSetBack(from);
                    checkNf = false;
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING) + " Player move end point seems to be set wrongly.");
                }
                data.crossWorldFrom = null;
            }
            if (newTo == null && (Math.abs(thisMove.yDistance) > 4.0 || thisMove.hDistance > 22.0) && (newTo = this.checkExtremeMove(player, pFrom, pTo, data, cc)) != null) {
                thisMove.flyCheck = checkSf ? CheckType.MOVING_SURVIVALFLY : CheckType.MOVING_CREATIVEFLY;
            }
            boolean bl = useBlockChangeTracker = newTo == null && cc.trackBlockMove && (cc.passableCheck || checkSf || checkCf) && this.blockChangeTracker.hasActivityShuffled(from.getWorld().getUID(), pFrom, pTo, 1.5625);
            if (newTo == null) {
                if (to.getY() < from.getY()) {
                    if (!this.survivalFly.isReallySneaking(player) && this.checkBounceEnvelope(player, pFrom, pTo, data, cc)) {
                        if ((BlockProperties.getBlockFlags(pTo.getTypeIdBelow()) & 0x800000L) != 0L) {
                            verticalBounce = BounceType.STATIC;
                            checkNf = false;
                        }
                        if (verticalBounce == BounceType.NO_BOUNCE && useBlockChangeTracker && (verticalBounce = this.checkPastStateBounceDescend(player, pFrom, pTo, thisMove, lastMove, tick, data, cc)) != BounceType.NO_BOUNCE) {
                            checkNf = false;
                        }
                    }
                } else if (data.verticalBounce != null && this.onPreparedBounceSupport(player, from, to, thisMove, lastMove, tick, data) || useBlockChangeTracker && thisMove.yDistance <= 1.515 && this.checkPastStateBounceAscend(player, pFrom, pTo, thisMove, lastMove, tick, data, cc)) {
                    checkNf = false;
                }
            }
        } else {
            useBlockChangeTracker = false;
        }
        boolean mightSkipNoFall = false;
        if (newTo == null && cc.passableCheck && player.getGameMode() != BridgeMisc.GAME_MODE_SPECTATOR && !NCPExemptionManager.isExempted(player, CheckType.MOVING_PASSABLE, true) && !player.hasPermission("nocheatplus.checks.moving.passable") && (newTo = this.passable.check(player, pFrom, pTo, data, cc, tick, useBlockChangeTracker)) != null) {
            mightSkipNoFall = true;
        }
        if (checkSf) {
            MovingUtil.prepareFullCheck(pFrom, pTo, thisMove, Math.max(cc.noFallyOnGround, cc.yOnGround));
            if (lastMove.toIsValid && lastMove.flyCheck == CheckType.MOVING_CREATIVEFLY) {
                this.workaroundFlyNoFlyTransition(player, tick, data);
            }
            if (newTo == null) {
                thisMove.flyCheck = CheckType.MOVING_SURVIVALFLY;
                newTo = this.survivalFly.check(player, pFrom, pTo, multiMoveCount, data, cc, tick, time, useBlockChangeTracker);
            }
            if (checkNf) {
                checkNf = this.noFall.isEnabled(player, cc);
            }
            if (newTo == null) {
                if (!(!cc.sfHoverCheck || lastMove.toIsValid && lastMove.to.extraPropertiesValid && lastMove.to.onGroundOrResetCond || pTo.isOnGround())) {
                    this.hoverTicks.add(playerName);
                    data.sfHoverTicks = 0;
                } else {
                    data.sfHoverTicks = -1;
                }
                if (checkNf) {
                    this.noFall.check(player, pFrom, pTo, data, cc);
                }
            } else if (checkNf && cc.sfSetBackPolicyFallDamage) {
                if (this.noFall.estimateDamage(player, from.getY(), data) < 1.0) {
                    mightSkipNoFall = true;
                } else if (mightSkipNoFall && !pFrom.isOnGround() && !pFrom.isResetCond()) {
                    mightSkipNoFall = false;
                }
                if (!(mightSkipNoFall || pTo.isResetCond() && pFrom.isResetCond())) {
                    this.noFall.checkDamage(player, data, Math.min(from.getY(), to.getY()));
                }
            }
        } else if (checkCf) {
            if (newTo == null) {
                thisMove.flyCheck = CheckType.MOVING_CREATIVEFLY;
                newTo = this.creativeFly.check(player, pFrom, pTo, data, cc, time, tick, useBlockChangeTracker);
            }
            data.sfHoverTicks = -1;
            data.sfLowJump = false;
        } else {
            data.clearFlyData();
        }
        if (cc.morePacketsCheck && (newTo == null || data.isMorePacketsSetBackOldest()) && !NCPExemptionManager.isExempted(player, CheckType.MOVING_MOREPACKETS, true) && !player.hasPermission("nocheatplus.checks.moving.morepackets")) {
            Location mpNewTo = this.morePackets.check(player, pFrom, pTo, newTo == null, data, cc);
            if (mpNewTo != null) {
                if (newTo != null && data.debug) {
                    this.debug(player, "Override set back by the older morepackets set back.");
                }
                newTo = mpNewTo;
            }
        } else {
            data.clearPlayerMorePacketsData();
        }
        if ((checkSf || checkCf) && jumpAmplifier != data.jumpAmplifier && (thisMove.touchedGround || !checkSf && (pFrom.isOnGround() || pTo.isOnGround()))) {
            data.jumpAmplifier = jumpAmplifier;
        }
        if (useBlockChangeTracker && data.blockChangeRef.firstSpanEntry != null) {
            if (data.debug) {
                this.debug(player, "BlockChangeReference: " + data.blockChangeRef.firstSpanEntry.tick + " .. " + data.blockChangeRef.lastSpanEntry.tick + " / " + tick);
            }
            data.blockChangeRef.updateFinal(pTo);
        }
        if (newTo == null) {
            if (data.hasTeleported()) {
                data.resetTeleported();
                if (data.debug) {
                    this.debug(player, "Ignore hook-induced set-back: actions not set to cancel.");
                }
            }
            if (verticalBounce != BounceType.NO_BOUNCE) {
                this.processBounce(player, pFrom.getY(), pTo.getY(), verticalBounce, tick, data, cc);
            }
            if (this.processingEvents.containsKey(playerName)) {
                data.playerMoves.finishCurrentMove();
            } else {
                thisMove.invalidate();
            }
            ++data.timeSinceSetBack;
            return false;
        }
        if (data.hasTeleported()) {
            if (data.debug) {
                this.debug(player, "The set back has been overridden from (" + newTo + ") to: " + data.getTeleported());
            }
            newTo = data.getTeleported();
        }
        if (data.debug) {
            if (verticalBounce != BounceType.NO_BOUNCE) {
                this.debug(player, "Bounce effect not processed: " + (Object)((Object)verticalBounce));
            }
            if (data.verticalBounce != null) {
                this.debug(player, "Bounce effect not used: " + data.verticalBounce);
            }
        }
        this.prepareSetBack(player, event, newTo, data, cc);
        if ((thisMove.flyCheck == CheckType.MOVING_SURVIVALFLY || thisMove.flyCheck == CheckType.MOVING_CREATIVEFLY && pFrom.isInLiquid()) && Bridge1_9.isGlidingWithElytra(player)) {
            MovingListener.stopGliding(player);
        }
        return true;
    }

    private static void stopGliding(Player player) {
        player.setGliding(false);
    }

    private void prepareCreativeFlyCheck(Player player, Location from, Location to, PlayerMoveInfo moveInfo, PlayerMoveData thisMove, int multiMoveCount, int tick, MovingData data, MovingConfig cc) {
        data.adjustFlySpeed(player.getFlySpeed(), tick, cc.speedGrace);
        data.adjustWalkSpeed(player.getWalkSpeed(), tick, cc.speedGrace);
        ModelFlying model = cc.getModelFlying(player, (PlayerLocation)moveInfo.from, data, cc);
        if ("jetpack.elytra".equals(model.getId())) {
            MCAccess mcAccess = (MCAccess)this.mcAccess.getHandle();
            MovingUtil.setElytraProperties(player, (PlayerLocation)moveInfo.from, from, cc.yOnGround, mcAccess);
            MovingUtil.setElytraProperties(player, (PlayerLocation)moveInfo.to, to, cc.yOnGround, mcAccess);
            thisMove.set(moveInfo.from, moveInfo.to);
            if (multiMoveCount > 0) {
                thisMove.multiMoveCount = multiMoveCount;
            }
        }
        thisMove.modelFlying = model;
    }

    private BounceType checkPastStateBounceDescend(Player player, PlayerLocation from, PlayerLocation to, PlayerMoveData thisMove, PlayerMoveData lastMove, int tick, MovingData data, MovingConfig cc) {
        UUID worldId = from.getWorld().getUID();
        BlockChangeTracker.BlockChangeEntry entryBelowAny = this.blockChangeTracker.getBlockChangeEntryMatchFlags(data.blockChangeRef, tick, worldId, to.getBlockX(), to.getBlockY() - 1, to.getBlockZ(), null, 0x800000L);
        if (entryBelowAny != null) {
            BlockChangeTracker.BlockChangeEntry entryBelowY_POS;
            BlockChangeTracker.BlockChangeEntry blockChangeEntry = entryBelowY_POS = entryBelowAny.direction == BlockChangeTracker.Direction.Y_POS ? entryBelowAny : this.blockChangeTracker.getBlockChangeEntryMatchFlags(data.blockChangeRef, tick, worldId, to.getBlockX(), to.getBlockY() - 1, to.getBlockZ(), BlockChangeTracker.Direction.Y_POS, 0x800000L);
            if (entryBelowY_POS != null) {
                return BounceType.STATIC_PAST_AND_PUSH;
            }
            return BounceType.STATIC_PAST;
        }
        return BounceType.NO_BOUNCE;
    }

    private boolean checkPastStateBounceAscend(Player player, PlayerLocation from, PlayerLocation to, PlayerMoveData thisMove, PlayerMoveData lastMove, int tick, MovingData data, MovingConfig cc) {
        BlockChangeTracker.BlockChangeEntry entry2BelowY_POS;
        UUID worldId = from.getWorld().getUID();
        double amount = -1.0;
        BlockChangeTracker.BlockChangeEntry entryBelowY_POS = this.blockChangeTracker.getBlockChangeEntryMatchFlags(data.blockChangeRef, tick, worldId, from.getBlockX(), from.getBlockY() - 1, from.getBlockZ(), BlockChangeTracker.Direction.Y_POS, 0x800000L);
        if (entryBelowY_POS != null || thisMove.yDistance < 1.015 && from.matchBlockChangeMatchResultingFlags(this.blockChangeTracker, data.blockChangeRef, BlockChangeTracker.Direction.Y_POS, Math.min(0.415, thisMove.yDistance), 0x800000L)) {
            if (data.debug) {
                this.debug(player, "Direct block push with bounce (" + (entryBelowY_POS == null ? "off_center)." : "center)."));
            }
            amount = Math.min(Math.max(0.505, 1.0 + (double)from.getBlockY() - from.getY() + 1.515), 2.525);
            if (entryBelowY_POS != null) {
                data.blockChangeRef.updateSpan(entryBelowY_POS);
            }
        }
        if (amount < 0.0 && lastMove.toIsValid && lastMove.yDistance >= 0.0 && lastMove.yDistance <= 0.505 && from.getY() - (double)from.getBlockY() == lastMove.yDistance && (entry2BelowY_POS = this.blockChangeTracker.getBlockChangeEntryMatchFlags(data.blockChangeRef, tick, worldId, from.getBlockX(), from.getBlockY() - 2, from.getBlockZ(), BlockChangeTracker.Direction.Y_POS, 0x800000L)) != null) {
            if (data.debug) {
                this.debug(player, "Foot position block push with bounce (" + (entry2BelowY_POS == null ? "off_center)." : "center)."));
            }
            amount = Math.min(Math.max(0.505, 1.0 + (double)from.getBlockY() - from.getY() + 1.515), 2.015 - lastMove.yDistance);
            if (entryBelowY_POS != null) {
                data.blockChangeRef.updateSpan(entry2BelowY_POS);
            }
        }
        if (amount >= 0.0) {
            if (data.peekVerticalVelocity(amount, 2, 3) == null) {
                SimpleEntry vel;
                data.verticalBounce = vel = new SimpleEntry(tick, amount, 773L, 4);
                data.useVerticalBounce(player);
                if (data.debug) {
                    this.debug(player, "checkPastStateBounceAscend: add velocity: " + vel);
                }
                return true;
            }
            if (data.debug) {
                this.debug(player, "checkPastStateBounceAscend: Don't add velocity.");
            }
        }
        return false;
    }

    private boolean checkBounceEnvelope(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        return (to.getY() - (double)to.getBlockY() <= Math.max(cc.yOnGround, cc.noFallyOnGround) || BlockProperties.isCarpet(to.getTypeId()) && to.getY() - (double)to.getBlockY() <= 0.9) && MovingUtil.getRealisticFallDistance(player, from.getY(), to.getY(), data) > 1.0 || to.getY() - (double)to.getBlockY() < 0.286 && to.getY() - from.getY() > -0.5 && to.getY() - from.getY() < -0.0624 && !to.isOnGround();
    }

    private boolean onPreparedBounceSupport(Player player, Location from, Location to, PlayerMoveData thisMove, PlayerMoveData lastMove, int tick, MovingData data) {
        if (to.getY() > from.getY() || to.getY() == from.getY() && data.verticalBounce.value < 0.13) {
            if (to.getY() == from.getY()) {
                data.prependVerticalVelocity(new SimpleEntry(tick, 0.0, 1));
                data.getOrUseVerticalVelocity(0.0);
                if (lastMove.toIsValid && lastMove.yDistance < 0.0) {
                    data.verticalBounce = new SimpleEntry(tick, data.verticalBounce.value, 1);
                }
            } else {
                data.useVerticalBounce(player);
            }
            return true;
        }
        data.verticalBounce = null;
        return false;
    }

    private Location checkExtremeMove(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        double amount;
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        double violation = 0.0;
        boolean allowVerticalVelocity = false;
        if (!(!(Math.abs(thisMove.yDistance) > 4.0) || lastMove.toIsValid && Math.abs(thisMove.yDistance) < Math.abs(lastMove.yDistance) && (thisMove.yDistance > 0.0 && lastMove.yDistance > 0.0 || thisMove.yDistance < 0.0 && lastMove.yDistance < 0.0))) {
            violation += thisMove.yDistance;
        }
        if (!(!(thisMove.hDistance > 22.0) || (amount = thisMove.hDistance - data.getHorizontalFreedom()) < 0.0 || lastMove.toIsValid && thisMove.hDistance - lastMove.hDistance <= 0.0 || data.useHorizontalVelocity(amount) >= amount)) {
            violation += thisMove.hDistance;
        }
        if (violation > 0.0) {
            double vL;
            ActionList actions;
            Check check;
            if (!data.hasSetBack()) {
                data.setSetBack(from);
            }
            violation *= 100.0;
            if (thisMove.flyCheck == CheckType.MOVING_SURVIVALFLY) {
                check = this.survivalFly;
                actions = cc.survivalFlyActions;
                data.survivalFlyVL += violation;
                vL = data.survivalFlyVL;
            } else {
                check = this.creativeFly;
                actions = cc.creativeFlyActions;
                data.creativeFlyVL += violation;
                vL = data.creativeFlyVL;
            }
            ViolationData vd = new ViolationData(check, player, vL, violation, actions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
                vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
                vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance((IGetPosition)from, to)));
                vd.setParameter(ParameterName.TAGS, "EXTREME_MOVE");
            }
            if (check.executeActions(vd).willCancel()) {
                return data.getSetBack(to);
            }
        }
        return null;
    }

    private void workaroundFlyNoFlyTransition(Player player, int tick, MovingData data) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        double amount = MovingListener.guessFlyNoFlyVelocity(player, data.playerMoves.getCurrentMove(), lastMove, data);
        data.clearActiveHorVel();
        data.addHorizontalVelocity(new AccountEntry(tick, amount, 1, MovingData.getHorVelValCount(amount)));
        data.addVerticalVelocity(new SimpleEntry(lastMove.yDistance, 2));
        data.addVerticalVelocity(new SimpleEntry(0.0, 2));
        data.setFrictionJumpPhase();
        data.clearNoFallData();
        player.setFallDistance(0.0f);
        if (data.debug) {
            this.debug(player, "Fly-nofly transition: Add velocity.");
        }
    }

    private static double guessFlyNoFlyVelocity(Player player, PlayerMoveData thisMove, PlayerMoveData lastMove, MovingData data) {
        double defaultAmount = lastMove.hDistance * 1.98 / 2.0;
        if (thisMove.hDistance > defaultAmount && Bridge1_9.isGlidingWithElytra(player)) {
            PlayerMoveData secondPastMove = data.playerMoves.getSecondPastMove();
            if (lastMove.modelFlying != null && secondPastMove.modelFlying != null && Magic.glideEnvelopeWithHorizontalGain(thisMove, lastMove, secondPastMove)) {
                return thisMove.hDistance + 0.0417;
            }
        }
        return defaultAmount;
    }

    private void processBounce(Player player, double fromY, double toY, BounceType bounceType, int tick, MovingData data, MovingConfig cc) {
        double max_gain;
        double fallDistance = MovingUtil.getRealisticFallDistance(player, fromY, toY, data);
        double base = Math.sqrt(fallDistance) / 3.3;
        double effect = Math.min(3.5, base + Math.min(base / 10.0, 0.0834));
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (effect > 0.415 && lastMove.toIsValid && (max_gain = Math.abs(lastMove.yDistance < 0.0 ? Math.min(lastMove.yDistance, toY - fromY) : toY - fromY) - 0.021000000000000005) < effect) {
            effect = max_gain;
            if (data.debug) {
                this.debug(player, "Cap bounce effect by recent y-distances.");
            }
        }
        if (bounceType == BounceType.STATIC_PAST_AND_PUSH) {
            // empty if block
        }
        if (data.debug) {
            this.debug(player, "Set bounce effect (dY=" + fallDistance + " / " + (Object)((Object)bounceType) + "): " + effect);
        }
        data.noFallSkipAirCheck = true;
        data.verticalBounce = new SimpleEntry(tick, effect, 512L, 1);
    }

    private void prepareSetBack(Player player, PlayerMoveEvent event, Location newTo, MovingData data, MovingConfig cc) {
        if (LocUtil.needsYawCorrection(newTo.getYaw())) {
            newTo.setYaw(LocUtil.correctYaw(newTo.getYaw()));
        }
        if (LocUtil.needsPitchCorrection(newTo.getPitch())) {
            newTo.setPitch(LocUtil.correctPitch(newTo.getPitch()));
        }
        data.prepareSetBack(newTo);
        this.aux.resetPositionsAndMediumProperties(player, newTo, data, cc);
        PlayerSetBackMethod method = cc.playerSetBackMethod;
        if (method.shouldSetTo()) {
            event.setTo(newTo);
        }
        if (method.shouldCancel()) {
            event.setCancelled(true);
        }
        if (data.debug) {
            this.debug(player, "Prepare set back to: " + newTo.getWorld().getName() + "/" + LocUtil.simpleFormatPosition(newTo) + " (" + method.getId() + ")");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerMoveMonitor(PlayerMoveEvent event) {
        long now = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (this.processingEvents.remove(player.getName()) == null) {
            return;
        }
        if (player.isDead() || player.isSleeping()) {
            return;
        }
        CombinedData data = CombinedData.getData(player);
        data.lastMoveTime = now;
        Location from = event.getFrom();
        MovingData mData = MovingData.getData(player);
        int tick = TickTask.getTick();
        MovingConfig mCc = MovingConfig.getConfig(player);
        if (!event.isCancelled()) {
            Location pLoc = player.getLocation(this.useLoc);
            this.onMoveMonitorNotCancelled(player, TrigUtil.isSamePosAndLook(pLoc, from) ? from : pLoc, event.getTo(), now, tick, data, mData, mCc);
            this.useLoc.setWorld(null);
        } else {
            this.onCancelledMove(player, from, tick, now, mData, mCc, data);
        }
    }

    private void onCancelledMove(Player player, Location from, int tick, long now, MovingData mData, MovingConfig mCc, CombinedData data) {
        if (mData.hasTeleported()) {
            Location ref = mData.getTeleported();
            PlayerSetBackMethod method = mCc.playerSetBackMethod;
            if (method.shouldUpdateFrom()) {
                LocUtil.set(from, ref);
            }
            if (method.shouldSchedule()) {
                PlayerData pd = DataManager.getPlayerData(player);
                if (pd.isPlayerSetBackScheduled()) {
                    this.debug(player, "Teleport (set back) already scheduled to: " + ref);
                } else if (mData.debug) {
                    pd.requestPlayerSetBack();
                    if (mData.debug) {
                        this.debug(player, "Schedule teleport (set back) to: " + ref);
                    }
                }
            }
        }
        Combined.resetYawRate(player, from.getYaw(), now, false);
        this.aux.resetPositionsAndMediumProperties(player, from, mData, mCc);
        mData.resetTrace(player, from, tick, (IEntityAccessDimensions)this.mcAccess.getHandle(), mCc);
        if (((NetConfig)CheckType.NET_FLYINGFREQUENCY.getConfigFactory().getConfig((Player)player)).flyingFrequencyActive) {
            ((NetData)CheckType.NET_FLYINGFREQUENCY.getDataFactory().getData((Player)player)).teleportQueue.onTeleportEvent(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
        }
    }

    private void onMoveMonitorNotCancelled(Player player, Location from, Location to, long now, long tick, CombinedData data, MovingData mData, MovingConfig mCc) {
        String toWorldName = to.getWorld().getName();
        Combined.feedYawRate(player, to.getYaw(), now, toWorldName, data);
        if (player.isInsideVehicle()) {
            Location ref = player.getVehicle().getLocation(this.useLoc);
            this.aux.resetPositionsAndMediumProperties(player, ref, mData, mCc);
            this.useLoc.setWorld(null);
            mData.updateTrace(player, to, tick, (IEntityAccessDimensions)this.mcAccess.getHandle());
        } else if (!from.getWorld().getName().equals(toWorldName)) {
            this.aux.resetPositionsAndMediumProperties(player, to, mData, mCc);
            mData.resetTrace(player, to, tick, (IEntityAccessDimensions)this.mcAccess.getHandle(), mCc);
        } else {
            PlayerMoveData lastMove = mData.playerMoves.getFirstPastMove();
            if (!lastMove.toIsValid || !TrigUtil.isSamePos(to, lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ())) {
                this.aux.resetPositionsAndMediumProperties(player, to, mData, mCc);
            }
            mData.updateTrace(player, to, tick, (IEntityAccessDimensions)this.mcAccess.getHandle());
            if (mData.hasTeleported()) {
                this.onPlayerMoveMonitorNotCancelledHasTeleported(player, to, mData);
            }
        }
    }

    private void onPlayerMoveMonitorNotCancelledHasTeleported(Player player, Location to, MovingData mData) {
        if (mData.isTeleportedPosition(to)) {
            if (mData.debug) {
                this.debug(player, "Event not cancelled, with teleported (set back) set, assume legacy behavior.");
            }
            return;
        }
        if (DataManager.getPlayerData(player).isPlayerSetBackScheduled()) {
            if (mData.debug) {
                this.debug(player, "Event not cancelled, despite a set back has been scheduled. Cancel set back.");
            }
            mData.resetTeleported();
        } else {
            if (mData.debug) {
                this.debug(player, "Inconsistent state (move MONITOR): teleported has been set, but no set back is scheduled. Ignore set back.");
            }
            mData.resetTeleported();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerPortalLowest(PlayerPortalEvent event) {
        Player player = event.getPlayer();
        if (MovingUtil.hasScheduledPlayerSetBack(player)) {
            if (MovingData.getData((Player)player).debug) {
                this.debug(player, "[PORTAL] Prevent use, due to a scheduled set back.");
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerPortal(PlayerPortalEvent event) {
        Location to = event.getTo();
        MovingData data = MovingData.getData(event.getPlayer());
        if (data.debug) {
            this.debug(event.getPlayer(), "[PORTAL] to=" + to);
        }
        if (to != null) {
            data.clearMostMovingCheckData();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        MovingData data = MovingData.getData(player);
        data.clearMostMovingCheckData();
        data.setSetBack(player.getLocation(this.useLoc));
        if (data.debug) {
            this.debug(player, "Death: " + player.getLocation(this.useLoc));
        }
        this.useLoc.setWorld(null);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onPlayerTeleportLowest(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        this.processingEvents.remove(player.getName());
        if (event.isCancelled()) {
            return;
        }
        PlayerTeleportEvent.TeleportCause cause = event.getCause();
        switch (cause) {
            case COMMAND: 
            case ENDER_PEARL: {
                break;
            }
            default: {
                return;
            }
        }
        MovingData data = MovingData.getData(player);
        Location to = event.getTo();
        if (to == null) {
            if (!event.isCancelled()) {
                if (data.debug) {
                    this.debugTeleportMessage(player, event, "Cancel event, that has no target location (to) set.");
                }
                event.setCancelled(true);
            }
            return;
        }
        if (data.hasTeleported()) {
            if (data.isTeleportedPosition(to)) {
                return;
            }
            if (data.debug) {
                this.debugTeleportMessage(player, event, "Prevent teleport, due to a scheduled set back: ", to);
            }
            event.setCancelled(true);
            return;
        }
        MovingConfig cc = MovingConfig.getConfig(player);
        boolean cancel = false;
        if (cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            if (CombinedConfig.getConfig((Player)player).enderPearlCheck && !BlockProperties.isPassable(to)) {
                cancel = true;
            }
        } else if (cause == PlayerTeleportEvent.TeleportCause.COMMAND && cc.passableUntrackedTeleportCheck) {
            Location newTo;
            if (cc.loadChunksOnTeleport) {
                MovingUtil.ensureChunksLoaded(player, to, "teleport", data, cc);
            }
            if (cc.passableUntrackedTeleportCheck && MovingUtil.shouldCheckUntrackedLocation(player, to) && (newTo = MovingUtil.checkUntrackedLocation(to)) != null) {
                event.setTo(newTo);
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, player.getName() + " correct untracked teleport destination (" + to + " corrected to " + newTo + ").");
            }
        }
        if (cancel) {
            event.setCancelled(true);
            if (data.debug) {
                this.debug(player, "TP " + cause + " (cancel): " + to);
            }
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            this.checkUndoCancelledSetBack(event);
        }
    }

    private void checkUndoCancelledSetBack(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        if (data.hasTeleported()) {
            this.undoCancelledSetBack(player, event, data);
        }
    }

    private final void undoCancelledSetBack(Player player, PlayerTeleportEvent event, MovingData data) {
        event.setCancelled(false);
        if (!data.isTeleported(event.getTo())) {
            Location teleported = data.getTeleported();
            event.setTo(teleported);
            event.setFrom(teleported);
        }
        if (data.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, player.getName() + " TP " + event.getCause() + " (revert cancel on set back): " + event.getTo());
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onPlayerTeleportMonitor(PlayerTeleportEvent event) {
        Location from;
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        data.joinOrRespawn = false;
        Location to = event.getTo();
        if (event.isCancelled()) {
            this.onPlayerTeleportMonitorCancelled(player, event, to, data);
            return;
        }
        if (to == null) {
            this.onPlayerTeleportMonitorNullTarget(player, event, to, data);
            return;
        }
        MovingConfig cc = MovingConfig.getConfig(player);
        if (data.hasTeleported() && this.onPlayerTeleportMonitorHasTeleported(player, event, to, data, cc)) {
            return;
        }
        boolean skipExtras = false;
        if (data.isVehicleSetBack) {
            if (event.getCause() != BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING_VEHICLE) + "Unexpected teleport cause on vehicle set back: " + event.getCause());
            }
            skipExtras = true;
        }
        double fallDistance = data.noFallFallDistance;
        data.clearFlyData();
        data.clearPlayerMorePacketsData();
        data.setSetBack(to);
        data.sfHoverTicks = -1;
        if (cc.loadChunksOnTeleport) {
            MovingUtil.ensureChunksLoaded(player, to, "teleport", data, cc);
        }
        this.aux.resetPositionsAndMediumProperties(player, to, data, cc);
        Combined.resetYawRate(player, to.getYaw(), System.currentTimeMillis(), true);
        data.resetTeleported();
        if (!skipExtras) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.UNKNOWN) {
                player.setFallDistance((float)fallDistance);
                data.noFallFallDistance = (float)fallDistance;
            } else if (fallDistance > 1.0 && fallDistance - (double)player.getFallDistance() > 0.0) {
                if (!cc.noFallTpReset) {
                    player.setFallDistance((float)fallDistance);
                    data.noFallFallDistance = (float)fallDistance;
                } else if (fallDistance >= 3.0) {
                    data.noFallSkipAirCheck = true;
                }
            }
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                data.noFallSkipAirCheck = true;
            }
        }
        data.crossWorldFrom = (from = event.getFrom()) != null && event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL && !from.getWorld().getName().equals(to.getWorld().getName()) ? new SimplePositionWithLook(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch()) : null;
        if (data.debug) {
            this.debugTeleportMessage(player, event, "(normal)", to);
        }
    }

    private boolean onPlayerTeleportMonitorHasTeleported(Player player, PlayerTeleportEvent event, Location to, MovingData data, MovingConfig cc) {
        if (data.isTeleportedPosition(to)) {
            this.confirmSetBack(player, true, data, cc);
            data.reducePlayerMorePacketsData(1.0f);
            if (data.debug) {
                this.debugTeleportMessage(player, event, "(set back)", to);
            }
            return true;
        }
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING) + " TP " + event.getCause() + " (set back was overridden): " + to);
        return false;
    }

    private void confirmSetBack(Player player, boolean fakeNews, MovingData data, MovingConfig cc) {
        Location teleported = data.getTeleported();
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        moveInfo.set(player, teleported, null, cc.yOnGround);
        if (cc.loadChunksOnTeleport) {
            MovingUtil.ensureChunksLoaded(player, teleported, "teleport", data, cc);
        }
        data.onSetBack((PlayerLocation)moveInfo.from);
        this.aux.returnPlayerMoveInfo(moveInfo);
        Combined.resetYawRate(player, teleported.getYaw(), System.currentTimeMillis(), true);
        data.resetTeleported();
    }

    private void onPlayerTeleportMonitorCancelled(Player player, PlayerTeleportEvent event, Location to, MovingData data) {
        if (data.isTeleported(to)) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING) + " TP " + event.getCause() + " (set back was prevented): " + to);
        } else if (data.debug) {
            this.debugTeleportMessage(player, event, to);
        }
        data.resetTeleported();
    }

    private void onPlayerTeleportMonitorNullTarget(Player player, PlayerTeleportEvent event, Location to, MovingData data) {
        if (data.debug) {
            this.debugTeleportMessage(player, event, "No target location (to) set.");
        }
        if (data.hasTeleported()) {
            if (DataManager.getPlayerData(player).isPlayerSetBackScheduled()) {
                event.setCancelled(true);
                if (data.debug) {
                    this.debugTeleportMessage(player, event, "Cancel, due to a scheduled set back.");
                }
            } else {
                data.resetTeleported();
                if (data.debug) {
                    this.debugTeleportMessage(player, event, "Skip set back, not being scheduled.");
                }
            }
        }
    }

    private void debugTeleportMessage(Player player, PlayerTeleportEvent event, Object ... extra) {
        StringBuilder builder = new StringBuilder(128);
        builder.append("TP ");
        builder.append(event.getCause());
        if (event.isCancelled()) {
            builder.append(" (cancelled)");
        }
        if (extra != null && extra.length > 0) {
            for (Object obj : extra) {
                if (obj == null) continue;
                builder.append(' ');
                if (obj instanceof String) {
                    builder.append((String)obj);
                    continue;
                }
                builder.append(obj.toString());
            }
        }
        this.debug(player, builder.toString());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        if (player.isInsideVehicle()) {
            data.removeAllVelocity();
            return;
        }
        Vector velocity = event.getVelocity();
        MovingConfig cc = MovingConfig.getConfig(player);
        data.addVelocity(player, cc, velocity.getX(), velocity.getY(), velocity.getZ());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        this.checkFallDamageEvent((Player)entity, event);
    }

    private void checkFallDamageEvent(Player player, EntityDamageEvent event) {
        MovingData data = MovingData.getData(player);
        if (player.isInsideVehicle()) {
            data.clearNoFallData();
            return;
        }
        MovingConfig cc = MovingConfig.getConfig(player);
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        double yOnGround = Math.max(cc.noFallyOnGround, cc.yOnGround);
        Location loc = player.getLocation(this.useLoc);
        moveInfo.set(player, loc, null, yOnGround);
        PlayerLocation pLoc = (PlayerLocation)moveInfo.from;
        pLoc.collectBlockFlags(yOnGround);
        if (event.isCancelled() || !MovingUtil.shouldCheckSurvivalFly(player, pLoc, data, cc) || !this.noFall.isEnabled(player, cc)) {
            data.clearNoFallData();
            this.useLoc.setWorld(null);
            this.aux.returnPlayerMoveInfo(moveInfo);
            return;
        }
        boolean allowReset = true;
        float fallDistance = player.getFallDistance();
        float yDiff = (float)(data.noFallMaxY - loc.getY());
        double damage = BridgeHealth.getDamage(event);
        if (data.debug) {
            this.debug(player, "Damage(FALL/PRE): " + damage + " / mc=" + player.getFallDistance() + " nf=" + data.noFallFallDistance + " yDiff=" + yDiff);
        }
        if (!data.noFallSkipAirCheck) {
            float dataDist = Math.max(yDiff, data.noFallFallDistance);
            double dataDamage = NoFall.getDamage(dataDist);
            if (damage > dataDamage + 0.5 || dataDamage <= 0.0) {
                PlayerMoveData firstPastMove = data.playerMoves.getFirstPastMove();
                if (pLoc.isOnGround() && pLoc.isInLava() && firstPastMove.toIsValid && firstPastMove.yDistance < 0.0) {
                    if (data.debug) {
                        this.debug(player, "NoFall/Damage: allow fall damage in lava (hotfix).");
                    }
                } else if (this.noFallVL(player, "fakefall", data, cc)) {
                    player.setFallDistance(dataDist);
                    if (dataDamage <= 0.0) {
                        event.setCancelled(true);
                        this.useLoc.setWorld(null);
                        this.aux.returnPlayerMoveInfo(moveInfo);
                        return;
                    }
                    if (data.debug) {
                        this.debug(player, "NoFall/Damage: override player fall distance and damage (" + fallDistance + " -> " + dataDist + ").");
                    }
                    fallDistance = dataDist;
                    BridgeHealth.setDamage(event, dataDamage);
                }
            }
            data.noFallFallDistance = (float)((double)data.noFallFallDistance + 1.0);
            if (!(pLoc.isOnGround(1.0, 0.3, 0.1) || pLoc.isResetCond() || pLoc.isAboveLadder() || pLoc.isAboveStairs())) {
                if (this.noFallVL(player, "fakeground", data, cc) && data.hasSetBack()) {
                    allowReset = false;
                }
            } else {
                data.vDistAcc.clear();
            }
        }
        this.aux.returnPlayerMoveInfo(moveInfo);
        double maxD = NoFall.getDamage(Math.max(yDiff, Math.max(data.noFallFallDistance, fallDistance))) + (allowReset ? 0.0 : 3.0);
        if (maxD > damage) {
            BridgeHealth.setDamage(event, maxD);
            if (data.debug) {
                this.debug(player, "Adjust fall damage to: " + maxD);
            }
        }
        if (allowReset) {
            data.clearNoFallData();
            if (data.debug) {
                this.debug(player, "Reset NoFall data on fall damage.");
            }
        } else {
            if (cc.noFallViolationReset) {
                data.clearNoFallData();
            }
            if (cc.sfHoverCheck && data.sfHoverTicks < 0) {
                data.sfHoverTicks = 0;
                this.hoverTicks.add(player.getName());
            }
        }
        this.useLoc.setWorld(null);
    }

    private final boolean noFallVL(Player player, String tag, MovingData data, MovingConfig cc) {
        data.noFallVL += 1.0;
        ViolationData vd = new ViolationData(this.noFall, player, data.noFallVL, 1.0, cc.noFallActions);
        if (tag != null) {
            vd.setParameter(ParameterName.TAGS, tag);
        }
        return this.noFall.executeActions(vd).willCancel();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        data.clearMostMovingCheckData();
        data.resetSetBack();
        this.dataOnJoin(player, event.getRespawnLocation(), data, MovingConfig.getConfig(player), true);
        if (Bridge1_9.hasGetItemInOffHand() && player.isBlocking()) {
            this.redoShield(player);
        }
    }

    private void redoShield(Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack stack = inv.getItemInOffHand();
        if (stack != null && stack.getType() == Material.SHIELD) {
            inv.setItemInOffHand(stack);
            return;
        }
        stack = inv.getItemInMainHand();
        if (stack != null && stack.getType() == Material.SHIELD) {
            inv.setItemInMainHand(stack);
            return;
        }
    }

    @Override
    public void playerJoins(Player player) {
        this.dataOnJoin(player, player.getLocation(this.useLoc), MovingData.getData(player), MovingConfig.getConfig(player), false);
        this.useLoc.setWorld(null);
    }

    private void dataOnJoin(Player player, Location loc, MovingData data, MovingConfig cc, boolean isRespawn) {
        int loaded;
        String tag;
        int tick = TickTask.getTick();
        String string = tag = isRespawn ? "Respawn" : "Join";
        if (cc.loadChunksOnJoin && (loaded = MapUtil.ensureChunksLoaded(loc.getWorld(), loc.getX(), loc.getZ(), 3.0)) > 0 && data.debug) {
            StaticLog.logInfo("Player " + tag + ": Loaded " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " for player: " + player.getName());
        }
        if (!data.hasSetBack() || data.hasSetBackWorldChanged(loc)) {
            data.clearFlyData();
            data.setSetBack(loc);
            data.joinOrRespawn = true;
        }
        data.clearVehicleData();
        data.clearAllMorePacketsData();
        data.removeAllVelocity();
        data.resetTrace(player, loc, tick, (IEntityAccessDimensions)this.mcAccess.getHandle(), cc);
        data.vDistAcc.clear();
        this.aux.resetPositionsAndMediumProperties(player, loc, data, cc);
        if (cc.enforceLocation) {
            this.playersEnforce.add(player.getName());
        }
        this.initHover(player, data, cc, data.playerMoves.getFirstPastMove().from.onGroundOrResetCond);
        if (player.isInsideVehicle()) {
            this.vehicleChecks.onPlayerVehicleEnter(player, player.getVehicle());
        }
        if (data.debug) {
            this.debug(player, tag + ": " + loc);
        }
    }

    private void initHover(Player player, MovingData data, MovingConfig cc, boolean isOnGroundOrResetCond) {
        if (!isOnGroundOrResetCond && cc.sfHoverCheck) {
            data.sfHoverTicks = 0;
            data.sfHoverLoginTicks = cc.sfHoverLoginTicks;
            this.hoverTicks.add(player.getName());
        } else {
            data.sfHoverLoginTicks = 0;
            data.sfHoverTicks = -1;
        }
    }

    @Override
    public void playerLeaves(Player player) {
        MovingData data = MovingData.getData(player);
        Location loc = player.getLocation(this.useLoc);
        if (data.debug) {
            StaticLog.logInfo("Player " + player.getName() + " leaves at location: " + loc.toString());
        }
        if (!(player.isSleeping() || player.isDead() || BlockProperties.isPassable(loc))) {
            Location refLoc;
            double d;
            PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
            if (lastMove.toIsValid && (d = (refLoc = new Location(loc.getWorld(), lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ())).distanceSquared(loc)) > 0.0 && (TrigUtil.manhattan(loc, refLoc) > 0 || BlockProperties.isPassable(refLoc)) && this.passable.isEnabled(player)) {
                StaticLog.logWarning("Potential exploit: Player " + player.getName() + " leaves, having moved into a block (not tracked by moving checks): " + player.getWorld().getName() + " / " + DebugUtil.formatMove(refLoc, loc));
                if (d > 1.25) {
                    StaticLog.logWarning("SKIP set back for " + player.getName() + ", because distance is too high (risk of false positives): " + d);
                } else {
                    StaticLog.logInfo("Set back player " + player.getName() + ": " + LocUtil.simpleFormat(refLoc));
                    data.prepareSetBack(refLoc);
                    if (!player.teleport(refLoc, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION)) {
                        StaticLog.logWarning("FAILED to set back player " + player.getName());
                    }
                }
            }
        }
        this.useLoc.setWorld(null);
        this.survivalFly.setReallySneaking(player, false);
        this.noFall.onLeave(player);
        data.onPlayerLeave();
        if (data.vehicleSetBackTaskId != -1) {
            data.vehicleSetBackTaskId = -1;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldunload(WorldUnloadEvent event) {
        MovingData.onWorldUnload(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        this.survivalFly.setReallySneaking(event.getPlayer(), event.isSneaking());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        if (!event.isSprinting()) {
            MovingData.getData((Player)event.getPlayer()).timeSprinting = 0L;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (player.isFlying() || event.isFlying() && !event.isCancelled()) {
            return;
        }
        MovingData data = MovingData.getData(player);
        MovingConfig cc = MovingConfig.getConfig(player);
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        Location loc = player.getLocation(this.useLoc);
        moveInfo.set(player, loc, null, cc.yOnGround);
        if (!MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, data, cc) || data.isVelocityJumpPhase() || BlockProperties.isOnGroundOrResetCond(player, loc, cc.yOnGround)) {
            this.useLoc.setWorld(null);
            this.aux.returnPlayerMoveInfo(moveInfo);
            return;
        }
        this.aux.returnPlayerMoveInfo(moveInfo);
        this.useLoc.setWorld(null);
        data.addVelocity(player, cc, 0.0, 0.3, 0.0);
    }

    @Override
    public void onTick(int tick, long timeLast) {
        if (!this.playersEnforce.isEmpty()) {
            this.checkOnTickPlayersEnforce();
        }
        if (tick % this.hoverTicksStep == 0 && !this.hoverTicks.isEmpty()) {
            this.checkOnTickHover();
        }
        this.useLoc.setWorld(null);
    }

    private void checkOnTickHover() {
        ArrayList<String> rem = new ArrayList<String>(this.hoverTicks.size());
        PlayerMoveInfo info = this.aux.usePlayerMoveInfo();
        for (String playerName : this.hoverTicks) {
            Player player = DataManager.getPlayerExact(playerName);
            if (player == null || !player.isOnline()) {
                rem.add(playerName);
                continue;
            }
            MovingData data = MovingData.getData(player);
            if (player.isDead() || player.isSleeping() || player.isInsideVehicle()) {
                data.sfHoverTicks = -1;
            }
            if (data.sfHoverTicks < 0) {
                data.sfHoverLoginTicks = 0;
                rem.add(playerName);
                continue;
            }
            if (data.sfHoverLoginTicks > 0) {
                --data.sfHoverLoginTicks;
                continue;
            }
            MovingConfig cc = MovingConfig.getConfig(player);
            if (!cc.sfHoverCheck) {
                rem.add(playerName);
                data.sfHoverTicks = -1;
                continue;
            }
            data.sfHoverTicks += this.hoverTicksStep;
            if (data.sfHoverTicks < cc.sfHoverTicks || !this.checkHover(player, data, cc, info)) continue;
            rem.add(playerName);
        }
        this.hoverTicks.removeAll(rem);
        this.aux.returnPlayerMoveInfo(info);
    }

    private void checkOnTickPlayersEnforce() {
        ArrayList<String> rem = new ArrayList<String>(this.playersEnforce.size());
        for (String playerName : this.playersEnforce) {
            Player player = DataManager.getPlayerExact(playerName);
            if (player == null || !player.isOnline()) {
                rem.add(playerName);
                continue;
            }
            if (player.isDead() || player.isSleeping() || player.isInsideVehicle()) continue;
            MovingData data = MovingData.getData(player);
            Location newTo = this.enforceLocation(player, player.getLocation(this.useLoc), data);
            if (newTo == null) continue;
            data.prepareSetBack(newTo);
            player.teleport(newTo, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
        }
        if (!rem.isEmpty()) {
            this.playersEnforce.removeAll(rem);
        }
    }

    private Location enforceLocation(Player player, Location loc, MovingData data) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (lastMove.toIsValid && TrigUtil.distanceSquared(lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ(), loc.getX(), loc.getY(), loc.getZ()) > 0.00390625) {
            if (data.hasSetBack()) {
                return data.getSetBack(loc);
            }
            return new Location(player.getWorld(), lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ(), loc.getYaw(), loc.getPitch());
        }
        return null;
    }

    private boolean checkHover(Player player, MovingData data, MovingConfig cc, PlayerMoveInfo info) {
        boolean res;
        Location loc = player.getLocation(this.useLoc);
        info.set(player, loc, null, cc.yOnGround);
        int loaded = ((PlayerLocation)info.from).ensureChunksLoaded();
        if (loaded > 0 && data.debug) {
            StaticLog.logInfo("Hover check: Needed to load " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " around " + loc.getBlockX() + "," + loc.getBlockZ() + " in order to check player: " + player.getName());
        }
        if (((PlayerLocation)info.from).isOnGroundOrResetCond() || ((PlayerLocation)info.from).isAboveLadder() || ((PlayerLocation)info.from).isAboveStairs()) {
            res = true;
            data.sfHoverTicks = 0;
        } else if (data.sfHoverTicks > cc.sfHoverTicks) {
            PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
            moveInfo.set(player, loc, null, cc.yOnGround);
            if (MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, data, cc)) {
                this.handleHoverViolation(player, loc, cc, data);
                res = false;
                data.sfHoverTicks = 0;
            } else {
                res = false;
                data.sfHoverTicks = 0;
            }
            this.aux.returnPlayerMoveInfo(moveInfo);
        } else {
            res = false;
        }
        info.cleanup();
        return res;
    }

    private void handleHoverViolation(Player player, Location loc, MovingConfig cc, MovingData data) {
        if (cc.sfHoverFallDamage && this.noFall.isEnabled(player, cc)) {
            this.noFall.checkDamage(player, data, loc.getY());
        }
        this.survivalFly.handleHoverViolation(player, loc, cc, data);
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.MOVING_SURVIVALFLY;
    }

    @Override
    public IData removeData(String playerName) {
        this.hoverTicks.remove(playerName);
        this.playersEnforce.remove(playerName);
        return null;
    }

    @Override
    public void removeAllData() {
        this.hoverTicks.clear();
        this.playersEnforce.clear();
        this.aux.clear();
    }

    @Override
    public void onReload() {
        this.aux.clear();
        this.hoverTicksStep = Math.max(1, ConfigManager.getConfigFile().getInt("checks.moving.survivalfly.hover.step"));
        MovingData.onReload();
    }

    private void outputMoveDebug(Player player, PlayerLocation from, PlayerLocation to, double maxYOnGround, MCAccess mcAccess) {
        double slow;
        StringBuilder builder = new StringBuilder(250);
        Location loc = player.getLocation();
        builder.append(CheckUtils.getLogMessagePrefix(player, this.checkType));
        builder.append("MOVE in world " + from.getWorld().getName() + ":\n");
        DebugUtil.addMove(from, to, loc, builder);
        double jump = mcAccess.getJumpAmplifier(player);
        double speed = mcAccess.getFasterMovementAmplifier(player);
        double strider = BridgeEnchant.getDepthStriderLevel(player);
        if (BuildParameters.debugLevel > 0) {
            Vector v;
            try {
                builder.append("\n(walkspeed=" + player.getWalkSpeed() + " flyspeed=" + player.getFlySpeed() + ")");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (player.isSprinting()) {
                builder.append("(sprinting)");
            }
            if (player.isSneaking()) {
                builder.append("(sneaking)");
            }
            if (player.isBlocking()) {
                builder.append("(blocking)");
            }
            if ((v = player.getVelocity()).lengthSquared() > 0.0) {
                builder.append("(svel=" + v.getX() + "," + v.getY() + "," + v.getZ() + ")");
            }
        }
        if (!Double.isInfinite(speed)) {
            builder.append("(e_speed=" + (speed + 1.0) + ")");
        }
        if (Double.isInfinite(slow = PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.SLOW))) {
            builder.append("(e_slow=" + (slow + 1.0) + ")");
        }
        if (Double.isInfinite(jump)) {
            builder.append("(e_jump=" + (jump + 1.0) + ")");
        }
        if (strider != 0.0) {
            builder.append("(e_depth_strider=" + strider + ")");
        }
        if (Bridge1_9.isGliding(player)) {
            builder.append("(gliding)");
        }
        if (player.getAllowFlight()) {
            builder.append("(allow_flight)");
        }
        if (player.isFlying()) {
            builder.append("(flying)");
        }
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
        if (BuildParameters.debugLevel > 0) {
            builder.setLength(0);
            from.collectBlockFlags(maxYOnGround);
            if (from.getBlockFlags() != 0L) {
                builder.append("\nfrom flags: " + StringUtil.join(BlockProperties.getFlagNames(from.getBlockFlags()), "+"));
            }
            if (from.getTypeId() != Material.AIR) {
                DebugUtil.addBlockInfo(builder, from, "\nfrom");
            }
            if (from.getTypeIdBelow() != Material.AIR) {
                DebugUtil.addBlockBelowInfo(builder, from, "\nfrom");
            }
            if (!from.isOnGround() && from.isOnGround(0.5)) {
                builder.append(" (ground within 0.5)");
            }
            to.collectBlockFlags(maxYOnGround);
            if (to.getBlockFlags() != 0L) {
                builder.append("\nto flags: " + StringUtil.join(BlockProperties.getFlagNames(to.getBlockFlags()), "+"));
            }
            if (to.getTypeId() != Material.AIR) {
                DebugUtil.addBlockInfo(builder, to, "\nto");
            }
            if (to.getTypeIdBelow() != Material.AIR) {
                DebugUtil.addBlockBelowInfo(builder, to, "\nto");
            }
            if (!to.isOnGround() && to.isOnGround(0.5)) {
                builder.append(" (ground within 0.5)");
            }
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
        }
    }

    public static enum BounceType {
        NO_BOUNCE,
        STATIC,
        STATIC_PAST,
        STATIC_PAST_AND_PUSH;

    }
}

