/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.checks.access.CheckConfigFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.ModelFlying;
import fr.neatmonster.nocheatplus.checks.moving.player.PlayerSetBackMethod;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.versions.Bugs;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class MovingConfig
extends ACheckConfig {
    public static final CheckConfigFactory factory = new CheckConfigFactory(){

        @Override
        public final ICheckConfig getConfig(Player player) {
            return MovingConfig.getConfig(player);
        }

        @Override
        public void removeAllConfigs() {
            MovingConfig.clear();
        }
    };
    private static final Map<String, MovingConfig> worldsMap = new HashMap<String, MovingConfig>();
    public static final String ID_JETPACK_ELYTRA = "jetpack.elytra";
    public static final String ID_POTION_LEVITATION = "potion.levitation";
    public final boolean ignoreCreative;
    public final boolean ignoreAllowFlight;
    public final boolean creativeFlyCheck;
    private final Map<GameMode, ModelFlying> flyingModelGameMode = new HashMap<GameMode, ModelFlying>();
    private final ModelFlying flyingModelElytra;
    private final ModelFlying flyingModelLevitation;
    public final ActionList creativeFlyActions;
    public final boolean morePacketsCheck;
    public final float morePacketsEPSIdeal;
    public final float morePacketsEPSMax;
    public final int morePacketsEPSBuckets;
    public final float morePacketsBurstPackets;
    public final double morePacketsBurstDirect;
    public final double morePacketsBurstEPM;
    public final int morePacketsSetBackAge;
    public final ActionList morePacketsActions;
    public final boolean noFallCheck;
    public final boolean noFallDealDamage;
    public final boolean noFallSkipAllowFlight;
    public final boolean noFallViolationReset;
    public final boolean noFallTpReset;
    public final boolean noFallVehicleReset;
    public final boolean noFallAntiCriticals;
    public final ActionList noFallActions;
    public final boolean passableCheck;
    public final ActionList passableActions;
    public final boolean passableUntrackedTeleportCheck;
    public final boolean passableUntrackedCommandCheck;
    public final boolean passableUntrackedCommandTryTeleport;
    public final SimpleCharPrefixTree passableUntrackedCommandPrefixes = new SimpleCharPrefixTree();
    public final boolean survivalFlyCheck;
    public final int survivalFlyBlockingSpeed;
    public final int survivalFlySneakingSpeed;
    public final int survivalFlySpeedingSpeed;
    public final int survivalFlySprintingSpeed;
    public final int survivalFlySwimmingSpeed;
    public final int survivalFlyWalkingSpeed;
    public final boolean survivalFlyCobwebHack;
    public final boolean sfSlownessSprintHack;
    public final boolean sfGroundHop;
    public final boolean survivalFlyAccountingH;
    public final boolean survivalFlyAccountingV;
    public final boolean sfSetBackPolicyVoid;
    public final boolean sfSetBackPolicyFallDamage;
    public final double sfStepHeight;
    public final long survivalFlyVLFreeze;
    public final ActionList survivalFlyActions;
    public final boolean sfHoverCheck;
    public final int sfHoverTicks;
    public final int sfHoverLoginTicks;
    public final boolean sfHoverFallDamage;
    public final double sfHoverViolation;
    public final double hBufMax;
    public final int velocityActivationCounter;
    public final int velocityActivationTicks;
    public final boolean velocityStrictInvalidation;
    public final double noFallyOnGround;
    public final double yOnGround;
    public final boolean splitMoves;
    public final boolean ignoreStance;
    public final boolean tempKickIllegal;
    public final boolean loadChunksOnJoin;
    public final boolean loadChunksOnMove;
    public final boolean loadChunksOnTeleport;
    public final boolean loadChunksOnWorldChange;
    public final long sprintingGrace;
    public final boolean assumeSprint;
    public final int speedGrace;
    public final boolean enforceLocation;
    public final boolean trackBlockMove;
    public final PlayerSetBackMethod playerSetBackMethod;
    public final boolean vehicleEnforceLocation;
    public final boolean vehiclePreventDestroyOwn;
    public final boolean scheduleVehicleSetBacks;
    public final Set<EntityType> ignoredVehicles = new HashSet<EntityType>();
    public final boolean vehicleMorePacketsCheck;
    public final ActionList vehicleMorePacketsActions;
    public final boolean vehicleEnvelopeActive;
    public final HashMap<EntityType, Double> vehicleEnvelopeHorizontalSpeedCap = new HashMap();
    public final ActionList vehicleEnvelopeActions;
    public final int traceMaxAge;
    public final int traceMaxSize;
    public final String msgKickIllegalMove;
    public final String msgKickIllegalVehicleMove;

    public static void clear() {
        worldsMap.clear();
    }

    public static MovingConfig getConfig(Player player) {
        return MovingConfig.getConfig(player.getWorld().getName());
    }

    public static MovingConfig getConfig(String worldName) {
        MovingConfig cc = worldsMap.get(worldName);
        if (cc != null) {
            return cc;
        }
        MovingConfig ccNew = new MovingConfig(ConfigManager.getConfigFile(worldName));
        worldsMap.put(worldName, ccNew);
        return ccNew;
    }

    public MovingConfig(ConfigFile config) {
        super(config, "checks.moving.");
        this.ignoreCreative = config.getBoolean("checks.moving.creativefly.ignorecreative");
        this.ignoreAllowFlight = config.getBoolean("checks.moving.creativefly.ignoreallowflight");
        this.creativeFlyCheck = config.getBoolean("checks.moving.creativefly.active");
        ModelFlying defaultModel = new ModelFlying("gamemode.creative", (ConfigurationSection)config, "checks.moving.creativefly.model.creative.", new ModelFlying().lock());
        for (GameMode gameMode : GameMode.values()) {
            this.flyingModelGameMode.put(gameMode, new ModelFlying("gamemode." + gameMode.name().toLowerCase(), (ConfigurationSection)config, "checks.moving.creativefly.model." + gameMode.name().toLowerCase() + ".", defaultModel).lock());
        }
        this.flyingModelLevitation = new ModelFlying(ID_POTION_LEVITATION, (ConfigurationSection)config, "checks.moving.creativefly.model.levitation.", new ModelFlying(null, defaultModel).scaleLevitationEffect(true).lock());
        this.flyingModelElytra = new ModelFlying(ID_JETPACK_ELYTRA, (ConfigurationSection)config, "checks.moving.creativefly.model.elytra.", new ModelFlying(null, defaultModel).verticalAscendGliding(true).lock());
        this.creativeFlyActions = (ActionList)config.getOptimizedActionList("checks.moving.creativefly.actions", "nocheatplus.checks.moving.creativefly");
        this.morePacketsCheck = config.getBoolean("checks.moving.morepackets.active");
        this.morePacketsEPSIdeal = config.getInt("checks.moving.morepackets.epsideal");
        this.morePacketsEPSMax = Math.max(this.morePacketsEPSIdeal, (float)config.getInt("checks.moving.morepackets.epsmax"));
        this.morePacketsEPSBuckets = 2 * Math.max(1, Math.min(60, config.getInt("checks.moving.morepackets.seconds")));
        this.morePacketsBurstPackets = config.getInt("checks.moving.morepackets.burst.epmviolation");
        this.morePacketsBurstDirect = config.getInt("checks.moving.morepackets.burst.directviolation");
        this.morePacketsBurstEPM = config.getInt("checks.moving.morepackets.burst.epmviolation");
        this.morePacketsSetBackAge = config.getInt("checks.moving.morepackets.setbackage");
        this.morePacketsActions = (ActionList)config.getOptimizedActionList("checks.moving.morepackets.actions", "nocheatplus.checks.moving.morepackets");
        this.noFallCheck = config.getBoolean("checks.moving.nofall.active");
        this.noFallDealDamage = config.getBoolean("checks.moving.nofall.dealdamage");
        this.noFallSkipAllowFlight = config.getBoolean("checks.moving.nofall.skipallowflight");
        this.noFallViolationReset = config.getBoolean("checks.moving.nofall.resetonviolation");
        this.noFallTpReset = config.getBoolean("checks.moving.nofall.resetonteleport");
        this.noFallVehicleReset = config.getBoolean("checks.moving.nofall.resetonvehicle");
        this.noFallAntiCriticals = config.getBoolean("checks.moving.nofall.anticriticals");
        this.noFallActions = (ActionList)config.getOptimizedActionList("checks.moving.nofall.actions", "nocheatplus.checks.moving.nofall");
        this.passableCheck = config.getBoolean("checks.moving.passable.active");
        this.passableActions = (ActionList)config.getOptimizedActionList("checks.moving.passable.actions", "nocheatplus.checks.moving.passable");
        this.passableUntrackedTeleportCheck = config.getBoolean("checks.moving.passable.untracked.teleport.active");
        this.passableUntrackedCommandCheck = config.getBoolean("checks.moving.passable.untracked.command.active");
        this.passableUntrackedCommandTryTeleport = config.getBoolean("checks.moving.passable.untracked.command.tryteleport");
        CommandUtil.feedCommands(this.passableUntrackedCommandPrefixes, config, "checks.moving.passable.untracked.command.prefixes", true);
        this.survivalFlyCheck = config.getBoolean("checks.moving.survivalfly.active");
        this.survivalFlyBlockingSpeed = config.getInt("checks.moving.survivalfly.blockingspeed", 100);
        this.survivalFlySneakingSpeed = config.getInt("checks.moving.survivalfly.sneakingspeed", 100);
        this.survivalFlySpeedingSpeed = config.getInt("checks.moving.survivalfly.speedingspeed", 200);
        this.survivalFlySprintingSpeed = config.getInt("checks.moving.survivalfly.sprintingspeed", 100);
        this.survivalFlySwimmingSpeed = config.getInt("checks.moving.survivalfly.swimmingspeed", 100);
        this.survivalFlyWalkingSpeed = config.getInt("checks.moving.survivalfly.walkingspeed", 100);
        this.survivalFlyCobwebHack = config.getBoolean("checks.moving.survivalfly.cobwebhack", true);
        this.sfSlownessSprintHack = config.getAlmostBoolean("checks.moving.survivalfly.slownesssprinthack", AlmostBoolean.MAYBE).decideOptimistically();
        this.sfGroundHop = config.getBoolean("checks.moving.survivalfly.groundhop", ServerVersion.compareMinecraftVersion("1.7") == -1);
        this.survivalFlyAccountingH = config.getBoolean("checks.moving.survivalfly.extended.horizontal-accounting", false);
        this.survivalFlyAccountingV = config.getBoolean("checks.moving.survivalfly.extended.vertical-accounting");
        this.sfSetBackPolicyFallDamage = config.getBoolean("checks.moving.survivalfly.setbackpolicy.falldamage");
        this.sfSetBackPolicyVoid = config.getBoolean("checks.moving.survivalfly.setbackpolicy.voidtovoid");
        double sfStepHeight = config.getDouble("checks.moving.survivalfly.stepheight", Double.MAX_VALUE);
        if (sfStepHeight == Double.MAX_VALUE) {
            String ref = Bukkit.getVersion().toLowerCase().indexOf("spigot") != -1 ? "1.7.10" : "1.8";
            this.sfStepHeight = ServerVersion.select(ref, 0.5, 0.6, 0.6, 0.5);
        } else {
            this.sfStepHeight = sfStepHeight;
        }
        this.survivalFlyVLFreeze = config.getLong("checks.moving.survivalfly.vlfreeze", 2000L);
        this.survivalFlyActions = (ActionList)config.getOptimizedActionList("checks.moving.survivalfly.actions", "nocheatplus.checks.moving.survivalfly");
        this.sfHoverCheck = config.getBoolean("checks.moving.survivalfly.hover.active");
        this.sfHoverTicks = config.getInt("checks.moving.survivalfly.hover.ticks");
        this.sfHoverLoginTicks = Math.max(0, config.getInt("checks.moving.survivalfly.hover.loginticks"));
        this.sfHoverFallDamage = config.getBoolean("checks.moving.survivalfly.hover.falldamage");
        this.sfHoverViolation = config.getDouble("checks.moving.survivalfly.hover.sfviolation");
        this.hBufMax = config.getDouble("checks.moving.survivalfly.hbufmax");
        this.velocityActivationCounter = config.getInt("checks.moving.velocity.activationcounter");
        this.velocityActivationTicks = config.getInt("checks.moving.velocity.activationticks");
        this.velocityStrictInvalidation = config.getBoolean("checks.moving.velocity.strictinvalidation");
        this.yOnGround = config.getDouble("checks.moving.yonground", 1.0E-5, 0.0626, 0.016);
        this.noFallyOnGround = config.getDouble("checks.moving.nofall.yonground", 1.0E-5, 0.0626, this.yOnGround);
        AlmostBoolean refSplitMoves = config.getAlmostBoolean("checks.moving.splitmoves", AlmostBoolean.MAYBE);
        this.splitMoves = refSplitMoves.decideOptimistically();
        AlmostBoolean refIgnoreStance = config.getAlmostBoolean("checks.moving.ignorestance", AlmostBoolean.MAYBE);
        this.ignoreStance = refIgnoreStance == AlmostBoolean.MAYBE ? ServerVersion.compareMinecraftVersion("1.8") >= 0 : refIgnoreStance.decide();
        this.tempKickIllegal = config.getBoolean("checks.moving.tempkickillegal");
        this.loadChunksOnJoin = config.getBoolean("checks.moving.loadchunks.join");
        this.loadChunksOnMove = config.getBoolean("checks.moving.loadchunks.move");
        this.loadChunksOnTeleport = config.getBoolean("checks.moving.loadchunks.teleport");
        this.loadChunksOnWorldChange = config.getBoolean("checks.moving.loadchunks.worldchange");
        this.sprintingGrace = Math.max(0L, (long)(config.getDouble("checks.moving.sprintinggrace") * 1000.0));
        this.assumeSprint = config.getBoolean("checks.moving.assumesprint");
        this.speedGrace = Math.max(0, (int)Math.round(config.getDouble("checks.moving.speedgrace") * 20.0));
        AlmostBoolean ref = config.getAlmostBoolean("checks.moving.enforcelocation", AlmostBoolean.MAYBE);
        this.enforceLocation = ref == AlmostBoolean.MAYBE ? Bugs.shouldEnforceLocation() : ref.decide();
        this.trackBlockMove = config.getBoolean("compatibility.blocks.changetracker.active") && config.getBoolean("compatibility.blocks.changetracker.pistons");
        PlayerSetBackMethod playerSetBackMethod = PlayerSetBackMethod.fromString("extern.fromconfig", config.getString("checks.moving.setback.method"));
        this.playerSetBackMethod = playerSetBackMethod.doesThisMakeSense() ? playerSetBackMethod : (ServerVersion.compareMinecraftVersion("1.9") < 0 ? PlayerSetBackMethod.LEGACY : PlayerSetBackMethod.MODERN);
        this.traceMaxAge = config.getInt("checks.moving.trace.maxage", 200);
        this.traceMaxSize = config.getInt("checks.moving.trace.maxsize", 200);
        ref = config.getAlmostBoolean("checks.moving.vehicle.enforcelocation", AlmostBoolean.MAYBE);
        this.vehicleEnforceLocation = ref.decideOptimistically();
        this.vehiclePreventDestroyOwn = config.getBoolean("checks.moving.vehicle.preventdestroyown");
        this.scheduleVehicleSetBacks = config.getAlmostBoolean("checks.moving.vehicle.schedulesetbacks", AlmostBoolean.MAYBE).decide();
        this.vehicleMorePacketsCheck = config.getBoolean("checks.moving.vehicle.morepackets.active");
        this.vehicleMorePacketsActions = (ActionList)config.getOptimizedActionList("checks.moving.vehicle.morepackets.actions", "nocheatplus.checks.moving.morepackets");
        ref = config.getAlmostBoolean("checks.moving.vehicle.envelope.active", AlmostBoolean.MAYBE);
        this.vehicleEnvelopeActive = ref == AlmostBoolean.MAYBE ? ServerVersion.compareMinecraftVersion("1.9") >= 0 : ref.decide();
        config.readDoubleValuesForEntityTypes("checks.moving.vehicle.envelope.hdistcap", this.vehicleEnvelopeHorizontalSpeedCap, 4.0, true);
        this.vehicleEnvelopeActions = (ActionList)config.getOptimizedActionList("checks.moving.vehicle.envelope.actions", "nocheatplus.checks.moving.vehicle.envelope");
        List<String> types = config.get("checks.moving.vehicle.ignoredvehicles") == null ? Arrays.asList("arrow", "spectral_arrow", "tipped_arrow") : config.getStringList("checks.moving.vehicle.ignoredvehicles");
        for (String stype : types) {
            try {
                EntityType type = EntityType.valueOf((String)stype.toUpperCase());
                if (type == null) continue;
                this.ignoredVehicles.add(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.msgKickIllegalMove = ColorUtil.replaceColors(config.getString("checks.moving.message.illegalplayermove"));
        this.msgKickIllegalVehicleMove = ColorUtil.replaceColors(config.getString("checks.moving.message.illegalvehiclemove"));
    }

    @Override
    public final boolean isEnabled(CheckType checkType) {
        switch (checkType) {
            case MOVING_NOFALL: {
                return this.noFallCheck;
            }
            case MOVING_SURVIVALFLY: {
                return this.survivalFlyCheck;
            }
            case MOVING_PASSABLE: {
                return this.passableCheck;
            }
            case MOVING_MOREPACKETS: {
                return this.morePacketsCheck;
            }
            case MOVING_VEHICLE_MOREPACKETS: {
                return this.vehicleMorePacketsCheck;
            }
            case MOVING_VEHICLE_ENVELOPE: {
                return this.vehicleEnvelopeActive;
            }
            case MOVING_CREATIVEFLY: {
                return this.creativeFlyCheck;
            }
        }
        return true;
    }

    @Deprecated
    public ModelFlying getModelFlying(Player player, PlayerLocation fromLocation) {
        return this.getModelFlying(player, fromLocation, MovingData.getData(player), MovingConfig.getConfig(player));
    }

    public ModelFlying getModelFlying(Player player, PlayerLocation fromLocation, MovingData data, MovingConfig cc) {
        boolean isGlidingWithElytra;
        GameMode gameMode = player.getGameMode();
        ModelFlying modelGameMode = this.flyingModelGameMode.get(gameMode);
        switch (gameMode) {
            case SURVIVAL: 
            case ADVENTURE: 
            case CREATIVE: {
                break;
            }
            default: {
                return modelGameMode;
            }
        }
        boolean bl = isGlidingWithElytra = Bridge1_9.isGlidingWithElytra(player) && MovingUtil.isGlidingWithElytraValid(player, fromLocation, data, cc);
        if (player.isFlying() || !isGlidingWithElytra && !this.ignoreAllowFlight && player.getAllowFlight()) {
            return modelGameMode;
        }
        if (isGlidingWithElytra) {
            return this.flyingModelElytra;
        }
        if (gameMode != GameMode.CREATIVE && !Double.isInfinite(Bridge1_9.getLevitationAmplifier(player)) && !fromLocation.isInLiquid()) {
            return this.flyingModelLevitation;
        }
        return modelGameMode;
    }
}

