/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.fight.ReachContext;
import fr.neatmonster.nocheatplus.checks.moving.location.tracking.LocationTrace;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Giant;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Reach
extends Check {
    public static final double CREATIVE_DISTANCE = 6.0;

    private static double getDistMod(Entity damaged) {
        if (damaged instanceof EnderDragon) {
            return 6.5;
        }
        if (damaged instanceof Giant) {
            return 1.5;
        }
        return 0.0;
    }

    public Reach() {
        super(CheckType.FIGHT_REACH);
    }

    public boolean check(Player player, Location pLoc, Entity damaged, boolean damagedIsFake, Location dRef, FightData data, FightConfig cc) {
        boolean cancel = false;
        double SURVIVAL_DISTANCE = cc.reachSurvivalDistance;
        double DYNAMIC_RANGE = cc.reachReduceDistance;
        double DYNAMIC_STEP = cc.reachReduceStep / SURVIVAL_DISTANCE;
        double distanceLimit = player.getGameMode() == GameMode.CREATIVE ? 6.0 : SURVIVAL_DISTANCE + Reach.getDistMod(damaged);
        double distanceMin = (distanceLimit - DYNAMIC_RANGE) / distanceLimit;
        double height = damagedIsFake ? (damaged instanceof LivingEntity ? ((LivingEntity)damaged).getEyeHeight() : 1.75) : ((MCAccess)this.mcAccess.getHandle()).getHeight(damaged);
        double pY = pLoc.getY() + player.getEyeHeight();
        double dY = dRef.getY();
        if (!(pY <= dY)) {
            if (pY >= dY + height) {
                dRef.setY(dY + height);
            } else {
                dRef.setY(pY);
            }
        }
        Vector pRel = dRef.toVector().subtract(pLoc.toVector().setY(pY));
        double lenpRel = pRel.length();
        double violation = lenpRel - distanceLimit;
        double reachMod = data.reachMod;
        if (violation > 0.0) {
            if (TickTask.getLag(1000L, true) < 1.5f) {
                data.reachVL += violation;
            }
            cancel = this.executeActions(player, data.reachVL, violation, cc.reachActions).willCancel();
            if (Improbable.check(player, (float)violation / 2.0f, System.currentTimeMillis(), "fight.reach")) {
                cancel = true;
            }
            if (cancel && cc.reachPenalty > 0L) {
                data.attackPenalty.applyPenalty(cc.reachPenalty);
            }
        } else if (lenpRel - distanceLimit * reachMod > 0.0) {
            if (cc.reachPenalty > 0L) {
                data.attackPenalty.applyPenalty(cc.reachPenalty / 2L);
            }
            cancel = true;
            Improbable.feed(player, (float)(lenpRel - distanceLimit * reachMod) / 4.0f, System.currentTimeMillis());
        } else {
            data.reachVL *= 0.8;
        }
        data.reachMod = !cc.reachReduce ? 1.0 : (lenpRel > distanceLimit - DYNAMIC_RANGE ? Math.max(distanceMin, data.reachMod - DYNAMIC_STEP) : Math.min(1.0, data.reachMod + DYNAMIC_STEP));
        if (data.debug && player.hasPermission("nocheatplus.admin.debug")) {
            player.sendMessage("NC+: Attack/reach " + damaged.getType() + " height=" + StringUtil.fdec3.format(height) + " dist=" + StringUtil.fdec3.format(lenpRel) + " @" + StringUtil.fdec3.format(reachMod));
        }
        return cancel;
    }

    public ReachContext getContext(Player player, Location pLoc, Entity damaged, Location damagedLoc, FightData data, FightConfig cc) {
        ReachContext context = new ReachContext();
        context.distanceLimit = player.getGameMode() == GameMode.CREATIVE ? 6.0 : cc.reachSurvivalDistance + Reach.getDistMod(damaged);
        context.distanceMin = (context.distanceLimit - cc.reachReduceDistance) / context.distanceLimit;
        context.pY = pLoc.getY() + player.getEyeHeight();
        return context;
    }

    public boolean loopCheck(Player player, Location pLoc, Entity damaged, LocationTrace.ITraceEntry dRef, ReachContext context, FightData data, FightConfig cc) {
        double lenpRel;
        double violation;
        boolean cancel = false;
        double dY = dRef.getY();
        double y = dRef.getY();
        if (!(context.pY <= dY)) {
            y = context.pY >= dY + dRef.getBoxMarginVertical() ? dY + dRef.getBoxMarginVertical() : context.pY;
        }
        if ((violation = (lenpRel = TrigUtil.distance(dRef.getX(), y, dRef.getZ(), pLoc.getX(), context.pY, pLoc.getZ())) - context.distanceLimit) > 0.0 || lenpRel - context.distanceLimit * data.reachMod > 0.0) {
            context.minViolation = Math.min(context.minViolation, lenpRel);
            cancel = true;
        }
        context.minResult = Math.min(context.minResult, lenpRel);
        return cancel;
    }

    public boolean loopFinish(Player player, Location pLoc, Entity damaged, ReachContext context, LocationTrace.ITraceEntry traceEntry, boolean forceViolation, FightData data, FightConfig cc) {
        double lenpRel;
        double d = lenpRel = forceViolation && context.minViolation != Double.MAX_VALUE ? context.minViolation : context.minResult;
        if (lenpRel == Double.MAX_VALUE) {
            return false;
        }
        double violation = lenpRel - context.distanceLimit;
        boolean cancel = false;
        if (violation > 0.0) {
            if (TickTask.getLag(1000L, true) < 1.5f) {
                data.reachVL += violation;
            }
            cancel = this.executeActions(player, data.reachVL, violation, cc.reachActions).willCancel();
            if (Improbable.check(player, (float)violation / 2.0f, System.currentTimeMillis(), "fight.reach")) {
                cancel = true;
            }
            if (cancel && cc.reachPenalty > 0L) {
                data.attackPenalty.applyPenalty(cc.reachPenalty);
            }
        } else if (lenpRel - context.distanceLimit * data.reachMod > 0.0) {
            if (cc.reachPenalty > 0L) {
                data.attackPenalty.applyPenalty(cc.reachPenalty / 2L);
            }
            cancel = true;
            Improbable.feed(player, (float)(lenpRel - context.distanceLimit * data.reachMod) / 4.0f, System.currentTimeMillis());
        } else {
            data.reachVL *= 0.8;
        }
        double DYNAMIC_STEP = cc.reachReduceStep / cc.reachSurvivalDistance;
        data.reachMod = !cc.reachReduce ? 1.0 : (lenpRel > context.distanceLimit - cc.reachReduceDistance ? Math.max(context.distanceMin, data.reachMod - DYNAMIC_STEP) : Math.min(1.0, data.reachMod + DYNAMIC_STEP));
        if (data.debug && player.hasPermission("nocheatplus.admin.debug")) {
            player.sendMessage("NC+: Attack/reach " + damaged.getType() + (traceEntry == null ? "" : " height=" + traceEntry.getBoxMarginVertical()) + " dist=" + StringUtil.fdec3.format(lenpRel) + " @" + StringUtil.fdec3.format(data.reachMod));
        }
        return cancel;
    }
}

