/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class Against
extends Check {
    public Against() {
        super(CheckType.BLOCKPLACE_AGAINST);
    }

    public boolean check(Player player, Block block, Material placedMat, Block blockAgainst, boolean isInteractBlock, BlockPlaceData data, BlockPlaceConfig cc) {
        boolean violation = false;
        BlockInteractData bdata = BlockInteractData.getData(player);
        Material againstType = blockAgainst.getType();
        if (bdata.isConsumedCheck(this.type) && !bdata.isPassedCheck(this.type)) {
            violation = true;
            if (data.debug) {
                this.debug(player, "Cancel due to block having been consumed by this check.");
            }
        } else if (BlockProperties.isAir(againstType)) {
            Material matAgainst = bdata.getLastType();
            if ((!isInteractBlock || BlockProperties.isAir(matAgainst) || BlockProperties.isLiquid(matAgainst)) && !player.hasPermission("nocheatplus.checks.blockplace.against.air")) {
                violation = true;
            }
        } else if (!(!BlockProperties.isLiquid(againstType) || placedMat == Material.WATER_LILY && BlockProperties.isLiquid(block.getRelative(BlockFace.DOWN).getType()) || player.hasPermission("nocheatplus.checks.blockplace.against.liquids"))) {
            violation = true;
        }
        bdata.addConsumedCheck(this.type);
        if (violation) {
            data.againstVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.againstVL, 1.0, cc.againstActions);
            vd.setParameter(ParameterName.BLOCK_TYPE, placedMat.toString());
            return this.executeActions(vd).willCancel();
        }
        data.againstVL *= 0.99;
        bdata.addPassedCheck(this.type);
        return false;
    }
}

