/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueLookBlockChecker;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.collision.InteractRayTracing;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.WrapBlockCache;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.util.Vector;

public class Visible
extends Check {
    private final WrapBlockCache wrapBlockCache;
    private final InteractRayTracing rayTracing = new InteractRayTracing(false);
    private final RayChecker checker = new RayChecker();
    private final List<String> tags = new ArrayList<String>();
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public Visible() {
        super(CheckType.BLOCKINTERACT_VISIBLE);
        this.wrapBlockCache = new WrapBlockCache();
        this.rayTracing.setMaxSteps(60);
    }

    public boolean check(Player player, Location loc, double eyeHeight, Block block, BlockFace face, Action action, FlyingQueueHandle flyingHandle, BlockInteractData data, BlockInteractConfig cc) {
        boolean collides;
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        double eyeX = loc.getX();
        double eyeY = loc.getY() + eyeHeight;
        double eyeZ = loc.getZ();
        this.tags.clear();
        if (TrigUtil.isSameBlock(blockX, blockY, blockZ, eyeX, eyeY, eyeZ)) {
            collides = false;
        } else {
            BlockCache blockCache = this.wrapBlockCache.getBlockCache();
            blockCache.setAccess(loc.getWorld());
            this.rayTracing.setBlockCache(blockCache);
            collides = !this.checker.checkFlyingQueue(eyeX, eyeY, eyeZ, loc.getYaw(), loc.getPitch(), blockX, blockY, blockZ, flyingHandle, face, this.tags, data.debug, player);
            this.checker.cleanup();
            this.useLoc.setWorld(null);
            this.rayTracing.cleanup();
            blockCache.cleanup();
        }
        boolean cancel = false;
        if (collides) {
            data.visibleVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.visibleVL, 1.0, cc.visibleActions);
            if (this.executeActions(vd).willCancel()) {
                cancel = true;
            }
        } else {
            data.visibleVL *= 0.99;
            data.addPassedCheck(this.type);
            if (data.debug) {
                this.debug(player, "pitch=" + loc.getPitch() + ",yaw=" + loc.getYaw() + " tags=" + StringUtil.join(this.tags, "+"));
            }
        }
        return cancel;
    }

    private boolean checkRayTracing(double eyeX, double eyeY, double eyeZ, double dirX, double dirY, double dirZ, int blockX, int blockY, int blockZ, BlockFace face, List<String> tags, boolean debug) {
        boolean collides;
        double collideZ;
        double collideY;
        int eyeBlockX = Location.locToBlock((double)eyeX);
        int eyeBlockY = Location.locToBlock((double)eyeY);
        int eyeBlockZ = Location.locToBlock((double)eyeZ);
        int bdX = blockX - eyeBlockX;
        int bdY = blockY - eyeBlockY;
        int bdZ = blockZ - eyeBlockZ;
        double tMinX = this.getMinTime(eyeX, eyeBlockX, dirX, bdX);
        double tMinY = this.getMinTime(eyeY, eyeBlockY, dirY, bdY);
        double tMinZ = this.getMinTime(eyeZ, eyeBlockZ, dirZ, bdZ);
        double tMaxX = this.getMaxTime(eyeX, eyeBlockX, dirX, tMinX);
        double tMaxY = this.getMaxTime(eyeY, eyeBlockY, dirY, tMinY);
        double tMaxZ = this.getMaxTime(eyeZ, eyeBlockZ, dirZ, tMinZ);
        double tCollide = Math.max(0.0, Math.max(tMinX, Math.max(tMinY, tMinZ)));
        double collideX = this.toBlock(eyeX + dirX * tCollide, blockX);
        if (TrigUtil.distanceSquared(0.5 + (double)blockX, 0.5 + (double)blockY, 0.5 + (double)blockZ, collideX, collideY = this.toBlock(eyeY + dirY * tCollide, blockY), collideZ = this.toBlock(eyeZ + dirZ * tCollide, blockZ)) > 0.75) {
            tags.add("early_block_miss");
        }
        if (tMinX > tMaxY && tMinX > tMaxZ || tMinY > tMaxX && tMinY > tMaxZ || tMinZ > tMaxX && tMaxZ > tMaxY) {
            tags.add("time_miss");
            collideX = this.postCorrect(blockX, bdX, collideX);
            collideY = this.postCorrect(blockY, bdY, collideY);
            collideZ = this.postCorrect(blockZ, bdZ, collideZ);
        }
        if (tMinX == tCollide) {
            collideX = Math.round(collideX);
        }
        if (tMinY == tCollide) {
            collideY = Math.round(collideY);
        }
        if (tMinZ == tCollide) {
            collideZ = Math.round(collideZ);
        }
        if (TrigUtil.distanceSquared(0.5 + (double)blockX, 0.5 + (double)blockY, 0.5 + (double)blockZ, collideX, collideY, collideZ) > 0.75) {
            tags.add("late_block_miss");
        }
        this.rayTracing.set(eyeX, eyeY, eyeZ, collideX, collideY, collideZ, blockX, blockY, blockZ);
        this.rayTracing.loop();
        if (this.rayTracing.collides()) {
            tags.add("raytracing");
            collides = true;
        } else if (this.rayTracing.getStepsDone() > this.rayTracing.getMaxSteps()) {
            tags.add("raytracing_maxsteps");
            collides = true;
        } else {
            collides = false;
        }
        if (!collides || debug) {
            // empty if block
        }
        return collides;
    }

    private double postCorrect(int blockC, int bdC, double collideC) {
        int ref;
        int n = ref = bdC < 0 ? blockC + 1 : blockC;
        if (Location.locToBlock((double)collideC) == ref) {
            return collideC;
        }
        return ref;
    }

    private double getMinTime(double eye, int eyeBlock, double dir, int blockDiff) {
        if (blockDiff == 0) {
            return 0.0;
        }
        double eyeOffset = Math.abs(eye - (double)eyeBlock);
        return ((dir < 0.0 ? eyeOffset : 1.0 - eyeOffset) + (double)(Math.abs(blockDiff) - 1)) / Math.abs(dir);
    }

    private double getMaxTime(double eye, int eyeBlock, double dir, double tMin) {
        if (dir == 0.0) {
            return Double.MAX_VALUE;
        }
        if (tMin == 0.0) {
            double eyeOffset = Math.abs(eye - (double)eyeBlock);
            return (dir < 0.0 ? eyeOffset : 1.0 - eyeOffset) / Math.abs(dir);
        }
        return tMin + 1.0 / Math.abs(dir);
    }

    private double toBlock(double coord, int block) {
        int blockDiff = block - Location.locToBlock((double)coord);
        if (blockDiff == 0) {
            return coord;
        }
        return Math.round(coord);
    }

    private final class RayChecker
    extends FlyingQueueLookBlockChecker {
        private BlockFace face;
        private List<String> tags;
        private boolean debug;
        private Player player;

        private RayChecker() {
        }

        @Override
        protected boolean check(double x, double y, double z, float yaw, float pitch, int blockX, int blockY, int blockZ) {
            Visible.this.useLoc.setPitch(pitch);
            Visible.this.useLoc.setYaw(yaw);
            Vector direction = Visible.this.useLoc.getDirection();
            this.tags.clear();
            if (Visible.this.checkRayTracing(x, y, z, direction.getX(), direction.getY(), direction.getZ(), blockX, blockY, blockZ, this.face, this.tags, this.debug)) {
                if (this.debug) {
                    Visible.this.debug(this.player, "pitch=" + pitch + ",yaw=" + yaw + " tags=" + StringUtil.join(this.tags, "+"));
                }
                return false;
            }
            return true;
        }

        public boolean checkFlyingQueue(double x, double y, double z, float oldYaw, float oldPitch, int blockX, int blockY, int blockZ, FlyingQueueHandle flyingHandle, BlockFace face, List<String> tags, boolean debug, Player player) {
            this.face = face;
            this.tags = tags;
            this.debug = debug;
            this.player = player;
            return super.checkFlyingQueue(x, y, z, oldYaw, oldPitch, blockX, blockY, blockZ, flyingHandle);
        }

        @Override
        public boolean checkFlyingQueue(double x, double y, double z, float oldYaw, float oldPitch, int blockX, int blockY, int blockZ, FlyingQueueHandle flyingHandle) {
            throw new UnsupportedOperationException("Use the other method.");
        }

        public void cleanup() {
            this.player = null;
            this.face = null;
            this.debug = false;
            this.tags = null;
        }
    }
}

