/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockinteract.Direction;
import fr.neatmonster.nocheatplus.checks.blockinteract.Reach;
import fr.neatmonster.nocheatplus.checks.blockinteract.Speed;
import fr.neatmonster.nocheatplus.checks.blockinteract.Visible;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.InventoryUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class BlockInteractListener
extends CheckListener {
    private final Direction direction = this.addCheck(new Direction());
    private final Reach reach = this.addCheck(new Reach());
    private final Visible visible = this.addCheck(new Visible());
    private final Speed speed = this.addCheck(new Speed());
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("cancel.dead");
    private final int idCancelOffline = this.counters.registerKey("cancel.offline");
    private final int idInteractLookCurrent = this.counters.registerKey("block.interact.look.current");
    private final int idInteractLookFlyingFirst = this.counters.registerKey("block.interact.look.flying.first");
    private final int idInteractLookFlyingOther = this.counters.registerKey("block.interact.look.flying.other");

    public static void debugBlockVSBlockInteract(Player player, CheckType checkType, Block block, String prefix, Action expectedAction) {
        String msg;
        BlockInteractData bdata = BlockInteractData.getData(player);
        int manhattan = bdata.manhattanLastBlock(block);
        if (manhattan == Integer.MAX_VALUE) {
            msg = "no last block set!";
        } else {
            String string = msg = manhattan == 0 ? "same as last block." : "last block differs, Manhattan: " + manhattan;
            if (bdata.getLastIsCancelled()) {
                msg = msg + " / cancelled";
            }
            if (bdata.getLastAction() != expectedAction) {
                msg = msg + " / action=" + bdata.getLastAction();
            }
        }
        CheckUtils.debug(player, checkType, prefix + " BlockInteract: " + msg);
    }

    public BlockInteractListener() {
        super(CheckType.BLOCKINTERACT);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        BlockInteractData data = BlockInteractData.getData(player);
        data.resetLastBlock();
        int cancelId = player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0 ? this.idCancelDead : (!player.isOnline() ? this.idCancelOffline : (MovingUtil.hasScheduledPlayerSetBack(player) ? -1 : Integer.MIN_VALUE));
        if (cancelId != Integer.MIN_VALUE) {
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setUseItemInHand(Event.Result.DENY);
            event.setCancelled(true);
            data.setPlayerInteractEventResolution(event);
            if (cancelId >= 0) {
                this.counters.addPrimaryThread(cancelId, 1);
            }
            return;
        }
        Action action = event.getAction();
        Block block = event.getClickedBlock();
        int previousLastTick = data.getLastTick();
        boolean blockChecks = true;
        if (block == null) {
            data.resetLastBlock();
            blockChecks = false;
        } else {
            data.setLastBlock(block, action);
        }
        BlockFace face = event.getBlockFace();
        switch (action) {
            case RIGHT_CLICK_AIR: 
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: {
                Object stack = null;
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                ItemStack stack = Bridge1_9.getUsedItem(player, event);
                if (stack == null || stack.getType() != Material.ENDER_PEARL) break;
                this.checkEnderPearlRightClickBlock(player, block, face, event, previousLastTick, data);
                break;
            }
            default: {
                data.setPlayerInteractEventResolution(event);
                return;
            }
        }
        boolean cancelled = false;
        if (event.isCancelled() && event.useInteractedBlock() != Event.Result.ALLOW) {
            if (event.useItemInHand() == Event.Result.ALLOW) {
                blockChecks = false;
            } else {
                data.setPlayerInteractEventResolution(event);
                return;
            }
        }
        BlockInteractConfig cc = BlockInteractConfig.getConfig(player);
        boolean preventUseItem = false;
        Location loc = player.getLocation(this.useLoc);
        FlyingQueueHandle flyingHandle = new FlyingQueueHandle(player);
        if (!cancelled && this.speed.isEnabled(player) && this.speed.check(player, data, cc)) {
            cancelled = true;
            preventUseItem = true;
        }
        if (blockChecks) {
            double eyeHeight = MovingUtil.getEyeHeight(player);
            if (!cancelled && this.reach.isEnabled(player) && this.reach.check(player, loc, eyeHeight, block, data, cc)) {
                cancelled = true;
            }
            if (!cancelled && this.direction.isEnabled(player) && this.direction.check(player, loc, eyeHeight, block, flyingHandle, data, cc)) {
                cancelled = true;
            }
            if (!cancelled && this.visible.isEnabled(player) && this.visible.check(player, loc, eyeHeight, block, face, action, flyingHandle, data, cc)) {
                cancelled = true;
            }
        }
        if (cancelled) {
            this.onCancelInteract(player, block, face, event, previousLastTick, preventUseItem, data, cc);
        } else if (flyingHandle.isFlyingQueueFetched()) {
            int flyingIndex = flyingHandle.getFirstIndexWithContentIfFetched();
            Integer cId = flyingIndex == 0 ? Integer.valueOf(this.idInteractLookFlyingFirst) : Integer.valueOf(this.idInteractLookFlyingOther);
            this.counters.add(cId, 1);
            if (data.debug) {
                this.logUsedFlyingPacket(player, flyingHandle, flyingIndex);
            }
        } else {
            this.counters.addPrimaryThread(this.idInteractLookCurrent, 1);
        }
        data.setPlayerInteractEventResolution(event);
        this.useLoc.setWorld(null);
    }

    private void logUsedFlyingPacket(Player player, FlyingQueueHandle flyingHandle, int flyingIndex) {
        DataPacketFlying packet = flyingHandle.getIfFetched(flyingIndex);
        if (packet != null) {
            this.debug(player, "Flying packet queue used at index " + flyingIndex + ": pitch=" + packet.getPitch() + ",yaw=" + packet.getYaw());
            return;
        }
    }

    private void onCancelInteract(Player player, Block block, BlockFace face, PlayerInteractEvent event, int previousLastTick, boolean preventUseItem, BlockInteractData data, BlockInteractConfig cc) {
        if (event.isCancelled()) {
            event.setUseInteractedBlock(Event.Result.DENY);
            if (data.debug) {
                this.genericDebug(player, block, face, event, "already cancelled: deny use block", previousLastTick, data, cc);
            }
        } else {
            Event.Result previousUseItem = event.useItemInHand();
            event.setCancelled(true);
            event.setUseInteractedBlock(Event.Result.DENY);
            if (previousUseItem == Event.Result.DENY || preventUseItem || !InventoryUtil.isConsumable(Bridge1_9.getUsedItem(player, event))) {
                event.setUseItemInHand(Event.Result.DENY);
                if (data.debug) {
                    this.genericDebug(player, block, face, event, "deny item use", previousLastTick, data, cc);
                }
            } else {
                event.setUseItemInHand(Event.Result.ALLOW);
                if (data.debug) {
                    this.genericDebug(player, block, face, event, "allow edible item use", previousLastTick, data, cc);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onPlayerInteractMonitor(PlayerInteractEvent event) {
        ItemStack stack;
        Player player = event.getPlayer();
        BlockInteractData data = BlockInteractData.getData(player);
        data.setPlayerInteractEventResolution(event);
        if (event.getAction() == Action.RIGHT_CLICK_AIR && event.isCancelled() && event.useItemInHand() != Event.Result.DENY && (stack = Bridge1_9.getUsedItem(player, event)) != null && BridgeMisc.maybeElytraBoost(player, stack.getType())) {
            int ticks;
            int power = BridgeMisc.getFireworksPower(stack);
            MovingData mData = MovingData.getData(player);
            mData.fireworksBoostDuration = ticks = Math.max((1 + power) * 20, 30);
            mData.fireworksBoostTickExpire = TickTask.getTick() + ticks;
            if (data.debug) {
                this.debug(player, "Elytra boost (power " + power + "): " + stack);
            }
        }
    }

    private void checkEnderPearlRightClickBlock(Player player, Block block, BlockFace face, PlayerInteractEvent event, int previousLastTick, BlockInteractData data) {
        if (block == null || !BlockProperties.isPassable(block.getType())) {
            CombinedConfig ccc = CombinedConfig.getConfig(player);
            if (ccc.enderPearlCheck && ccc.enderPearlPreventClickBlock) {
                event.setUseItemInHand(Event.Result.DENY);
                if (data.debug) {
                    BlockInteractConfig cc = BlockInteractConfig.getConfig(player);
                    this.genericDebug(player, block, face, event, "click block: deny use ender pearl", previousLastTick, data, cc);
                }
            }
        }
    }

    private void genericDebug(Player player, Block block, BlockFace face, PlayerInteractEvent event, String tag, int previousLastTick, BlockInteractData data, BlockInteractConfig cc) {
        StringBuilder builder = new StringBuilder(512);
        if (data.getLastTick() == previousLastTick && data.subsequentCancel > 0) {
            ++data.rateLimitSkip;
            return;
        }
        builder.append("Interact cancel: " + event.isCancelled());
        builder.append(" (");
        builder.append(tag);
        if (block == null) {
            builder.append(") block: null");
        } else {
            builder.append(") block: ");
            builder.append(block.getWorld().getName() + "/" + LocUtil.simpleFormat(block));
            builder.append(" type: " + block.getType());
            builder.append(" data: " + BlockProperties.getData(block));
            builder.append(" face: " + face);
        }
        if (data.rateLimitSkip > 0) {
            builder.append(" skipped(rate-limit: " + data.rateLimitSkip);
            data.rateLimitSkip = 0;
        }
        this.debug(player, builder.toString());
    }
}

