/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.actions.types.penalty;

import fr.neatmonster.nocheatplus.actions.types.penalty.Penalty;
import java.util.Collection;
import java.util.Random;

public class PenaltyNode {
    private final Random random;
    public final double probability;
    private final Penalty penalty;
    private final PenaltyNode[] childNodes;
    private final boolean abortOnApply;

    public PenaltyNode(Random random, Penalty penalty) {
        this(random, 1.0, penalty, null, false);
    }

    public PenaltyNode(Random random, double probability, Penalty penalty) {
        this(random, probability, penalty, null, false);
    }

    public PenaltyNode(Random random, double probability, Penalty penalty, Collection<PenaltyNode> childNodes, boolean abortOnApply) {
        this.random = random;
        this.probability = probability;
        this.penalty = penalty;
        this.childNodes = childNodes == null ? new PenaltyNode[]{} : childNodes.toArray(new PenaltyNode[childNodes.size()]);
        this.abortOnApply = abortOnApply;
    }

    public boolean evaluate(Collection<Penalty> results) {
        if (this.probability < 1.0 && this.random.nextDouble() > this.probability) {
            return false;
        }
        if (this.penalty != null) {
            results.add(this.penalty);
        }
        for (int i = 0; !(i >= this.childNodes.length || this.childNodes[i].evaluate(results) && this.abortOnApply); ++i) {
        }
        return true;
    }
}

