/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.BlockPropertiesSetup;
import fr.neatmonster.nocheatplus.compat.blocks.init.vanilla.VanillaBlocksFactory;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.config.RawConfigFile;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.collision.BlockPositionContainer;
import fr.neatmonster.nocheatplus.utilities.collision.ICollidePassable;
import fr.neatmonster.nocheatplus.utilities.collision.PassableAxisTracing;
import fr.neatmonster.nocheatplus.utilities.collision.PassableRayTracing;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.WrapBlockCache;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.InputMismatchException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockProperties {
    protected static final double LIQUID_HEIGHT_LOWERED = 8.0000002E7;
    protected static final int maxBlocks = 4096;
    protected static final BlockProps[] blocks = new BlockProps[4096];
    protected static Map<Integer, ToolProps> tools = new LinkedHashMap<Integer, ToolProps>(50, 0.5f);
    public static final long indestructible = Long.MAX_VALUE;
    public static final ToolProps noTool = new ToolProps(ToolType.NONE, MaterialBase.NONE);
    public static final ToolProps woodSword = new ToolProps(ToolType.SWORD, MaterialBase.WOOD);
    public static final ToolProps woodSpade = new ToolProps(ToolType.SPADE, MaterialBase.WOOD);
    public static final ToolProps woodPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.WOOD);
    public static final ToolProps woodAxe = new ToolProps(ToolType.AXE, MaterialBase.WOOD);
    public static final ToolProps stonePickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.STONE);
    public static final ToolProps ironPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.IRON);
    public static final ToolProps diamondPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.DIAMOND);
    public static final long[] instantTimes = BlockProperties.secToMs(0.0);
    public static final long[] leafTimes = BlockProperties.secToMs(0.3);
    public static long[] glassTimes = BlockProperties.secToMs(0.45);
    public static final long[] gravelTimes = BlockProperties.secToMs(0.9, 0.45, 0.25, 0.15, 0.15, 0.1);
    public static long[] railsTimes = BlockProperties.secToMs(1.05, 0.55, 0.3, 0.2, 0.15, 0.1);
    public static final long[] woodTimes = BlockProperties.secToMs(3.0, 1.5, 0.75, 0.5, 0.4, 0.25);
    private static final long[] indestructibleTimes = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
    public static final BlockProps instantType = new BlockProps(noTool, 0.0f, instantTimes);
    public static final BlockProps glassType = new BlockProps(noTool, 0.3f, glassTimes, 2.0f);
    public static final BlockProps gravelType = new BlockProps(woodSpade, 0.6f, gravelTimes);
    public static final BlockProps stoneType = new BlockProps(woodPickaxe, 1.5f);
    public static final BlockProps woodType = new BlockProps(woodAxe, 2.0f, woodTimes);
    public static final BlockProps brickType = new BlockProps(woodPickaxe, 2.0f);
    public static final BlockProps coalType = new BlockProps(woodPickaxe, 3.0f);
    public static final BlockProps goldBlockType = new BlockProps(woodPickaxe, 3.0f, BlockProperties.secToMs(15.0, 7.5, 3.75, 0.7, 0.55, 1.2));
    public static final BlockProps ironBlockType = new BlockProps(woodPickaxe, 5.0f, BlockProperties.secToMs(25.0, 12.5, 2.0, 1.25, 0.95, 2.0));
    public static final BlockProps diamondBlockType = new BlockProps(woodPickaxe, 5.0f, BlockProperties.secToMs(25.0, 12.5, 6.0, 1.25, 0.95, 2.0));
    public static final BlockProps hugeMushroomType = new BlockProps(woodAxe, 0.2f, BlockProperties.secToMs(0.3, 0.15, 0.1, 0.05, 0.05, 0.05));
    public static final BlockProps leafType = new BlockProps(noTool, 0.2f, leafTimes);
    public static final BlockProps sandType = new BlockProps(woodSpade, 0.5f, BlockProperties.secToMs(0.75, 0.4, 0.2, 0.15, 0.1, 0.1));
    public static final BlockProps leverType = new BlockProps(noTool, 0.5f, BlockProperties.secToMs(0.75));
    public static final BlockProps sandStoneType = new BlockProps(woodPickaxe, 0.8f);
    public static final BlockProps chestType = new BlockProps(woodAxe, 2.5f, BlockProperties.secToMs(3.75, 1.9, 0.95, 0.65, 0.5, 0.35));
    public static final BlockProps woodDoorType = new BlockProps(woodAxe, 3.0f, BlockProperties.secToMs(4.5, 2.25, 1.15, 0.75, 0.6, 0.4));
    public static final BlockProps dispenserType = new BlockProps(woodPickaxe, 3.5f);
    public static final BlockProps ironDoorType = new BlockProps(woodPickaxe, 5.0f);
    public static final BlockProps indestructibleType = new BlockProps(noTool, -1.0f, indestructibleTimes);
    private static BlockProps defaultBlockProps = instantType;
    protected static final Material[] instantMat = new Material[]{Material.CROPS, Material.TRIPWIRE_HOOK, Material.TRIPWIRE, Material.TORCH, Material.TNT, Material.SUGAR_CANE_BLOCK, Material.SAPLING, Material.RED_ROSE, Material.YELLOW_FLOWER, Material.REDSTONE_WIRE, Material.REDSTONE_TORCH_ON, Material.REDSTONE_TORCH_OFF, Material.DIODE_BLOCK_ON, Material.DIODE_BLOCK_OFF, Material.PUMPKIN_STEM, Material.NETHER_WARTS, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.MELON_STEM, Material.WATER_LILY, Material.LONG_GRASS, Material.FIRE, Material.DEAD_BUSH, Material.CROPS, Material.COMMAND, Material.FLOWER_POT, Material.CARROT, Material.POTATO};
    private static ICollidePassable rtRay = null;
    private static ICollidePassable rtAxis = null;
    private static WrapBlockCache wrapBlockCache = null;
    private static PlayerLocation pLoc = null;
    protected static final long[] blockFlags = new long[4096];
    public static final long F_STAIRS = 1L;
    public static final long F_LIQUID = 2L;
    public static final long F_SOLID = 4L;
    public static final long F_IGN_PASSABLE = 8L;
    public static final long F_WATER = 16L;
    public static final long F_LAVA = 32L;
    public static final long F_HEIGHT150 = 64L;
    public static final long F_GROUND = 128L;
    public static final long F_HEIGHT100 = 256L;
    public static final long F_CLIMBABLE = 512L;
    public static final long F_VARIABLE = 1024L;
    public static final long F_XZ100 = 2048L;
    public static final long F_GROUND_HEIGHT = 4096L;
    public static final long F_HEIGHT_8SIM_DEC = 8192L;
    public static final long F_HEIGHT_8SIM_INC = 16384L;
    public static final long F_HEIGHT_8_INC = 32768L;
    public static final long F_RAILS = 65536L;
    public static final long F_ICE = 131072L;
    public static final long F_LEAVES = 262144L;
    public static final long F_THIN_FENCE = 524288L;
    public static final long F_COLLIDE_EDGES = 0x100000L;
    public static final long F_THICK_FENCE = 0x200000L;
    public static final long F_PASSABLE_X4 = 0x400000L;
    public static final long F_BOUNCE25 = 0x800000L;
    public static final long F_FACING_LOW3D2_NSWE = 0x1000000L;
    public static final long F_ATTACHED_LOW2_SNEW = 0x2000000L;
    public static final long F_ALLOW_LOWJUMP = 0x4000000L;
    public static final long F_HEIGHT8_1 = 0x8000000L;
    private static boolean specialCaseTrapDoorAboveLadder = false;
    private static final Map<Long, String> flagNameMap = new LinkedHashMap<Long, String>();
    private static final Map<String, Long> nameFlagMap = new LinkedHashMap<String, Long>();
    private static final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    protected static float breakPenaltyInWater;
    protected static float breakPenaltyOffGround;

    public static void init(IHandle<MCAccess> mcAccess, WorldConfigProvider<?> worldConfigProvider) {
        wrapBlockCache = new WrapBlockCache();
        rtRay = new PassableRayTracing();
        rtAxis = new PassableAxisTracing();
        pLoc = new PlayerLocation(mcAccess, null);
        LinkedHashSet<String> blocksFeatures = new LinkedHashSet<String>();
        try {
            BlockProperties.initTools(mcAccess, worldConfigProvider);
            BlockProperties.initBlocks(mcAccess, worldConfigProvider);
            blocksFeatures.add("BlocksMC1_4");
            try {
                blocksFeatures.addAll(new VanillaBlocksFactory().setupVanillaBlocks(worldConfigProvider));
            }
            catch (Throwable t) {
                StaticLog.logSevere("Could not initialize vanilla blocks: " + t.getClass().getSimpleName() + " - " + t.getMessage());
                StaticLog.logSevere(t);
            }
            if (mcAccess instanceof BlockPropertiesSetup) {
                try {
                    ((BlockPropertiesSetup)((Object)mcAccess)).setupBlockProperties(worldConfigProvider);
                    blocksFeatures.add(mcAccess.getClass().getSimpleName());
                }
                catch (Throwable t) {
                    StaticLog.logSevere("McAccess.setupBlockProperties (" + mcAccess.getClass().getSimpleName() + ") could not execute properly: " + t.getClass().getSimpleName() + " - " + t.getMessage());
                    StaticLog.logSevere(t);
                }
            }
        }
        catch (Throwable t) {
            StaticLog.logSevere(t);
        }
        NCPAPIProvider.getNoCheatPlusAPI().setFeatureTags("blocks", blocksFeatures);
    }

    private static void initTools(IHandle<MCAccess> mcAccess, WorldConfigProvider<?> worldConfigProvider) {
        tools.clear();
        tools.put(268, new ToolProps(ToolType.SWORD, MaterialBase.WOOD));
        tools.put(269, new ToolProps(ToolType.SPADE, MaterialBase.WOOD));
        tools.put(270, new ToolProps(ToolType.PICKAXE, MaterialBase.WOOD));
        tools.put(271, new ToolProps(ToolType.AXE, MaterialBase.WOOD));
        tools.put(272, new ToolProps(ToolType.SWORD, MaterialBase.STONE));
        tools.put(273, new ToolProps(ToolType.SPADE, MaterialBase.STONE));
        tools.put(274, new ToolProps(ToolType.PICKAXE, MaterialBase.STONE));
        tools.put(275, new ToolProps(ToolType.AXE, MaterialBase.STONE));
        tools.put(256, new ToolProps(ToolType.SPADE, MaterialBase.IRON));
        tools.put(257, new ToolProps(ToolType.PICKAXE, MaterialBase.IRON));
        tools.put(258, new ToolProps(ToolType.AXE, MaterialBase.IRON));
        tools.put(267, new ToolProps(ToolType.SWORD, MaterialBase.IRON));
        tools.put(276, new ToolProps(ToolType.SWORD, MaterialBase.DIAMOND));
        tools.put(277, new ToolProps(ToolType.SPADE, MaterialBase.DIAMOND));
        tools.put(278, new ToolProps(ToolType.PICKAXE, MaterialBase.DIAMOND));
        tools.put(279, new ToolProps(ToolType.AXE, MaterialBase.DIAMOND));
        tools.put(283, new ToolProps(ToolType.SWORD, MaterialBase.GOLD));
        tools.put(284, new ToolProps(ToolType.SPADE, MaterialBase.GOLD));
        tools.put(285, new ToolProps(ToolType.PICKAXE, MaterialBase.GOLD));
        tools.put(286, new ToolProps(ToolType.AXE, MaterialBase.GOLD));
        tools.put(359, new ToolProps(ToolType.SHEARS, MaterialBase.NONE));
    }

    private static void initBlocks(IHandle<MCAccess> mcAccessHandle, WorldConfigProvider<?> worldConfigProvider) {
        BlockProps pumpkinType;
        MCAccess mcAccess = mcAccessHandle.getHandle();
        Arrays.fill(blocks, null);
        for (int i = 0; i < 4096; ++i) {
            BlockProperties.blockFlags[i] = 0L;
            if (mcAccess.isBlockLiquid(i).decide()) {
                int n = i;
                blockFlags[n] = blockFlags[n] | 2L;
                if (!mcAccess.isBlockSolid(i).decide()) continue;
                int n2 = i;
                blockFlags[n2] = blockFlags[n2] | 4L;
                continue;
            }
            if (!mcAccess.isBlockSolid(i).decide()) continue;
            int n = i;
            blockFlags[n] = blockFlags[n] | 0x84L;
        }
        for (Material mat : new Material[]{Material.NETHER_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.SMOOTH_STAIRS, Material.BRICK_STAIRS, Material.SANDSTONE_STAIRS, Material.WOOD_STAIRS, Material.SPRUCE_WOOD_STAIRS, Material.BIRCH_WOOD_STAIRS, Material.JUNGLE_WOOD_STAIRS}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x1981L;
        }
        for (Material mat : new Material[]{Material.STEP, Material.WOOD_STEP}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x880L;
        }
        for (Material mat : new Material[]{Material.RAILS, Material.DETECTOR_RAIL, Material.POWERED_RAIL}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x10000L;
        }
        for (Material mat : new Material[]{Material.STATIONARY_WATER, Material.WATER}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x2012L;
        }
        for (Material mat : new Material[]{Material.LAVA, Material.STATIONARY_LAVA}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x2022L;
        }
        int n = Material.SNOW.getId();
        blockFlags[n] = blockFlags[n] | 0x4000L;
        for (Material mat : new Material[]{Material.VINE, Material.LADDER}) {
            int n3 = mat.getId();
            blockFlags[n3] = blockFlags[n3] | 0x200L;
        }
        for (Material mat : new Material[]{Material.WATER_LILY, Material.LADDER, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.COCOA, Material.SNOW, Material.BREWING_STAND, Material.PISTON_MOVING_PIECE, Material.PISTON_EXTENSION, Material.STEP, Material.WOOD_STEP}) {
            int n4 = mat.getId();
            blockFlags[n4] = blockFlags[n4] | 0x80L;
        }
        for (Material mat : new Material[]{Material.BREWING_STAND, Material.PISTON_EXTENSION, Material.SOIL}) {
            int n5 = mat.getId();
            blockFlags[n5] = blockFlags[n5] | 0x100L;
        }
        for (Material mat : new Material[]{Material.PISTON_EXTENSION, Material.ENDER_PORTAL_FRAME}) {
            int n6 = mat.getId();
            blockFlags[n6] = blockFlags[n6] | 0x800L;
        }
        int n7 = Material.ICE.getId();
        blockFlags[n7] = blockFlags[n7] | 0x20000L;
        for (Material mat : new Material[]{Material.WALL_SIGN, Material.SIGN_POST}) {
            int n8 = mat.getId();
            blockFlags[n8] = blockFlags[n8] & 0xFFFFFFFFFFFFFF7BL;
        }
        for (Material mat : new Material[]{Material.WOOD_PLATE, Material.STONE_PLATE, Material.WALL_SIGN, Material.SIGN_POST, Material.DIODE_BLOCK_ON, Material.DIODE_BLOCK_OFF, Material.BREWING_STAND, Material.LADDER, Material.CAKE_BLOCK}) {
            int n9 = mat.getId();
            blockFlags[n9] = blockFlags[n9] | 8L;
        }
        for (Material mat : new Material[]{Material.FENCE, Material.FENCE_GATE, Material.NETHER_FENCE, Material.COBBLE_WALL}) {
            int n10 = mat.getId();
            blockFlags[n10] = blockFlags[n10] | 0x200440L;
        }
        for (Material mat : new Material[]{Material.FENCE_GATE, Material.TRAP_DOOR}) {
            int n11 = mat.getId();
            blockFlags[n11] = blockFlags[n11] | 0x400000L;
        }
        for (Material mat : new Material[]{Material.LADDER}) {
            int n12 = mat.getId();
            blockFlags[n12] = blockFlags[n12] | 0x1000000L;
        }
        for (Material mat : new Material[]{Material.TRAP_DOOR}) {
            int n13 = mat.getId();
            blockFlags[n13] = blockFlags[n13] | 0x2000000L;
        }
        for (Material mat : new Material[]{Material.IRON_FENCE, Material.THIN_GLASS}) {
            int n14 = mat.getId();
            blockFlags[n14] = blockFlags[n14] | 0x80400L;
        }
        for (Material mat : new Material[]{Material.PISTON_EXTENSION, Material.BREWING_STAND, Material.ENDER_PORTAL_FRAME, Material.CAKE_BLOCK, Material.TRAP_DOOR, Material.SOIL}) {
            int n15 = mat.getId();
            blockFlags[n15] = blockFlags[n15] | 0x1000L;
        }
        for (Material mat : instantMat) {
            BlockProperties.blocks[mat.getId()] = instantType;
        }
        for (Material mat : new Material[]{Material.LEAVES, Material.BED_BLOCK}) {
            BlockProperties.blocks[mat.getId()] = leafType;
        }
        int n16 = Material.LEAVES.getId();
        blockFlags[n16] = blockFlags[n16] | 0x40000L;
        for (Material mat : new Material[]{Material.HUGE_MUSHROOM_1, Material.HUGE_MUSHROOM_2, Material.VINE, Material.COCOA}) {
            BlockProperties.blocks[mat.getId()] = hugeMushroomType;
        }
        BlockProperties.blocks[Material.SNOW.getId()] = new BlockProps(BlockProperties.getToolProps(Material.WOOD_SPADE), 0.1f, BlockProperties.secToMs(0.5, 0.1, 0.05, 0.05, 0.05, 0.05));
        BlockProperties.blocks[Material.SNOW_BLOCK.getId()] = new BlockProps(BlockProperties.getToolProps(Material.WOOD_SPADE), 0.1f, BlockProperties.secToMs(1.0, 0.15, 0.1, 0.05, 0.05, 0.05));
        for (Material mat : new Material[]{Material.REDSTONE_LAMP_ON, Material.REDSTONE_LAMP_OFF, Material.GLOWSTONE, Material.GLASS}) {
            BlockProperties.blocks[mat.getId()] = glassType;
        }
        BlockProperties.blocks[Material.THIN_GLASS.getId()] = glassType;
        BlockProperties.blocks[Material.NETHERRACK.getId()] = new BlockProps(woodPickaxe, 0.4f, BlockProperties.secToMs(2.0, 0.3, 0.15, 0.1, 0.1, 0.05));
        BlockProperties.blocks[Material.LADDER.getId()] = new BlockProps(noTool, 0.4f, BlockProperties.secToMs(0.6), 2.5f);
        BlockProperties.blocks[Material.CACTUS.getId()] = new BlockProps(noTool, 0.4f, BlockProperties.secToMs(0.6));
        BlockProperties.blocks[Material.WOOD_PLATE.getId()] = new BlockProps(woodAxe, 0.5f, BlockProperties.secToMs(0.75, 0.4, 0.2, 0.15, 0.1, 0.1));
        BlockProperties.blocks[Material.STONE_PLATE.getId()] = new BlockProps(woodPickaxe, 0.5f, BlockProperties.secToMs(2.5, 0.4, 0.2, 0.15, 0.1, 0.07));
        BlockProperties.blocks[Material.SAND.getId()] = sandType;
        BlockProperties.blocks[Material.SOUL_SAND.getId()] = sandType;
        for (Material mat : new Material[]{Material.LEVER, Material.PISTON_BASE, Material.PISTON_EXTENSION, Material.PISTON_STICKY_BASE, Material.STONE_BUTTON, Material.PISTON_MOVING_PIECE}) {
            BlockProperties.blocks[mat.getId()] = leverType;
        }
        BlockProperties.blocks[Material.ICE.getId()] = new BlockProps(woodPickaxe, 0.5f, BlockProperties.secToMs(0.7, 0.35, 0.18, 0.12, 0.09, 0.06));
        BlockProperties.blocks[Material.DIRT.getId()] = sandType;
        BlockProperties.blocks[Material.CAKE_BLOCK.getId()] = leverType;
        BlockProperties.blocks[Material.BREWING_STAND.getId()] = new BlockProps(woodPickaxe, 0.5f, BlockProperties.secToMs(2.5, 0.4, 0.2, 0.15, 0.1, 0.1));
        BlockProperties.blocks[Material.SPONGE.getId()] = new BlockProps(noTool, 0.6f, BlockProperties.secToMs(0.9));
        for (Material mat : new Material[]{Material.MYCEL, Material.GRAVEL, Material.GRASS, Material.SOIL, Material.CLAY}) {
            BlockProperties.blocks[mat.getId()] = gravelType;
        }
        for (Material mat : new Material[]{Material.RAILS, Material.POWERED_RAIL, Material.DETECTOR_RAIL}) {
            BlockProperties.blocks[mat.getId()] = new BlockProps(woodPickaxe, 0.7f, railsTimes);
        }
        BlockProperties.blocks[Material.MONSTER_EGGS.getId()] = new BlockProps(noTool, 0.75f, BlockProperties.secToMs(1.15));
        BlockProperties.blocks[Material.WOOL.getId()] = new BlockProps(noTool, 0.8f, BlockProperties.secToMs(1.2), 3.0f);
        BlockProperties.blocks[Material.SANDSTONE.getId()] = sandStoneType;
        BlockProperties.blocks[Material.SANDSTONE_STAIRS.getId()] = sandStoneType;
        for (Material mat : new Material[]{Material.STONE, Material.SMOOTH_BRICK, Material.SMOOTH_STAIRS}) {
            BlockProperties.blocks[mat.getId()] = stoneType;
        }
        BlockProperties.blocks[Material.NOTE_BLOCK.getId()] = new BlockProps(woodAxe, 0.8f, BlockProperties.secToMs(1.2, 0.6, 0.3, 0.2, 0.15, 0.1));
        BlockProperties.blocks[Material.WALL_SIGN.getId()] = pumpkinType = new BlockProps(woodAxe, 1.0f, BlockProperties.secToMs(1.5, 0.75, 0.4, 0.25, 0.2, 0.15));
        BlockProperties.blocks[Material.SIGN_POST.getId()] = pumpkinType;
        BlockProperties.blocks[Material.PUMPKIN.getId()] = pumpkinType;
        BlockProperties.blocks[Material.JACK_O_LANTERN.getId()] = pumpkinType;
        BlockProperties.blocks[Material.MELON_BLOCK.getId()] = new BlockProps(noTool, 1.0f, BlockProperties.secToMs(1.45), 3.0f);
        BlockProperties.blocks[Material.BOOKSHELF.getId()] = new BlockProps(woodAxe, 1.5f, BlockProperties.secToMs(2.25, 1.15, 0.6, 0.4, 0.3, 0.2));
        for (Material mat : new Material[]{Material.WOOD_STAIRS, Material.WOOD, Material.WOOD_STEP, Material.LOG, Material.FENCE, Material.FENCE_GATE, Material.JUKEBOX, Material.JUNGLE_WOOD_STAIRS, Material.SPRUCE_WOOD_STAIRS, Material.BIRCH_WOOD_STAIRS, Material.WOOD_DOUBLE_STEP}) {
            BlockProperties.blocks[mat.getId()] = woodType;
        }
        for (Material mat : new Material[]{Material.COBBLESTONE_STAIRS, Material.COBBLESTONE, Material.NETHER_BRICK, Material.NETHER_BRICK_STAIRS, Material.NETHER_FENCE, Material.CAULDRON, Material.BRICK, Material.BRICK_STAIRS, Material.MOSSY_COBBLESTONE, Material.BRICK, Material.BRICK_STAIRS, Material.STEP, Material.DOUBLE_STEP}) {
            BlockProperties.blocks[mat.getId()] = brickType;
        }
        BlockProperties.blocks[Material.WORKBENCH.getId()] = chestType;
        BlockProperties.blocks[Material.CHEST.getId()] = chestType;
        BlockProperties.blocks[Material.WOODEN_DOOR.getId()] = woodDoorType;
        BlockProperties.blocks[Material.TRAP_DOOR.getId()] = woodDoorType;
        for (Material mat : new Material[]{Material.ENDER_STONE, Material.COAL_ORE}) {
            BlockProperties.blocks[mat.getId()] = coalType;
        }
        BlockProperties.blocks[Material.DRAGON_EGG.getId()] = new BlockProps(noTool, 3.0f, BlockProperties.secToMs(4.5));
        long[] ironTimes = BlockProperties.secToMs(15.0, 15.0, 1.15, 0.75, 0.6, 15.0);
        BlockProps ironType = new BlockProps(stonePickaxe, 3.0f, ironTimes);
        for (Material mat : new Material[]{Material.LAPIS_ORE, Material.LAPIS_BLOCK, Material.IRON_ORE}) {
            BlockProperties.blocks[mat.getId()] = ironType;
        }
        long[] diamondTimes = BlockProperties.secToMs(15.0, 15.0, 15.0, 0.75, 0.6, 15.0);
        BlockProps diamondType = new BlockProps(ironPickaxe, 3.0f, diamondTimes);
        for (Material mat : new Material[]{Material.REDSTONE_ORE, Material.GLOWING_REDSTONE_ORE, Material.EMERALD_ORE, Material.GOLD_ORE, Material.DIAMOND_ORE}) {
            BlockProperties.blocks[mat.getId()] = diamondType;
        }
        BlockProperties.blocks[Material.GOLD_BLOCK.getId()] = goldBlockType;
        BlockProperties.blocks[Material.FURNACE.getId()] = dispenserType;
        BlockProperties.blocks[Material.BURNING_FURNACE.getId()] = dispenserType;
        BlockProperties.blocks[Material.DISPENSER.getId()] = dispenserType;
        BlockProperties.blocks[Material.WEB.getId()] = new BlockProps(woodSword, 4.0f, BlockProperties.secToMs(20.0, 0.4, 0.4, 0.4, 0.4, 0.4));
        for (Material mat : new Material[]{Material.MOB_SPAWNER, Material.IRON_DOOR_BLOCK, Material.IRON_FENCE, Material.ENCHANTMENT_TABLE, Material.EMERALD_BLOCK}) {
            BlockProperties.blocks[mat.getId()] = ironDoorType;
        }
        BlockProperties.blocks[Material.IRON_BLOCK.getId()] = ironBlockType;
        BlockProperties.blocks[Material.DIAMOND_BLOCK.getId()] = diamondBlockType;
        BlockProperties.blocks[Material.ENDER_CHEST.getId()] = new BlockProps(woodPickaxe, 22.5f);
        BlockProperties.blocks[Material.OBSIDIAN.getId()] = new BlockProps(diamondPickaxe, 50.0f, BlockProperties.secToMs(250.0, 125.0, 62.5, 41.6, 9.4, 20.8));
        BlockProperties.blocks[Material.BEACON.getId()] = new BlockProps(noTool, 25.0f, BlockProperties.secToMs(4.45));
        BlockProperties.blocks[Material.COBBLE_WALL.getId()] = brickType;
        int n17 = Material.COBBLE_WALL.getId();
        blockFlags[n17] = blockFlags[n17] | 0x40L;
        BlockProperties.blocks[Material.WOOD_BUTTON.getId()] = leverType;
        BlockProperties.blocks[Material.SKULL.getId()] = new BlockProps(noTool, 8.5f, BlockProperties.secToMs(1.45));
        int n18 = Material.SKULL.getId();
        blockFlags[n18] = blockFlags[n18] | 0x80L;
        BlockProperties.blocks[Material.ANVIL.getId()] = new BlockProps(woodPickaxe, 5.0f);
        int n19 = Material.FLOWER_POT.getId();
        blockFlags[n19] = blockFlags[n19] | 0x80L;
        for (Material mat : new Material[]{Material.AIR, Material.ENDER_PORTAL, Material.ENDER_PORTAL_FRAME, Material.PORTAL, Material.LAVA, Material.WATER, Material.BEDROCK, Material.STATIONARY_LAVA, Material.STATIONARY_WATER}) {
            BlockProperties.blocks[mat.getId()] = indestructibleType;
        }
        BlockProperties.blocks[95] = indestructibleType;
    }

    public static void dumpBlocks(boolean all) {
        LogManager logManager = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
        LinkedList<String> missing = new LinkedList<String>();
        LinkedList<String> allBlocks = new LinkedList<String>();
        if (all) {
            allBlocks.add("Dump block properties for fastbreak check:");
            allBlocks.add("--- Present entries -------------------------------");
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (int i = 0; i < blocks.length; ++i) {
            String tagsJoined;
            String mat;
            try {
                Material temp = Material.getMaterial((int)i);
                if (!temp.isBlock()) continue;
                mat = temp.toString();
            }
            catch (Exception e) {
                mat = "?";
            }
            tags.clear();
            BlockProperties.addFlagNames(blockFlags[i], tags);
            String string = tagsJoined = tags.isEmpty() ? "" : " / " + StringUtil.join(tags, "+");
            if (blocks[i] == null) {
                if (mat.equals("?")) continue;
                missing.add("* MISSING " + i + "(" + mat + tagsJoined + ") ");
                continue;
            }
            if (!all) continue;
            allBlocks.add(i + ": (" + mat + tagsJoined + ") " + blocks[i].toString());
        }
        if (all) {
            logManager.info(Streams.DEFAULT_FILE, StringUtil.join(allBlocks, "\n"));
        }
        if (!missing.isEmpty()) {
            missing.add(0, "--- Missing entries -------------------------------");
            missing.add(0, "The block breaking data is incomplete, default to allow instant breaking:");
            logManager.warning(Streams.INIT, StringUtil.join(missing, "\n"));
        }
    }

    public static void addFlagNames(long flags, Collection<String> tags) {
        String tag = flagNameMap.get(flags);
        if (tag != null) {
            tags.add(tag);
            return;
        }
        for (Long flag : flagNameMap.keySet()) {
            if ((flags & flag) == 0L) continue;
            tags.add(flagNameMap.get(flag));
        }
    }

    public static Collection<String> getFlagNames(Long flags) {
        ArrayList<String> tags = new ArrayList<String>(flagNameMap.size());
        if (flags == null) {
            return tags;
        }
        BlockProperties.addFlagNames(flags, tags);
        return tags;
    }

    public static long parseFlag(String input) {
        String ucInput = input.trim().toUpperCase();
        Long flag = nameFlagMap.get(ucInput);
        if (flag != null) {
            return flag;
        }
        try {
            Long altFlag = Long.parseLong(input);
            return altFlag;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InputMismatchException();
        }
    }

    public static long[] secToMs(double s1, double s2, double s3, double s4, double s5, double s6) {
        return new long[]{(long)(s1 * 1000.0), (long)(s2 * 1000.0), (long)(s3 * 1000.0), (long)(s4 * 1000.0), (long)(s5 * 1000.0), (long)(s6 * 1000.0)};
    }

    public static long[] secToMs(double s1) {
        long v = (long)(s1 * 1000.0);
        return new long[]{v, v, v, v, v, v};
    }

    public static ToolProps getToolProps(ItemStack stack) {
        if (stack == null) {
            return noTool;
        }
        return BlockProperties.getToolProps(stack.getTypeId());
    }

    public static ToolProps getToolProps(Material mat) {
        if (mat == null) {
            return noTool;
        }
        return BlockProperties.getToolProps(mat.getId());
    }

    public static ToolProps getToolProps(Integer id) {
        ToolProps props = tools.get(id);
        if (props == null) {
            return noTool;
        }
        return props;
    }

    public static BlockProps getBlockProps(ItemStack stack) {
        if (stack == null) {
            return defaultBlockProps;
        }
        return BlockProperties.getBlockProps(stack.getTypeId());
    }

    public static BlockProps getBlockProps(Material mat) {
        if (mat == null) {
            return defaultBlockProps;
        }
        return BlockProperties.getBlockProps(mat.getId());
    }

    public static BlockProps getBlockProps(int blockId) {
        if (blockId < 0 || blockId >= blocks.length || blocks[blockId] == null) {
            return defaultBlockProps;
        }
        return blocks[blockId];
    }

    public static long getBreakingDuration(Material BlockType, Player player) {
        return BlockProperties.getBreakingDuration(BlockType.getId(), player);
    }

    public static long getBreakingDuration(int blockId, Player player) {
        long res = BlockProperties.getBreakingDuration(blockId, Bridge1_9.getItemInMainHand(player), player.getInventory().getHelmet(), player, player.getLocation(useLoc));
        useLoc.setWorld(null);
        return res;
    }

    public static long getBreakingDuration(int blockId, ItemStack itemInHand, ItemStack helmet, Player player, Location location) {
        boolean inWater;
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, 0.3);
        boolean onGround = pLoc.isOnGround();
        int bx = pLoc.getBlockX();
        int bz = pLoc.getBlockZ();
        double y = pLoc.getY() + player.getEyeHeight();
        int by = Location.locToBlock((double)y);
        int headId = blockCache.getTypeId(bx, by, bz);
        long headFlags = blockFlags[headId];
        if ((headFlags & 0x10L) == 0L) {
            inWater = false;
        } else {
            int data8 = (blockCache.getData(bx, by, bz) & 0xF) % 8;
            double level = (data8 & 8) != 0 ? 1.0 : 1.0 - 0.125 * (1.0 + (double)data8);
            inWater = y - (double)by < level;
        }
        blockCache.cleanup();
        pLoc.cleanup();
        double haste = PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.FAST_DIGGING);
        return BlockProperties.getBreakingDuration(blockId, itemInHand, onGround, inWater, helmet != null && helmet.containsEnchantment(Enchantment.WATER_WORKER), Double.isInfinite(haste) ? 0 : 1 + (int)haste);
    }

    public static long getBreakingDuration(int blockId, ItemStack itemInHand, boolean onGround, boolean inWater, boolean aquaAffinity, int haste) {
        if (BlockProperties.isAir(itemInHand)) {
            return BlockProperties.getBreakingDuration(blockId, BlockProperties.getBlockProps(blockId), noTool, onGround, inWater, aquaAffinity, 0);
        }
        int efficiency = 0;
        if (itemInHand.containsEnchantment(Enchantment.DIG_SPEED)) {
            efficiency = itemInHand.getEnchantmentLevel(Enchantment.DIG_SPEED);
        }
        return BlockProperties.getBreakingDuration(blockId, BlockProperties.getBlockProps(blockId), BlockProperties.getToolProps(itemInHand.getTypeId()), onGround, inWater, aquaAffinity, efficiency, haste);
    }

    public static long getBreakingDuration(int blockId, BlockProps blockProps, ToolProps toolProps, boolean onGround, boolean inWater, boolean aquaAffinity, int efficiency, int haste) {
        long dur = BlockProperties.getBreakingDuration(blockId, blockProps, toolProps, onGround, inWater, aquaAffinity, efficiency);
        return haste > 0 ? (long)(Math.pow(0.8, haste) * (double)dur) : dur;
    }

    public static long getBreakingDuration(int blockId, BlockProps blockProps, ToolProps toolProps, boolean onGround, boolean inWater, boolean aquaAffinity, int efficiency) {
        long duration;
        boolean isValidTool = BlockProperties.isValidTool(blockId, blockProps, toolProps, efficiency);
        if (efficiency > 0) {
            if (BlockProperties.isLeaves(blockId) || blockProps == glassType) {
                if (efficiency == 1) {
                    return 100L;
                }
                return 0L;
            }
            if (blockProps == chestType) {
                return (long)((double)blockProps.breakingTimes[0] / 5.0 / (double)efficiency);
            }
        }
        if (isValidTool) {
            duration = blockProps.breakingTimes[toolProps.materialBase.index];
            if (efficiency > 0) {
                duration = (long)((float)duration / blockProps.efficiencyMod);
            }
        } else {
            duration = blockProps.breakingTimes[0];
            if (toolProps.toolType == ToolType.SWORD) {
                duration = (long)((float)duration / 1.5f);
            }
        }
        if (toolProps.toolType == ToolType.SHEARS) {
            if (blockId == Material.WEB.getId()) {
                duration = 400L;
                isValidTool = true;
            } else if (blockId == Material.WOOL.getId()) {
                duration = 240L;
                isValidTool = true;
            } else if (BlockProperties.isLeaves(blockId)) {
                duration = 20L;
                isValidTool = true;
            } else if (blockId == Material.VINE.getId()) {
                duration = 300L;
                isValidTool = true;
            }
        } else if (blockId == Material.VINE.getId() && toolProps.toolType == ToolType.AXE) {
            isValidTool = true;
            duration = toolProps.materialBase == MaterialBase.WOOD || toolProps.materialBase == MaterialBase.STONE ? 100L : 0L;
        }
        if (isValidTool || blockProps.tool.toolType == ToolType.NONE) {
            float mult = 1.0f;
            if (inWater && !aquaAffinity) {
                mult *= breakPenaltyInWater;
            }
            if (!onGround) {
                mult *= breakPenaltyOffGround;
            }
            duration = (long)(mult * (float)duration);
            if (efficiency > 0) {
                if (blockId == Material.WOODEN_DOOR.getId() && toolProps.toolType != ToolType.AXE) {
                    switch (efficiency) {
                        case 1: {
                            return (long)(mult * 1500.0f);
                        }
                        case 2: {
                            return (long)(mult * 750.0f);
                        }
                        case 3: {
                            return (long)(mult * 450.0f);
                        }
                        case 4: {
                            return (long)(mult * 250.0f);
                        }
                        case 5: {
                            return (long)(mult * 150.0f);
                        }
                    }
                }
                for (int i = 0; i < efficiency; ++i) {
                    duration = (long)((double)duration / 1.33);
                }
                if (toolProps.materialBase == MaterialBase.WOOD) {
                    if (toolProps.toolType == ToolType.PICKAXE && (blockProps == ironDoorType || blockProps == dispenserType)) {
                        if (blockProps == dispenserType) {
                            duration = (long)((double)duration / 1.5 - (double)((efficiency - 1) * 60));
                        } else if (blockProps == ironDoorType) {
                            duration = (long)((double)duration / 1.5 - (double)((efficiency - 1) * 100));
                        }
                    } else {
                        duration = blockId == Material.LOG.getId() ? (duration -= efficiency >= 4 ? 250L : 400L) : (blockProps.tool.toolType == toolProps.toolType ? (duration -= 250L) : (duration -= (long)(efficiency * 30)));
                    }
                } else if (toolProps.materialBase == MaterialBase.STONE && blockId == Material.LOG.getId()) {
                    duration -= 100L;
                }
            }
        }
        if (efficiency > 0 && !isValidTool && !isValidTool && blockId == Material.MELON_BLOCK.getId()) {
            duration = Math.min(duration, 450L / (long)Math.pow(2.0, efficiency - 1));
        }
        return Math.max(0L, duration);
    }

    public static boolean isValidTool(int blockId, BlockProps blockProps, ToolProps toolProps, int efficiency) {
        boolean isValidTool;
        boolean bl = isValidTool = blockProps.tool.toolType == toolProps.toolType;
        if (!isValidTool && efficiency > 0) {
            if (blockId == Material.SNOW.getId()) {
                return toolProps.toolType == ToolType.SPADE;
            }
            if (blockId == Material.WOOL.getId()) {
                return true;
            }
            if (blockId == Material.WOODEN_DOOR.getId()) {
                return true;
            }
            if (blockProps.hardness <= 2.0f && (blockProps.tool.toolType == ToolType.AXE || blockProps.tool.toolType == ToolType.SPADE || (double)blockProps.hardness < 0.8 && blockId != Material.NETHERRACK.getId() && blockId != Material.SNOW.getId() && blockId != Material.SNOW_BLOCK.getId() && blockId != Material.STONE_PLATE.getId())) {
                return true;
            }
        }
        return isValidTool;
    }

    public static void setToolProps(int itemId, ToolProps toolProps) {
        if (toolProps == null) {
            throw new NullPointerException("ToolProps must not be null");
        }
        toolProps.validate();
        tools.put(itemId, toolProps);
    }

    public static void setBlockProps(int blockId, BlockProps blockProps) {
        if (blockProps == null) {
            throw new NullPointerException("BlockProps must not be null");
        }
        blockProps.validate();
        if (blockId < 0 || blockId >= blocks.length) {
            throw new IllegalArgumentException("The blockId is outside of supported range: " + blockId);
        }
        BlockProperties.blocks[blockId] = blockProps;
    }

    public static boolean isValidTool(Material blockType, ItemStack itemInHand) {
        return BlockProperties.isValidTool(blockType.getId(), itemInHand);
    }

    public static boolean isValidTool(int blockId, ItemStack itemInHand) {
        BlockProps blockProps = BlockProperties.getBlockProps(blockId);
        ToolProps toolProps = BlockProperties.getToolProps(itemInHand);
        int efficiency = itemInHand == null ? 0 : itemInHand.getEnchantmentLevel(Enchantment.DIG_SPEED);
        return BlockProperties.isValidTool(blockId, blockProps, toolProps, efficiency);
    }

    public static BlockProps getDefaultBlockProps() {
        return defaultBlockProps;
    }

    public static void setDefaultBlockProps(BlockProps blockProps) {
        blockProps.validate();
        defaultBlockProps = blockProps;
    }

    public static boolean isInLiquid(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, yOnGround);
        boolean res = pLoc.isInLiquid();
        blockCache.cleanup();
        pLoc.cleanup();
        return res;
    }

    public static boolean isInWeb(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, yOnGround);
        boolean res = pLoc.isInWeb();
        blockCache.cleanup();
        pLoc.cleanup();
        return res;
    }

    public static boolean isOnGround(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, yOnGround);
        boolean res = pLoc.isOnGround();
        blockCache.cleanup();
        pLoc.cleanup();
        return res;
    }

    public static boolean isOnGroundOrResetCond(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, yOnGround);
        boolean res = pLoc.isOnGroundOrResetCond();
        blockCache.cleanup();
        pLoc.cleanup();
        return res;
    }

    public static boolean isResetCond(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, yOnGround);
        boolean res = pLoc.isResetCond();
        blockCache.cleanup();
        pLoc.cleanup();
        return res;
    }

    public static int getId(Material blockType) {
        return blockType.getId();
    }

    public static int getData(Block block) {
        return block.getData();
    }

    public static Material getMaterial(int id) {
        return Material.getMaterial((int)id);
    }

    public static final long getBLockFlags(int id) {
        return blockFlags[id];
    }

    public static final long getBlockFlags(Material blockType) {
        return BlockProperties.getBlockFlags(blockType.getId());
    }

    public static final long getBlockFlags(int id) {
        return blockFlags[id];
    }

    public static final void setBlockFlags(Material blockType, long flags) {
        BlockProperties.setBlockFlags(blockType.getId(), flags);
    }

    public static final void setBlockFlags(int id, long flags) {
        BlockProperties.blockFlags[id] = flags;
    }

    public static final boolean canClimbUp(BlockCache cache, int x, int y, int z) {
        int id = cache.getTypeId(x, y, z);
        if ((blockFlags[id] & 0x200L) == 0L) {
            return false;
        }
        if (id == Material.LADDER.getId()) {
            return true;
        }
        if ((blockFlags[cache.getTypeId(x + 1, y, z)] & 4L) != 0L) {
            return true;
        }
        if ((blockFlags[cache.getTypeId(x - 1, y, z)] & 4L) != 0L) {
            return true;
        }
        if ((blockFlags[cache.getTypeId(x, y, z + 1)] & 4L) != 0L) {
            return true;
        }
        return (blockFlags[cache.getTypeId(x, y, z - 1)] & 4L) != 0L;
    }

    public static final boolean isClimbable(int id) {
        return (blockFlags[id] & 0x200L) != 0L;
    }

    public static final boolean isAttachedClimbable(int id) {
        return id == Material.VINE.getId();
    }

    public static final boolean isStairs(int id) {
        return (blockFlags[id] & 1L) != 0L;
    }

    public static final boolean isLiquid(Material blockType) {
        return BlockProperties.isLiquid(blockType.getId());
    }

    public static final boolean isLiquid(int id) {
        return (blockFlags[id] & 2L) != 0L;
    }

    public static final boolean isIce(int id) {
        return (blockFlags[id] & 0x20000L) != 0L;
    }

    public static final boolean isLeaves(int id) {
        return (blockFlags[id] & 0x40000L) != 0L;
    }

    public static final boolean isSolid(Material blockType) {
        return BlockProperties.isSolid(blockType.getId());
    }

    public static final boolean isSolid(int id) {
        return (blockFlags[id] & 4L) != 0L;
    }

    public static final boolean isGround(Material blockType) {
        return BlockProperties.isGround(blockType.getId());
    }

    public static final boolean isGround(int id) {
        return (blockFlags[id] & 0x80L) != 0L;
    }

    public static final boolean isGround(int id, long ignoreFlags) {
        long flags = blockFlags[id];
        return (flags & 0x80L) != 0L && (flags & ignoreFlags) == 0L;
    }

    public static final boolean isAir(Material type) {
        return type == null || type == Material.AIR;
    }

    public static final boolean isAir(ItemStack stack) {
        return stack == null || BlockProperties.isAir(stack.getType());
    }

    public static final BlockFace getFacing(long flags, int data) {
        if ((flags & 0x1000000L) != 0L) {
            switch (data & 7) {
                case 3: {
                    return BlockFace.SOUTH;
                }
                case 4: {
                    return BlockFace.WEST;
                }
                case 5: {
                    return BlockFace.EAST;
                }
            }
            return BlockFace.NORTH;
        }
        if ((flags & 0x2000000L) != 0L) {
            switch (data & 3) {
                case 0: {
                    return BlockFace.NORTH;
                }
                case 1: {
                    return BlockFace.SOUTH;
                }
                case 2: {
                    return BlockFace.WEST;
                }
                case 3: {
                    return BlockFace.EAST;
                }
            }
        }
        return null;
    }

    public static final boolean isTrapDoorAboveLadderSpecialCase(BlockCache access, int x, int y, int z) {
        if (!BlockProperties.isSpecialCaseTrapDoorAboveLadder()) {
            return false;
        }
        long flags1 = blockFlags[access.getTypeId(x, y, z)];
        if ((flags1 & 0x400000L) == 0L) {
            return false;
        }
        int data1 = access.getData(x, y, z);
        if ((data1 & 4) != 4) {
            return false;
        }
        BlockFace face1 = BlockProperties.getFacing(flags1, data1);
        if (face1 == null) {
            return false;
        }
        int belowId = access.getTypeId(x, y - 1, z);
        if (belowId != BlockProperties.getId(Material.LADDER)) {
            return false;
        }
        long flags2 = blockFlags[belowId];
        int data2 = access.getData(x, y - 1, z);
        BlockFace face2 = BlockProperties.getFacing(flags2, data2);
        return face1 == face2;
    }

    public static final boolean isPassable(Material blockType) {
        return BlockProperties.isPassable(blockType.getId());
    }

    public static final boolean isPassable(int id) {
        long flags = blockFlags[id];
        if ((flags & 0xAL) != 0L) {
            return true;
        }
        return (flags & 4L) == 0L;
    }

    public static final boolean isRails(int id) {
        return (blockFlags[id] & 0x10000L) != 0L;
    }

    public static final boolean isAscendingRails(int id, int data) {
        return BlockProperties.isRails(id) && (data & 7) > 1;
    }

    public static final boolean isPassable(BlockCache access, double x, double y, double z, BlockCache.IBlockCacheNode node, BlockCache.IBlockCacheNode nodeAbove) {
        int id = node.getId();
        if (BlockProperties.isPassable(id)) {
            return true;
        }
        int bx = Location.locToBlock((double)x);
        int by = Location.locToBlock((double)y);
        int bz = Location.locToBlock((double)z);
        if (node.hasNonNullBounds() == AlmostBoolean.NO || !BlockProperties.collidesBlock(access, x, y, z, x, y, z, bx, by, bz, node, nodeAbove, blockFlags[id])) {
            return true;
        }
        double fx = x - (double)bx;
        double fy = y - (double)by;
        double fz = z - (double)bz;
        return BlockProperties.isPassableWorkaround(access, bx, by, bz, fx, fy, fz, node, 0.0, 0.0, 0.0, 0.0);
    }

    public static final boolean isPassableH150(BlockCache access, double x, double y, double z) {
        int by = Location.locToBlock((double)y) - 1;
        double fy = y - (double)by;
        if (fy >= 1.5) {
            return true;
        }
        int bx = Location.locToBlock((double)x);
        int bz = Location.locToBlock((double)z);
        BlockCache.IBlockCacheNode nodeBelow = access.getOrCreateBlockCacheNode(x, y, z, false);
        int belowId = nodeBelow.getId();
        long belowFlags = blockFlags[belowId];
        if ((belowFlags & 0x40L) == 0L || BlockProperties.isPassable(belowId)) {
            return true;
        }
        double[] belowBounds = nodeBelow.getBounds(access, bx, by, bz);
        if (belowBounds == null) {
            return true;
        }
        if (!BlockProperties.collidesBlock(access, x, y, z, x, y, z, bx, by, bz, nodeBelow, null, belowFlags)) {
            return true;
        }
        double fx = x - (double)bx;
        double fz = z - (double)bz;
        return BlockProperties.isPassableWorkaround(access, bx, by, bz, fx, fy, fz, nodeBelow, 0.0, 0.0, 0.0, 0.0);
    }

    public static final boolean isPassableExact(BlockCache access, double x, double y, double z) {
        return BlockProperties.isPassable(access, x, y, z, access.getOrCreateBlockCacheNode(x, y, z, false), null) && BlockProperties.isPassableH150(access, x, y, z);
    }

    public static final boolean isPassableExact(BlockCache access, Location loc) {
        return BlockProperties.isPassableExact(access, loc.getX(), loc.getY(), loc.getZ());
    }

    public static final boolean isPassableWorkaround(BlockCache access, int bx, int by, int bz, double fx, double fy, double fz, BlockCache.IBlockCacheNode node, double dX, double dY, double dZ, double dT) {
        int id = node.getId();
        long flags = blockFlags[id];
        if ((flags & 1L) != 0L) {
            if ((access.getData(bx, by, bz) & 4) != 0 ? Math.max(fy, fy + dY * dT) < 0.5 : Math.min(fy, fy + dY * dT) >= 0.5) {
                return true;
            }
        } else if (id == Material.SOUL_SAND.getId()) {
            if (Math.min(fy, fy + dY * dT) >= 0.875) {
                return true;
            }
        } else {
            if ((flags & 0x400000L) != 0L && (access.getData(bx, by, bz) & 4) != 0) {
                return true;
            }
            if ((flags & 0x200000L) != 0L) {
                if (!BlockProperties.collidesFence(fx, fz, dX, dZ, dT, 0.125)) {
                    return true;
                }
            } else if ((flags & 0x80000L) != 0L) {
                if (!BlockProperties.collidesFence(fx, fz, dX, dZ, dT, 0.05)) {
                    return true;
                }
            } else if (id == Material.CAKE_BLOCK.getId()) {
                if (Math.min(fy, fy + dY * dT) >= 0.4375) {
                    return true;
                }
            } else if (id == Material.CAULDRON.getId()) {
                if (Math.min(fy, fy + dY * dT) >= 0.3125) {
                    return BlockProperties.isInsideCenter(fx, fz, dX, dZ, dT, 0.125);
                }
            } else {
                if (id == Material.CACTUS.getId()) {
                    if (Math.min(fy, fy + dY * dT) >= 0.9375) {
                        return true;
                    }
                    return !BlockProperties.collidesCenter(fx, fz, dX, dZ, dT, 0.0625);
                }
                if (id == Material.PISTON_EXTENSION.getId() ? Math.min(fy, fy + dY * dT) >= 0.625 : (flags & 0x1000L) != 0L && BlockProperties.getGroundMinHeight(access, bx, by, bz, node, flags) <= Math.min(fy, fy + dY * dT)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean collidesFence(double fx, double fz, double dX, double dZ, double dT, double d) {
        double dFx = 0.5 - fx;
        double dFz = 0.5 - fz;
        if (Math.abs(dFx) > d && Math.abs(dFz) > d) {
            double dFx2 = 0.5 - (fx + dX * dT);
            double dFz2 = 0.5 - (fz + dZ * dT);
            if (Math.abs(dFx2) > d && Math.abs(dFz2) > d && dFx * dFx2 > 0.0 && dFz * dFz2 > 0.0) {
                return false;
            }
        }
        return true;
    }

    public static final boolean collidesCenter(double fx, double fz, double dX, double dZ, double dT, double inset) {
        double low = inset;
        double high = 1.0 - inset;
        double xEnd = fx + dX * dT;
        if (xEnd < low && fx < low) {
            return false;
        }
        if (xEnd >= high && fx >= high) {
            return false;
        }
        double zEnd = fz + dZ * dT;
        if (zEnd < low && fz < low) {
            return false;
        }
        return !(zEnd >= high) || !(fz >= high);
    }

    public static final boolean isInsideCenter(double fx, double fz, double dX, double dZ, double dT, double inset) {
        double low = inset;
        double high = 1.0 - inset;
        double xEnd = fx + dX * dT;
        if (xEnd < low || fx < low) {
            return false;
        }
        if (xEnd >= high || fx >= high) {
            return false;
        }
        double zEnd = fz + dZ * dT;
        if (zEnd < low || fz < low) {
            return false;
        }
        return !(zEnd >= high) && !(fz >= high);
    }

    public static double getGroundMinHeight(BlockCache access, int x, int y, int z, BlockCache.IBlockCacheNode node, long flags) {
        int id = node.getId();
        double[] bounds = node.getBounds(access, x, y, z);
        if ((flags & 0x4000L) != 0L) {
            int data = (node.getData(access, x, y, z) & 0xF) % 8;
            if (data < 3) {
                return 0.0;
            }
            return 0.5;
        }
        if ((flags & 0x8000L) != 0L) {
            int data = (node.getData(access, x, y, z) & 0xF) % 8;
            return 0.125 * (double)data;
        }
        if ((flags & 0x40L) != 0L) {
            return 1.5;
        }
        if ((flags & 1L) != 0L) {
            if ((node.getData(access, x, y, z) & 4) != 0) {
                return 1.0;
            }
            return 0.5;
        }
        if ((flags & 0x200000L) != 0L) {
            return Math.min(1.0, bounds[4]);
        }
        if (id == Material.SOUL_SAND.getId()) {
            return 0.875;
        }
        if (id == Material.CAULDRON.getId()) {
            return 0.3125;
        }
        if (id == Material.CACTUS.getId()) {
            return 0.9375;
        }
        if (id == Material.PISTON_EXTENSION.getId()) {
            return 0.625;
        }
        if (id == Material.ENDER_PORTAL_FRAME.getId()) {
            return 0.8125;
        }
        if (bounds == null) {
            return 0.0;
        }
        if ((flags & 0x1000L) != 0L) {
            if (id == Material.SOIL.getId()) {
                return bounds[4];
            }
            if ((flags & 0x400000L) != 0L && (node.getData(access, x, y, z) & 4) != 0) {
                return bounds[4];
            }
            return 0.0;
        }
        return bounds[4];
    }

    public static final boolean isPassable(PlayerLocation loc) {
        return BlockProperties.isPassable(loc.getBlockCache(), loc.getX(), loc.getY(), loc.getZ(), loc.getOrCreateBlockCacheNode(), null);
    }

    public static final boolean isPassable(Location loc) {
        return BlockProperties.isPassable(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ());
    }

    public static final boolean isPassable(World world, double x, double y, double z) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(world);
        boolean res = BlockProperties.isPassable(blockCache, x, y, z, blockCache.getOrCreateBlockCacheNode(x, y, z, false), null);
        blockCache.cleanup();
        return res;
    }

    public static final boolean isPassable(Location from, Location to) {
        return BlockProperties.isPassable(rtRay, from, to);
    }

    public static final boolean isPassableAxisWise(Location from, Location to) {
        return BlockProperties.isPassable(rtAxis, from, to);
    }

    private static boolean isPassable(ICollidePassable rt, Location from, Location to) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(from.getWorld());
        rt.setMaxSteps(60);
        rt.setBlockCache(blockCache);
        rt.set(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
        rt.loop();
        boolean collides = rt.collides();
        blockCache.cleanup();
        rt.cleanup();
        return !collides;
    }

    public static final boolean isPassable(BlockCache access, Location loc) {
        return BlockProperties.isPassable(access, loc.getX(), loc.getY(), loc.getZ(), access.getOrCreateBlockCacheNode(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), false), null);
    }

    public static void applyConfig(RawConfigFile config, String pathPrefix) {
        for (String input : config.getStringList(pathPrefix + "allowinstantbreak")) {
            Integer id = RawConfigFile.parseTypeId(input);
            if (id == null || id < 0 || id >= 4096) {
                StaticLog.logWarning("Bad block id (" + pathPrefix + "allowinstantbreak" + "): " + input);
                continue;
            }
            BlockProperties.setBlockProps(id, instantType);
        }
        ConfigurationSection section = config.getConfigurationSection(pathPrefix + "overrideflags");
        if (section != null) {
            Map entries = section.getValues(false);
            boolean hasErrors = false;
            for (Map.Entry entry : entries.entrySet()) {
                String key = (String)entry.getKey();
                Integer id = RawConfigFile.parseTypeId(key);
                if (id == null || id < 0 || id >= 4096) {
                    StaticLog.logWarning("Bad block id (" + pathPrefix + "overrideflags" + "): " + key);
                    continue;
                }
                Object obj = entry.getValue();
                if (!(obj instanceof String)) {
                    StaticLog.logWarning("Bad flags at " + pathPrefix + "overrideflags" + " for key: " + key);
                    hasErrors = true;
                    continue;
                }
                List<String> split = StringUtil.split((String)obj, Character.valueOf(' '), Character.valueOf(','), Character.valueOf('/'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf(';'), Character.valueOf('\t'));
                long flags = 0L;
                boolean error = false;
                for (String input : split) {
                    if ((input = input.trim()).isEmpty()) continue;
                    if (input.equalsIgnoreCase("default")) {
                        flags |= blockFlags[id];
                        continue;
                    }
                    try {
                        flags |= BlockProperties.parseFlag(input);
                    }
                    catch (InputMismatchException e) {
                        StaticLog.logWarning("Bad flag at " + pathPrefix + "overrideflags" + " for key " + key + " (skip setting flags for this block): " + input);
                        error = true;
                        hasErrors = true;
                        break;
                    }
                }
                if (error) continue;
                BlockProperties.blockFlags[id.intValue()] = flags;
            }
            if (hasErrors) {
                StaticLog.logInfo("Overriding block-flags was not entirely successful, all available flags: \n" + StringUtil.join(flagNameMap.values(), "|"));
            }
        }
    }

    public static final boolean hasAnyFlags(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long flags) {
        return BlockProperties.hasAnyFlags(access, Location.locToBlock((double)minX), Location.locToBlock((double)minY), Location.locToBlock((double)minZ), Location.locToBlock((double)maxX), Location.locToBlock((double)maxY), Location.locToBlock((double)maxZ), flags);
    }

    public static final boolean hasAnyFlags(BlockCache access, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, long flags) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if ((blockFlags[access.getTypeId(x, y, z)] & flags) == 0L) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collides(BlockCache access, double[] bounds, long flags) {
        return BlockProperties.collides(access, bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5], flags);
    }

    public static final boolean collides(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long flags) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((flags & 0x40L) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Math.min(Location.locToBlock((double)maxY), access.getMaxBlockY());
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                BlockCache.IBlockCacheNode nodeAbove = null;
                for (int y = iMaxY; y >= iMinY; --y) {
                    BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(x, y, z, false);
                    int id = node.getId();
                    long cFlags = blockFlags[id];
                    if ((cFlags & flags) != 0L && node.hasNonNullBounds().decideOptimistically() && BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, node, nodeAbove, cFlags)) {
                        return true;
                    }
                    nodeAbove = node;
                }
            }
        }
        return false;
    }

    public static final boolean collidesId(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Material mat) {
        return BlockProperties.collidesId(access, minX, minY, minZ, maxX, maxY, maxZ, mat.getId());
    }

    public static final boolean collidesId(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int id) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((blockFlags[id] & 0x40L) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    if (id != access.getTypeId(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collidesBlock(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int id) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((blockFlags[id] & 0x40L) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Math.min(Location.locToBlock((double)maxY), access.getMaxBlockY());
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        long flags = blockFlags[id];
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                BlockCache.IBlockCacheNode nodeAbove = null;
                for (int y = iMaxY; y >= iMinY; --y) {
                    BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(x, y, z, false);
                    if (id != node.getId() || !node.hasNonNullBounds().decideOptimistically() || !BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, node, nodeAbove, flags)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collidesBlock(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int x, int y, int z, BlockCache.IBlockCacheNode node, BlockCache.IBlockCacheNode nodeAbove, long flags) {
        boolean allowEdge;
        double bmaxX;
        double bmaxY;
        double bmaxZ;
        double bminX;
        double bminY;
        double bminZ;
        double[] bounds = node.getBounds(access, x, y, z);
        if (bounds == null) {
            return false;
        }
        if ((flags & 1L) != 0L) {
            bminZ = 0.0;
            bminY = 0.0;
            bminX = 0.0;
            bmaxZ = 1.0;
            bmaxY = 1.0;
            bmaxX = 1.0;
        } else {
            int data;
            if ((flags & 0x800L) != 0L) {
                bminZ = 0.0;
                bminX = 0.0;
                bmaxZ = 1.0;
                bmaxX = 1.0;
            } else {
                bminX = bounds[0];
                bminZ = bounds[2];
                bmaxX = bounds[3];
                bmaxZ = bounds[5];
            }
            if ((flags & 0x4000L) != 0L) {
                bminY = 0.0;
                data = (node.getData(access, x, y, z) & 0xF) % 8;
                bmaxY = data < 3 ? 0.0 : 0.5;
            } else if ((flags & 0x8000L) != 0L) {
                bminY = 0.0;
                data = (node.getData(access, x, y, z) & 0xF) % 8;
                bmaxY = 0.125 * (double)data;
            } else if ((flags & 0x40L) != 0L) {
                bminY = 0.0;
                bmaxY = 1.5;
            } else if ((flags & 0x100L) != 0L) {
                bminY = 0.0;
                bmaxY = 1.0;
            } else if ((flags & 0x2000L) != 0L) {
                int data8;
                bminY = 0.0;
                data = node.getData(access, x, y, z);
                bmaxY = (data & 8) == 0 ? ((data8 = (data & 0xF) % 8) > 4 ? 0.5 : (BlockProperties.shouldLiquidBelowBeFullHeight(access, x, y + 1, z, nodeAbove) ? 1.0 : 8.0000002E7)) : (BlockProperties.shouldLiquidBelowBeFullHeight(access, x, y + 1, z, nodeAbove) ? 1.0 : 8.0000002E7);
            } else if ((flags & 0x8000000L) != 0L) {
                bminY = 0.0;
                bmaxY = 0.125;
            } else if (node.getId() == Material.ENDER_PORTAL_FRAME.getId()) {
                bminY = 0.0;
                bmaxY = (node.getData(access, x, y, z) & 4) != 0 ? 1.0 : 0.8125;
            } else {
                bminY = bounds[1];
                bmaxY = bounds[4];
            }
        }
        if (minX > bmaxX + (double)x || maxX < bminX + (double)x || minY > bmaxY + (double)y || maxY < bminY + (double)y || minZ > bmaxZ + (double)z || maxZ < bminZ + (double)z) {
            return false;
        }
        boolean bl = allowEdge = (flags & 0x100000L) == 0L;
        return (minX != bmaxX + (double)x || !(bmaxX < 1.0) && !allowEdge) && (minY != bmaxY + (double)y || !(bmaxY < 1.0) && !allowEdge) && (minZ != bmaxZ + (double)z || !(bmaxZ < 1.0) && !allowEdge);
    }

    public static boolean shouldLiquidBelowBeFullHeight(BlockCache access, int x, int y, int z, BlockCache.IBlockCacheNode node) {
        int id;
        if (node == null) {
            node = access.getOrCreateBlockCacheNode(x, y, z, false);
        }
        if (BlockProperties.isLiquid(id = node.getId())) {
            return true;
        }
        if (!BlockProperties.isSolid(id)) {
            return false;
        }
        double[] bounds = BlockProperties.getCorrectedBounds(access, x, y, z, node);
        return bounds == null ? true : bounds[1] == 0.0;
    }

    public static double[] getCorrectedBounds(BlockCache access, int x, int y, int z) {
        return BlockProperties.getCorrectedBounds(access, x, y, z, access.getOrCreateBlockCacheNode(x, y, z, false));
    }

    public static double[] getCorrectedBounds(BlockCache access, int x, int y, int z, BlockCache.IBlockCacheNode node) {
        double[] bounds = node.getBounds(access, x, y, z);
        if (bounds == null) {
            return null;
        }
        return bounds;
    }

    public static final boolean isOnGroundShuffled(BlockCache access, double x1, double y1, double z1, double x2, double y2, double z2, double xzMargin, double yBelow, double yAbove) {
        return BlockProperties.isOnGroundShuffled(access, x1, y1, z1, x2, y2, z2, xzMargin, yBelow, yAbove, 0L);
    }

    public static final boolean isOnGround(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return BlockProperties.isOnGround(access, minX, minY, minZ, maxX, maxY, maxZ, 0L);
    }

    public static final boolean isOnGroundShuffled(BlockCache access, double x1, double y1, double z1, double x2, double y2, double z2, double xzMargin, double yBelow, double yAbove, long ignoreFlags) {
        return BlockProperties.isOnGround(access, Math.min(x1, x2) - xzMargin, Math.min(y1, y2) - yBelow, Math.min(z1, z2) - xzMargin, Math.max(x1, x2) + xzMargin, Math.max(y1, y2) + yAbove, Math.max(z1, z2) + xzMargin, ignoreFlags);
    }

    public static final boolean isOnGround(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long ignoreFlags) {
        int maxBlockY = access.getMaxBlockY();
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - 0.5626));
        if (iMinY > maxBlockY) {
            return false;
        }
        int iMaxY = Math.min(Location.locToBlock((double)maxY), maxBlockY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            block5: for (int z = iMinZ; z <= iMaxZ; ++z) {
                BlockCache.IBlockCacheNode nodeAbove = null;
                block6: for (int y = iMaxY; y >= iMinY; --y) {
                    BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(x, y, z, false);
                    switch (BlockProperties.isOnGround(access, minX, minY, minZ, maxX, maxY, maxZ, ignoreFlags, x, y, z, node, nodeAbove)) {
                        case YES: {
                            return true;
                        }
                        case MAYBE: {
                            nodeAbove = node;
                            continue block6;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static final AlmostBoolean isOnGround(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long ignoreFlags, int x, int y, int z, BlockCache.IBlockCacheNode node, BlockCache.IBlockCacheNode nodeAbove) {
        int aboveId;
        long aboveFlags;
        int id = node.getId();
        long flags = blockFlags[id];
        if ((flags & 0x80L) == 0L || (flags & ignoreFlags) != 0L) {
            return AlmostBoolean.MAYBE;
        }
        double[] bounds = node.getBounds(access, x, y, z);
        if (bounds == null) {
            return AlmostBoolean.YES;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, node, nodeAbove, flags)) {
            return AlmostBoolean.MAYBE;
        }
        if (BlockProperties.isPassableWorkaround(access, x, y, z, minX - (double)x, minY - (double)y, minZ - (double)z, node, maxX - minX, maxY - minY, maxZ - minZ, 1.0) && ((flags & 0x1000L) == 0L || BlockProperties.getGroundMinHeight(access, x, y, z, node, flags) > maxY - (double)y)) {
            return AlmostBoolean.MAYBE;
        }
        if (BlockProperties.getGroundMinHeight(access, x, y, z, node, flags) > maxY - (double)y) {
            if (BlockProperties.isFullBounds(bounds)) {
                return AlmostBoolean.NO;
            }
            return AlmostBoolean.MAYBE;
        }
        if (maxY - (double)y < 1.0) {
            return AlmostBoolean.YES;
        }
        if (y >= access.getMaxBlockY()) {
            return AlmostBoolean.YES;
        }
        if (nodeAbove == null) {
            nodeAbove = access.getOrCreateBlockCacheNode(x, y + 1, z, false);
        }
        if (((aboveFlags = blockFlags[aboveId = nodeAbove.getId()]) & 8L) != 0L) {
            return AlmostBoolean.YES;
        }
        if ((aboveFlags & 0x80L) == 0L || (aboveFlags & 2L) != 0L || (aboveFlags & ignoreFlags) != 0L) {
            return AlmostBoolean.YES;
        }
        boolean variable = (flags & 0x400L) != 0L;
        if (!(variable |= (aboveFlags & 0x400L) != 0L) && id == aboveId) {
            if (BlockProperties.isFullBounds(bounds)) {
                return AlmostBoolean.NO;
            }
            return AlmostBoolean.MAYBE;
        }
        double[] aboveBounds = nodeAbove.getBounds(access, x, y + 1, z);
        if (aboveBounds == null) {
            return AlmostBoolean.YES;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, Math.max(maxY, 1.49 + (double)y), maxZ, x, y + 1, z, nodeAbove, null, aboveFlags)) {
            return AlmostBoolean.YES;
        }
        if (BlockProperties.isPassableWorkaround(access, x, y + 1, z, minX - (double)x, minY - (double)(y + 1), minZ - (double)z, nodeAbove, maxX - minX, maxY - minY, maxZ - minZ, 1.0)) {
            return AlmostBoolean.YES;
        }
        if (BlockProperties.isFullBounds(aboveBounds)) {
            return AlmostBoolean.NO;
        }
        if (variable) {
            if (BlockProperties.isSameShape(bounds, aboveBounds)) {
                return AlmostBoolean.MAYBE;
            }
            return AlmostBoolean.YES;
        }
        return AlmostBoolean.MAYBE;
    }

    public static final boolean isFullBounds(double[] bounds) {
        for (int i = 0; i < 3; ++i) {
            if (bounds[i] == 0.0 && bounds[i + 3] == 1.0) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSameShape(double[] bounds1, double[] bounds2) {
        if (bounds1 == null || bounds2 == null) {
            return bounds1 == bounds2;
        }
        for (int i = 0; i < 6; ++i) {
            if (bounds1[i] == bounds2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isDownStream(PlayerLocation from, PlayerLocation to) {
        return BlockProperties.isDownStream(from.getBlockCache(), from.getBlockX(), from.getBlockY(), from.getBlockZ(), from.getData(), to.getX() - from.getX(), to.getZ() - from.getZ());
    }

    public static final boolean isDownStream(BlockCache access, int x, int y, int z, int data, double dX, double dZ) {
        if ((data & 8) == 0) {
            if (dX > 0.0) {
                if (data < 7 && BlockProperties.isLiquid(access.getTypeId(x + 1, y, z)) && access.getData(x + 1, y, z) > data) {
                    return true;
                }
                if (data > 0 && BlockProperties.isLiquid(access.getTypeId(x - 1, y, z)) && access.getData(x - 1, y, z) < data) {
                    return true;
                }
            } else if (dX < 0.0) {
                if (data < 7 && BlockProperties.isLiquid(access.getTypeId(x - 1, y, z)) && access.getData(x - 1, y, z) > data) {
                    return true;
                }
                if (data > 0 && BlockProperties.isLiquid(access.getTypeId(x + 1, y, z)) && access.getData(x + 1, y, z) < data) {
                    return true;
                }
            }
            if (dZ > 0.0) {
                if (data < 7 && BlockProperties.isLiquid(access.getTypeId(x, y, z + 1)) && access.getData(x, y, z + 1) > data) {
                    return true;
                }
                if (data > 0 && BlockProperties.isLiquid(access.getTypeId(x, y, z - 1)) && access.getData(x, y, z - 1) < data) {
                    return true;
                }
            } else if (dZ < 0.0) {
                if (data < 7 && BlockProperties.isLiquid(access.getTypeId(x, y, z - 1)) && access.getData(x, y, z - 1) > data) {
                    return true;
                }
                if (data > 0 && BlockProperties.isLiquid(access.getTypeId(x, y, z + 1)) && access.getData(x, y, z + 1) < data) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final long collectFlagsSimple(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)minY);
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        long flags = 0L;
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    flags |= blockFlags[access.getTypeId(x, y, z)];
                }
            }
        }
        return flags;
    }

    public static float getBreakPenaltyInWater() {
        return breakPenaltyInWater;
    }

    public static void setBreakPenaltyInWater(float breakPenaltyInWater) {
        BlockProperties.breakPenaltyInWater = breakPenaltyInWater;
    }

    public static float getBreakPenaltyOffGround() {
        return breakPenaltyOffGround;
    }

    public static void setBreakPenaltyOffGround(float breakPenaltyOffGround) {
        BlockProperties.breakPenaltyOffGround = breakPenaltyOffGround;
    }

    public static void cleanup() {
        if (pLoc != null) {
            pLoc.cleanup();
            pLoc = null;
        }
        if (wrapBlockCache != null) {
            wrapBlockCache.cleanup();
            wrapBlockCache = null;
        }
    }

    public static final boolean isPassableRay(BlockCache access, int blockX, int blockY, int blockZ, double oX, double oY, double oZ, double dX, double dY, double dZ, double dT) {
        double maxZ;
        double minZ;
        double maxY;
        double minY;
        double maxX;
        double minX;
        BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(blockX, blockY, blockZ, false);
        if (BlockProperties.isPassable(node.getId())) {
            return true;
        }
        double[] bounds = access.getBounds(blockX, blockY, blockZ);
        if (bounds == null) {
            return true;
        }
        if (dX < 0.0) {
            minX = dX * dT + oX + (double)blockX;
            maxX = oX + (double)blockX;
        } else {
            maxX = dX * dT + oX + (double)blockX;
            minX = oX + (double)blockX;
        }
        if (dY < 0.0) {
            minY = dY * dT + oY + (double)blockY;
            maxY = oY + (double)blockY;
        } else {
            maxY = dY * dT + oY + (double)blockY;
            minY = oY + (double)blockY;
        }
        if (dZ < 0.0) {
            minZ = dZ * dT + oZ + (double)blockZ;
            maxZ = oZ + (double)blockZ;
        } else {
            maxZ = dZ * dT + oZ + (double)blockZ;
            minZ = oZ + (double)blockZ;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, blockX, blockY, blockZ, node, null, blockFlags[node.getId()] | 0x100000L)) {
            return true;
        }
        return BlockProperties.isPassableWorkaround(access, blockX, blockY, blockZ, oX, oY, oZ, node, dX, dY, dZ, dT);
    }

    public static final boolean isPassableBox(BlockCache access, int blockX, int blockY, int blockZ, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(blockX, blockY, blockZ, false);
        int id = node.getId();
        if (BlockProperties.isPassable(id)) {
            return true;
        }
        double[] bounds = access.getBounds(blockX, blockY, blockZ);
        if (bounds == null) {
            return true;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, blockX, blockY, blockZ, node, null, blockFlags[id] | 0x100000L)) {
            return true;
        }
        return BlockProperties.isPassableWorkaround(access, blockX, blockY, blockZ, minX - (double)blockX, minY - (double)blockY, minZ - (double)blockZ, node, maxX - minX, maxY - minY, maxZ - minZ, 1.0);
    }

    public static final boolean isPassableBox(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)minY);
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    if (BlockProperties.isPassableBox(access, x, y, z, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static final int collectInitiallyCollidingBlocks(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, BlockPositionContainer results) {
        int added = 0;
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)minY);
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    if (BlockProperties.isPassableBox(access, x, y, z, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                    results.addBlockPosition(x, y, z);
                    ++added;
                }
            }
        }
        return added;
    }

    public static boolean isSpecialCaseTrapDoorAboveLadder() {
        return specialCaseTrapDoorAboveLadder;
    }

    public static void setSpecialCaseTrapDoorAboveLadder(boolean specialCaseTrapDoorAboveLadder) {
        BlockProperties.specialCaseTrapDoorAboveLadder = specialCaseTrapDoorAboveLadder;
    }

    static {
        for (Field field : BlockProperties.class.getDeclaredFields()) {
            String name = field.getName();
            if (!name.startsWith("F_")) continue;
            try {
                Long value = field.getLong(BlockProperties.class);
                flagNameMap.put(value, name.substring(2));
                nameFlagMap.put(name, value);
                nameFlagMap.put(name.substring(2), value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        breakPenaltyInWater = 4.0f;
        breakPenaltyOffGround = 4.0f;
    }

    public static class BlockProps {
        public final ToolProps tool;
        public final long[] breakingTimes;
        public final float hardness;
        public final float efficiencyMod;

        public BlockProps(ToolProps tool, float hardness) {
            this(tool, hardness, 1.0f);
        }

        public BlockProps(ToolProps tool, float hardness, float efficiencyMod) {
            this.tool = tool;
            this.hardness = hardness;
            this.breakingTimes = new long[6];
            for (int i = 0; i < 6; ++i) {
                float multiplier = tool.materialBase == null ? 1.0f : (i < tool.materialBase.index ? 1.0f : MaterialBase.getById((int)i).breakMultiplier * 3.33f);
                this.breakingTimes[i] = (long)(5000.0f * hardness / multiplier);
            }
            this.efficiencyMod = efficiencyMod;
        }

        public BlockProps(ToolProps tool, float hardness, long[] breakingTimes) {
            this(tool, hardness, breakingTimes, 1.0f);
        }

        public BlockProps(ToolProps tool, float hardness, long[] breakingTimes, float efficiencyMod) {
            this.tool = tool;
            this.breakingTimes = breakingTimes;
            this.hardness = hardness;
            this.efficiencyMod = efficiencyMod;
        }

        public String toString() {
            return "BlockProps(" + this.hardness + " / " + this.tool.toString() + " / " + Arrays.toString(this.breakingTimes) + ")";
        }

        public void validate() {
            if (this.breakingTimes == null) {
                throw new IllegalArgumentException("Breaking times must not be null.");
            }
            if (this.breakingTimes.length != 6) {
                throw new IllegalArgumentException("Breaking times length must match the number of available tool types (6).");
            }
            if (this.tool == null) {
                throw new IllegalArgumentException("Tool must not be null.");
            }
            this.tool.validate();
        }
    }

    public static class ToolProps {
        public final ToolType toolType;
        public final MaterialBase materialBase;

        public ToolProps(ToolType toolType, MaterialBase materialBase) {
            this.toolType = toolType;
            this.materialBase = materialBase;
        }

        public String toString() {
            return "ToolProps(" + (Object)((Object)this.toolType) + "/" + (Object)((Object)this.materialBase) + ")";
        }

        public void validate() {
            if (this.toolType == null) {
                throw new IllegalArgumentException("ToolType must not be null.");
            }
            if (this.materialBase == null) {
                throw new IllegalArgumentException("MaterialBase must not be null");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MaterialBase {
        NONE(0, 1.0f),
        WOOD(1, 2.0f),
        STONE(2, 4.0f),
        IRON(3, 6.0f),
        DIAMOND(4, 8.0f),
        GOLD(5, 12.0f);

        public final int index;
        public final float breakMultiplier;

        private MaterialBase(int index, float breakMultiplier) {
            this.index = index;
            this.breakMultiplier = breakMultiplier;
        }

        public static final MaterialBase getById(int id) {
            for (MaterialBase base : MaterialBase.values()) {
                if (base.index != id) continue;
                return base;
            }
            throw new IllegalArgumentException("Bad id: " + id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolType {
        NONE,
        SWORD,
        SHEARS,
        SPADE,
        AXE,
        PICKAXE;

    }
}

